/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.resource.java.NestableAnnotationDefinition;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.v2_2.ELJaxb_2_2_PlatformDefinition;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.java.XmlDiscriminatorValueAnnotation;
import org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.resource.java.ELJaxbJavaResourceModelTestCase;

public class XmlDiscriminatorValueAnnotationTests
extends ELJaxbJavaResourceModelTestCase {
    public XmlDiscriminatorValueAnnotationTests(String name) {
        super(name);
    }

    @Override
    protected AnnotationDefinition[] annotationDefinitions() {
        return ELJaxb_2_2_PlatformDefinition.instance().getAnnotationDefinitions();
    }

    @Override
    protected NestableAnnotationDefinition[] nestableAnnotationDefinitions() {
        return ELJaxb_2_2_PlatformDefinition.instance().getNestableAnnotationDefinitions();
    }

    private ICompilationUnit createTestXmlDiscriminatorValueWithValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.oxm.annotations.XmlDiscriminatorValue"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlDiscriminatorValue(\"foo\")");
            }
        });
    }

    private XmlDiscriminatorValueAnnotation getXmlDiscriminatorValueAnnotation(JavaResourceType resourceType) {
        return (XmlDiscriminatorValueAnnotation)resourceType.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlDiscriminatorValue");
    }

    public void testValue() throws Exception {
        ICompilationUnit cu = this.createTestXmlDiscriminatorValueWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlDiscriminatorValueAnnotation annotation = this.getXmlDiscriminatorValueAnnotation(resourceType);
        XmlDiscriminatorValueAnnotationTests.assertEquals((String)"foo", (String)annotation.getValue());
        this.assertSourceContains("@XmlDiscriminatorValue(\"foo\")", cu);
        annotation.setValue("bar");
        XmlDiscriminatorValueAnnotationTests.assertEquals((String)"bar", (String)annotation.getValue());
        this.assertSourceContains("@XmlDiscriminatorValue(\"bar\")", cu);
        annotation.setValue("");
        XmlDiscriminatorValueAnnotationTests.assertEquals((String)"", (String)annotation.getValue());
        this.assertSourceContains("@XmlDiscriminatorValue(\"\")", cu);
        annotation.setValue(null);
        XmlDiscriminatorValueAnnotationTests.assertNull((Object)annotation.getValue());
        this.assertSourceContains("@XmlDiscriminatorValue", cu);
        this.assertSourceDoesNotContain("@XmlDiscriminatorValue(", cu);
    }
}

