/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.resource.java.NestableAnnotationDefinition;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.v2_2.ELJaxb_2_2_PlatformDefinition;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.java.XmlJoinNodeAnnotation;
import org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.resource.java.ELJaxbJavaResourceModelTestCase;

public class XmlJoinNodeAnnotationTests
extends ELJaxbJavaResourceModelTestCase {
    public XmlJoinNodeAnnotationTests(String name) {
        super(name);
    }

    @Override
    protected AnnotationDefinition[] annotationDefinitions() {
        return ELJaxb_2_2_PlatformDefinition.instance().getAnnotationDefinitions();
    }

    @Override
    protected NestableAnnotationDefinition[] nestableAnnotationDefinitions() {
        return ELJaxb_2_2_PlatformDefinition.instance().getNestableAnnotationDefinitions();
    }

    private ICompilationUnit createTestXmlJoinNode() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.oxm.annotations.XmlJoinNode"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlJoinNode");
            }
        });
    }

    private ICompilationUnit createTestXmlJoinNodeWithXmlPath() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.oxm.annotations.XmlJoinNode"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlJoinNode(xmlPath=\"foo\")");
            }
        });
    }

    private ICompilationUnit createTestXmlJoinNodeWithReferencedXmlPath() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.oxm.annotations.XmlJoinNode"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlJoinNode(referencedXmlPath=\"foo\")");
            }
        });
    }

    private ICompilationUnit createTestXmlJoinNodes() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.oxm.annotations.XmlJoinNodes", "org.eclipse.persistence.oxm.annotations.XmlJoinNode"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlJoinNodes({@XmlJoinNode,@XmlJoinNode})");
            }
        });
    }

    private XmlJoinNodeAnnotation getXmlJoinNodeAnnotation(JavaResourceAttribute resourceAttribute) {
        return this.getXmlJoinNodeAnnotation(resourceAttribute, 0);
    }

    private XmlJoinNodeAnnotation getXmlJoinNodeAnnotation(JavaResourceAttribute resourceAttribute, int index) {
        return (XmlJoinNodeAnnotation)resourceAttribute.getAnnotation(index, "org.eclipse.persistence.oxm.annotations.XmlJoinNode");
    }

    public void testXmlPath() throws Exception {
        ICompilationUnit cu = this.createTestXmlJoinNodeWithXmlPath();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlJoinNodeAnnotation annotation = this.getXmlJoinNodeAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlJoinNodeAnnotationTests.assertEquals((String)"foo", (String)annotation.getXmlPath());
        this.assertSourceContains("@XmlJoinNode(xmlPath=\"foo\")", cu);
        annotation.setXmlPath("bar");
        XmlJoinNodeAnnotationTests.assertEquals((String)"bar", (String)annotation.getXmlPath());
        this.assertSourceContains("@XmlJoinNode(xmlPath=\"bar\")", cu);
        annotation.setXmlPath("");
        XmlJoinNodeAnnotationTests.assertEquals((String)"", (String)annotation.getXmlPath());
        this.assertSourceContains("@XmlJoinNode(xmlPath=\"\")", cu);
        annotation.setXmlPath(null);
        XmlJoinNodeAnnotationTests.assertNull((Object)annotation.getXmlPath());
        this.assertSourceContains("@XmlJoinNode", cu);
        this.assertSourceDoesNotContain("@XmlJoinNode(", cu);
    }

    public void testReferencedXmlPath() throws Exception {
        ICompilationUnit cu = this.createTestXmlJoinNodeWithReferencedXmlPath();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlJoinNodeAnnotation annotation = this.getXmlJoinNodeAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlJoinNodeAnnotationTests.assertEquals((String)"foo", (String)annotation.getReferencedXmlPath());
        this.assertSourceContains("@XmlJoinNode(referencedXmlPath=\"foo\")", cu);
        annotation.setReferencedXmlPath("bar");
        XmlJoinNodeAnnotationTests.assertEquals((String)"bar", (String)annotation.getReferencedXmlPath());
        this.assertSourceContains("@XmlJoinNode(referencedXmlPath=\"bar\")", cu);
        annotation.setReferencedXmlPath("");
        XmlJoinNodeAnnotationTests.assertEquals((String)"", (String)annotation.getReferencedXmlPath());
        this.assertSourceContains("@XmlJoinNode(referencedXmlPath=\"\")", cu);
        annotation.setReferencedXmlPath(null);
        XmlJoinNodeAnnotationTests.assertNull((Object)annotation.getReferencedXmlPath());
        this.assertSourceContains("@XmlJoinNode", cu);
        this.assertSourceDoesNotContain("@XmlJoinNode(", cu);
    }

    public void testContainedXmlPath() throws Exception {
        ICompilationUnit cu = this.createTestXmlJoinNodes();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlJoinNodeAnnotation annotation = this.getXmlJoinNodeAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlJoinNodeAnnotationTests.assertNull((Object)annotation.getXmlPath());
        this.assertSourceContains("@XmlJoinNodes({@XmlJoinNode,@XmlJoinNode})", cu);
        annotation.setXmlPath("foo");
        XmlJoinNodeAnnotationTests.assertEquals((String)"foo", (String)annotation.getXmlPath());
        this.assertSourceContains("@XmlJoinNodes({@XmlJoinNode(xmlPath = \"foo\"),@XmlJoinNode})", cu);
        annotation.setXmlPath(null);
        XmlJoinNodeAnnotationTests.assertNull((Object)annotation.getXmlPath());
        this.assertSourceContains("@XmlJoinNodes({@XmlJoinNode,@XmlJoinNode})", cu);
    }

    public void testContainedReferencedXmlPath() throws Exception {
        ICompilationUnit cu = this.createTestXmlJoinNodes();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlJoinNodeAnnotation annotation = this.getXmlJoinNodeAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlJoinNodeAnnotationTests.assertNull((Object)annotation.getReferencedXmlPath());
        this.assertSourceContains("@XmlJoinNodes({@XmlJoinNode,@XmlJoinNode})", cu);
        annotation.setReferencedXmlPath("foo");
        XmlJoinNodeAnnotationTests.assertEquals((String)"foo", (String)annotation.getReferencedXmlPath());
        this.assertSourceContains("@XmlJoinNodes({@XmlJoinNode(referencedXmlPath = \"foo\"),@XmlJoinNode})", cu);
        annotation.setReferencedXmlPath(null);
        XmlJoinNodeAnnotationTests.assertNull((Object)annotation.getReferencedXmlPath());
        this.assertSourceContains("@XmlJoinNodes({@XmlJoinNode,@XmlJoinNode})", cu);
    }

    public void testContained() throws Exception {
        ICompilationUnit cu = this.createTestXmlJoinNode();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlJoinNodeAnnotationTests.assertEquals((int)1, (int)resourceAttribute.getAnnotationsSize("org.eclipse.persistence.oxm.annotations.XmlJoinNode"));
        resourceAttribute.addAnnotation(1, "org.eclipse.persistence.oxm.annotations.XmlJoinNode");
        XmlJoinNodeAnnotationTests.assertEquals((int)2, (int)resourceAttribute.getAnnotationsSize("org.eclipse.persistence.oxm.annotations.XmlJoinNode"));
        this.assertSourceContains("@XmlJoinNodes({ @XmlJoinNode, @XmlJoinNode })", cu);
        XmlJoinNodeAnnotation annotation1 = this.getXmlJoinNodeAnnotation((JavaResourceAttribute)resourceAttribute, 0);
        annotation1.setXmlPath("foo");
        XmlJoinNodeAnnotation annotation2 = this.getXmlJoinNodeAnnotation((JavaResourceAttribute)resourceAttribute, 1);
        annotation2.setXmlPath("bar");
        this.assertSourceContains("@XmlJoinNodes({ @XmlJoinNode(xmlPath = \"foo\"), @XmlJoinNode(xmlPath = \"bar\") })", cu);
        resourceAttribute.moveAnnotation(0, 1, "org.eclipse.persistence.oxm.annotations.XmlJoinNode");
        this.assertSourceContains("@XmlJoinNodes({ @XmlJoinNode(xmlPath = \"bar\"), @XmlJoinNode(xmlPath = \"foo\") })", cu);
        resourceAttribute.removeAnnotation(0, "org.eclipse.persistence.oxm.annotations.XmlJoinNode");
        XmlJoinNodeAnnotationTests.assertEquals((int)1, (int)resourceAttribute.getAnnotationsSize("org.eclipse.persistence.oxm.annotations.XmlJoinNode"));
        this.assertSourceContains("@XmlJoinNode(xmlPath = \"foo\")", cu);
        this.assertSourceDoesNotContain("@XmlJoinNodes", cu);
    }
}

