/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.resource.java.NestableAnnotationDefinition;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.v2_2.ELJaxb_2_2_PlatformDefinition;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.java.XmlTransformationAnnotation;
import org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.resource.java.ELJaxbJavaResourceModelTestCase;

public class XmlTransformationAnnotationTests
extends ELJaxbJavaResourceModelTestCase {
    public XmlTransformationAnnotationTests(String name) {
        super(name);
    }

    @Override
    protected AnnotationDefinition[] annotationDefinitions() {
        return ELJaxb_2_2_PlatformDefinition.instance().getAnnotationDefinitions();
    }

    @Override
    protected NestableAnnotationDefinition[] nestableAnnotationDefinitions() {
        return ELJaxb_2_2_PlatformDefinition.instance().getNestableAnnotationDefinitions();
    }

    private ICompilationUnit createTestXmlTransformation() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.oxm.annotations.XmlTransformation"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlTransformation");
            }
        });
    }

    private ICompilationUnit createTestXmlTransformationWithOptional() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.oxm.annotations.XmlTransformation"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlTransformation(optional = true)");
            }
        });
    }

    private XmlTransformationAnnotation getXmlTransformationAnnotation(JavaResourceAttribute resourceAttribute) {
        return (XmlTransformationAnnotation)resourceAttribute.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlTransformation");
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestXmlTransformation();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlTransformationAnnotation annotation = this.getXmlTransformationAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlTransformationAnnotationTests.assertTrue((annotation != null ? 1 : 0) != 0);
        XmlTransformationAnnotationTests.assertNull((Object)annotation.getOptional());
    }

    public void testGetOptional() throws Exception {
        ICompilationUnit cu = this.createTestXmlTransformationWithOptional();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlTransformationAnnotation annotation = this.getXmlTransformationAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlTransformationAnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)annotation.getOptional());
    }

    public void testSetOptional() throws Exception {
        ICompilationUnit cu = this.createTestXmlTransformation();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlTransformationAnnotation annotation = this.getXmlTransformationAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlTransformationAnnotationTests.assertNull((Object)annotation.getOptional());
        annotation.setOptional(Boolean.FALSE);
        XmlTransformationAnnotationTests.assertEquals((Object)Boolean.FALSE, (Object)annotation.getOptional());
        this.assertSourceContains("@XmlTransformation(optional = false)", cu);
        annotation.setOptional(null);
        XmlTransformationAnnotationTests.assertNull((Object)annotation.getOptional());
        this.assertSourceContains("@XmlTransformation", cu);
        this.assertSourceDoesNotContain("optional", cu);
    }
}

