/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.context.JaxbClass;
import org.eclipse.jpt.jaxb.core.context.XmlJavaTypeAdapter;
import org.eclipse.jpt.jaxb.core.resource.java.XmlJavaTypeAdapterAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericJavaTypeXmlJavaTypeAdapterTests
extends JaxbContextModelTestCase {
    public GenericJavaTypeXmlJavaTypeAdapterTests(String name) {
        super(name);
    }

    private ICompilationUnit createTypeWithXmlJavaTypeAdapter() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlJavaTypeAdapter");
            }
        });
    }

    public void testModifyValue() throws Exception {
        this.createTypeWithXmlJavaTypeAdapter();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        XmlJavaTypeAdapter contextXmlJavaTypeAdapter = jaxbClass.getXmlJavaTypeAdapter();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        GenericJavaTypeXmlJavaTypeAdapterTests.assertNull((Object)contextXmlJavaTypeAdapter.getValue());
        contextXmlJavaTypeAdapter.setValue("foo");
        XmlJavaTypeAdapterAnnotation javaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceType.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaTypeXmlJavaTypeAdapterTests.assertEquals((String)"foo", (String)javaTypeAdapterAnnotation.getValue());
        GenericJavaTypeXmlJavaTypeAdapterTests.assertEquals((String)"foo", (String)contextXmlJavaTypeAdapter.getValue());
        contextXmlJavaTypeAdapter.setValue(null);
        javaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceType.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaTypeXmlJavaTypeAdapterTests.assertNull((Object)javaTypeAdapterAnnotation.getValue());
        GenericJavaTypeXmlJavaTypeAdapterTests.assertNull((Object)contextXmlJavaTypeAdapter.getValue());
    }

    public void testUpdateValue() throws Exception {
        this.createTypeWithXmlJavaTypeAdapter();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        XmlJavaTypeAdapter contextXmlJavaTypeAdapter = jaxbClass.getXmlJavaTypeAdapter();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        GenericJavaTypeXmlJavaTypeAdapterTests.assertNull((Object)contextXmlJavaTypeAdapter.getValue());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaTypeXmlJavaTypeAdapterTests.this.addXmlJavaTypeAdapterTypeMemberValuePair(declaration, "value", "String");
            }
        });
        GenericJavaTypeXmlJavaTypeAdapterTests.assertEquals((String)"String", (String)contextXmlJavaTypeAdapter.getValue());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaTypeXmlJavaTypeAdapterTests.this.removeXmlJavaTypeAdapterAnnotation(declaration);
            }
        });
        GenericJavaTypeXmlJavaTypeAdapterTests.assertNull((Object)jaxbClass.getXmlJavaTypeAdapter());
    }

    public void testModifyType() throws Exception {
        this.createTypeWithXmlJavaTypeAdapter();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        XmlJavaTypeAdapter contextXmlJavaTypeAdapter = jaxbClass.getXmlJavaTypeAdapter();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        GenericJavaTypeXmlJavaTypeAdapterTests.assertEquals((String)"test.AnnotationTestType", (String)contextXmlJavaTypeAdapter.getType());
        GenericJavaTypeXmlJavaTypeAdapterTests.assertNull((Object)contextXmlJavaTypeAdapter.getSpecifiedType());
        GenericJavaTypeXmlJavaTypeAdapterTests.assertEquals((String)"test.AnnotationTestType", (String)contextXmlJavaTypeAdapter.getDefaultType());
        contextXmlJavaTypeAdapter.setSpecifiedType("foo");
        XmlJavaTypeAdapterAnnotation javaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceType.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaTypeXmlJavaTypeAdapterTests.assertEquals((String)"foo", (String)javaTypeAdapterAnnotation.getType());
        GenericJavaTypeXmlJavaTypeAdapterTests.assertEquals((String)"foo", (String)contextXmlJavaTypeAdapter.getSpecifiedType());
        GenericJavaTypeXmlJavaTypeAdapterTests.assertEquals((String)"test.AnnotationTestType", (String)contextXmlJavaTypeAdapter.getDefaultType());
        contextXmlJavaTypeAdapter.setSpecifiedType(null);
        javaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceType.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaTypeXmlJavaTypeAdapterTests.assertNull((Object)javaTypeAdapterAnnotation.getType());
        GenericJavaTypeXmlJavaTypeAdapterTests.assertEquals((String)"test.AnnotationTestType", (String)contextXmlJavaTypeAdapter.getType());
        GenericJavaTypeXmlJavaTypeAdapterTests.assertNull((Object)contextXmlJavaTypeAdapter.getSpecifiedType());
        GenericJavaTypeXmlJavaTypeAdapterTests.assertEquals((String)"test.AnnotationTestType", (String)contextXmlJavaTypeAdapter.getDefaultType());
    }

    public void testUpdateType() throws Exception {
        this.createTypeWithXmlJavaTypeAdapter();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        XmlJavaTypeAdapter contextXmlJavaTypeAdapter = jaxbClass.getXmlJavaTypeAdapter();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        GenericJavaTypeXmlJavaTypeAdapterTests.assertEquals((String)"test.AnnotationTestType", (String)contextXmlJavaTypeAdapter.getType());
        GenericJavaTypeXmlJavaTypeAdapterTests.assertNull((Object)contextXmlJavaTypeAdapter.getSpecifiedType());
        GenericJavaTypeXmlJavaTypeAdapterTests.assertEquals((String)"test.AnnotationTestType", (String)contextXmlJavaTypeAdapter.getDefaultType());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaTypeXmlJavaTypeAdapterTests.this.addXmlJavaTypeAdapterTypeMemberValuePair(declaration, "type", "String");
            }
        });
        GenericJavaTypeXmlJavaTypeAdapterTests.assertEquals((String)"String", (String)contextXmlJavaTypeAdapter.getSpecifiedType());
        GenericJavaTypeXmlJavaTypeAdapterTests.assertEquals((String)"String", (String)contextXmlJavaTypeAdapter.getType());
        GenericJavaTypeXmlJavaTypeAdapterTests.assertEquals((String)"test.AnnotationTestType", (String)contextXmlJavaTypeAdapter.getDefaultType());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaTypeXmlJavaTypeAdapterTests.this.removeXmlJavaTypeAdapterAnnotation(declaration);
            }
        });
        GenericJavaTypeXmlJavaTypeAdapterTests.assertNull((Object)jaxbClass.getXmlJavaTypeAdapter());
    }

    protected void addXmlJavaTypeAdapterTypeMemberValuePair(ModifiedDeclaration declaration, String name, String typeName) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlJavaTypeAdapterAnnotation(declaration), name, (Expression)this.newTypeLiteral(declaration.getAst(), typeName));
    }

    protected void addXmlJavaTypeAdapterMemberValuePair(ModifiedDeclaration declaration, String name, String value) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlJavaTypeAdapterAnnotation(declaration), name, value);
    }

    protected void removeXmlJavaTypeAdapterAnnotation(ModifiedDeclaration declaration) {
        this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAccessorOrder");
        this.removeAnnotation(declaration, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
    }

    protected Annotation getXmlJavaTypeAdapterAnnotation(ModifiedDeclaration declaration) {
        return declaration.getAnnotationNamed("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
    }
}

