/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.context.JaxbClass;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.XmlAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.XmlElementRef;
import org.eclipse.jpt.jaxb.core.context.XmlElementRefMapping;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementRefAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementWrapperAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlMixedAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericJavaXmlElementRefMappingTests
extends JaxbContextModelTestCase {
    public GenericJavaXmlElementRefMappingTests(String name) {
        super(name);
    }

    private ICompilationUnit createTypeWithXmlElementRef() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "javax.xml.bind.annotation.XmlElementRef"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElementRef");
            }
        });
    }

    private ICompilationUnit createTypeWithJAXBElementXmlElementRef() throws Exception {
        return this.createTestType("AnnotationTestType2", (AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "javax.xml.bind.annotation.XmlElementRef", "javax.xml.bind.JAXBElement"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElementRef").append(CR);
                sb.append("private JAXBElement foo;").append(CR).append(CR);
            }
        });
    }

    private ICompilationUnit createTypeWithRootElementXmlElementRef() throws Exception {
        return this.createTestType("AnnotationTestType3", (AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "javax.xml.bind.annotation.XmlElementRef", "javax.xml.bind.annotation.XmlRootElement"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType").append(CR);
                sb.append("@XmlRootElement(name=\"foo\")");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElementRef").append(CR);
                sb.append("private AnnotationTestType3 foo;").append(CR).append(CR);
            }
        });
    }

    public void testDefaultName() throws Exception {
        this.createTypeWithXmlElementRef();
        this.createTypeWithJAXBElementXmlElementRef();
        this.createTypeWithRootElementXmlElementRef();
        JaxbClass jaxbClass = (JaxbClass)this.getContextRoot().getType("test.AnnotationTestType");
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementRefMapping xmlElementRefMapping = (XmlElementRefMapping)persistentAttribute.getMapping();
        XmlElementRef xmlElementRef = xmlElementRefMapping.getXmlElementRef();
        GenericJavaXmlElementRefMappingTests.assertEquals((String)"", (String)xmlElementRef.getQName().getName());
        GenericJavaXmlElementRefMappingTests.assertEquals((String)"", (String)xmlElementRef.getQName().getNamespace());
        classMapping = ((JaxbClass)this.getContextRoot().getType("test.AnnotationTestType2")).getMapping();
        xmlElementRefMapping = (XmlElementRefMapping)((JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0)).getMapping();
        xmlElementRef = xmlElementRefMapping.getXmlElementRef();
        GenericJavaXmlElementRefMappingTests.assertEquals((String)"foo", (String)xmlElementRef.getQName().getName());
        GenericJavaXmlElementRefMappingTests.assertEquals((String)"", (String)xmlElementRef.getQName().getNamespace());
        classMapping = ((JaxbClass)this.getContextRoot().getType("test.AnnotationTestType3")).getMapping();
        xmlElementRefMapping = (XmlElementRefMapping)((JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0)).getMapping();
        xmlElementRef = xmlElementRefMapping.getXmlElementRef();
        GenericJavaXmlElementRefMappingTests.assertEquals((String)"foo", (String)xmlElementRef.getQName().getName());
        GenericJavaXmlElementRefMappingTests.assertEquals((String)"", (String)xmlElementRef.getQName().getNamespace());
    }

    public void testModifyName() throws Exception {
        this.createTypeWithXmlElementRef();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        XmlElementRefMapping xmlElementRefMapping = (XmlElementRefMapping)((JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0)).getMapping();
        XmlElementRef xmlElementRef = xmlElementRefMapping.getXmlElementRef();
        JavaResourceAttribute resourceAttribute = xmlElementRefMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementRefMappingTests.assertNull((Object)xmlElementRef.getQName().getSpecifiedName());
        GenericJavaXmlElementRefMappingTests.assertEquals((String)"", (String)xmlElementRef.getQName().getDefaultName());
        GenericJavaXmlElementRefMappingTests.assertEquals((String)"", (String)xmlElementRef.getQName().getName());
        xmlElementRef.getQName().setSpecifiedName("foo");
        XmlElementRefAnnotation xmlElementRefAnnotation = (XmlElementRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRef");
        GenericJavaXmlElementRefMappingTests.assertEquals((String)"foo", (String)xmlElementRefAnnotation.getName());
        GenericJavaXmlElementRefMappingTests.assertEquals((String)"foo", (String)xmlElementRef.getQName().getSpecifiedName());
        GenericJavaXmlElementRefMappingTests.assertEquals((String)"foo", (String)xmlElementRef.getQName().getName());
        xmlElementRef.getQName().setSpecifiedName(null);
        xmlElementRefAnnotation = (XmlElementRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRef");
        GenericJavaXmlElementRefMappingTests.assertNull((Object)xmlElementRefAnnotation.getName());
        GenericJavaXmlElementRefMappingTests.assertNull((Object)xmlElementRef.getQName().getSpecifiedName());
    }

    public void testUpdateName() throws Exception {
        this.createTypeWithXmlElementRef();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        XmlElementRefMapping xmlElementRefMapping = (XmlElementRefMapping)((JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0)).getMapping();
        XmlElementRef xmlElementRef = xmlElementRefMapping.getXmlElementRef();
        JavaResourceAttribute resourceAttribute = xmlElementRefMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementRefMappingTests.assertNull((Object)xmlElementRef.getQName().getSpecifiedName());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementRefMappingTests.this.addXmlElementRefMemberValuePair(declaration, "name", "foo");
            }
        });
        GenericJavaXmlElementRefMappingTests.assertEquals((String)"foo", (String)xmlElementRef.getQName().getName());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlElementRefAnnotation = (NormalAnnotation)GenericJavaXmlElementRefMappingTests.this.getXmlElementRefAnnotation(declaration);
                GenericJavaXmlElementRefMappingTests.this.values(xmlElementRefAnnotation).remove(0);
            }
        });
        GenericJavaXmlElementRefMappingTests.assertNull((Object)xmlElementRef.getQName().getSpecifiedName());
    }

    public void testModifyNamespace() throws Exception {
        this.createTypeWithXmlElementRef();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        XmlElementRefMapping xmlElementRefMapping = (XmlElementRefMapping)((JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0)).getMapping();
        XmlElementRef xmlElementRef = xmlElementRefMapping.getXmlElementRef();
        JavaResourceAttribute resourceAttribute = xmlElementRefMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementRefMappingTests.assertNull((Object)xmlElementRef.getQName().getSpecifiedNamespace());
        xmlElementRef.getQName().setSpecifiedNamespace("foo");
        XmlElementRefAnnotation xmlElementRefAnnotation = (XmlElementRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRef");
        GenericJavaXmlElementRefMappingTests.assertEquals((String)"foo", (String)xmlElementRefAnnotation.getNamespace());
        GenericJavaXmlElementRefMappingTests.assertEquals((String)"foo", (String)xmlElementRef.getQName().getNamespace());
        xmlElementRef.getQName().setSpecifiedNamespace(null);
        xmlElementRefAnnotation = (XmlElementRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRef");
        GenericJavaXmlElementRefMappingTests.assertNull((Object)xmlElementRefAnnotation.getNamespace());
        GenericJavaXmlElementRefMappingTests.assertNull((Object)xmlElementRef.getQName().getSpecifiedNamespace());
    }

    public void testUpdateNamespace() throws Exception {
        this.createTypeWithXmlElementRef();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        XmlElementRefMapping xmlElementRefMapping = (XmlElementRefMapping)((JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0)).getMapping();
        XmlElementRef xmlElementRef = xmlElementRefMapping.getXmlElementRef();
        JavaResourceAttribute resourceAttribute = xmlElementRefMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementRefMappingTests.assertNull((Object)xmlElementRef.getQName().getSpecifiedNamespace());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementRefMappingTests.this.addXmlElementRefMemberValuePair(declaration, "namespace", "foo");
            }
        });
        GenericJavaXmlElementRefMappingTests.assertEquals((String)"foo", (String)xmlElementRef.getQName().getNamespace());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlElementRefAnnotation = (NormalAnnotation)GenericJavaXmlElementRefMappingTests.this.getXmlElementRefAnnotation(declaration);
                GenericJavaXmlElementRefMappingTests.this.values(xmlElementRefAnnotation).remove(0);
            }
        });
        GenericJavaXmlElementRefMappingTests.assertNull((Object)xmlElementRef.getQName().getSpecifiedNamespace());
    }

    public void testModifyRequired() throws Exception {
        this.createTypeWithXmlElementRef();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        XmlElementRefMapping xmlElementRefMapping = (XmlElementRefMapping)((JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0)).getMapping();
        XmlElementRef xmlElementRef = xmlElementRefMapping.getXmlElementRef();
        JavaResourceAttribute resourceAttribute = xmlElementRefMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementRefMappingTests.assertNull((Object)xmlElementRef.getSpecifiedRequired());
        GenericJavaXmlElementRefMappingTests.assertEquals((boolean)false, (boolean)xmlElementRef.isDefaultRequired());
        GenericJavaXmlElementRefMappingTests.assertEquals((boolean)false, (boolean)xmlElementRef.isRequired());
        xmlElementRef.setSpecifiedRequired(Boolean.TRUE);
        XmlElementRefAnnotation xmlElementRefAnnotation = (XmlElementRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRef");
        GenericJavaXmlElementRefMappingTests.assertEquals((Object)Boolean.TRUE, (Object)xmlElementRefAnnotation.getRequired());
        GenericJavaXmlElementRefMappingTests.assertEquals((Object)Boolean.TRUE, (Object)xmlElementRef.getSpecifiedRequired());
        GenericJavaXmlElementRefMappingTests.assertEquals((boolean)false, (boolean)xmlElementRef.isDefaultRequired());
        GenericJavaXmlElementRefMappingTests.assertEquals((boolean)true, (boolean)xmlElementRef.isRequired());
        xmlElementRef.setSpecifiedRequired(null);
        xmlElementRefAnnotation = (XmlElementRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRef");
        GenericJavaXmlElementRefMappingTests.assertNull((Object)xmlElementRefAnnotation.getName());
        GenericJavaXmlElementRefMappingTests.assertNull((Object)xmlElementRef.getSpecifiedRequired());
        GenericJavaXmlElementRefMappingTests.assertEquals((boolean)false, (boolean)xmlElementRef.isDefaultRequired());
        GenericJavaXmlElementRefMappingTests.assertEquals((boolean)false, (boolean)xmlElementRef.isRequired());
    }

    public void testUpdateRequired() throws Exception {
        this.createTypeWithXmlElementRef();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        XmlElementRefMapping xmlElementRefMapping = (XmlElementRefMapping)((JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0)).getMapping();
        XmlElementRef xmlElementRef = xmlElementRefMapping.getXmlElementRef();
        JavaResourceAttribute resourceAttribute = xmlElementRefMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementRefMappingTests.assertNull((Object)xmlElementRef.getSpecifiedRequired());
        GenericJavaXmlElementRefMappingTests.assertEquals((boolean)false, (boolean)xmlElementRef.isDefaultRequired());
        GenericJavaXmlElementRefMappingTests.assertEquals((boolean)false, (boolean)xmlElementRef.isRequired());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementRefMappingTests.this.addXmlElementRefMemberValuePair(declaration, "required", true);
            }
        });
        GenericJavaXmlElementRefMappingTests.assertEquals((Object)Boolean.TRUE, (Object)xmlElementRef.getSpecifiedRequired());
        GenericJavaXmlElementRefMappingTests.assertEquals((boolean)false, (boolean)xmlElementRef.isDefaultRequired());
        GenericJavaXmlElementRefMappingTests.assertEquals((boolean)true, (boolean)xmlElementRef.isRequired());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlElementRefAnnotation = (NormalAnnotation)GenericJavaXmlElementRefMappingTests.this.getXmlElementRefAnnotation(declaration);
                GenericJavaXmlElementRefMappingTests.this.values(xmlElementRefAnnotation).remove(0);
            }
        });
        GenericJavaXmlElementRefMappingTests.assertNull((Object)xmlElementRef.getSpecifiedRequired());
        GenericJavaXmlElementRefMappingTests.assertEquals((boolean)false, (boolean)xmlElementRef.isDefaultRequired());
        GenericJavaXmlElementRefMappingTests.assertEquals((boolean)false, (boolean)xmlElementRef.isRequired());
    }

    public void testModifyType() throws Exception {
        this.createTypeWithXmlElementRef();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        XmlElementRefMapping xmlElementRefMapping = (XmlElementRefMapping)((JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0)).getMapping();
        XmlElementRef xmlElementRef = xmlElementRefMapping.getXmlElementRef();
        GenericJavaXmlElementRefMappingTests.assertNull((Object)xmlElementRef.getSpecifiedType());
        GenericJavaXmlElementRefMappingTests.assertEquals((String)"int", (String)xmlElementRef.getType());
        GenericJavaXmlElementRefMappingTests.assertEquals((String)"int", (String)xmlElementRef.getDefaultType());
        xmlElementRef.setSpecifiedType("Foo");
        GenericJavaXmlElementRefMappingTests.assertEquals((String)"Foo", (String)xmlElementRef.getSpecifiedType());
        GenericJavaXmlElementRefMappingTests.assertEquals((String)"Foo", (String)xmlElementRef.getType());
        xmlElementRef.setSpecifiedType(null);
        GenericJavaXmlElementRefMappingTests.assertNull((Object)xmlElementRef.getSpecifiedType());
        GenericJavaXmlElementRefMappingTests.assertEquals((String)"int", (String)xmlElementRef.getType());
    }

    public void testUpdateType() throws Exception {
        this.createTypeWithXmlElementRef();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        XmlElementRefMapping xmlElementRefMapping = (XmlElementRefMapping)((JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0)).getMapping();
        XmlElementRef xmlElementRef = xmlElementRefMapping.getXmlElementRef();
        JavaResourceAttribute resourceAttribute = xmlElementRefMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementRefMappingTests.assertNull((Object)xmlElementRef.getSpecifiedType());
        GenericJavaXmlElementRefMappingTests.assertEquals((String)"int", (String)xmlElementRef.getDefaultType());
        GenericJavaXmlElementRefMappingTests.assertEquals((String)"int", (String)xmlElementRef.getType());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementRefMappingTests.this.addXmlElementRefTypeMemberValuePair(declaration, "type", "Foo");
            }
        });
        GenericJavaXmlElementRefMappingTests.assertEquals((String)"Foo", (String)xmlElementRef.getSpecifiedType());
        GenericJavaXmlElementRefMappingTests.assertEquals((String)"Foo", (String)xmlElementRef.getType());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlElementRefAnnotation = (NormalAnnotation)GenericJavaXmlElementRefMappingTests.this.getXmlElementRefAnnotation(declaration);
                GenericJavaXmlElementRefMappingTests.this.values(xmlElementRefAnnotation).remove(0);
            }
        });
        GenericJavaXmlElementRefMappingTests.assertNull((Object)xmlElementRef.getSpecifiedType());
        GenericJavaXmlElementRefMappingTests.assertEquals((String)"int", (String)xmlElementRef.getType());
    }

    public void testChangeMappingType() throws Exception {
        this.createTypeWithXmlElementRef();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementRefMapping xmlElementRefMapping = (XmlElementRefMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementRefMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementRefMappingTests.assertNotNull((Object)xmlElementRefMapping);
        GenericJavaXmlElementRefMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRef"));
        persistentAttribute.setMappingKey("xml-attribute");
        XmlAttributeMapping xmlAttributeMapping = (XmlAttributeMapping)persistentAttribute.getMapping();
        GenericJavaXmlElementRefMappingTests.assertNotNull((Object)xmlAttributeMapping);
        GenericJavaXmlElementRefMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRef"));
        GenericJavaXmlElementRefMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute"));
        persistentAttribute.setMappingKey("xml-element-ref");
        xmlElementRefMapping = (XmlElementRefMapping)persistentAttribute.getMapping();
        GenericJavaXmlElementRefMappingTests.assertNotNull((Object)xmlElementRefMapping);
        GenericJavaXmlElementRefMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRef"));
        GenericJavaXmlElementRefMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute"));
    }

    public void testModifyXmlJavaTypeAdapter() throws Exception {
        this.createTypeWithXmlElementRef();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementRefMapping xmlElementRefMapping = (XmlElementRefMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementRefMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementRefMappingTests.assertNull((Object)xmlElementRefMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlElementRefMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
        xmlElementRefMapping.addXmlJavaTypeAdapter();
        GenericJavaXmlElementRefMappingTests.assertNotNull((Object)xmlElementRefMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlElementRefMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
        xmlElementRefMapping.removeXmlJavaTypeAdapter();
        GenericJavaXmlElementRefMappingTests.assertNull((Object)xmlElementRefMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlElementRefMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
    }

    public void testUpdateXmlJavaTypeAdapter() throws Exception {
        this.createTypeWithXmlElementRef();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementRefMapping xmlElementRefMapping = (XmlElementRefMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementRefMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementRefMappingTests.assertNull((Object)xmlElementRefMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlElementRefMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementRefMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
            }
        });
        GenericJavaXmlElementRefMappingTests.assertNotNull((Object)xmlElementRefMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlElementRefMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementRefMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
            }
        });
        GenericJavaXmlElementRefMappingTests.assertNull((Object)xmlElementRefMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlElementRefMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
    }

    protected void addXmlElementRefMemberValuePair(ModifiedDeclaration declaration, String name, String value) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlElementRefAnnotation(declaration), name, value);
    }

    protected void addXmlElementRefMemberValuePair(ModifiedDeclaration declaration, String name, boolean value) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlElementRefAnnotation(declaration), name, value);
    }

    protected void addXmlElementRefTypeMemberValuePair(ModifiedDeclaration declaration, String name, String typeName) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlElementRefAnnotation(declaration), name, (Expression)this.newTypeLiteral(declaration.getAst(), typeName));
    }

    protected Annotation getXmlElementRefAnnotation(ModifiedDeclaration declaration) {
        return declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlElementRef");
    }

    public void testModifyXmlElementWrapper() throws Exception {
        this.createTypeWithXmlElementRef();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementRefMapping xmlElementRefMapping = (XmlElementRefMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementRefMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlElementWrapperAnnotation xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        GenericJavaXmlElementRefMappingTests.assertNull((Object)xmlElementRefMapping.getXmlElementWrapper());
        GenericJavaXmlElementRefMappingTests.assertNull((Object)xmlElementWrapperAnnotation);
        xmlElementRefMapping.addXmlElementWrapper();
        xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        GenericJavaXmlElementRefMappingTests.assertNotNull((Object)xmlElementRefMapping.getXmlElementWrapper());
        GenericJavaXmlElementRefMappingTests.assertNotNull((Object)xmlElementWrapperAnnotation);
        xmlElementRefMapping.removeXmlElementWrapper();
        xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
    }

    public void testUpdateXmlElementRefWrapper() throws Exception {
        this.createTypeWithXmlElementRef();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementRefMapping xmlElementRefMapping = (XmlElementRefMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementRefMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlElementWrapperAnnotation xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        GenericJavaXmlElementRefMappingTests.assertNull((Object)xmlElementRefMapping.getXmlElementWrapper());
        GenericJavaXmlElementRefMappingTests.assertNull((Object)xmlElementWrapperAnnotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementRefMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlElementWrapper");
            }
        });
        xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        GenericJavaXmlElementRefMappingTests.assertNotNull((Object)xmlElementRefMapping.getXmlElementWrapper());
        GenericJavaXmlElementRefMappingTests.assertNotNull((Object)xmlElementWrapperAnnotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementRefMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlElementWrapper");
            }
        });
        xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        GenericJavaXmlElementRefMappingTests.assertNull((Object)xmlElementRefMapping.getXmlElementWrapper());
        GenericJavaXmlElementRefMappingTests.assertNull((Object)xmlElementWrapperAnnotation);
    }

    public void testModifyXmlMixed() throws Exception {
        this.createTypeWithXmlElementRef();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementRefMapping attributeMapping = (XmlElementRefMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = attributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlMixedAnnotation annotation = (XmlMixedAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlMixed");
        GenericJavaXmlElementRefMappingTests.assertNull((Object)attributeMapping.getXmlMixed());
        GenericJavaXmlElementRefMappingTests.assertNull((Object)annotation);
        attributeMapping.addXmlMixed();
        annotation = (XmlMixedAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlMixed");
        GenericJavaXmlElementRefMappingTests.assertNotNull((Object)attributeMapping.getXmlMixed());
        GenericJavaXmlElementRefMappingTests.assertNotNull((Object)annotation);
        attributeMapping.removeXmlMixed();
        annotation = (XmlMixedAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlMixed");
        GenericJavaXmlElementRefMappingTests.assertNull((Object)attributeMapping.getXmlMixed());
        GenericJavaXmlElementRefMappingTests.assertNull((Object)annotation);
    }

    public void testUpdateXmlMixed() throws Exception {
        this.createTypeWithXmlElementRef();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementRefMapping attributeMapping = (XmlElementRefMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = attributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlMixedAnnotation annotation = (XmlMixedAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlMixed");
        GenericJavaXmlElementRefMappingTests.assertNull((Object)attributeMapping.getXmlMixed());
        GenericJavaXmlElementRefMappingTests.assertNull((Object)annotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementRefMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlMixed");
            }
        });
        annotation = (XmlMixedAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlMixed");
        GenericJavaXmlElementRefMappingTests.assertNotNull((Object)attributeMapping.getXmlMixed());
        GenericJavaXmlElementRefMappingTests.assertNotNull((Object)annotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementRefMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlMixed");
            }
        });
        annotation = (XmlMixedAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlMixed");
        GenericJavaXmlElementRefMappingTests.assertNull((Object)attributeMapping.getXmlMixed());
        GenericJavaXmlElementRefMappingTests.assertNull((Object)annotation);
    }
}

