/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.resource.java.XmlIDAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.resource.java.JaxbJavaResourceModelTestCase;

public class XmlIDAnnotationTests
extends JaxbJavaResourceModelTestCase {
    public XmlIDAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestXmlID() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlID"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlID");
            }
        });
    }

    public void testGetXmlID() throws Exception {
        ICompilationUnit cu = this.createTestXmlID();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlIDAnnotation xmlIDAnnotation = (XmlIDAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlID");
        XmlIDAnnotationTests.assertTrue((xmlIDAnnotation != null ? 1 : 0) != 0);
        resourceAttribute.removeAnnotation("javax.xml.bind.annotation.XmlID");
        this.assertSourceDoesNotContain("@XmlID", cu);
    }
}

