/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.tests.internal.resource.java;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.resource.java.NestableAnnotationDefinition;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.resource.java.JavaResourceModelTestCase;

public class SourceAttributeTests
extends JavaResourceModelTestCase {
    private static String TEST_CLASS_NAME = "TestClass";

    public SourceAttributeTests(String name) {
        super(name);
    }

    protected AnnotationDefinition[] annotationDefinitions() {
        return new AnnotationDefinition[0];
    }

    protected NestableAnnotationDefinition[] nestableAnnotationDefinitions() {
        return new NestableAnnotationDefinition[0];
    }

    private ICompilationUnit createTestClassWithVariousAttributes() throws CoreException {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import java.util.List;").append(CR);
                sb.append(CR);
                sb.append("public class ").append(TEST_CLASS_NAME).append("<T extends Number> ").append("{").append(CR);
                sb.append("    public String string;").append(CR);
                sb.append("    public List<String> stringList;").append(CR);
                sb.append("    public String[] stringArray;").append(CR);
                sb.append("    public String[][] stringDoubleArray;").append(CR);
                sb.append("    public T generic;").append(CR);
                sb.append("    public List<T> genericList;").append(CR);
                sb.append("    public T[] genericArray;").append(CR);
                sb.append("    public List<?> wildcardList;").append(CR);
                sb.append("}").append(CR);
            }
        };
        return this.javaProject.createCompilationUnit("test", String.valueOf(TEST_CLASS_NAME) + ".java", sourceWriter);
    }

    public void testAttributeTypes() throws Exception {
        ICompilationUnit testClassCU = this.createTestClassWithVariousAttributes();
        JavaResourceType testClass = this.buildJavaResourceType(testClassCU);
        JavaResourceField att = this.getField(testClass, 0);
        SourceAttributeTests.assertEquals((String)"string", (String)att.getName());
        SourceAttributeTests.assertEquals((String)"java.lang.String", (String)att.getTypeName());
        SourceAttributeTests.assertEquals((boolean)false, (boolean)att.typeIsArray());
        SourceAttributeTests.assertEquals(null, (String)att.getTypeArrayComponentTypeName());
        SourceAttributeTests.assertEquals((int)0, (int)att.getTypeArrayDimensionality());
        SourceAttributeTests.assertEquals((int)0, (int)att.getTypeTypeArgumentNamesSize());
        att = this.getField(testClass, 1);
        SourceAttributeTests.assertEquals((String)"stringList", (String)att.getName());
        SourceAttributeTests.assertEquals((String)"java.util.List", (String)att.getTypeName());
        SourceAttributeTests.assertEquals((boolean)false, (boolean)att.typeIsArray());
        SourceAttributeTests.assertEquals(null, (String)att.getTypeArrayComponentTypeName());
        SourceAttributeTests.assertEquals((int)0, (int)att.getTypeArrayDimensionality());
        SourceAttributeTests.assertEquals((int)1, (int)att.getTypeTypeArgumentNamesSize());
        SourceAttributeTests.assertEquals((String)"java.lang.String", (String)att.getTypeTypeArgumentName(0));
        att = this.getField(testClass, 2);
        SourceAttributeTests.assertEquals((String)"stringArray", (String)att.getName());
        SourceAttributeTests.assertEquals((String)"java.lang.String[]", (String)att.getTypeName());
        SourceAttributeTests.assertEquals((boolean)true, (boolean)att.typeIsArray());
        SourceAttributeTests.assertEquals((String)"java.lang.String", (String)att.getTypeArrayComponentTypeName());
        SourceAttributeTests.assertEquals((int)1, (int)att.getTypeArrayDimensionality());
        SourceAttributeTests.assertEquals((int)0, (int)att.getTypeTypeArgumentNamesSize());
        att = this.getField(testClass, 3);
        SourceAttributeTests.assertEquals((String)"stringDoubleArray", (String)att.getName());
        SourceAttributeTests.assertEquals((String)"java.lang.String[][]", (String)att.getTypeName());
        SourceAttributeTests.assertEquals((boolean)true, (boolean)att.typeIsArray());
        SourceAttributeTests.assertEquals((String)"java.lang.String", (String)att.getTypeArrayComponentTypeName());
        SourceAttributeTests.assertEquals((int)2, (int)att.getTypeArrayDimensionality());
        SourceAttributeTests.assertEquals((int)0, (int)att.getTypeTypeArgumentNamesSize());
        att = this.getField(testClass, 4);
        SourceAttributeTests.assertEquals((String)"generic", (String)att.getName());
        SourceAttributeTests.assertEquals((String)"java.lang.Number", (String)att.getTypeName());
        SourceAttributeTests.assertEquals((boolean)false, (boolean)att.typeIsArray());
        SourceAttributeTests.assertEquals(null, (String)att.getTypeArrayComponentTypeName());
        SourceAttributeTests.assertEquals((int)0, (int)att.getTypeArrayDimensionality());
        SourceAttributeTests.assertEquals((int)0, (int)att.getTypeTypeArgumentNamesSize());
        att = this.getField(testClass, 5);
        SourceAttributeTests.assertEquals((String)"genericList", (String)att.getName());
        SourceAttributeTests.assertEquals((String)"java.util.List", (String)att.getTypeName());
        SourceAttributeTests.assertEquals((boolean)false, (boolean)att.typeIsArray());
        SourceAttributeTests.assertEquals(null, (String)att.getTypeArrayComponentTypeName());
        SourceAttributeTests.assertEquals((int)0, (int)att.getTypeArrayDimensionality());
        SourceAttributeTests.assertEquals((int)1, (int)att.getTypeTypeArgumentNamesSize());
        SourceAttributeTests.assertEquals((String)"java.lang.Number", (String)att.getTypeTypeArgumentName(0));
        att = this.getField(testClass, 6);
        SourceAttributeTests.assertEquals((String)"genericArray", (String)att.getName());
        SourceAttributeTests.assertEquals((String)"java.lang.Number[]", (String)att.getTypeName());
        SourceAttributeTests.assertEquals((boolean)true, (boolean)att.typeIsArray());
        SourceAttributeTests.assertEquals((String)"java.lang.Number", (String)att.getTypeArrayComponentTypeName());
        SourceAttributeTests.assertEquals((int)1, (int)att.getTypeArrayDimensionality());
        SourceAttributeTests.assertEquals((int)0, (int)att.getTypeTypeArgumentNamesSize());
        att = this.getField(testClass, 7);
        SourceAttributeTests.assertEquals((String)"wildcardList", (String)att.getName());
        SourceAttributeTests.assertEquals((String)"java.util.List", (String)att.getTypeName());
        SourceAttributeTests.assertEquals((boolean)false, (boolean)att.typeIsArray());
        SourceAttributeTests.assertEquals(null, (String)att.getTypeArrayComponentTypeName());
        SourceAttributeTests.assertEquals((int)0, (int)att.getTypeArrayDimensionality());
        SourceAttributeTests.assertEquals((int)1, (int)att.getTypeTypeArgumentNamesSize());
        SourceAttributeTests.assertEquals((String)"java.lang.Object", (String)att.getTypeTypeArgumentName(0));
    }
}

