/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.BaseTemporalConverter;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.TemporalType;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.TemporalAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class JavaIdMappingTests
extends ContextModelTestCase {
    private ICompilationUnit createTestEntityWithIdMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithTemporal() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Temporal", "javax.persistence.TemporalType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
                sb.append("@Temporal(TemporalType.TIMESTAMP)").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithIdMappingGeneratedValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.GeneratedValue"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
                sb.append("@GeneratedValue").append(CR);
            }
        });
    }

    public JavaIdMappingTests(String name) {
        super(name);
    }

    public void testMorphToBasicMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)idMapping.getConverter()).setTemporalType(TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setMappingKey("basic");
        JavaIdMappingTests.assertEquals((String)"FOO", (String)((BasicMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        JavaIdMappingTests.assertEquals((Object)TemporalType.TIME, (Object)((BaseTemporalConverter)((BasicMapping)persistentAttribute.getMapping()).getConverter()).getTemporalType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        JavaIdMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Basic"));
        JavaIdMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        JavaIdMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToDefault() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)idMapping.getConverter()).setTemporalType(TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaIdMappingTests.assertEquals((String)"FOO", (String)((BasicMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        JavaIdMappingTests.assertEquals((Object)TemporalType.TIME, (Object)((BaseTemporalConverter)((BasicMapping)persistentAttribute.getMapping()).getConverter()).getTemporalType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        JavaIdMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        JavaIdMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToVersionMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)idMapping.getConverter()).setTemporalType(TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setMappingKey("version");
        JavaIdMappingTests.assertEquals((String)"FOO", (String)((VersionMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        JavaIdMappingTests.assertEquals((Object)TemporalType.TIME, (Object)((BaseTemporalConverter)((VersionMapping)persistentAttribute.getMapping()).getConverter()).getTemporalType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        JavaIdMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        JavaIdMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        JavaIdMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)idMapping.getConverter()).setTemporalType(TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setMappingKey("embedded");
        JavaIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        JavaIdMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToTransientMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)idMapping.getConverter()).setTemporalType(TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setMappingKey("transient");
        JavaIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        JavaIdMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Transient"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)idMapping.getConverter()).setTemporalType(TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setMappingKey("embeddedId");
        JavaIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        JavaIdMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.EmbeddedId"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToOneToOneMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)idMapping.getConverter()).setTemporalType(TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setMappingKey("oneToOne");
        JavaIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToOneMapping));
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        JavaIdMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToOneToManyMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)idMapping.getConverter()).setTemporalType(TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setMappingKey("oneToMany");
        JavaIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        JavaIdMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToMany"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToManyToOneMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)idMapping.getConverter()).setTemporalType(TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setMappingKey("manyToOne");
        JavaIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        JavaIdMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ManyToOne"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToManyToManyMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)idMapping.getConverter()).setTemporalType(TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setMappingKey("manyToMany");
        JavaIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToManyMapping));
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        JavaIdMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ManyToMany"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testGetTemporal() throws Exception {
        this.createTestEntityWithTemporal();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertEquals((Object)TemporalType.TIMESTAMP, (Object)((BaseTemporalConverter)idMapping.getConverter()).getTemporalType());
    }

    public void testSetTemporal() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertNull((Object)idMapping.getConverter().getType());
        idMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)idMapping.getConverter()).setTemporalType(TemporalType.TIME);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        TemporalAnnotation temporal = (TemporalAnnotation)resourceField.getAnnotation("javax.persistence.Temporal");
        JavaIdMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.TemporalType.TIME, (Object)temporal.getValue());
        idMapping.setConverter(null);
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
    }

    public void testGetTemporalUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertNull((Object)idMapping.getConverter().getType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        TemporalAnnotation temporal = (TemporalAnnotation)resourceField.addAnnotation("javax.persistence.Temporal");
        temporal.setValue(org.eclipse.jpt.jpa.core.resource.java.TemporalType.DATE);
        this.getJpaProject().synchronizeContextModel();
        JavaIdMappingTests.assertEquals((Object)TemporalType.DATE, (Object)((BaseTemporalConverter)idMapping.getConverter()).getTemporalType());
        resourceField.removeAnnotation("javax.persistence.Temporal");
        this.getJpaProject().synchronizeContextModel();
        JavaIdMappingTests.assertNull((Object)idMapping.getConverter().getType());
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        JavaIdMappingTests.assertSame((Object)idMapping, (Object)persistentAttribute.getMapping());
    }

    public void testGetColumn() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertNull((Object)idMapping.getColumn().getSpecifiedName());
        JavaIdMappingTests.assertEquals((String)"id", (String)idMapping.getColumn().getName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ColumnAnnotation column = (ColumnAnnotation)resourceField.addAnnotation("javax.persistence.Column");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaIdMappingTests.assertEquals((String)"foo", (String)idMapping.getColumn().getSpecifiedName());
        JavaIdMappingTests.assertEquals((String)"foo", (String)idMapping.getColumn().getName());
        JavaIdMappingTests.assertEquals((String)"id", (String)idMapping.getColumn().getDefaultName());
    }

    public void testGetSequenceGenerator() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertNull((Object)idMapping.getGeneratorContainer().getSequenceGenerator());
        JavaIdMappingTests.assertEquals((int)0, (int)idMapping.getPersistenceUnit().getGeneratorsSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation("javax.persistence.SequenceGenerator");
        this.getJpaProject().synchronizeContextModel();
        JavaIdMappingTests.assertNotNull((Object)idMapping.getGeneratorContainer().getSequenceGenerator());
        JavaIdMappingTests.assertEquals((int)2, (int)resourceField.getAnnotationsSize());
        JavaIdMappingTests.assertEquals((int)1, (int)idMapping.getPersistenceUnit().getGeneratorsSize());
        idMapping.getGeneratorContainer().getSequenceGenerator().setName("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaIdMappingTests.assertEquals((int)1, (int)idMapping.getPersistenceUnit().getGeneratorsSize());
    }

    public void testAddSequenceGenerator() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertNull((Object)idMapping.getGeneratorContainer().getSequenceGenerator());
        idMapping.getGeneratorContainer().addSequenceGenerator();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaIdMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNotNull((Object)idMapping.getGeneratorContainer().getSequenceGenerator());
        try {
            idMapping.getGeneratorContainer().addSequenceGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        JavaIdMappingTests.fail((String)"IllegalStateException not thrown");
    }

    public void testRemoveSequenceGenerator() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation("javax.persistence.SequenceGenerator");
        this.getJpaProject().synchronizeContextModel();
        idMapping.getGeneratorContainer().removeSequenceGenerator();
        JavaIdMappingTests.assertNull((Object)idMapping.getGeneratorContainer().getSequenceGenerator());
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.SequenceGenerator"));
        try {
            idMapping.getGeneratorContainer().removeSequenceGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        JavaIdMappingTests.fail((String)"IllegalStateException not thrown");
    }

    public void testGetTableGenerator() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator());
        JavaIdMappingTests.assertEquals((int)0, (int)idMapping.getPersistenceUnit().getGeneratorsSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation("javax.persistence.TableGenerator");
        this.getJpaProject().synchronizeContextModel();
        JavaIdMappingTests.assertNotNull((Object)idMapping.getGeneratorContainer().getTableGenerator());
        JavaIdMappingTests.assertEquals((int)2, (int)resourceField.getAnnotationsSize());
        JavaIdMappingTests.assertEquals((int)1, (int)idMapping.getPersistenceUnit().getGeneratorsSize());
        idMapping.getGeneratorContainer().getTableGenerator().setName("foo");
        JavaIdMappingTests.assertEquals((int)1, (int)idMapping.getPersistenceUnit().getGeneratorsSize());
    }

    public void testAddTableGenerator() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator());
        idMapping.getGeneratorContainer().addTableGenerator();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaIdMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNotNull((Object)idMapping.getGeneratorContainer().getTableGenerator());
        try {
            idMapping.getGeneratorContainer().addTableGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        JavaIdMappingTests.fail((String)"IllegalStateException not thrown");
    }

    public void testRemoveTableGenerator() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation("javax.persistence.TableGenerator");
        this.getJpaProject().synchronizeContextModel();
        idMapping.getGeneratorContainer().removeTableGenerator();
        JavaIdMappingTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator());
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.TableGenerator"));
        try {
            idMapping.getGeneratorContainer().removeTableGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        JavaIdMappingTests.fail((String)"IllegalStateException not thrown");
    }

    public void testGetGeneratedValue() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertNull((Object)idMapping.getGeneratedValue());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation("javax.persistence.GeneratedValue");
        this.getJpaProject().synchronizeContextModel();
        JavaIdMappingTests.assertNotNull((Object)idMapping.getGeneratedValue());
        JavaIdMappingTests.assertEquals((int)2, (int)resourceField.getAnnotationsSize());
    }

    public void testGetGeneratedValue2() throws Exception {
        this.addXmlClassRef("test.AnnotationTestType");
        this.createTestEntityWithIdMappingGeneratedValue();
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaIdMappingTests.assertNotNull((Object)idMapping.getGeneratedValue());
        JavaIdMappingTests.assertEquals((int)2, (int)resourceField.getAnnotationsSize());
    }

    public void testAddGeneratedValue() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertNull((Object)idMapping.getGeneratedValue());
        idMapping.addGeneratedValue();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaIdMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.GeneratedValue"));
        JavaIdMappingTests.assertNotNull((Object)idMapping.getGeneratedValue());
        try {
            idMapping.addGeneratedValue();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        JavaIdMappingTests.fail((String)"IllegalStateException not thrown");
    }

    public void testRemoveGeneratedValue() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation("javax.persistence.GeneratedValue");
        this.getJpaProject().synchronizeContextModel();
        idMapping.removeGeneratedValue();
        JavaIdMappingTests.assertNull((Object)idMapping.getGeneratedValue());
        JavaIdMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.GeneratedValue"));
        try {
            idMapping.removeGeneratedValue();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        JavaIdMappingTests.fail((String)"IllegalStateException not thrown");
    }
}

