/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JoinTable;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmEntity;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.jpa2.context.Cascade2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.ManyToOneMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.ManyToOneRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaManyToOneMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaManyToOneRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmDerivedIdentity2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmManyToOneMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmManyToOneRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmOneToOneMapping2_0;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlManyToOne;
import org.eclipse.jpt.jpa.core.resource.orm.XmlOneToOne;
import org.eclipse.jpt.jpa.core.resource.orm.v2_0.XmlDerivedId_2_0;
import org.eclipse.jpt.jpa.core.resource.orm.v2_0.XmlMapsId_2_0;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericOrmManyToOneMapping2_0Tests
extends Generic2_0ContextModelTestCase {
    public GenericOrmManyToOneMapping2_0Tests(String name) {
        super(name);
    }

    private void createTestEntityWithIdDerivedIdentity() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToOne @Id").append(CR);
                sb.append("    private AnnotationTestType manyToOne;").append(CR);
                sb.append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmReadOnlyPersistentAttribute each : ormPersistentType.getAttributes()) {
            each.addToXml();
        }
    }

    private void createTestEntityWithMapsIdDerivedIdentity() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne", "javax.persistence.MapsId"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToOne @MapsId").append(CR);
                sb.append("    private AnnotationTestType manyToOne;").append(CR);
                sb.append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmReadOnlyPersistentAttribute each : ormPersistentType.getAttributes()) {
            each.addToXml();
        }
    }

    private ICompilationUnit createTestEntityWithValidManyToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToOne").append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEntityWithManyToOneMapping() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToOne").append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmReadOnlyPersistentAttribute each : ormPersistentType.getAttributes()) {
            each.addToXml();
        }
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityManyToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne", "javax.persistence.JoinColumn", "javax.persistence.FetchType", "javax.persistence.CascadeType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToOne(fetch=FetchType.LAZY, optional=false, targetEntity=Address.class, cascade={CascadeType.ALL, CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.REFRESH, CascadeType.DETACH})");
                sb.append(CR);
                sb.append("    @JoinColumn(name=\"MY_COLUMN\", referencedColumnName=\"MY_REFERENCED_COLUMN\", unique=true, nullable=false, insertable=false, updatable=false, columnDefinition=\"COLUMN_DEFINITION\", table=\"MY_TABLE\")");
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    public void testUpdateId() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        OrmManyToOneMapping2_0 contextMapping = (OrmManyToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlDerivedId_2_0 resourceMapping = (XmlDerivedId_2_0)resourceEntity.getAttributes().getManyToOnes().get(0);
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceMapping.setId(Boolean.TRUE);
        GenericOrmManyToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceMapping.setId(Boolean.FALSE);
        GenericOrmManyToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceMapping.setId(null);
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
    }

    public void testSetDerivedId() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        OrmManyToOneMapping2_0 contextMapping = (OrmManyToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlDerivedId_2_0 resourceMapping = (XmlDerivedId_2_0)resourceEntity.getAttributes().getManyToOnes().get(0);
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().setValue(true);
        GenericOrmManyToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().setValue(false);
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
    }

    public void testUpdateMapsId() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        OrmManyToOneMapping2_0 contextMapping = (OrmManyToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlMapsId_2_0 resourceMapping = (XmlMapsId_2_0)resourceEntity.getAttributes().getManyToOnes().get(0);
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        resourceMapping.setMapsId("foo");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"foo", (String)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"foo", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        resourceMapping.setMapsId("bar");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"bar", (String)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"bar", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        resourceMapping.setMapsId("");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"", (String)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        resourceMapping.setMapsId(null);
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
    }

    public void testSetMapsId() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        OrmManyToOneMapping2_0 contextMapping = (OrmManyToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlMapsId_2_0 resourceMapping = (XmlMapsId_2_0)resourceEntity.getAttributes().getManyToOnes().get(0);
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedIdAttributeName("foo");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"foo", (String)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"foo", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedIdAttributeName("bar");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"bar", (String)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"bar", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedIdAttributeName("");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"", (String)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedIdAttributeName(null);
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
    }

    public void testUpdatePredominantDerivedIdentityStrategy() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        OrmManyToOneMapping2_0 contextMapping = (OrmManyToOneMapping2_0)contextAttribute.getMapping();
        OrmDerivedIdentity2_0 derivedIdentity = contextMapping.getDerivedIdentity();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlManyToOne resourceMapping = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        resourceMapping.setMapsId("foo");
        GenericOrmManyToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        resourceMapping.setId(Boolean.TRUE);
        GenericOrmManyToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        resourceMapping.setMapsId(null);
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        resourceMapping.setId(null);
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
    }

    public void testSetPredominantDerivedIdentityStrategy() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        OrmManyToOneMapping2_0 contextMapping = (OrmManyToOneMapping2_0)contextAttribute.getMapping();
        OrmDerivedIdentity2_0 derivedIdentity = contextMapping.getDerivedIdentity();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlManyToOne resourceMapping = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        derivedIdentity.setMapsIdDerivedIdentityStrategy();
        GenericOrmManyToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        derivedIdentity.setIdDerivedIdentityStrategy();
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        derivedIdentity.setNullDerivedIdentityStrategy();
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
    }

    public void testMorphMapping() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = (OrmPersistentAttribute)contextType.getAttributeNamed("manyToOne");
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlManyToOne resourceManyToOne = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        resourceManyToOne.setMapsId("foo");
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceManyToOne.getId());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)((OrmManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"foo", (String)resourceManyToOne.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"foo", (String)((OrmManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextAttribute.setMappingKey("oneToOne");
        XmlOneToOne resourceOneToOne = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceOneToOne.getId());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)((OrmOneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"foo", (String)resourceOneToOne.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"foo", (String)((OrmOneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextAttribute.setMappingKey("manyToOne");
        resourceManyToOne = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceManyToOne.getId());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)((OrmManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"foo", (String)resourceManyToOne.getMapsId());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"foo", (String)((OrmManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
    }

    public void testVirtualJoinTable() throws Exception {
        this.createTestEntityWithValidManyToOneMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        JavaManyToOneMapping2_0 javaManyToOneMapping = (JavaManyToOneMapping2_0)ormPersistentAttribute.getJavaPersistentAttribute().getMapping();
        ManyToOneMapping2_0 virtualManyToOneMapping = (ManyToOneMapping2_0)ormPersistentAttribute.getMapping();
        ((ManyToOneRelationship2_0)javaManyToOneMapping.getRelationship()).setStrategyToJoinTable();
        JoinTable virtualJoinTable = ((ManyToOneRelationship2_0)virtualManyToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable();
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmManyToOneMapping2_0Tests.assertEquals(null, (String)virtualJoinTable.getSpecifiedName());
        this.createTestTargetEntityAddress();
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)virtualJoinTable.getName());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)virtualJoinTable.getSpecifiedCatalog());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)virtualJoinTable.getSpecifiedSchema());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((int)0, (int)virtualJoinTable.getSpecifiedJoinColumnsSize());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((int)0, (int)virtualJoinTable.getSpecifiedInverseJoinColumnsSize());
        JoinColumn virtualJoinColumn = virtualJoinTable.getDefaultJoinColumn();
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)virtualJoinColumn.getDefaultTable());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"AnnotationTestType_id", (String)virtualJoinColumn.getDefaultName());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"id", (String)virtualJoinColumn.getDefaultReferencedColumnName());
        JoinColumn virtualInverseJoinColumn = virtualJoinTable.getDefaultInverseJoinColumn();
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)virtualInverseJoinColumn.getDefaultTable());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"address_id", (String)virtualInverseJoinColumn.getDefaultName());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"id", (String)virtualInverseJoinColumn.getDefaultReferencedColumnName());
        JavaJoinTable javaJoinTable = ((JavaManyToOneRelationship2_0)javaManyToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable();
        javaJoinTable.setSpecifiedName("FOO");
        javaJoinTable.setSpecifiedCatalog("CATALOG");
        javaJoinTable.setSpecifiedSchema("SCHEMA");
        JavaJoinColumn javaJoinColumn = javaJoinTable.addSpecifiedJoinColumn(0);
        javaJoinColumn.setSpecifiedName("NAME");
        javaJoinColumn.setSpecifiedReferencedColumnName("REFERENCED_NAME");
        JavaJoinColumn inverseJavaJoinColumn = javaJoinTable.addSpecifiedInverseJoinColumn(0);
        inverseJavaJoinColumn.setSpecifiedName("INVERSE_NAME");
        inverseJavaJoinColumn.setSpecifiedReferencedColumnName("INVERSE_REFERENCED_NAME");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"FOO", (String)virtualJoinTable.getSpecifiedName());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"CATALOG", (String)virtualJoinTable.getSpecifiedCatalog());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"SCHEMA", (String)virtualJoinTable.getSpecifiedSchema());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((int)1, (int)virtualJoinTable.getSpecifiedJoinColumnsSize());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((int)1, (int)virtualJoinTable.getSpecifiedInverseJoinColumnsSize());
        virtualJoinColumn = (JoinColumn)virtualJoinTable.getSpecifiedJoinColumns().iterator().next();
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"NAME", (String)virtualJoinColumn.getSpecifiedName());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"REFERENCED_NAME", (String)virtualJoinColumn.getSpecifiedReferencedColumnName());
        virtualInverseJoinColumn = (JoinColumn)virtualJoinTable.getSpecifiedInverseJoinColumns().iterator().next();
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"INVERSE_NAME", (String)virtualInverseJoinColumn.getSpecifiedName());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"INVERSE_REFERENCED_NAME", (String)virtualInverseJoinColumn.getSpecifiedReferencedColumnName());
    }

    public void testUpdateDefaultNameFromJavaTable() throws Exception {
        this.createTestEntityWithValidManyToOneMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("address"), "manyToOne");
        OrmManyToOneMapping2_0 ormManyToOneMapping = (OrmManyToOneMapping2_0)ormPersistentAttribute.getMapping();
        ((ManyToOneRelationship2_0)ormManyToOneMapping.getRelationship()).setStrategyToJoinTable();
        OrmJoinTable ormJoinTable = ((OrmManyToOneRelationship2_0)ormManyToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable();
        GenericOrmManyToOneMapping2_0Tests.assertEquals(null, (String)ormJoinTable.getDefaultName());
        this.createTestTargetEntityAddress();
        OrmPersistentType targetPersistentType = this.getEntityMappings().addPersistentType("entity", "test.Address");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)ormJoinTable.getDefaultName());
        ((JavaEntity)targetPersistentType.getJavaPersistentType().getMapping()).getTable().setSpecifiedName("FOO");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"AnnotationTestType_FOO", (String)ormJoinTable.getDefaultName());
        ((JavaEntity)ormPersistentType.getJavaPersistentType().getMapping()).getTable().setSpecifiedName("BAR");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getDefaultName());
        JavaManyToOneMapping2_0 javaManyToOneMapping = (JavaManyToOneMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("address").getMapping();
        ((ManyToOneRelationship2_0)javaManyToOneMapping.getRelationship()).setStrategyToJoinTable();
        ((ManyToOneRelationship2_0)javaManyToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable().setSpecifiedName("JAVA_JOIN_TABLE");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getDefaultName());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)ormJoinTable.getDefaultName());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        ormPersistentAttribute.removeFromXml();
        OrmReadOnlyPersistentAttribute virtualPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        ManyToOneMapping2_0 virtualManyToOneMapping = (ManyToOneMapping2_0)virtualPersistentAttribute.getMapping();
        JoinTable virtualJoinTable = ((ManyToOneRelationship2_0)virtualManyToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable();
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)virtualPersistentAttribute.isVirtual());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"JAVA_JOIN_TABLE", (String)virtualJoinTable.getSpecifiedName());
        ((ManyToOneRelationship2_0)javaManyToOneMapping.getRelationship()).getJoinTableStrategy().removeStrategy();
        virtualJoinTable = ((ManyToOneRelationship2_0)virtualManyToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable();
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)virtualJoinTable);
        ((ManyToOneRelationship2_0)javaManyToOneMapping.getRelationship()).setStrategyToJoinTable();
        virtualJoinTable = ((ManyToOneRelationship2_0)virtualManyToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable();
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)virtualJoinTable.getSpecifiedName());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"BAR_FOO", (String)virtualJoinTable.getDefaultName());
        ((OrmEntity)ormPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TABLE_NAME");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"ORM_TABLE_NAME_FOO", (String)virtualJoinTable.getDefaultName());
        ((OrmEntity)targetPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TARGET");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"ORM_TABLE_NAME_ORM_TARGET", (String)virtualJoinTable.getDefaultName());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute contextAttribute = contextType.getAttributeNamed("id");
        OrmManyToOneMapping2_0 contextMapping = (OrmManyToOneMapping2_0)contextAttribute.getMapping();
        OrmManyToOneRelationship2_0 rel = (OrmManyToOneRelationship2_0)contextMapping.getRelationship();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlManyToOne resourceMapping = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToJoinColumn();
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToJoinTable();
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmManyToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getJoinTable());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToJoinColumn();
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute contextAttribute = contextType.getAttributeNamed("id");
        OrmManyToOneMapping2_0 contextMapping = (OrmManyToOneMapping2_0)contextAttribute.getMapping();
        OrmManyToOneRelationship2_0 rel = (OrmManyToOneRelationship2_0)contextMapping.getRelationship();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlManyToOne resourceMapping = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceMapping.getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        this.getJpaProject().synchronizeContextModel();
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceMapping.getJoinColumns().clear();
        this.getJpaProject().synchronizeContextModel();
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmManyToOneMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceMapping.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        this.getJpaProject().synchronizeContextModel();
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmManyToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getJoinTable());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinTable());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityManyToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((int)3, (int)ormPersistentType.getDefaultAttributesSize());
        OrmReadOnlyPersistentAttribute virtualPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        ManyToOneMapping virtualManyToOneMapping = (ManyToOneMapping)virtualPersistentAttribute.getMapping();
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"address", (String)virtualManyToOneMapping.getName());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((Object)FetchType.LAZY, (Object)virtualManyToOneMapping.getSpecifiedFetch());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)virtualManyToOneMapping.getSpecifiedOptional());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"Address", (String)virtualManyToOneMapping.getSpecifiedTargetEntity());
        JoinColumn virtualJoinColumn = (JoinColumn)virtualManyToOneMapping.getRelationship().getJoinColumnStrategy().getSpecifiedJoinColumns().iterator().next();
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"MY_COLUMN", (String)virtualJoinColumn.getSpecifiedName());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"MY_REFERENCED_COLUMN", (String)virtualJoinColumn.getSpecifiedReferencedColumnName());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)virtualJoinColumn.getSpecifiedUnique());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)virtualJoinColumn.getSpecifiedNullable());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)virtualJoinColumn.getSpecifiedInsertable());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)virtualJoinColumn.getSpecifiedUpdatable());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualJoinColumn.getColumnDefinition());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"MY_TABLE", (String)virtualJoinColumn.getSpecifiedTable());
        Cascade2_0 cascade = (Cascade2_0)virtualManyToOneMapping.getCascade();
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)cascade.isAll());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)cascade.isMerge());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)cascade.isPersist());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)cascade.isRemove());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)cascade.isRefresh());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)cascade.isDetach());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityManyToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        GenericOrmManyToOneMapping2_0Tests.assertEquals((int)3, (int)ormPersistentType.getDefaultAttributesSize());
        OrmReadOnlyPersistentAttribute virtualPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)virtualPersistentAttribute.getMappingKey());
        GenericOrmManyToOneMapping2_0Tests.assertTrue((boolean)virtualPersistentAttribute.isVirtual());
        virtualPersistentAttribute.addToXml("manyToOne");
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"address", (String)ormManyToOneMapping.getName());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((Object)FetchType.EAGER, (Object)ormManyToOneMapping.getDefaultFetch());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((boolean)true, (boolean)ormManyToOneMapping.isDefaultOptional());
        GenericOrmManyToOneMapping2_0Tests.assertEquals((String)"test.Address", (String)ormManyToOneMapping.getDefaultTargetEntity());
        Cascade2_0 cascade = (Cascade2_0)ormManyToOneMapping.getCascade();
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)cascade.isAll());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)cascade.isMerge());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)cascade.isPersist());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)cascade.isRemove());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)cascade.isRefresh());
        GenericOrmManyToOneMapping2_0Tests.assertFalse((boolean)cascade.isDetach());
    }
}

