/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.metadata;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JpaMetadataTests
extends AnnotationTestCase {
    private static final String SETTINGS_DIR = ".settings/";
    private static final String ECLIPSE_CORE_SETTINGS_DIR = ".metadata/.plugins/org.eclipse.core.runtime/.settings/";
    public static final String PREFS_FILE_NAME = "org.eclipse.jpt.core.prefs";
    protected IEclipsePreferences workspacePreferences;
    private String eclipseCoreSettingsDir;
    private String projectSettingsDir;

    protected JpaMetadataTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        IPath workspacePath = this.getWorkspaceRoot().getLocation();
        this.eclipseCoreSettingsDir = workspacePath + "/" + ECLIPSE_CORE_SETTINGS_DIR;
        IPath projectPath = this.javaProject.getProject().getLocation();
        this.projectSettingsDir = projectPath + "/" + SETTINGS_DIR;
    }

    protected Map<String, String> getWorkspacePrefs() {
        return this.getSettings(String.valueOf(this.eclipseCoreSettingsDir) + PREFS_FILE_NAME);
    }

    protected Map<String, String> getProjectPrefs() {
        return this.getSettings(String.valueOf(this.projectSettingsDir) + PREFS_FILE_NAME);
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private Map<String, String> getSettings(String settingsPath) {
        Set<Map.Entry<Object, Object>> settingsSet = null;
        try {
            settingsSet = this.loadMetadata(settingsPath);
        }
        catch (IOException e) {
            throw new RuntimeException("Missing: " + settingsPath, e);
        }
        HashMap<String, String> settings = new HashMap<String, String>();
        for (Map.Entry<Object, Object> property : settingsSet) {
            settings.put((String)property.getKey(), (String)property.getValue());
        }
        return settings;
    }

    private Set<Map.Entry<Object, Object>> loadMetadata(String metadataPath) throws IOException {
        FileInputStream stream = new FileInputStream(metadataPath);
        Properties properties = new Properties();
        properties.load(stream);
        stream.close();
        return properties.entrySet();
    }
}

