/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMember;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class AttributeOverridesTests
extends JpaJavaResourceModelTestCase {
    private static final String COLUMN_NAME = "MY_COLUMN";
    private static final String ATTRIBUTE_OVERRIDE_NAME = "MY_ATTRIBUTE_OVERRIDE";

    public AttributeOverridesTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestAttributeOverrideOnField() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides", "javax.persistence.Column"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@AttributeOverrides(@AttributeOverride(name = \"MY_ATTRIBUTE_OVERRIDE\"))");
            }
        });
    }

    private ICompilationUnit createTestAttributeOverrideWithColumnOnField() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides", "javax.persistence.Column"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@AttributeOverrides(@AttributeOverride(name = \"MY_ATTRIBUTE_OVERRIDE\", column = @Column(name = \"MY_COLUMN\")))");
            }
        });
    }

    private ICompilationUnit createTestAttributeOverride() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.AttributeOverride", "javax.persistence.Column"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append(CR);
                sb.append("@AttributeOverride(name = \"FOO\", column = @Column(name = \"FOO\", columnDefinition = \"BAR\", table = \"BAZ\", unique = false, nullable = false, insertable = false, updatable = false, length = 1, precision = 1, scale = 1))");
            }
        });
    }

    private AttributeOverrideAnnotation getAttributeOverrideAnnotationAt(JavaResourceMember resourceMember, int index) {
        return (AttributeOverrideAnnotation)resourceMember.getAnnotation(index, "javax.persistence.AttributeOverride");
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverrideOnField();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        AttributeOverrideAnnotation attributeOverride = this.getAttributeOverrideAnnotationAt((JavaResourceMember)resourceField, 0);
        AttributeOverridesTests.assertNotNull((Object)attributeOverride);
        AttributeOverridesTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
    }

    public void testGetNullColumn() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverrideOnField();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        AttributeOverrideAnnotation attributeOverride = this.getAttributeOverrideAnnotationAt((JavaResourceMember)resourceField, 0);
        ColumnAnnotation column = attributeOverride.getColumn();
        AttributeOverridesTests.assertNotNull((Object)attributeOverride);
        AttributeOverridesTests.assertNull((Object)column);
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverrideOnField();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        AttributeOverrideAnnotation attributeOverride = this.getAttributeOverrideAnnotationAt((JavaResourceMember)resourceField, 0);
        AttributeOverridesTests.assertNotNull((Object)attributeOverride);
        AttributeOverridesTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        attributeOverride.setName("Foo");
        AttributeOverridesTests.assertEquals((String)"Foo", (String)attributeOverride.getName());
        this.assertSourceContains("@AttributeOverrides(@AttributeOverride(name = \"Foo\"))", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverrideOnField();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        AttributeOverrideAnnotation attributeOverride = this.getAttributeOverrideAnnotationAt((JavaResourceMember)resourceField, 0);
        AttributeOverridesTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        attributeOverride.setName(null);
        AttributeOverridesTests.assertNull((Object)attributeOverride.getName());
        this.assertSourceDoesNotContain("@AttributeOverride(name=\"MY_ATTRIBUTE_OVERRIDE\")", cu);
        this.assertSourceContains("@AttributeOverride", cu);
        this.assertSourceContains("@AttributeOverrides", cu);
    }

    public void testColumnGetName() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverrideWithColumnOnField();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        AttributeOverrideAnnotation attributeOverride = this.getAttributeOverrideAnnotationAt((JavaResourceMember)resourceField, 0);
        ColumnAnnotation column = attributeOverride.getColumn();
        AttributeOverridesTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
    }

    public void testColumnSetName() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverrideWithColumnOnField();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        AttributeOverrideAnnotation attributeOverride = this.getAttributeOverrideAnnotationAt((JavaResourceMember)resourceField, 0);
        ColumnAnnotation column = attributeOverride.getColumn();
        AttributeOverridesTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
        column.setName("Foo");
        this.assertSourceContains("@AttributeOverrides(@AttributeOverride(name = \"MY_ATTRIBUTE_OVERRIDE\", column = @Column(name = \"Foo\")))", cu);
        column.setName(null);
        AttributeOverridesTests.assertNull((Object)attributeOverride.getColumn().getName());
        attributeOverride.removeColumn();
        AttributeOverridesTests.assertNull((Object)attributeOverride.getColumn());
        this.assertSourceContains("@AttributeOverride(name = \"MY_ATTRIBUTE_OVERRIDE\")", cu);
    }

    public void testAddAttributeOverrideCopyExisting() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverride();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        String expected1 = "@AttributeOverrides({";
        String expected2 = "@AttributeOverride(name = \"FOO\", column = @Column(name = \"FOO\", columnDefinition = \"BAR\", table = \"BAZ\", unique = false, nullable = false, insertable = false, updatable = false, length = 1, precision = 1, scale = 1)),";
        String expected3 = "@AttributeOverride(name = \"BAR\") })";
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceType.addAnnotation(1, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAR");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        AttributeOverridesTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.AttributeOverride"));
        AttributeOverridesTests.assertNotNull((Object)resourceType.getAnnotation("javax.persistence.AttributeOverrides"));
        AttributeOverridesTests.assertNotNull((Object)resourceType.getAnnotation(0, "javax.persistence.AttributeOverride"));
        AttributeOverridesTests.assertEquals((int)2, (int)resourceType.getAnnotationsSize("javax.persistence.AttributeOverride"));
    }

    public void testAddAttributeOverrideToBeginningOfList() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverride();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        String expected1 = "@AttributeOverrides({";
        String expected2 = "@AttributeOverride(name = \"FOO\", column = @Column(name = \"FOO\", columnDefinition = \"BAR\", table = \"BAZ\", unique = false, nullable = false, insertable = false, updatable = false, length = 1, precision = 1, scale = 1)),";
        String expected3 = "@AttributeOverride(name = \"BAR\") })";
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceType.addAnnotation(1, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAR");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        expected2 = "@AttributeOverride(name = \"BAZ\"),";
        expected3 = "@AttributeOverride(name = \"FOO\", column = @Column(name = \"FOO\", columnDefinition = \"BAR\", table = \"BAZ\", unique = false, nullable = false, insertable = false, updatable = false, length = 1, precision = 1, scale = 1)), @AttributeOverride(name = \"BAR\") })";
        attributeOverride = (AttributeOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAZ");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        ListIterator attributeOverrides = resourceType.getAnnotations("javax.persistence.AttributeOverride").iterator();
        AttributeOverridesTests.assertEquals((String)"BAZ", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        AttributeOverridesTests.assertEquals((String)"FOO", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        AttributeOverridesTests.assertEquals((String)"BAR", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        AttributeOverridesTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.AttributeOverride"));
        AttributeOverridesTests.assertNotNull((Object)resourceType.getAnnotation("javax.persistence.AttributeOverrides"));
        AttributeOverridesTests.assertNotNull((Object)resourceType.getAnnotation(0, "javax.persistence.AttributeOverride"));
        AttributeOverridesTests.assertEquals((int)3, (int)resourceType.getAnnotationsSize("javax.persistence.AttributeOverride"));
    }

    public void testRemoveAttributeOverrideCopyExisting() throws Exception {
        ICompilationUnit cu = this.createTestAttributeOverride();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        String expected1 = "@AttributeOverrides({";
        String expected2 = "@AttributeOverride(name = \"FOO\", column = @Column(name = \"FOO\", columnDefinition = \"BAR\", table = \"BAZ\", unique = false, nullable = false, insertable = false, updatable = false, length = 1, precision = 1, scale = 1)),";
        String expected3 = "@AttributeOverride(name = \"BAR\") })";
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceType.addAnnotation(1, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAR");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        expected1 = "@AttributeOverride(name = \"FOO\", column = @Column(name = \"FOO\", columnDefinition = \"BAR\", table = \"BAZ\", unique = false, nullable = false, insertable = false, updatable = false, length = 1, precision = 1, scale = 1))";
        resourceType.removeAnnotation(1, "javax.persistence.AttributeOverride");
        this.assertSourceContains(expected1, cu);
        this.assertSourceDoesNotContain("@AttributeOverrides", cu);
    }
}

