/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.HTTPUtils;
import org.eclipse.wst.wsi.internal.core.util.OperationSignature;
import org.eclipse.wst.wsi.internal.core.util.TypesRegistry;
import org.eclipse.wst.wsi.internal.core.wsdl.WSDLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BP1318
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1318(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            TypesRegistry registry;
            Binding binding;
            OperationSignature.OperationMatch match;
            if (this.validator.isOneWayResponse(entryContext)) {
                throw new AssertionNotApplicableException();
            }
            Document responseDoc = entryContext.getMessageEntryDocument();
            Document requestDoc = entryContext.getRequestDocument();
            if (responseDoc == null || requestDoc == null) {
                throw new AssertionNotApplicableException();
            }
            String headers = entryContext.getRequest().getHTTPHeaders();
            String action = null;
            if (headers != null) {
                action = (String)HTTPUtils.getHttpHeaderTokens(headers, ":").get("SOAPAction".toUpperCase());
            }
            if ((match = OperationSignature.matchOperation(requestDoc, action, binding = this.validator.analyzerContext.getCandidateInfo().getBindings()[0], registry = new TypesRegistry(this.validator.getWSDLDocument().getDefinitions(), this.validator))) == null) {
                throw new AssertionNotApplicableException();
            }
            BindingOperation bindingOperation = match.getOperation();
            if (!WSDLUtils.isRpcLiteral(match.getOperationStyle(), bindingOperation)) {
                throw new AssertionNotApplicableException();
            }
            NodeList soapBodyList = responseDoc.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
            if (soapBodyList == null || soapBodyList.getLength() == 0) {
                throw new AssertionNotApplicableException();
            }
            boolean grandChildFound = false;
            int n = 0;
            while (n < soapBodyList.getLength()) {
                Element nextBodyElem = (Element)soapBodyList.item(n);
                NodeList childList = nextBodyElem.getChildNodes();
                if (childList != null) {
                    int m = 0;
                    while (m < childList.getLength()) {
                        Element nextChildElem;
                        NodeList grandChildList;
                        if (childList.item(m).getNodeType() == 1 && (grandChildList = (nextChildElem = (Element)childList.item(m)).getChildNodes()) != null) {
                            int p = 0;
                            while (p < grandChildList.getLength()) {
                                if (grandChildList.item(p).getNodeType() == 1) {
                                    grandChildFound = true;
                                    Element nextGrandChildElem = (Element)grandChildList.item(p);
                                    if (nextGrandChildElem.getAttributeNodeNS("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle") != null) {
                                        throw new AssertionFailException(entryContext.getMessageEntry().getMessage());
                                    }
                                }
                                ++p;
                            }
                        }
                        ++m;
                    }
                }
                ++n;
            }
            if (!grandChildFound) {
                throw new AssertionNotApplicableException();
            }
        }
        catch (AssertionFailException e) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(e.getMessage(), entryContext);
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

