/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.formatter;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.cleanup.CSSCleanupStrategy;
import org.eclipse.wst.css.core.internal.cleanup.CSSCleanupStrategyImpl;
import org.eclipse.wst.css.core.internal.formatter.AttrChangeContext;
import org.eclipse.wst.css.core.internal.formatter.CSSSourceFormatter;
import org.eclipse.wst.css.core.internal.formatter.CSSSourceFormatterFactory;
import org.eclipse.wst.css.core.internal.formatter.CSSSourceGenerator;
import org.eclipse.wst.css.core.internal.formatter.CompoundRegion;
import org.eclipse.wst.css.core.internal.formatter.FormatRegion;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSAttr;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclItem;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclaration;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleSheet;
import org.eclipse.wst.css.core.internal.util.CSSLinkConverter;
import org.eclipse.wst.css.core.internal.util.CSSUtil;
import org.eclipse.wst.css.core.internal.util.RegionIterator;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.util.Assert;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;

public abstract class AbstractCSSSourceFormatter
implements CSSSourceGenerator {
    protected static final short GENERATE = 0;
    protected static final short FORMAT = 1;
    protected static final short CLEANUP = 2;
    protected static short strategy;
    static /* synthetic */ Class class$0;

    AbstractCSSSourceFormatter() {
    }

    protected void appendDelimBefore(ICSSNode node, CompoundRegion toAppend, StringBuffer source) {
        boolean needIndent;
        if (node == null || source == null) {
            return;
        }
        if (AbstractCSSSourceFormatter.isCleanup() && !this.getCleanupStrategy(node).isFormatSource()) {
            return;
        }
        String delim = this.getLineDelimiter(node);
        boolean bl = needIndent = !(node instanceof ICSSStyleSheet);
        if (toAppend == null) {
            source.append(delim);
            source.append(this.getIndent(node));
            if (needIndent) {
                source.append(this.getIndentString());
            }
        } else {
            String type = toAppend.getType();
            if (type == "COMMENT") {
                RegionIterator it = new RegionIterator(toAppend.getDocumentRegion(), toAppend.getTextRegion());
                it.prev();
                ITextRegion prev = it.prev();
                int[] result = null;
                if (prev == null || prev.getType() == "S" && (result = TextUtilities.indexOf((String[])DefaultLineTracker.DELIMITERS, (String)it.getStructuredDocumentRegion().getText(prev), (int)0))[0] >= 0) {
                    void offset = result[0] + DefaultLineTracker.DELIMITERS[result[1]].length();
                    if (offset < it.getStructuredDocumentRegion().getText(prev).length() && TextUtilities.indexOf((String[])DefaultLineTracker.DELIMITERS, (String)it.getStructuredDocumentRegion().getText(prev), (int)offset)[0] >= 0) {
                        source.append(delim);
                    }
                    source.append(delim);
                    source.append(this.getIndent(node));
                    if (needIndent) {
                        source.append(this.getIndentString());
                    }
                } else if (prev.getType() == "COMMENT") {
                    int[] delimiterFound;
                    String fullText = toAppend.getDocumentRegion().getFullText(prev);
                    String trimmedText = toAppend.getDocumentRegion().getText(prev);
                    String whiteSpaces = "";
                    if (fullText != null && trimmedText != null) {
                        whiteSpaces = fullText.substring(trimmedText.length());
                    }
                    if ((delimiterFound = TextUtilities.indexOf((String[])DefaultLineTracker.DELIMITERS, (String)whiteSpaces, (int)0))[0] != -1) {
                        source.append(delim);
                    } else {
                        this.appendSpaceBefore(node, toAppend.getText(), source);
                        if (source.toString().endsWith(this.getIndentString())) {
                            source.delete(source.length() - this.getIndentString().length(), source.length());
                        }
                    }
                } else {
                    this.appendSpaceBefore(node, toAppend.getText(), source);
                }
            } else if (type == "DELIMITER" || type == "DECLARATION_DELIMITER") {
                int append;
                int length;
                RegionIterator it = new RegionIterator(toAppend.getDocumentRegion(), toAppend.getTextRegion());
                it.prev();
                ITextRegion prev = it.prev();
                Preferences preferences = CSSCorePlugin.getDefault().getPluginPreferences();
                if (prev.getType() == "S" && TextUtilities.indexOf((String[])DefaultLineTracker.DELIMITERS, (String)it.getStructuredDocumentRegion().getText(prev), (int)0)[0] >= 0) {
                    source.append(delim);
                    source.append(this.getIndent(node));
                    if (needIndent) {
                        source.append(this.getIndentString());
                    }
                } else if (!(preferences.getInt("lineWidth") <= 0 || preferences.getBoolean("prohibitWrapOnAttr") && node.getOwnerDocument().getNodeType() == 8 || (length = this.getLastLineLength(node, source)) + (append = 1) <= preferences.getInt("lineWidth"))) {
                    source.append(this.getLineDelimiter(node));
                    source.append(this.getIndent(node));
                    if (needIndent) {
                        source.append(this.getIndentString());
                    }
                }
            } else if (type == "RBRACE" || type == "LBRACE") {
                source.append(delim);
                source.append(this.getIndent(node));
            } else {
                source.append(delim);
                source.append(this.getIndent(node));
                if (needIndent) {
                    source.append(this.getIndentString());
                }
            }
        }
    }

    protected void appendSpaceBefore(ICSSNode node, CompoundRegion toAppend, StringBuffer source) {
        boolean needIndent;
        if (node == null || toAppend == null || source == null) {
            return;
        }
        if (AbstractCSSSourceFormatter.isCleanup() && !this.getCleanupStrategy(node).isFormatSource()) {
            return;
        }
        String type = toAppend.getType();
        Preferences preferences = CSSCorePlugin.getDefault().getPluginPreferences();
        boolean bl = needIndent = !(node instanceof ICSSStyleSheet);
        if (type == "COMMENT") {
            String delim = this.getLineDelimiter(node);
            RegionIterator it = new RegionIterator(toAppend.getDocumentRegion(), toAppend.getTextRegion());
            it.prev();
            ITextRegion prev = it.prev();
            if (prev.getType() == "S" && TextUtilities.indexOf((String[])DefaultLineTracker.DELIMITERS, (String)it.getStructuredDocumentRegion().getText(prev), (int)0)[0] >= 0) {
                source.append(delim);
                source.append(this.getIndent(node));
                if (needIndent) {
                    source.append(this.getIndentString());
                }
            } else {
                this.appendSpaceBefore(node, toAppend.getText(), source);
            }
        } else if (type == "LBRACE" && preferences.getBoolean("newLineOnOpenBrace")) {
            String delim = this.getLineDelimiter(node);
            source.append(delim);
            source.append(this.getIndent(node));
        } else if (type == "DECLARATION_SEPARATOR" && node instanceof ICSSStyleDeclItem) {
            int n = preferences.getInt("preDelim");
            while (n-- > 0) {
                source.append(" ");
            }
        } else if (type == "DECLARATION_VALUE_OPERATOR" || type == "DECLARATION_VALUE_PARENTHESIS_CLOSE") {
            int append;
            int length;
            if (!(preferences.getInt("lineWidth") <= 0 || preferences.getBoolean("prohibitWrapOnAttr") && node.getOwnerDocument().getNodeType() == 8 || (length = this.getLastLineLength(node, source)) + (append = 1) <= preferences.getInt("lineWidth"))) {
                source.append(this.getLineDelimiter(node));
                source.append(this.getIndent(node));
                if (needIndent) {
                    source.append(this.getIndentString());
                }
            }
        } else {
            if ("FOREIGN_ELEMENT" == type || "DECLARATION_DELIMITER" == type) {
                return;
            }
            this.appendSpaceBefore(node, toAppend.getText(), source);
        }
    }

    protected void appendSpaceBefore(ICSSNode node, String toAppend, StringBuffer source) {
        if (node == null || source == null) {
            return;
        }
        if (AbstractCSSSourceFormatter.isCleanup() && !this.getCleanupStrategy(node).isFormatSource()) {
            return;
        }
        Preferences preferences = CSSCorePlugin.getDefault().getPluginPreferences();
        if (toAppend != null && toAppend.startsWith("{") && preferences.getBoolean("newLineOnOpenBrace")) {
            source.append(this.getLineDelimiter(node));
            source.append(this.getIndent(node));
            return;
        }
        if (!(preferences.getInt("lineWidth") <= 0 || preferences.getBoolean("prohibitWrapOnAttr") && node.getOwnerDocument().getNodeType() == 8)) {
            int append;
            int n = this.getLastLineLength(node, source);
            int n2 = append = toAppend != null ? TextUtilities.indexOf((String[])DefaultLineTracker.DELIMITERS, (String)toAppend, (int)0)[0] : 0;
            if (toAppend != null) {
                int n3 = append = append < 0 ? toAppend.length() : append;
            }
            if (n + append + 1 > preferences.getInt("lineWidth")) {
                source.append(this.getLineDelimiter(node));
                source.append(this.getIndent(node));
                source.append(this.getIndentString());
                return;
            }
        }
        source.append(" ");
    }

    public final StringBuffer cleanup(ICSSNode node) {
        short oldStrategy = strategy;
        strategy = (short)2;
        StringBuffer source = this.formatProc(node);
        strategy = oldStrategy;
        return source;
    }

    public final StringBuffer cleanup(ICSSNode node, IRegion region) {
        short oldStrategy = strategy;
        strategy = (short)2;
        StringBuffer source = this.formatProc(node, region);
        strategy = oldStrategy;
        return source;
    }

    protected String decoratedIdentRegion(CompoundRegion region, CSSCleanupStrategy stgy) {
        if (AbstractCSSSourceFormatter.isFormat()) {
            return region.getText();
        }
        String text = null;
        text = !stgy.isFormatSource() ? region.getFullText() : region.getText();
        if (region.getType() == "STRING" || region.getType() == "URI") {
            return this.decoratedRegion(region, 0, stgy);
        }
        if (AbstractCSSSourceFormatter.isCleanup()) {
            if (stgy.getIdentCase() == 0 || region.getType() == "COMMENT") {
                return text;
            }
            if (stgy.getIdentCase() == 2) {
                return text.toUpperCase();
            }
            return text.toLowerCase();
        }
        Preferences preferences = CSSCorePlugin.getDefault().getPluginPreferences();
        if (region.getType() == "COMMENT") {
            return text;
        }
        if (preferences.getInt("identifierCase") == 2) {
            return text.toUpperCase();
        }
        return text.toLowerCase();
    }

    protected String decoratedPropNameRegion(CompoundRegion region, CSSCleanupStrategy stgy) {
        if (AbstractCSSSourceFormatter.isFormat()) {
            return region.getText();
        }
        String text = null;
        text = !stgy.isFormatSource() ? region.getFullText() : region.getText();
        if (region.getType() == "STRING" || region.getType() == "URI") {
            return this.decoratedRegion(region, 1, stgy);
        }
        if (AbstractCSSSourceFormatter.isCleanup()) {
            if (stgy.getPropNameCase() == 0 || region.getType() != "DECLARATION_PROPERTY") {
                return text;
            }
            if (stgy.getPropNameCase() == 2) {
                return text.toUpperCase();
            }
            return text.toLowerCase();
        }
        Preferences preferences = CSSCorePlugin.getDefault().getPluginPreferences();
        if (region.getType() != "DECLARATION_PROPERTY") {
            return text;
        }
        if (preferences.getInt("propNameCase") == 2) {
            return text.toUpperCase();
        }
        return text.toLowerCase();
    }

    protected String decoratedPropValueRegion(CompoundRegion region, CSSCleanupStrategy stgy) {
        if (AbstractCSSSourceFormatter.isFormat()) {
            return region.getText();
        }
        String text = null;
        text = !stgy.isFormatSource() ? region.getFullText() : region.getText();
        String type = region.getType();
        if (type == "STRING" || type == "URI" || type == "DECLARATION_VALUE_URI") {
            return this.decoratedRegion(region, 2, stgy);
        }
        if (AbstractCSSSourceFormatter.isCleanup() && stgy.getPropValueCase() != 0 && type != "COMMENT") {
            text = stgy.getPropValueCase() == 2 ? text.toUpperCase() : text.toLowerCase();
        }
        return text;
    }

    protected String decoratedRegion(CompoundRegion region, int type, CSSCleanupStrategy stgy) {
        if (AbstractCSSSourceFormatter.isFormat()) {
            return region.getText();
        }
        Preferences preferences = CSSCorePlugin.getDefault().getPluginPreferences();
        String text = null;
        text = !stgy.isFormatSource() ? region.getFullText() : region.getText();
        String regionType = region.getType();
        if (regionType == "URI" || regionType == "DECLARATION_VALUE_URI") {
            boolean prefIsUpper;
            String uri = CSSLinkConverter.stripFunc(text);
            boolean bl = prefIsUpper = preferences.getInt("identifierCase") == 2;
            boolean upper = type == 0 ? prefIsUpper : (type == 1 ? preferences.getInt("propNameCase") == 2 : preferences.getInt("propValueCase") == 2);
            String func = text.substring(0, 4);
            if (AbstractCSSSourceFormatter.isCleanup()) {
                boolean bl2 = upper = (type == 0 ? stgy.getIdentCase() : (type == 1 ? stgy.getPropNameCase() : stgy.getPropValueCase())) == 2;
                String string = (type == 0 ? stgy.getIdentCase() : (type == 1 ? stgy.getPropNameCase() : stgy.getPropValueCase())) == 0 ? text.substring(0, 4) : (func = upper ? "URL(" : "url(");
            }
            if (!AbstractCSSSourceFormatter.isCleanup() && preferences.getBoolean("quoteInURI") || AbstractCSSSourceFormatter.isCleanup() && stgy.isQuoteValues()) {
                String quote = preferences.getString("quote");
                quote = CSSUtil.detectQuote(uri, quote);
                text = String.valueOf(func) + quote + uri + quote + ")";
            } else {
                text = AbstractCSSSourceFormatter.isCleanup() && !stgy.isQuoteValues() ? String.valueOf(func) + CSSLinkConverter.removeFunc(text) + ")" : String.valueOf(func) + uri + ")";
            }
        } else if (region.getType() == "STRING" && (!AbstractCSSSourceFormatter.isCleanup() || stgy.isQuoteValues())) {
            String quote = preferences.getString("quote");
            if (!text.startsWith(quote)) {
                text = text.startsWith("\"") || text.startsWith("'") ? String.valueOf(quote) + text.substring(1) : String.valueOf(quote) + text;
            }
            if (!text.endsWith(quote)) {
                text = text.endsWith("\"") || text.endsWith("'") ? String.valueOf(text.substring(0, text.length() - 1)) + quote : String.valueOf(text) + quote;
            }
        }
        return text;
    }

    public final StringBuffer format(ICSSNode node) {
        short oldStrategy = strategy;
        strategy = 1;
        StringBuffer source = this.formatProc(node);
        strategy = oldStrategy;
        return source;
    }

    public final StringBuffer format(ICSSNode node, IRegion region) {
        short oldStrategy = strategy;
        strategy = 1;
        StringBuffer source = this.formatProc(node, region);
        strategy = oldStrategy;
        return source;
    }

    public StringBuffer formatAttrChanged(ICSSNode node, ICSSAttr attr, boolean insert, AttrChangeContext context) {
        return new StringBuffer(insert && attr != null ? attr.getValue() : "");
    }

    protected abstract void formatBefore(ICSSNode var1, ICSSNode var2, String var3, StringBuffer var4, IRegion var5);

    public final StringBuffer formatBefore(ICSSNode node, ICSSNode child, IRegion exceptFor) {
        Assert.isTrue((child == null || child.getParentNode() == node ? 1 : 0) != 0);
        StringBuffer buf = new StringBuffer();
        this.formatBefore(node, child, "", buf, exceptFor);
        return buf;
    }

    protected abstract void formatBefore(ICSSNode var1, ICSSNode var2, IRegion var3, String var4, StringBuffer var5);

    protected final void formatChildren(ICSSNode node, StringBuffer source) {
        ICSSNode child = node.getFirstChild();
        boolean first = true;
        while (child != null) {
            CSSSourceFormatter formatter;
            INodeNotifier iNodeNotifier = (INodeNotifier)child;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.wst.css.core.internal.formatter.CSSSourceFormatter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((formatter = (CSSSourceFormatter)iNodeNotifier.getAdapterFor((Object)clazz)) == null) {
                formatter = CSSSourceFormatterFactory.getInstance().getSourceFormatter((INodeNotifier)child);
            }
            StringBuffer childSource = ((AbstractCSSSourceFormatter)formatter).formatProc(child);
            if (!first) {
                this.formatBefore(node, child, new String(childSource), source, null);
            }
            source.append(childSource);
            child = child.getNextSibling();
            first = false;
        }
    }

    protected final void formatChildren(ICSSNode node, IRegion region, StringBuffer source) {
        ICSSNode child = node.getFirstChild();
        int start = region.getOffset();
        int end = region.getOffset() + region.getLength();
        boolean first = true;
        while (child != null) {
            int curStart;
            int curEnd = ((IndexedRegion)child).getEndOffset();
            StringBuffer childSource = null;
            boolean toFinish = false;
            if (start < curEnd) {
                curStart = ((IndexedRegion)child).getStartOffset();
                if (curStart < end) {
                    CSSSourceFormatter formatter;
                    INodeNotifier iNodeNotifier = (INodeNotifier)child;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.wst.css.core.internal.formatter.CSSSourceFormatter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((formatter = (CSSSourceFormatter)iNodeNotifier.getAdapterFor((Object)clazz)) == null) {
                        formatter = CSSSourceFormatterFactory.getInstance().getSourceFormatter((INodeNotifier)child);
                    }
                    childSource = AbstractCSSSourceFormatter.includes(region, curStart, curEnd) ? ((AbstractCSSSourceFormatter)formatter).formatProc(child) : ((AbstractCSSSourceFormatter)formatter).formatProc(child, AbstractCSSSourceFormatter.overlappedRegion(region, curStart, curEnd));
                } else {
                    toFinish = true;
                }
            }
            if (!first && start < (curEnd = ((IndexedRegion)child).getStartOffset()) && (curStart = ((IndexedRegion)child.getPreviousSibling()).getEndOffset()) < end) {
                String toAppend;
                String string = toAppend = childSource != null ? new String(childSource) : "";
                if (AbstractCSSSourceFormatter.includes(region, curStart, curEnd)) {
                    this.formatBefore(node, child, toAppend, source, null);
                } else {
                    this.formatBefore(node, child, AbstractCSSSourceFormatter.overlappedRegion(region, curStart, curEnd), toAppend, source);
                }
            }
            if (childSource != null) {
                source.append(childSource);
            }
            first = false;
            if (toFinish) break;
            child = child.getNextSibling();
        }
    }

    protected abstract void formatPost(ICSSNode var1, StringBuffer var2);

    protected abstract void formatPost(ICSSNode var1, IRegion var2, StringBuffer var3);

    protected abstract void formatPre(ICSSNode var1, StringBuffer var2);

    protected abstract void formatPre(ICSSNode var1, IRegion var2, StringBuffer var3);

    protected final StringBuffer formatProc(ICSSNode node) {
        StringBuffer source = new StringBuffer();
        this.formatPre(node, source);
        this.formatChildren(node, source);
        this.formatPost(node, source);
        return source;
    }

    protected final StringBuffer formatProc(ICSSNode node, IRegion region) {
        StringBuffer source = new StringBuffer();
        int curStart = ((IndexedRegion)node).getStartOffset();
        int curEnd = ((IndexedRegion)node).getEndOffset();
        if (node.getChildNodes().getLength() > 0) {
            curEnd = ((IndexedRegion)node.getFirstChild()).getStartOffset();
            if (AbstractCSSSourceFormatter.overlaps(region, curStart, curEnd)) {
                if (AbstractCSSSourceFormatter.includes(region, curStart, curEnd)) {
                    this.formatPre(node, source);
                } else {
                    this.formatPre(node, AbstractCSSSourceFormatter.overlappedRegion(region, curStart, curEnd), source);
                }
            }
            if (AbstractCSSSourceFormatter.overlaps(region, curStart = curEnd, curEnd = ((IndexedRegion)node.getLastChild()).getEndOffset())) {
                if (AbstractCSSSourceFormatter.includes(region, curStart, curEnd)) {
                    this.formatChildren(node, source);
                } else {
                    this.formatChildren(node, AbstractCSSSourceFormatter.overlappedRegion(region, curStart, curEnd), source);
                }
            }
            if (AbstractCSSSourceFormatter.overlaps(region, curStart = curEnd, curEnd = ((IndexedRegion)node).getEndOffset())) {
                if (AbstractCSSSourceFormatter.includes(region, curStart, curEnd)) {
                    this.formatPost(node, source);
                } else {
                    this.formatPost(node, AbstractCSSSourceFormatter.overlappedRegion(region, curStart, curEnd), source);
                }
            }
        } else {
            curEnd = this.getChildInsertPos(node);
            if (AbstractCSSSourceFormatter.overlaps(region, curStart, curEnd)) {
                if (AbstractCSSSourceFormatter.includes(region, curStart, curEnd)) {
                    this.formatPre(node, source);
                } else {
                    this.formatPre(node, AbstractCSSSourceFormatter.overlappedRegion(region, curStart, curEnd), source);
                }
            }
            if (AbstractCSSSourceFormatter.overlaps(region, curStart = curEnd, curEnd = ((IndexedRegion)node).getEndOffset())) {
                if (AbstractCSSSourceFormatter.includes(region, curStart, curEnd)) {
                    this.formatPost(node, source);
                } else {
                    this.formatPost(node, AbstractCSSSourceFormatter.overlappedRegion(region, curStart, curEnd), source);
                }
            }
        }
        return source;
    }

    public int getAttrInsertPos(ICSSNode node, String attrName) {
        return -1;
    }

    protected CSSCleanupStrategy getCleanupStrategy(ICSSNode node) {
        CSSCleanupStrategy currentStrategy = CSSCleanupStrategyImpl.getInstance();
        ICSSDocument doc = node.getOwnerDocument();
        if (doc == null) {
            return currentStrategy;
        }
        ICSSModel model = doc.getModel();
        if (model == null) {
            return currentStrategy;
        }
        model.getStyleSheetType();
        return currentStrategy;
    }

    protected String getIndent(ICSSNode node) {
        if (node == null) {
            return "";
        }
        ICSSNode parent = node.getParentNode();
        if (node instanceof ICSSAttr) {
            parent = ((ICSSAttr)node).getOwnerCSSNode();
        }
        if (parent == null) {
            return "";
        }
        if (node instanceof CSSStyleDeclaration) {
            parent = parent.getParentNode();
        }
        if (parent == null) {
            return "";
        }
        String parentIndent = this.getIndent(parent);
        if (parent instanceof CSSRule) {
            return String.valueOf(parentIndent) + this.getIndentString();
        }
        if (node.getParentNode() instanceof ICSSStyleDeclaration) {
            return String.valueOf(parentIndent) + this.getIndentString();
        }
        return parentIndent;
    }

    protected int getLastLineLength(ICSSNode node, StringBuffer source) {
        if (node == null || source == null) {
            return 0;
        }
        String str = new String(source);
        String delim = this.getLineDelimiter(node);
        int n = str.lastIndexOf(delim);
        if (n < 0) {
            return str.length();
        }
        return str.length() - n - delim.length();
    }

    public int getLengthToReformatAfter(ICSSNode node, int insertPos) {
        if (node == null) {
            return 0;
        }
        IndexedRegion nnode = (IndexedRegion)node;
        if (insertPos < 0 || !nnode.contains(insertPos)) {
            return 0;
        }
        IStructuredDocumentRegion flatNode = node.getOwnerDocument().getModel().getStructuredDocument().getRegionAtCharacterOffset(insertPos);
        if (flatNode == null) {
            return 0;
        }
        ITextRegion region = flatNode.getRegionAtCharacterOffset(insertPos);
        if (region == null) {
            return 0;
        }
        RegionIterator it = new RegionIterator(flatNode, region);
        boolean found = false;
        while (it.hasNext()) {
            region = it.next();
            if (region.getType() == "S") continue;
            found = true;
            break;
        }
        int pos = (found ? it.getStructuredDocumentRegion().getStartOffset(region) : it.getStructuredDocumentRegion().getTextEndOffset(region)) - insertPos;
        return pos >= 0 ? pos : 0;
    }

    public int getLengthToReformatBefore(ICSSNode node, int insertPos) {
        if (node == null) {
            return 0;
        }
        IndexedRegion nnode = (IndexedRegion)node;
        if (insertPos <= 0 || !nnode.contains(insertPos - 1)) {
            return 0;
        }
        IStructuredDocumentRegion flatNode = node.getOwnerDocument().getModel().getStructuredDocument().getRegionAtCharacterOffset(insertPos - 1);
        if (flatNode == null) {
            return 0;
        }
        ITextRegion region = flatNode.getRegionAtCharacterOffset(insertPos - 1);
        if (region == null) {
            return 0;
        }
        RegionIterator it = new RegionIterator(flatNode, region);
        boolean found = false;
        while (it.hasPrev()) {
            region = it.prev();
            if (region.getType() == "S") continue;
            found = true;
            break;
        }
        int pos = insertPos - (found ? it.getStructuredDocumentRegion().getTextEndOffset(region) : it.getStructuredDocumentRegion().getStartOffset(region));
        return pos >= 0 ? pos : 0;
    }

    String getLineDelimiter(ICSSNode node) {
        ICSSModel model = node != null ? node.getOwnerDocument().getModel() : null;
        return model != null ? model.getStructuredDocument().getLineDelimiter() : "\n";
    }

    protected CompoundRegion[] getOutsideRegions(IStructuredDocument model, IRegion reg) {
        IStructuredDocumentRegion documentRegion;
        ITextRegion textRegion;
        CompoundRegion[] ret = new CompoundRegion[2];
        RegionIterator it = new RegionIterator(model, reg.getOffset());
        it.prev();
        if (it.hasPrev()) {
            textRegion = it.prev();
            documentRegion = it.getStructuredDocumentRegion();
            ret[0] = new CompoundRegion(documentRegion, textRegion);
        } else {
            ret[0] = null;
        }
        it.reset(model, reg.getOffset() + reg.getLength());
        if (it.hasNext()) {
            textRegion = it.next();
            documentRegion = it.getStructuredDocumentRegion();
            ret[1] = new CompoundRegion(documentRegion, textRegion);
        } else {
            ret[1] = null;
        }
        return ret;
    }

    protected CSSSourceGenerator getParentFormatter(ICSSNode node) {
        ICSSNode parent = node.getParentNode();
        if (parent != null) {
            CSSSourceGenerator formatter;
            INodeNotifier iNodeNotifier = (INodeNotifier)parent;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.css.core.internal.formatter.CSSSourceFormatter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((formatter = (CSSSourceGenerator)iNodeNotifier.getAdapterFor((Object)clazz)) == null) {
                formatter = CSSSourceFormatterFactory.getInstance().getSourceFormatter((INodeNotifier)parent);
            }
            return formatter;
        }
        return null;
    }

    protected CompoundRegion[] getRegions(IStructuredDocument model, IRegion reg, IRegion exceptFor, String pickupType) {
        int start = reg.getOffset();
        int end = reg.getOffset() + reg.getLength();
        int startE = exceptFor != null ? exceptFor.getOffset() : -1;
        int endE = exceptFor != null ? exceptFor.getOffset() + exceptFor.getLength() : 0;
        ArrayList<CompoundRegion> list = new ArrayList<CompoundRegion>();
        IStructuredDocumentRegion flatNode = model.getRegionAtCharacterOffset(start);
        boolean pickuped = false;
        while (flatNode != null && flatNode.getStartOffset() < end) {
            ITextRegionList regionList = flatNode.getRegions();
            Iterator it = regionList.iterator();
            while (it.hasNext()) {
                ITextRegion region = (ITextRegion)it.next();
                if (flatNode.getStartOffset(region) < start) continue;
                if (end <= flatNode.getStartOffset(region)) break;
                if (startE >= 0 && startE <= flatNode.getStartOffset(region) && flatNode.getEndOffset(region) <= endE) continue;
                if (region.getType() == "COMMENT" || region.getType() == "CDC" || region.getType() == "CDO") {
                    list.add(new CompoundRegion(flatNode, region));
                    continue;
                }
                if (pickuped || region.getType() != pickupType) continue;
                list.add(new CompoundRegion(flatNode, region));
                pickuped = true;
            }
            flatNode = flatNode.getNext();
        }
        if (list.size() > 0) {
            CompoundRegion[] regions = new CompoundRegion[list.size()];
            list.toArray(regions);
            return regions;
        }
        return new CompoundRegion[0];
    }

    protected CompoundRegion[] getRegionsWithoutWhiteSpaces(IStructuredDocument model, IRegion reg, CSSCleanupStrategy stgy) {
        int start = reg.getOffset();
        int end = reg.getOffset() + reg.getLength() - 1;
        ArrayList<CompoundRegion> list = new ArrayList<CompoundRegion>();
        IStructuredDocumentRegion flatNode = model.getRegionAtCharacterOffset(start);
        while (flatNode != null && flatNode.getStartOffset() <= end) {
            ITextRegionList regionList = flatNode.getRegions();
            Iterator it = regionList.iterator();
            while (it.hasNext()) {
                ITextRegion region = (ITextRegion)it.next();
                if (flatNode.getStartOffset(region) < start) continue;
                if (end < flatNode.getStartOffset(region)) break;
                if (region.getType() == "S" && (!AbstractCSSSourceFormatter.isCleanup() || stgy.isFormatSource())) continue;
                list.add(new CompoundRegion(flatNode, region));
            }
            flatNode = flatNode.getNext();
        }
        if (list.size() > 0) {
            CompoundRegion[] regions = new CompoundRegion[list.size()];
            list.toArray(regions);
            return regions;
        }
        return new CompoundRegion[0];
    }

    public static boolean includes(IRegion region, int start, int end) {
        if (region == null) {
            return false;
        }
        return region.getOffset() <= start && end <= region.getOffset() + region.getLength();
    }

    protected static boolean isCleanup() {
        return strategy == 2;
    }

    protected static boolean isFormat() {
        return strategy == 1;
    }

    protected boolean isIncludesPreEnd(ICSSNode node, IRegion region) {
        return node.getFirstChild() != null && ((IndexedRegion)node.getFirstChild()).getStartOffset() == region.getOffset() + region.getLength();
    }

    protected static boolean needS(CompoundRegion region) {
        return region != null && region.getType() != "S";
    }

    public static IRegion overlappedRegion(IRegion region, int start, int end) {
        if (AbstractCSSSourceFormatter.overlaps(region, start, end)) {
            int offset = region.getOffset() <= start ? start : region.getOffset();
            int length = (end <= region.getOffset() + region.getLength() ? end : region.getOffset() + region.getLength()) - offset;
            return new FormatRegion(offset, length);
        }
        return null;
    }

    public static boolean overlaps(IRegion region, int start, int end) {
        if (region == null) {
            return false;
        }
        return start < region.getOffset() + region.getLength() && region.getOffset() < end;
    }

    private String getIndentString() {
        StringBuffer indent = new StringBuffer();
        Preferences preferences = CSSCorePlugin.getDefault().getPluginPreferences();
        if (preferences != null) {
            char indentChar = ' ';
            String indentCharPref = preferences.getString("indentationChar");
            if ("tab".equals(indentCharPref)) {
                indentChar = '\t';
            }
            int indentationWidth = preferences.getInt("indentationSize");
            int i = 0;
            while (i < indentationWidth) {
                indent.append(indentChar);
                ++i;
            }
        }
        return indent.toString();
    }
}

