/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.tests.conversion;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.util.ConvertAction;

public class IncludePathTests
extends TestCase {
    private static IProject createSimpleProject(String name, IPath location, String[] natureIds) {
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(name);
        if (location != null) {
            description.setLocation(location);
        }
        if (natureIds != null) {
            description.setNatureIds(natureIds);
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        try {
            project.create(description, (IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return project;
    }

    private static final ISelection selectionFor(IProject p) {
        return new StructuredSelection((Object[])new IProject[]{p, ResourcesPlugin.getWorkspace().getRoot().getProject("IncludePathTests")});
    }

    public IncludePathTests() {
        this("WEb project Include Path manipulation tests");
    }

    public IncludePathTests(String name) {
        super(name);
    }

    private void assertConvertedIncludePath(IProject p, String expected) throws JavaScriptModelException {
        ConvertAction convertor = new ConvertAction();
        convertor.selectionChanged(null, IncludePathTests.selectionFor(p));
        convertor.run(null);
        this.assertIncludePath(p, expected);
    }

    private void assertIncludePath(IProject p, String expected) throws JavaScriptModelException {
        IIncludePathEntry[] rawIncludepath = JavaScriptCore.create((IProject)p).getRawIncludepath();
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < rawIncludepath.length) {
            b.append(rawIncludepath[i].toString());
            b.append('\n');
            ++i;
        }
        IncludePathTests.assertEquals((String)"Unexpected Include Path entries", (String)expected, (String)b.toString());
    }

    public void testConvertSimpleProject() throws CoreException {
        IProject p = IncludePathTests.createSimpleProject(this.getName(), null, null);
        this.assertConvertedIncludePath(p, "/testConvertSimpleProject[CPE_SOURCE][K_SOURCE][isExported:false][attributes:provider=org.eclipse.wst.jsdt.web.core.internal.project.ModuleSourcePathProvider]\norg.eclipse.wst.jsdt.launching.JRE_CONTAINER[CPE_CONTAINER][K_SOURCE][isExported:false]\norg.eclipse.wst.jsdt.launching.baseBrowserLibrary[CPE_CONTAINER][K_SOURCE][isExported:false]\n");
        try {
            p.delete(true, true, null);
        }
        catch (Exception exception) {}
    }

    public void testConvertDefaultJSProject() throws CoreException {
        IProject p = IncludePathTests.createSimpleProject(this.getName(), null, new String[]{"org.eclipse.wst.jsdt.core.jsNature"});
        this.assertConvertedIncludePath(p, "org.eclipse.wst.jsdt.launching.JRE_CONTAINER[CPE_CONTAINER][K_SOURCE][isExported:false]\norg.eclipse.wst.jsdt.launching.baseBrowserLibrary[CPE_CONTAINER][K_SOURCE][isExported:false]\n/testConvertDefaultJSProject[CPE_SOURCE][K_SOURCE][isExported:false]\n");
        try {
            p.delete(true, true, null);
        }
        catch (Exception exception) {}
    }

    public void testVerifyDefaultIncludePath() throws CoreException {
        IProject p = IncludePathTests.createSimpleProject(this.getName(), null, new String[]{"org.eclipse.wst.jsdt.core.jsNature"});
        this.assertIncludePath(p, "org.eclipse.wst.jsdt.launching.JRE_CONTAINER[CPE_CONTAINER][K_SOURCE][isExported:false]\norg.eclipse.wst.jsdt.launching.baseBrowserLibrary[CPE_CONTAINER][K_SOURCE][isExported:false]\n/testVerifyDefaultIncludePath[CPE_SOURCE][K_SOURCE][isExported:false]\n");
        try {
            p.delete(true, true, null);
        }
        catch (Exception exception) {}
    }
}

