/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaModelTests;

public class SignatureTests
extends AbstractJavaModelTests {
    static /* synthetic */ Class class$0;

    public SignatureTests(String name) {
        super(name);
    }

    protected void assertInvalidTypeSignature(String typeName, boolean isResolved, String expected) {
        String actual;
        try {
            actual = Signature.createTypeSignature((String)typeName, (boolean)isResolved);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        SignatureTests.assertEquals((String)expected, (String)actual);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.SignatureTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return SignatureTests.buildModelTestSuite(clazz);
    }

    public void testCreateArraySignature() {
        SignatureTests.assertEquals((String)"Signature#createArraySignature not correct", (String)"[[[[QString", (String)Signature.createArraySignature((String)"QString", (int)4));
        SignatureTests.assertEquals((String)"Signature#createArraySignature not correct", (String)"[[[[Qlist<Qstring;>;", (String)Signature.createArraySignature((String)"Qlist<Qstring;>;", (int)4));
    }

    public void testCreateMethodSignature() {
        SignatureTests.assertEquals((String)"Signature#createMethodSignature is not correct 1", (String)"(QString;QObject;I)I", (String)Signature.createMethodSignature((String[])new String[]{"QString;", "QObject;", "I"}, (String)"I"));
        SignatureTests.assertEquals((String)"Signature#createMethodSignature is not correct 2", (String)"()Ljava.lang.String;", (String)Signature.createMethodSignature((String[])new String[0], (String)"Ljava.lang.String;"));
    }

    public void testCreateTypeSignature() {
        SignatureTests.assertEquals((String)"Signature#createTypeSignature is not correct1", (String)"I", (String)Signature.createTypeSignature((char[])"int".toCharArray(), (boolean)false));
        SignatureTests.assertEquals((String)"Signature#createTypeSignature is not correct2", (String)"Ljava.lang.String;", (String)Signature.createTypeSignature((char[])"java.lang.String".toCharArray(), (boolean)true));
        SignatureTests.assertEquals((String)"Signature#createTypeSignature is not correct3", (String)"QString;", (String)Signature.createTypeSignature((char[])"String".toCharArray(), (boolean)false));
        SignatureTests.assertEquals((String)"Signature#createTypeSignature is not correct4", (String)"Qjava.lang.String;", (String)Signature.createTypeSignature((char[])"java.lang.String".toCharArray(), (boolean)false));
        SignatureTests.assertEquals((String)"Signature#createTypeSignature is not correct5", (String)"[I", (String)Signature.createTypeSignature((char[])"int []".toCharArray(), (boolean)false));
        SignatureTests.assertEquals((String)"Signature#createTypeSignature is not correct6", (String)"[QString;", (String)Signature.createTypeSignature((char[])"String []".toCharArray(), (boolean)false));
        SignatureTests.assertEquals((String)"Signature#createTypeSignature is not correct7", (String)"[Ljava.util.Vector;", (String)Signature.createTypeSignature((char[])"java.util.Vector []".toCharArray(), (boolean)true));
        SignatureTests.assertEquals((String)"Signature#createTypeSignature is not correct8", (String)"[[Ljava.util.Vector;", (String)Signature.createTypeSignature((char[])"java .\n util  .  Vector[  ][]".toCharArray(), (boolean)true));
        SignatureTests.assertEquals((String)"Signature#createTypeSignature is not correct9", (String)"Linteration.test.MyData;", (String)Signature.createTypeSignature((char[])"interation.test.MyData".toCharArray(), (boolean)true));
        SignatureTests.assertEquals((String)"Signature#createTypeSignature is not correct10", (String)"Llongtest.MyData;", (String)Signature.createTypeSignature((char[])"longtest.MyData".toCharArray(), (boolean)true));
        SignatureTests.assertEquals((String)"Signature#createTypeSignature is not correct11", (String)"Lbooleantest.MyData;", (String)Signature.createTypeSignature((char[])"booleantest.MyData".toCharArray(), (boolean)true));
        SignatureTests.assertEquals((String)"Signature#createTypeSignature is not correct12", (String)"Lbytetest.MyData;", (String)Signature.createTypeSignature((char[])"bytetest.MyData".toCharArray(), (boolean)true));
        SignatureTests.assertEquals((String)"Signature#createTypeSignature is not correct13", (String)"Lchartest.MyData;", (String)Signature.createTypeSignature((char[])"chartest.MyData".toCharArray(), (boolean)true));
        SignatureTests.assertEquals((String)"Signature#createTypeSignature is not correct14", (String)"Lshorttest.MyData;", (String)Signature.createTypeSignature((char[])"shorttest.MyData".toCharArray(), (boolean)true));
        SignatureTests.assertEquals((String)"Signature#createTypeSignature is not correct15", (String)"Ldoubletest.MyData;", (String)Signature.createTypeSignature((char[])"doubletest.MyData".toCharArray(), (boolean)true));
        SignatureTests.assertEquals((String)"Signature#createTypeSignature is not correct16", (String)"Lfloattest.MyData;", (String)Signature.createTypeSignature((char[])"floattest.MyData".toCharArray(), (boolean)true));
        SignatureTests.assertEquals((String)"Signature#createTypeSignature is not correct17", (String)"Lvoidtest.MyData;", (String)Signature.createTypeSignature((char[])"voidtest.MyData".toCharArray(), (boolean)true));
        SignatureTests.assertEquals((String)"Signature#createTypeSignature is not correct18", (String)"QList<QList<QString;>;>;", (String)Signature.createTypeSignature((char[])"List<List<String>>".toCharArray(), (boolean)false));
        SignatureTests.assertEquals((String)"Signature#createTypeSignature is not correct19", (String)"QList<QList<I>;>;", (String)Signature.createTypeSignature((char[])"List<List<int>>".toCharArray(), (boolean)false));
        SignatureTests.assertEquals((String)"Signature#createTypeSignature is not correct20", (String)"[QList<QList<[I>;>;", (String)Signature.createTypeSignature((char[])"List<List<int[]>>[]".toCharArray(), (boolean)false));
        SignatureTests.assertEquals((String)"Signature#createTypeSignature is not correct21", (String)"Qjava.y.Map<[QObject;QString;>.MapEntry<[Qp.K<QT;>;[Qq.r.V2;>;", (String)Signature.createTypeSignature((char[])"java.y.Map<Object[],String>.MapEntry<p.K<T>[],q.r.V2[]>".toCharArray(), (boolean)false));
    }

    public void testCreateInvalidTypeSignature() {
        this.assertInvalidTypeSignature(null, false, null);
        this.assertInvalidTypeSignature("", false, "");
        this.assertInvalidTypeSignature("int.Y", false, "I");
        this.assertInvalidTypeSignature("Y [].X", false, "[QY;");
        this.assertInvalidTypeSignature("X[[]", true, "[[LX;");
    }

    public void testGetArrayCount() {
        SignatureTests.assertEquals((String)"Signature#getArrayCount is not correct", (int)4, (int)Signature.getArrayCount((String)"[[[[QString;"));
        try {
            Signature.getArrayCount((String)"");
            SignatureTests.assertTrue((String)"Signature#getArrayCount is not correct, exception", (boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        SignatureTests.assertEquals((String)"Signature#getArrayCount not correct", (int)4, (int)Signature.getArrayCount((String)"[[[[Qlist<Qstring;>;"));
    }

    public void testGetElementType() {
        SignatureTests.assertEquals((String)"Signature#getElementType is not correct1", (String)"QString;", (String)Signature.getElementType((String)"[[[[QString;"));
        SignatureTests.assertEquals((String)"Signature#getElementType is not correct2", (String)"QString;", (String)Signature.getElementType((String)"QString;"));
        SignatureTests.assertEquals((String)"Signature#getElementType is not correct2", (String)"I", (String)Signature.getElementType((String)"[[I"));
        try {
            Signature.getElementType((String)"");
            SignatureTests.assertTrue((String)"Signature#getArrayCount is not correct, exception", (boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        SignatureTests.assertEquals((String)"Signature#getElementType not correct", (String)"Qlist<Qstring;>;", (String)Signature.getElementType((String)"[[[[Qlist<Qstring;>;"));
    }

    public void testGetParameterCount01() {
        String methodSig = "(QString;QObject;I)I";
        SignatureTests.assertEquals((String)"Signature#getParameterCount is not correct", (int)3, (int)Signature.getParameterCount((String)methodSig));
    }

    public void testGetParameterCount02() {
        try {
            Signature.getParameterCount((String)"");
            SignatureTests.assertTrue((String)"Signature#getParameterCount is not correct: exception", (boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testGetParameterCount03() {
        String methodSig = "<X:Qlist<Qstring;>;>(IQlist;Tww;)Qlist<Qxxx;>;^Qexception;^Qerror;";
        SignatureTests.assertEquals((String)"Signature#getParameterCount is not correct", (int)3, (int)Signature.getParameterCount((String)methodSig));
    }

    public void testGetParameterCount04() {
        String methodSig = "<X:Qlist<Qstring;>;>(IQlist<Qstring;>;Tww;)Qlist<Qxxx;>;^Qexception;^Qerror;";
        SignatureTests.assertEquals((String)"Signature#getParameterCount is not correct", (int)3, (int)Signature.getParameterCount((String)methodSig));
    }

    public void testGetParameterCount05() {
        String methodSig = "foo(+Ljava.lang.Comparable;)";
        SignatureTests.assertEquals((String)"Signature#getParameterCount is not correct", (int)1, (int)Signature.getParameterCount((String)methodSig));
    }

    public void testGetParameterCount06() {
        String methodSig = "foo(+Ljava.lang.Comparable;)";
        SignatureTests.assertEquals((String)"Signature#getParameterCount is not correct", (int)1, (int)Signature.getParameterCount((String)methodSig));
    }

    public void testGetParameterCount07() {
        String methodSig = "foo(*)";
        SignatureTests.assertEquals((String)"Signature#getParameterCount is not correct", (int)1, (int)Signature.getParameterCount((String)methodSig));
    }

    public void testGetParameterCount08() {
        String methodSig = "foo(LA<+Ljava.lang.Comparable;>;)";
        SignatureTests.assertEquals((String)"Signature#getParameterCount is not correct", (int)1, (int)Signature.getParameterCount((String)methodSig));
    }

    public void testGetParameterCount09() {
        String methodSig = "foo(LA<-Ljava.lang.Comparable;>;)";
        SignatureTests.assertEquals((String)"Signature#getParameterCount is not correct", (int)1, (int)Signature.getParameterCount((String)methodSig));
    }

    public void testGetParameterCount10() {
        String methodSig = "foo(LA<*>;)";
        SignatureTests.assertEquals((String)"Signature#getParameterCount is not correct", (int)1, (int)Signature.getParameterCount((String)methodSig));
    }

    public void testGetParameterCount11() {
        String methodSig = "foo(LA<+Ljava.lang.Comparable;+Ljava.lang.Comparable;>;)";
        SignatureTests.assertEquals((String)"Signature#getParameterCount is not correct", (int)1, (int)Signature.getParameterCount((String)methodSig));
    }

    public void testGetParameterCount12() {
        String methodSig = "foo(+Ljava.lang.Comparable;+Ljava.lang.Comparable;)";
        SignatureTests.assertEquals((String)"Signature#getParameterCount is not correct", (int)2, (int)Signature.getParameterCount((String)methodSig));
    }

    public void testGetParameterCount13() {
        String methodSig = "foo(+Ljava.lang.Comparable;-Ljava.lang.Comparable;)";
        SignatureTests.assertEquals((String)"Signature#getParameterCount is not correct", (int)2, (int)Signature.getParameterCount((String)methodSig));
    }

    public void testGetParameterCount14() {
        String methodSig = "foo(Ljava.util.List<-[Ljava.lang.Number;>;)";
        SignatureTests.assertEquals((String)"Signature#getParameterCount is not correct", (int)1, (int)Signature.getParameterCount((String)methodSig));
    }

    public void testGetParameterCount15() {
        String methodSig = "foo(LA<++Ljava.lang.Comparable;>;)";
        SignatureTests.assertEquals((String)"Signature#getParameterCount is not correct", (int)1, (int)Signature.getParameterCount((String)methodSig));
    }

    public void testGetParameterCount16() {
        String methodSig = "foo(LA<--Ljava.lang.Comparable;>;)";
        SignatureTests.assertEquals((String)"Signature#getParameterCount is not correct", (int)1, (int)Signature.getParameterCount((String)methodSig));
    }

    public void testGetParameterCount17() {
        String methodSig = "foo(LA<+-Ljava.lang.Comparable;>;)";
        SignatureTests.assertEquals((String)"Signature#getParameterCount is not correct", (int)1, (int)Signature.getParameterCount((String)methodSig));
    }

    public void testGetParameterCount18() {
        String methodSig = "(ILjava.util.Collection<+*>;)Z";
        SignatureTests.assertEquals((String)"Signature#getParameterCount is not correct", (int)2, (int)Signature.getParameterCount((String)methodSig));
    }

    public void testGetParameterTypes() {
        String methodSig = "(QString;QObject;I)I";
        String[] types = Signature.getParameterTypes((String)methodSig);
        SignatureTests.assertEquals((String)"Signature#getParameterTypes is not correct1", (int)3, (int)types.length);
        SignatureTests.assertEquals((String)"Signature#getParameterTypes is not correct2", (String)"QObject;", (String)types[1]);
        try {
            Signature.getParameterTypes((String)"");
            SignatureTests.assertTrue((String)"Signature#getParameterTypes is not correct: exception", (boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        methodSig = "(BCDFIJSVZ)V";
        SignatureTests.assertEquals((String)"Signature#getParameterTypes 4", (int)9, (int)Signature.getParameterTypes((String)methodSig).length);
        SignatureTests.assertEquals((String)"Signature#getParameterTypes 4", (String)"B", (String)Signature.getParameterTypes((String)methodSig)[0]);
        SignatureTests.assertEquals((String)"Signature#getParameterTypes 4", (String)"C", (String)Signature.getParameterTypes((String)methodSig)[1]);
        SignatureTests.assertEquals((String)"Signature#getParameterTypes 4", (String)"D", (String)Signature.getParameterTypes((String)methodSig)[2]);
        SignatureTests.assertEquals((String)"Signature#getParameterTypes 4", (String)"F", (String)Signature.getParameterTypes((String)methodSig)[3]);
        SignatureTests.assertEquals((String)"Signature#getParameterTypes 4", (String)"I", (String)Signature.getParameterTypes((String)methodSig)[4]);
        SignatureTests.assertEquals((String)"Signature#getParameterTypes 4", (String)"J", (String)Signature.getParameterTypes((String)methodSig)[5]);
        SignatureTests.assertEquals((String)"Signature#getParameterTypes 4", (String)"S", (String)Signature.getParameterTypes((String)methodSig)[6]);
        SignatureTests.assertEquals((String)"Signature#getParameterTypes 4", (String)"V", (String)Signature.getParameterTypes((String)methodSig)[7]);
        SignatureTests.assertEquals((String)"Signature#getParameterTypes 4", (String)"Z", (String)Signature.getParameterTypes((String)methodSig)[8]);
        methodSig = "([I[[J[[[B[Qstring;[Tv;[Lstring;)V";
        SignatureTests.assertEquals((String)"Signature#getParameterTypes 5", (int)6, (int)Signature.getParameterTypes((String)methodSig).length);
        SignatureTests.assertEquals((String)"Signature#getParameterTypes 5", (String)"[I", (String)Signature.getParameterTypes((String)methodSig)[0]);
        SignatureTests.assertEquals((String)"Signature#getParameterTypes 5", (String)"[[J", (String)Signature.getParameterTypes((String)methodSig)[1]);
        SignatureTests.assertEquals((String)"Signature#getParameterTypes 5", (String)"[[[B", (String)Signature.getParameterTypes((String)methodSig)[2]);
        SignatureTests.assertEquals((String)"Signature#getParameterTypes 5", (String)"[Qstring;", (String)Signature.getParameterTypes((String)methodSig)[3]);
        SignatureTests.assertEquals((String)"Signature#getParameterTypes 5", (String)"[Tv;", (String)Signature.getParameterTypes((String)methodSig)[4]);
        SignatureTests.assertEquals((String)"Signature#getParameterTypes 5", (String)"[Lstring;", (String)Signature.getParameterTypes((String)methodSig)[5]);
        methodSig = "(La;)V";
        SignatureTests.assertEquals((String)"Signature#getParameterTypes 6", (int)1, (int)Signature.getParameterTypes((String)methodSig).length);
        SignatureTests.assertEquals((String)"Signature#getParameterTypes 6", (String)"La;", (String)Signature.getParameterTypes((String)methodSig)[0]);
        methodSig = "(La<TE;>;)V";
        SignatureTests.assertEquals((String)"Signature#getParameterTypes 6", (int)1, (int)Signature.getParameterTypes((String)methodSig).length);
        SignatureTests.assertEquals((String)"Signature#getParameterTypes 6", (String)"La<TE;>;", (String)Signature.getParameterTypes((String)methodSig)[0]);
        methodSig = "(La/b/c<TE;>.d<TF;>;)V";
        SignatureTests.assertEquals((String)"Signature#getParameterTypes 6", (int)1, (int)Signature.getParameterTypes((String)methodSig).length);
        SignatureTests.assertEquals((String)"Signature#getParameterTypes 6", (String)"La/b/c<TE;>.d<TF;>;", (String)Signature.getParameterTypes((String)methodSig)[0]);
    }

    public void testGetQualifier1() {
        SignatureTests.assertEquals((String)"java.lang", (String)Signature.getQualifier((String)"java.lang.Object"));
    }

    public void testGetQualifier2() {
        SignatureTests.assertEquals((String)"", (String)Signature.getQualifier((String)""));
    }

    public void testGetQualifier3() {
        SignatureTests.assertEquals((String)"java.util", (String)Signature.getQualifier((String)"java.util.List<java.lang.Object>"));
    }

    public void testGetReturnType() {
        String methodSig = "(QString;QObject;I)I";
        SignatureTests.assertEquals((String)"Signature#getReturnType is not correct1", (String)"I", (String)Signature.getReturnType((String)methodSig));
        try {
            Signature.getReturnType((String)"");
            SignatureTests.assertTrue((String)"Signature#getReturnType is not correct: exception", (boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        methodSig = "<X:Qlist<Qstring;>;>(Qstring;Qobject;I)IQexception;Qerror;";
        SignatureTests.assertEquals((String)"Signature#getReturnType is not correct2", (String)"I", (String)Signature.getReturnType((String)methodSig));
        methodSig = "<X:Qlist<Qstring;>;>(Qlist<Qstring;>;)Qlist<Qxxx;>;Qexception;Qerror;";
        SignatureTests.assertEquals((String)"Signature#getReturnType is not correct3", (String)"Qlist<Qxxx;>;", (String)Signature.getReturnType((String)methodSig));
    }

    public void testGetReturnType2() {
        String methodSig = "(LObject;)+[I";
        SignatureTests.assertEquals((String)"Signature#getReturnType is not correct", (String)"+[I", (String)Signature.getReturnType((String)methodSig));
    }

    public void testGetTypeVariable() {
        String formalTypeParameterSignature = "Hello:";
        SignatureTests.assertEquals((String)"Signature#getTypeVariable is not correct1", (String)"Hello", (String)Signature.getTypeVariable((String)formalTypeParameterSignature));
        formalTypeParameterSignature = "Hello::Qi1;:Qi2;";
        SignatureTests.assertEquals((String)"Signature#getTypeVariable is not correct2", (String)"Hello", (String)Signature.getTypeVariable((String)formalTypeParameterSignature));
        formalTypeParameterSignature = "Hello:Qlist<Qstring;>;:Qi1;:Qi2;";
        SignatureTests.assertEquals((String)"Signature#getTypeVariable is not correct3", (String)"Hello", (String)Signature.getTypeVariable((String)formalTypeParameterSignature));
        try {
            Signature.getTypeVariable((String)"");
            SignatureTests.assertTrue((String)"Signature#getTypeVariable is not correct: exception", (boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testGetSimpleName01() {
        SignatureTests.assertEquals((String)"Signature#getSimpleName is not correct 1", (String)"Object", (String)Signature.getSimpleName((String)"java.lang.Object"));
    }

    public void testGetSimpleName02() {
        SignatureTests.assertEquals((String)"Signature#getSimpleName is not correct 2", (String)"", (String)Signature.getSimpleName((String)""));
    }

    public void testGetSimpleName03() {
        SignatureTests.assertEquals((String)"Signature#getSimpleName is not correct 3", (String)"MapEntry<K<T>[],V2[]>", (String)Signature.getSimpleName((String)"java.y.Map<Object[],String>.MapEntry<p.K<T>[],q.r.V2[]>"));
    }

    public void testGetSimpleName04() {
        SignatureTests.assertEquals((String)"Signature#getSimpleName is not correct 4", (String)"MapEntry<K<T>[],? extends V2>", (String)Signature.getSimpleName((String)"java.y.Map<Object[],String>.MapEntry<p.K<T>[],? extends q.r.V2>"));
    }

    public void testGetSimpleName05() {
        SignatureTests.assertEquals((String)"Unexpected simple name", (String)"List<?>", (String)Signature.getSimpleName((String)"List<?>"));
    }

    public void testGetSimpleName06() {
        SignatureTests.assertEquals((String)"Unexpected simple name", (String)"List<? extends E>", (String)Signature.getSimpleName((String)"List<?extends E>"));
    }

    public void testGetSimpleName07() {
        SignatureTests.assertEquals((String)"Unexpected simple name", (String)"List<? super E>", (String)Signature.getSimpleName((String)"List<?super E>"));
    }

    public void testGetSimpleName08() {
        SignatureTests.assertEquals((String)"Unexpected simple name", (String)"List<+Comparable<-TT;>;>;", (String)Signature.getSimpleName((String)"\tjava.util.List<+Ljava.lang.Comparable<-TT;>;>;"));
    }

    public void testGetSimpleNames01() {
        this.assertStringsEqual("Unexpected simple names", "java\nlang\nObject\n", Signature.getSimpleNames((String)"java.lang.Object"));
    }

    public void testGetSimpleNames02() {
        this.assertStringsEqual("Unexpected simple names", "", Signature.getSimpleNames((String)""));
    }

    public void testGetSimpleNames03() {
        this.assertStringsEqual("Unexpected simple names", "Object\n", Signature.getSimpleNames((String)"Object"));
    }

    public void testGetSimpleNames04() {
        this.assertStringsEqual("Unexpected simple names", "java\nutil\nList<java.lang.String>\n", Signature.getSimpleNames((String)"java.util.List<java.lang.String>"));
    }

    public void testToQualifiedName() {
        SignatureTests.assertEquals((String)"Signature#toQualifiedName is not correct1", (String)"java.lang.Object", (String)Signature.toQualifiedName((String[])new String[]{"java", "lang", "Object"}));
        SignatureTests.assertEquals((String)"Signature#toQualifiedName is not correct2", (String)"Object", (String)Signature.toQualifiedName((String[])new String[]{"Object"}));
        SignatureTests.assertEquals((String)"Signature#toQualifiedName is not correct3", (String)"", (String)Signature.toQualifiedName((String[])new String[0]));
    }

    public void testToStringType01() {
        SignatureTests.assertEquals((String)"java/lang/String", (String)Signature.toString((String)"Ljava/lang/String;"));
    }

    public void testToStringType02() {
        SignatureTests.assertEquals((String)"java.lang.String", (String)Signature.toString((String)"Ljava.lang.String;"));
    }

    public void testToStringType03() {
        SignatureTests.assertEquals((String)"java.lang.String[]", (String)Signature.toString((String)"[Ljava.lang.String;"));
    }

    public void testToStringType04() {
        SignatureTests.assertEquals((String)"String", (String)Signature.toString((String)"QString;"));
    }

    public void testToStringType05() {
        SignatureTests.assertEquals((String)"String[][]", (String)Signature.toString((String)"[[QString;"));
    }

    public void testToStringType06() {
        SignatureTests.assertEquals((String)"boolean", (String)Signature.toString((String)"Z"));
    }

    public void testToStringType07() {
        SignatureTests.assertEquals((String)"byte", (String)Signature.toString((String)"B"));
    }

    public void testToStringType08() {
        SignatureTests.assertEquals((String)"char", (String)Signature.toString((String)"C"));
    }

    public void testToStringType09() {
        SignatureTests.assertEquals((String)"double", (String)Signature.toString((String)"D"));
    }

    public void testToStringType10() {
        SignatureTests.assertEquals((String)"float", (String)Signature.toString((String)"F"));
    }

    public void testToStringType11() {
        SignatureTests.assertEquals((String)"int", (String)Signature.toString((String)"I"));
    }

    public void testToStringType12() {
        SignatureTests.assertEquals((String)"long", (String)Signature.toString((String)"J"));
    }

    public void testToStringType13() {
        SignatureTests.assertEquals((String)"short", (String)Signature.toString((String)"S"));
    }

    public void testToStringType14() {
        SignatureTests.assertEquals((String)"void", (String)Signature.toString((String)"V"));
    }

    public void testToStringType15() {
        SignatureTests.assertEquals((String)"int[][][]", (String)Signature.toString((String)"[[[I"));
    }

    public void testToStringType16() {
        SignatureTests.assertEquals((String)"VAR", (String)Signature.toString((String)"TVAR;"));
    }

    public void testToStringType17() {
        SignatureTests.assertEquals((String)"A<B>", (String)Signature.toString((String)"QA<QB;>;"));
    }

    public void testToStringType18() {
        SignatureTests.assertEquals((String)"A<?>", (String)Signature.toString((String)"QA<*>;"));
    }

    public void testToStringType19() {
        SignatureTests.assertEquals((String)"A<? extends B>", (String)Signature.toString((String)"QA<+QB;>;"));
    }

    public void testToStringType20() {
        SignatureTests.assertEquals((String)"A<? super B>", (String)Signature.toString((String)"QA<-QB;>;"));
    }

    public void testToStringType21() {
        SignatureTests.assertEquals((String)"A<?,?,?,?,?>", (String)Signature.toString((String)"LA<*****>;"));
    }

    public void testToStringType22() {
        SignatureTests.assertEquals((String)"a<V>.b<W>.c<X>", (String)Signature.toString((String)"La<TV;>.b<QW;>.c<LX;>;"));
    }

    public void testToStringType23() {
        SignatureTests.assertEquals((String)"java.y.Map<Object[],String>.MapEntry<p.K<T>[],q.r.V2[]>", (String)Signature.toString((String)"Qjava.y.Map<[QObject;QString;>.MapEntry<[Qp.K<QT;>;[Qq.r.V2;>;"));
    }

    public void testToStringType24() {
        SignatureTests.assertEquals((String)"Stack<List<Object>>", (String)Signature.toString((String)"QStack<QList<QObject;>;>;"));
    }

    public void testToStringType25() {
        SignatureTests.assertEquals((String)"?", (String)Signature.toString((String)"*"));
    }

    public void testToStringType26() {
        SignatureTests.assertEquals((String)"? extends Object", (String)Signature.toString((String)"+QObject;"));
    }

    public void testToStringType27() {
        SignatureTests.assertEquals((String)"? super InputStream", (String)Signature.toString((String)"-QInputStream;"));
    }

    public void testToStringMethod01() {
        SignatureTests.assertEquals((String)"void main(String[] args)", (String)Signature.toString((String)"([Ljava.lang.String;)V", (String)"main", (String[])new String[]{"args"}, (boolean)false, (boolean)true));
    }

    public void testToStringMethod02() {
        SignatureTests.assertEquals((String)"main(String[] args)", (String)Signature.toString((String)"([Ljava.lang.String;)V", (String)"main", (String[])new String[]{"args"}, (boolean)false, (boolean)false));
    }

    public void testToStringMethod03() {
        SignatureTests.assertEquals((String)"main(java.lang.String[] args)", (String)Signature.toString((String)"([Ljava.lang.String;)V", (String)"main", (String[])new String[]{"args"}, (boolean)true, (boolean)false));
    }

    public void testToStringMethod04() {
        SignatureTests.assertEquals((String)"(java.lang.String[])", (String)Signature.toString((String)"([Ljava.lang.String;)V", null, null, (boolean)true, (boolean)false));
    }

    public void testToStringMethod05() {
        SignatureTests.assertEquals((String)"String main(String[] args)", (String)Signature.toString((String)"([Ljava.lang.String;)Ljava.lang.String;", (String)"main", (String[])new String[]{"args"}, (boolean)false, (boolean)true));
    }

    public void testToStringMethod06() {
        SignatureTests.assertEquals((String)"java.lang.String main(java.lang.String[] args)", (String)Signature.toString((String)"([Ljava.lang.String;)Ljava.lang.String;", (String)"main", (String[])new String[]{"args"}, (boolean)true, (boolean)true));
    }

    public void testToStringMethod07() {
        SignatureTests.assertEquals((String)"java.lang.String main(java.lang.String[] args)", (String)Signature.toString((String)"main([Ljava.lang.String;)Ljava.lang.String;", (String)"main", (String[])new String[]{"args"}, (boolean)true, (boolean)true));
    }

    public void testToStringMethod08() {
        SignatureTests.assertEquals((String)"java.lang.String[] foo()", (String)Signature.toString((String)"()[Ljava.lang.String;", (String)"foo", null, (boolean)true, (boolean)true));
    }

    public void testToStringMethod09() {
        SignatureTests.assertEquals((String)"I foo(C, L)", (String)Signature.toString((String)"(LC;LL;)LI;", (String)"foo", null, (boolean)true, (boolean)true));
    }

    public void testToStringMethod10() {
        SignatureTests.assertEquals((String)"char[][] foo()", (String)Signature.toString((String)"()[[C", (String)"foo", null, (boolean)true, (boolean)true));
    }

    public void testToStringMethod11() {
        SignatureTests.assertEquals((String)"void foo(java.lang.Object, String[][], boolean, byte, char, double, float, int, long, short)", (String)Signature.toString((String)"(Ljava.lang.Object;[[QString;ZBCDFIJS)V", (String)"foo", null, (boolean)true, (boolean)true));
    }

    public void testToStringMethod12() {
        try {
            Signature.toString((String)"([Ljava.lang.String;V", null, null, (boolean)true, (boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        SignatureTests.assertTrue((String)"Should get an exception", (boolean)false);
    }

    public void testToStringInnerType() {
        SignatureTests.assertEquals((String)"Signature#toString is not correct", (String)"x.y.A.Inner", (String)Signature.toString((String)"Lx.y.A$Inner;"));
    }

    public void testGetTypeSignatureKind01() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(String) is not correct 1", (int)1, (int)Signature.getTypeSignatureKind((String)"Ljava.lang.String;"));
    }

    public void testGetTypeSignatureKind02() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(String) is not correct 2", (int)4, (int)Signature.getTypeSignatureKind((String)"[Ljava.lang.String;"));
    }

    public void testGetTypeSignatureKind03() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(String) is not correct 3", (int)1, (int)Signature.getTypeSignatureKind((String)"QString;"));
    }

    public void testGetTypeSignatureKind04() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(String) is not correct 4", (int)4, (int)Signature.getTypeSignatureKind((String)"[[QString;"));
    }

    public void testGetTypeSignatureKind05() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(String) is not correct 5", (int)2, (int)Signature.getTypeSignatureKind((String)"Z"));
    }

    public void testGetTypeSignatureKind06() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(String) is not correct 6", (int)2, (int)Signature.getTypeSignatureKind((String)"B"));
    }

    public void testGetTypeSignatureKind07() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(String) is not correct 7", (int)2, (int)Signature.getTypeSignatureKind((String)"C"));
    }

    public void testGetTypeSignatureKind08() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(String) is not correct 8", (int)2, (int)Signature.getTypeSignatureKind((String)"D"));
    }

    public void testGetTypeSignatureKind09() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(String) is not correct 9", (int)2, (int)Signature.getTypeSignatureKind((String)"F"));
    }

    public void testGetTypeSignatureKind10() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(String) is not correct 10", (int)2, (int)Signature.getTypeSignatureKind((String)"I"));
    }

    public void testGetTypeSignatureKind11() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(String) is not correct 11", (int)2, (int)Signature.getTypeSignatureKind((String)"J"));
    }

    public void testGetTypeSignatureKind12() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(String) is not correct 12", (int)2, (int)Signature.getTypeSignatureKind((String)"S"));
    }

    public void testGetTypeSignatureKind13() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(String) is not correct 13", (int)2, (int)Signature.getTypeSignatureKind((String)"V"));
    }

    public void testGetTypeSignatureKind14() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(String) is not correct 14", (int)4, (int)Signature.getTypeSignatureKind((String)"[[[I"));
    }

    public void testGetTypeSignatureKind16() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(String) is not correct 16", (int)1, (int)Signature.getTypeSignatureKind((String)"QA<QB;>;"));
    }

    public void testGetTypeSignatureKind17() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(String) is not correct 17", (int)1, (int)Signature.getTypeSignatureKind((String)"QA<*>;"));
    }

    public void testGetTypeSignatureKind18() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(String) is not correct 18", (int)1, (int)Signature.getTypeSignatureKind((String)"QA<+QB;>;"));
    }

    public void testGetTypeSignatureKind19() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(String) is not correct 19", (int)1, (int)Signature.getTypeSignatureKind((String)"QA<-QB;>;"));
    }

    public void testGetTypeSignatureKind20() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(String) is not correct 20", (int)1, (int)Signature.getTypeSignatureKind((String)"LA<*****>;"));
    }

    public void testGetTypeSignatureKind21() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(String) is not correct 21", (int)1, (int)Signature.getTypeSignatureKind((String)"La<TV;>.b<QW;>.c<LX;>;"));
    }

    public void testGetTypeSignatureKind25() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(String) is not correct 25", (int)1, (int)Signature.getTypeSignatureKind((String)"<T:>Ljava.lang.Class;"));
    }

    public void testGetTypeSignatureKindCharArray01() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(char[]) is not correct 1", (int)1, (int)Signature.getTypeSignatureKind((char[])"Ljava.lang.String;".toCharArray()));
    }

    public void testGetTypeSignatureKindCharArray02() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(char[]) is not correct 2", (int)4, (int)Signature.getTypeSignatureKind((char[])"[Ljava.lang.String;".toCharArray()));
    }

    public void testGetTypeSignatureKindCharArray03() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(char[]) is not correct 3", (int)1, (int)Signature.getTypeSignatureKind((char[])"QString;".toCharArray()));
    }

    public void testGetTypeSignatureKindCharArray04() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(char[]) is not correct 4", (int)4, (int)Signature.getTypeSignatureKind((char[])"[[QString;".toCharArray()));
    }

    public void testGetTypeSignatureKindCharArray05() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(char[]) is not correct 5", (int)2, (int)Signature.getTypeSignatureKind((char[])"Z".toCharArray()));
    }

    public void testGetTypeSignatureKindCharArray06() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(char[]) is not correct 6", (int)2, (int)Signature.getTypeSignatureKind((char[])"B".toCharArray()));
    }

    public void testGetTypeSignatureKindCharArray07() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(char[]) is not correct 7", (int)2, (int)Signature.getTypeSignatureKind((char[])"C".toCharArray()));
    }

    public void testGetTypeSignatureKindCharArray08() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(char[]) is not correct 8", (int)2, (int)Signature.getTypeSignatureKind((char[])"D".toCharArray()));
    }

    public void testGetTypeSignatureKindCharArray09() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(char[]) is not correct 9", (int)2, (int)Signature.getTypeSignatureKind((char[])"F".toCharArray()));
    }

    public void testGetTypeSignatureKindCharArray10() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(char[]) is not correct 10", (int)2, (int)Signature.getTypeSignatureKind((char[])"I".toCharArray()));
    }

    public void testGetTypeSignatureKindCharArray11() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(char[]) is not correct 11", (int)2, (int)Signature.getTypeSignatureKind((char[])"J".toCharArray()));
    }

    public void testGetTypeSignatureKindCharArray12() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(char[]) is not correct 12", (int)2, (int)Signature.getTypeSignatureKind((char[])"S".toCharArray()));
    }

    public void testGetTypeSignatureKindCharArray13() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(char[]) is not correct 13", (int)2, (int)Signature.getTypeSignatureKind((char[])"V".toCharArray()));
    }

    public void testGetTypeSignatureKindCharArray14() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(char[]) is not correct 14", (int)4, (int)Signature.getTypeSignatureKind((char[])"[[[I".toCharArray()));
    }

    public void testGetTypeSignatureKindCharArray16() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(char[]) is not correct 16", (int)1, (int)Signature.getTypeSignatureKind((char[])"QA<QB;>;".toCharArray()));
    }

    public void testGetTypeSignatureKindCharArray17() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(char[]) is not correct 17", (int)1, (int)Signature.getTypeSignatureKind((char[])"QA<*>;".toCharArray()));
    }

    public void testGetTypeSignatureKindCharArray18() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(char[]) is not correct 18", (int)1, (int)Signature.getTypeSignatureKind((char[])"QA<+QB;>;".toCharArray()));
    }

    public void testGetTypeSignatureKindCharArray19() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(char[]) is not correct 19", (int)1, (int)Signature.getTypeSignatureKind((char[])"QA<-QB;>;".toCharArray()));
    }

    public void testGetTypeSignatureKindCharArray20() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(char[]) is not correct 20", (int)1, (int)Signature.getTypeSignatureKind((char[])"LA<*****>;".toCharArray()));
    }

    public void testGetTypeSignatureKindCharArray21() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(char[]) is not correct 21", (int)1, (int)Signature.getTypeSignatureKind((char[])"La<TV;>.b<QW;>.c<LX;>;".toCharArray()));
    }

    public void testGetTypeSignatureKindCharArray25() {
        SignatureTests.assertEquals((String)"Signature#getTypeSignatureKind(char[]) is not correct 25", (int)1, (int)Signature.getTypeSignatureKind((char[])"<T:>Ljava.lang.Class;".toCharArray()));
    }

    public void testGetTypeFragment01() {
        SignatureTests.assertEquals((String)"C.D.E", (String)Signature.getSignatureSimpleName((String)"La.b.C$D$E;"));
    }

    public void testGetTypeFragment02() {
        SignatureTests.assertEquals((String)"C.D.E", (String)Signature.getSignatureSimpleName((String)"LC$D$E;"));
    }

    public void testGetTypeFragment03() {
        SignatureTests.assertEquals((String)"C<X>.D.E", (String)Signature.getSignatureSimpleName((String)"La.b.C<LX;>.D$E;"));
    }

    public void testGetPackageFragment01() {
        SignatureTests.assertEquals((String)"a.b", (String)Signature.getSignatureQualifier((String)"La.b.C$D$E;"));
    }

    public void testGetPackageFragment02() {
        SignatureTests.assertEquals((String)"", (String)Signature.getSignatureQualifier((String)"LC$D$E;"));
    }

    public void testGetPackageFragment03() {
        SignatureTests.assertEquals((String)"a.b", (String)Signature.getSignatureQualifier((String)"La.b.C<LX;>.D$E;"));
    }

    public void testGetPackageFragment04() {
        SignatureTests.assertEquals((String)"", (String)Signature.getSignatureQualifier((String)"LC<LX;>.D$E;"));
    }
}

