/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.rewrite.modifying;

import java.util.List;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.tests.model.SuiteOfTestCases;
import org.eclipse.wst.jsdt.core.tests.rewrite.modifying.ASTRewritingModifyingTest;

public class ASTRewritingModifyingReplaceTest
extends ASTRewritingModifyingTest {
    private static final Class THIS;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.rewrite.modifying.ASTRewritingModifyingReplaceTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        THIS = clazz;
    }

    public ASTRewritingModifyingReplaceTest(String name) {
        super(name);
    }

    public static Test allTests() {
        return new SuiteOfTestCases.Suite(THIS);
    }

    public static Test suite() {
        return ASTRewritingModifyingReplaceTest.allTests();
    }

    public void test0004() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0004", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("function X() {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        List statements = astRoot.statements();
        SimpleName name = astRoot.getAST().newSimpleName("AAA");
        FunctionDeclaration f = (FunctionDeclaration)statements.get(0);
        f.setName(name);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("function AAA() {\n");
        buf.append("}\n");
        ASTRewritingModifyingReplaceTest.assertEqualString(preview, buf.toString());
    }

    public void test0005() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0005", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("function X() {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("function Y() {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("function Z() {\n");
        buf.append("\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        AST a = astRoot.getAST();
        List statements = astRoot.statements();
        FunctionDeclaration functionDeclaration = a.newFunctionDeclaration();
        SimpleName name = a.newSimpleName("AAA");
        functionDeclaration.setName(name);
        statements.set(1, functionDeclaration);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("function X() {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("function AAA() {\n");
        buf.append("}\n");
        buf.append("function Z() {\n");
        buf.append("\n");
        buf.append("}\n");
        ASTRewritingModifyingReplaceTest.assertEqualString(preview, buf.toString());
    }
}

