/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import junit.framework.Test;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.wst.jsdt.internal.compiler.parser.Scanner;

public class ScannerTest
extends AbstractRegressionTest {
    static /* synthetic */ Class class$0;

    public ScannerTest(String name) {
        super(name);
    }

    public static Test suite() {
        return ScannerTest.buildAllCompliancesTestSuite(ScannerTest.testClass());
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.compiler.regression.ScannerTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void test001() {
        String sourceA001 = "\\u003b";
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)true, (boolean)false, (boolean)false);
        scanner.setSource(sourceA001.toCharArray());
        int token = 0;
        try {
            token = scanner.getNextToken();
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
        ScannerTest.assertEquals((String)"Wrong token type", (int)64, (int)token);
    }

    public void test002() {
        String sourceA002 = "// tests\n  ";
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)true, (boolean)false, (boolean)false);
        scanner.setSource(sourceA002.toCharArray());
        int token = 0;
        try {
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)1000, (int)token);
            ScannerTest.assertEquals((String)"Wrong size", (int)2, (int)scanner.getCurrentTokenSource().length);
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)158, (int)token);
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void test003() {
        String sourceA003 = "// tests\n  ";
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (boolean)false);
        scanner.setSource(sourceA003.toCharArray());
        int token = 0;
        try {
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)1001, (int)token);
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)1000, (int)token);
            ScannerTest.assertEquals((String)"Wrong size", (int)2, (int)scanner.getCurrentTokenSource().length);
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)158, (int)token);
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void test004() {
        String source = "01e0f";
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(source.toCharArray());
        int token = 0;
        try {
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)42, (int)token);
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void test005() {
        StringBuffer buf = new StringBuffer();
        buf.append("\"Hello\"");
        String str = buf.toString();
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(str.toCharArray());
        scanner.resetTo(0, str.length() - 1);
        int token = 0;
        try {
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)45, (int)token);
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)158, (int)token);
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void test006() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        try {
            scanner.setSource(null);
        }
        catch (NullPointerException nullPointerException) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void test007() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        char[] source = "int i = 0;".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(source.length + 50, source.length - 1);
        int token = -1;
        try {
            token = scanner.getNextToken();
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
        ScannerTest.assertEquals((String)"Expecting EOF", (int)158, (int)token);
    }

    public void test008() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)"1.5");
        char[] source = "0x11aa.aap-3333f".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        int token = -1;
        try {
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token", (int)42, (int)token);
            token = scanner.getNextToken();
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
        ScannerTest.assertEquals((String)"Expecting EOF", (int)158, (int)token);
    }

    public void test009() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)"1.4");
        char[] source = "0x11aa.aap-3333f".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        int counter = 0;
        try {
            while (scanner.getNextToken() != 158) {
                ++counter;
            }
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
        ScannerTest.assertEquals((String)"Wrong number of tokens", (int)5, (int)counter);
    }

    public void test010() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)"1.5");
        char[] source = "0x11aa.aap-3333f".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        int counter = 0;
        try {
            while (scanner.getNextToken() != 158) {
                ++counter;
            }
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
        ScannerTest.assertEquals((String)"Wrong number of tokens", (int)1, (int)counter);
    }

    public void test011() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)"1.5");
        char[] source = "0x.aap-3333f".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        int counter = 0;
        try {
            while (scanner.getNextToken() != 158) {
                ++counter;
            }
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
        ScannerTest.assertEquals((String)"Wrong number of tokens", (int)1, (int)counter);
    }

    public void test012() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)"1.5");
        char[] source = "0xaap3f".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        int counter = 0;
        try {
            while (scanner.getNextToken() != 158) {
                ++counter;
            }
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
        ScannerTest.assertEquals((String)"Wrong number of tokens", (int)1, (int)counter);
    }

    public void test013() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)"1.5");
        char[] source = "0xaapaf".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            while (scanner.getNextToken() != 158) {
            }
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)true);
            return;
        }
        ScannerTest.assertTrue((boolean)false);
    }

    public void test014() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)"1.5");
        char[] source = "0xaap.1f".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            while (scanner.getNextToken() != 158) {
            }
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)true);
            return;
        }
        ScannerTest.assertTrue((boolean)false);
    }

    public void test015() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)"1.5");
        char[] source = "0xaa.p1f".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        int counter = 0;
        try {
            while (scanner.getNextToken() != 158) {
                ++counter;
            }
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
        ScannerTest.assertEquals((String)"Wrong number of tokens", (int)1, (int)counter);
    }

    public void test016() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)"1.5");
        char[] source = "0xaa.p1F".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        int counter = 0;
        try {
            while (scanner.getNextToken() != 158) {
                ++counter;
            }
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
        ScannerTest.assertEquals((String)"Wrong number of tokens", (int)1, (int)counter);
    }

    public void test017() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)"1.5");
        char[] source = "0xaa.p1D".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        int counter = 0;
        try {
            while (scanner.getNextToken() != 158) {
                ++counter;
            }
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
        ScannerTest.assertEquals((String)"Wrong number of tokens", (int)1, (int)counter);
    }

    public void test018() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)"1.5");
        char[] source = "0xaa.p1d".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        int counter = 0;
        try {
            while (scanner.getNextToken() != 158) {
                ++counter;
            }
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
        ScannerTest.assertEquals((String)"Wrong number of tokens", (int)1, (int)counter);
    }

    public void test019() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)"1.4");
        char[] source = "0x".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            while (scanner.getNextToken() != 158) {
            }
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)true);
            return;
        }
        ScannerTest.assertTrue((boolean)false);
    }

    public void test020() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)"1.5");
        char[] source = "0x".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            while (scanner.getNextToken() != 158) {
            }
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)true);
            return;
        }
        ScannerTest.assertTrue((boolean)false);
    }

    public void test021() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)"1.4");
        char[] source = "0x1".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        int counter = 0;
        try {
            while (scanner.getNextToken() != 158) {
                ++counter;
            }
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
        ScannerTest.assertEquals((String)"Wrong number of tokens", (int)1, (int)counter);
    }

    public void test022() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)"1.5");
        char[] source = "0x1".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        int counter = 0;
        try {
            while (scanner.getNextToken() != 158) {
                ++counter;
            }
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
        ScannerTest.assertEquals((String)"Wrong number of tokens", (int)1, (int)counter);
    }

    public void test023() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)"1.5");
        char[] source = "0x.p-2".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            while (scanner.getNextToken() != 158) {
            }
            ScannerTest.assertTrue((boolean)false);
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)true);
        }
    }

    public void test024() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)true, (String)"1.5");
        char[] source = "public class X {\n\n}".toCharArray();
        scanner.setSource(source);
        int counter = 0;
        try {
            while (scanner.getNextToken() != 158) {
                ++counter;
            }
        }
        catch (InvalidInputException invalidInputException) {}
        ScannerTest.assertEquals((String)"wrong number of tokens", (int)5, (int)counter);
        int[] lineEnds = scanner.getLineEnds();
        ScannerTest.assertNotNull((String)"No line ends", (Object)lineEnds);
        ScannerTest.assertEquals((String)"wrong length", (int)2, (int)lineEnds.length);
        source = "public class X {}".toCharArray();
        scanner.setSource(source);
        lineEnds = scanner.getLineEnds();
        ScannerTest.assertNotNull((String)"No line ends", (Object)lineEnds);
        ScannerTest.assertEquals((String)"wrong length", (int)0, (int)lineEnds.length);
        counter = 0;
        try {
            while (scanner.getNextToken() != 158) {
                ++counter;
            }
        }
        catch (InvalidInputException invalidInputException) {}
        ScannerTest.assertEquals((String)"wrong number of tokens", (int)5, (int)counter);
        lineEnds = scanner.getLineEnds();
        ScannerTest.assertNotNull((String)"No line ends", (Object)lineEnds);
        ScannerTest.assertEquals((String)"wrong length", (int)0, (int)lineEnds.length);
    }

    public void test025() {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        scanner.setSource("String\r\nwith\r\nmany\r\nmany\r\nline\r\nbreaks".toCharArray());
        try {
            while (scanner.getNextToken() != 158) {
            }
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
        ScannerTest.assertEquals((String)"Wrong size", (int)5, (int)scanner.getLineEnds().length);
        scanner.setSource("No line breaks here".toCharArray());
        ScannerTest.assertEquals((String)"Wrong size", (int)0, (int)scanner.getLineEnds().length);
    }

    public void test026() {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)"1.4");
        char[] source = "0x.p-2".toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            while (scanner.getNextToken() != 158) {
            }
            ScannerTest.assertTrue((boolean)false);
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)true);
        }
    }

    public void test027() {
        char[] source = "class Test {\n  char  C = \"\\u005Cn\";\n}".toCharArray();
        Scanner scanner = new Scanner(false, false, false, 0x300000L, null, null, false);
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            int token;
            StringBuffer buffer = new StringBuffer();
            while ((token = scanner.getNextToken()) != 70) {
                try {
                    switch (token) {
                        case 70: {
                            break;
                        }
                        default: {
                            buffer.append(scanner.getCurrentTokenSource());
                            break;
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
            }
            ScannerTest.assertEquals("Wrong contents", "classTest{charC=\"\n\";}", String.valueOf(buffer));
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void test028() {
        char[] source = "class Test {\n  char  C = '\\u005Cn';\n}".toCharArray();
        Scanner scanner = new Scanner(false, false, false, 0x300000L, null, null, false);
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            int token;
            StringBuffer buffer = new StringBuffer();
            while ((token = scanner.getNextToken()) != 70) {
                try {
                    switch (token) {
                        case 35: {
                            buffer.append(new String(scanner.getCurrentTokenSourceString()));
                            break;
                        }
                        case 70: {
                            break;
                        }
                        default: {
                            buffer.append(scanner.getCurrentTokenSource());
                            break;
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
            }
            ScannerTest.assertEquals("Wrong contents", "classTest{charC='\\n';}", String.valueOf(buffer));
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void test029() {
        char[] source = "class Test {\n  char  C = \"\\n\";\n}".toCharArray();
        Scanner scanner = new Scanner(false, false, false, 0x300000L, null, null, false);
        scanner.setSource(source);
        scanner.resetTo(0, source.length - 1);
        try {
            int token;
            StringBuffer buffer = new StringBuffer();
            while ((token = scanner.getNextToken()) != 70) {
                try {
                    switch (token) {
                        case 70: {
                            break;
                        }
                        default: {
                            buffer.append(scanner.getCurrentTokenSource());
                            break;
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
            }
            ScannerTest.assertEquals("Wrong contents", "classTest{charC=\"\n\";}", String.valueOf(buffer));
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void test030() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n  static String C = \"\\n\";\n  \n  public static void main(String[] args) {\n  \tSystem.out.print(C.length());\n  \tSystem.out.print(C.charAt(0) == '\\n');\n  }\n}"}, "1true");
    }

    public void test031() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n  static String C = \"\\u005Cn\";\n  \n  public static void main(String[] args) {\n  \tSystem.out.print(C.length());\n  \tSystem.out.print(C.charAt(0) == '\\n');\n  }\n}"}, "1true");
    }

    public void test032() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n  static char C = '\\u005Cn';\n  \n  public static void main(String[] args) {\n  \tSystem.out.print(C == '\\n');\n  }\n}"}, "true");
    }

    public void test033() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n  static char C = \\u0027\\u005Cn\\u0027;\n  \n  public static void main(String[] args) {\n  \tSystem.out.print(C == '\\n');\n  }\n}"}, "true");
    }

    public void test034() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n  static String C = \"C\\n\\u0043\";\n  \n  public static void main(String[] args) {\n  \tSystem.out.print(C.length());\n  \tSystem.out.print(C.charAt(1) == '\\n');\n  }\n}"}, "3true");
    }

    public void test035() {
        this.runConformTest(new String[]{"Test.java", "\\u0070\\u0075\\u0062\\u006c\\u0069\\u0063\\u0020\\u0063\\u006c\\u0061\\u0073\\u0073\\u0020\\u0054\\u0065\\u0073\\u0074\\u0020\\u007b\\u000A\n\\u0020\\u0020\\u0073\\u0074\\u0061\\u0074\\u0069\\u0063\\u0020\\u0053\\u0074\\u0072\\u0069\\u006e\\u0067\\u0020\\u0043\\u0020\\u003d\\u0020\\u0022\\u005c\\u006e\\u0022\\u003b\\u000A\n\\u0020\\u0020\\u000A\n\\u0020\\u0020\\u0070\\u0075\\u0062\\u006c\\u0069\\u0063\\u0020\\u0073\\u0074\\u0061\\u0074\\u0069\\u0063\\u0020\\u0076\\u006f\\u0069\\u0064\\u0020\\u006d\\u0061\\u0069\\u006e\\u0028\\u0053\\u0074\\u0072\\u0069\\u006e\\u0067\\u005b\\u005d\\u0020\\u0061\\u0072\\u0067\\u0073\\u0029\\u0020\\u007b\\u000A\n\\u0020\\u0020\\u0009\\u0053\\u0079\\u0073\\u0074\\u0065\\u006d\\u002e\\u006f\\u0075\\u0074\\u002e\\u0070\\u0072\\u0069\\u006e\\u0074\\u0028\\u0043\\u002e\\u006c\\u0065\\u006e\\u0067\\u0074\\u0068\\u0028\\u0029\\u0029\\u003b\\u000A\n\\u0020\\u0020\\u0009\\u0053\\u0079\\u0073\\u0074\\u0065\\u006d\\u002e\\u006f\\u0075\\u0074\\u002e\\u0070\\u0072\\u0069\\u006e\\u0074\\u0028\\u0043\\u002e\\u0063\\u0068\\u0061\\u0072\\u0041\\u0074\\u0028\\u0030\\u0029\\u0020\\u003d\\u003d\\u0020\\u0027\\u005c\\u006e\\u0027\\u0029\\u003b\\u000A\n\\u0020\\u0020\\u007d\\u0020\\u0009\\u000A\n\\u007d"}, "1true");
    }

    public void test036() {
        try {
            IScanner s = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)true, (String)"1.5", (String)"1.5");
            char[] source = new char[]{';', ' '};
            s.setSource(source);
            s.resetTo(0, 0);
            int token = s.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token", (int)64, (int)token);
            char[] tokenSource = s.getCurrentTokenSource();
            ScannerTest.assertEquals((String)"wront size", (int)1, (int)tokenSource.length);
            ScannerTest.assertEquals((String)"Wrong character", (char)';', (char)tokenSource[0]);
            token = s.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token", (int)158, (int)token);
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((String)"Should not happen", (boolean)false);
        }
    }

    public void test037() {
        try {
            IScanner s = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)true, (String)"1.5", (String)"1.5");
            char[] source = new char[]{';', ' '};
            s.setSource(source);
            int token = s.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token", (int)64, (int)token);
            char[] tokenSource = s.getCurrentTokenSource();
            ScannerTest.assertEquals((String)"wront size", (int)1, (int)tokenSource.length);
            ScannerTest.assertEquals((String)"Wrong character", (char)';', (char)tokenSource[0]);
            token = s.getNextToken();
            tokenSource = s.getCurrentTokenSource();
            ScannerTest.assertEquals((String)"wront size", (int)1, (int)tokenSource.length);
            ScannerTest.assertEquals((String)"Wrong character", (char)' ', (char)tokenSource[0]);
            ScannerTest.assertEquals((String)"Wrong token", (int)1000, (int)token);
            token = s.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token", (int)158, (int)token);
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((String)"Should not happen", (boolean)false);
        }
    }

    public void test038() {
        try {
            IScanner s = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)true, (String)"1.5", (String)"1.5");
            char[] source = new char[]{';', ' '};
            s.setSource(source);
            s.resetTo(0, 1);
            int token = s.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token", (int)64, (int)token);
            char[] tokenSource = s.getCurrentTokenSource();
            ScannerTest.assertEquals((String)"wront size", (int)1, (int)tokenSource.length);
            ScannerTest.assertEquals((String)"Wrong character", (char)';', (char)tokenSource[0]);
            token = s.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token", (int)1000, (int)token);
            tokenSource = s.getCurrentTokenSource();
            ScannerTest.assertEquals((String)"wront size", (int)1, (int)tokenSource.length);
            ScannerTest.assertEquals((String)"Wrong character", (char)' ', (char)tokenSource[0]);
            token = s.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token", (int)158, (int)token);
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((String)"Should not happen", (boolean)false);
        }
    }

    public void test039() {
        try {
            IScanner s = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)true, (String)"1.5", (String)"1.5");
            char[] source = new char[]{';', ' '};
            s.setSource(source);
            s.resetTo(1, 1);
            int token = s.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token", (int)1000, (int)token);
            char[] tokenSource = s.getCurrentTokenSource();
            ScannerTest.assertEquals((String)"wront size", (int)1, (int)tokenSource.length);
            ScannerTest.assertEquals((String)"Wrong character", (char)' ', (char)tokenSource[0]);
            token = s.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token", (int)158, (int)token);
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((String)"Should not happen", (boolean)false);
        }
    }

    public void test040() {
        try {
            IScanner s = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)true, (String)"1.5", (String)"1.5");
            char[] source = new char[]{';', ' '};
            s.setSource(source);
            s.resetTo(2, 1);
            int token = s.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token", (int)158, (int)token);
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((String)"Should not happen", (boolean)false);
        }
    }

    public void test041() {
        try {
            IScanner s = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)true, (String)"1.5", (String)"1.5");
            char[] source = "\\u003B\\u0020".toCharArray();
            ScannerTest.assertEquals((String)"wrong size", (int)12, (int)source.length);
            s.setSource(source);
            s.resetTo(0, 5);
            int token = s.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token", (int)64, (int)token);
            char[] tokenSource = s.getRawTokenSource();
            ScannerTest.assertEquals((String)"wront size", (int)6, (int)tokenSource.length);
            ScannerTest.assertEquals("Wrong character", "\\u003B", new String(tokenSource));
            token = s.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token", (int)158, (int)token);
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((String)"Should not happen", (boolean)false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test042() {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)true, (String)"1.5", (String)"1.5");
        char[] source = "\"a\\u000D\"".toCharArray();
        scanner.setSource(source);
        StringBuffer buffer = new StringBuffer();
        try {
            block7: while (true) {
                int token;
                if ((token = scanner.getNextToken()) == 158) {
                    ScannerTest.assertTrue((String)"Should have failed", (boolean)false);
                    return;
                }
                try {
                    switch (token) {
                        case 158: {
                            continue block7;
                        }
                    }
                    buffer.append(scanner.getCurrentTokenSource());
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (InvalidInputException e) {
            buffer.append(scanner.getRawTokenSource());
            ScannerTest.assertEquals("Unexpected contents", "\"a\\u000D\"", String.valueOf(buffer));
            ScannerTest.assertEquals("Wrong exception", "Invalid_Char_In_String", e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test043() {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)true, (String)"1.5", (String)"1.5");
        char[] source = "\"\\u004Ca\\u000D\"".toCharArray();
        scanner.setSource(source);
        StringBuffer buffer = new StringBuffer();
        try {
            block7: while (true) {
                int token;
                if ((token = scanner.getNextToken()) == 158) {
                    ScannerTest.assertTrue((String)"Should have failed", (boolean)false);
                    return;
                }
                try {
                    switch (token) {
                        case 158: {
                            continue block7;
                        }
                    }
                    buffer.append(scanner.getCurrentTokenSource());
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (InvalidInputException e) {
            buffer.append(scanner.getRawTokenSource());
            ScannerTest.assertEquals("Unexpected contents", "\"\\u004Ca\\u000D\"", String.valueOf(buffer));
            ScannerTest.assertEquals("Wrong exception", "Invalid_Char_In_String", e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test044() {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)true, (String)"1.5", (String)"1.5");
        char[] source = "\"\\u004Ca\\u000D\\u0022".toCharArray();
        scanner.setSource(source);
        StringBuffer buffer = new StringBuffer();
        try {
            block7: while (true) {
                int token;
                if ((token = scanner.getNextToken()) == 158) {
                    ScannerTest.assertTrue((String)"Should have failed", (boolean)false);
                    return;
                }
                try {
                    switch (token) {
                        case 158: {
                            continue block7;
                        }
                    }
                    buffer.append(scanner.getCurrentTokenSource());
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (InvalidInputException e) {
            buffer.append(scanner.getRawTokenSource());
            ScannerTest.assertEquals("Unexpected contents", "\"\\u004Ca\\u000D\\u0022", String.valueOf(buffer));
            ScannerTest.assertEquals("Wrong exception", "Invalid_Char_In_String", e.getMessage());
        }
    }

    public void test045() {
        this.runConformTest(new String[]{"_X.java", "import java.lang.reflect.Field;\npublic class _X {\n\tpublic static void main(String[] args) {\n\t\tString i\\u0000;\n\t\tString i\\u0001;\n\t\tString i\\u0002;\n\t\tString i\\u0003;\n\t\tString i\\u0004;\n\t\tString i\\u0005;\n\t\tString i\\u0006;\n\t\tString i\\u0007;\n\t\tString i\\u0008;\n\t\tString i\\u000e;\n\t\tString i\\u000f;\n\t\tString i\\u0010;\n\t\tString i\\u0011;\n\t\tString i\\u0012;\n\t\tString i\\u0013;\n\t\tString i\\u0014;\n\t\tString i\\u0015;\n\t\tString i\\u0016;\n\t\tString i\\u0017;\n\t\tString i\\u0018;\n\t\tString i\\u0019;\n\t\tString i\\u001a;\n\t\tString i\\u001b;\n\t\tString i\\u007f;\n\t\tSystem.out.print(\"SUCCESS\");\n\t}\n}"}, "SUCCESS");
    }

    public void test046() {
        StringBuffer buf = new StringBuffer();
        buf.append("'Hello'");
        String str = buf.toString();
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(str.toCharArray());
        scanner.resetTo(0, str.length() - 1);
        int token = 0;
        try {
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)44, (int)token);
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)158, (int)token);
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void test047() {
        StringBuffer buf = new StringBuffer();
        buf.append("/=/g");
        String str = buf.toString();
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(str.toCharArray());
        scanner.resetTo(0, str.length() - 1);
        int token = 0;
        try {
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)46, (int)token);
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void test048() {
        StringBuffer buf = new StringBuffer();
        buf.append("// test unicode \\u000a var a =1; \n");
        String str = buf.toString();
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(str.toCharArray());
        scanner.resetTo(0, str.length() - 1);
        int token = 0;
        try {
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)1001, (int)token);
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)158, (int)token);
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void test049() {
        StringBuffer buf = new StringBuffer();
        buf.append("/* \n");
        buf.append("* test unicode \\u000a var a =1; \n ");
        buf.append("*/");
        String str = buf.toString();
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(str.toCharArray());
        scanner.resetTo(0, str.length() - 1);
        int token = 0;
        try {
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)1002, (int)token);
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)158, (int)token);
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void test050() {
        StringBuffer buf = new StringBuffer();
        buf.append("\"a\\>\"");
        String str = buf.toString();
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(str.toCharArray());
        scanner.resetTo(0, str.length() - 1);
        int token = 0;
        try {
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)45, (int)token);
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void test051() {
        StringBuffer buf = new StringBuffer();
        buf.append("\"abc\\u000adef\";");
        String str = buf.toString();
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(str.toCharArray());
        scanner.resetTo(0, str.length() - 1);
        int token = 0;
        try {
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)45, (int)token);
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)64, (int)token);
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void test052() {
        StringBuffer buf = new StringBuffer();
        buf.append("\"abc\\u0022def\";\n");
        String str = buf.toString();
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(str.toCharArray());
        scanner.resetTo(0, str.length() - 1);
        int token = 0;
        try {
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)45, (int)token);
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)64, (int)token);
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void test053() {
        StringBuffer buf = new StringBuffer();
        buf.append("'abc\\u0027def';\n");
        String str = buf.toString();
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(str.toCharArray());
        scanner.resetTo(0, str.length() - 1);
        int token = 0;
        try {
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)44, (int)token);
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)64, (int)token);
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void test054() {
        StringBuffer buf = new StringBuffer();
        buf.append("\"\\u0022def\";\n");
        String str = buf.toString();
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(str.toCharArray());
        scanner.resetTo(0, str.length() - 1);
        int token = 0;
        try {
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)45, (int)token);
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)64, (int)token);
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void test055() {
        StringBuffer buf = new StringBuffer();
        buf.append("\"abc\\x22def\";\n");
        String str = buf.toString();
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(str.toCharArray());
        scanner.resetTo(0, str.length() - 1);
        int token = 0;
        try {
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)45, (int)token);
            scanner.getCurrentTokenSource();
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)64, (int)token);
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
    }

    public void test056() {
        StringBuffer buf = new StringBuffer();
        buf.append("\"\\x22def\";\n");
        String str = buf.toString();
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(str.toCharArray());
        scanner.resetTo(0, str.length() - 1);
        int token = 0;
        try {
            token = scanner.getNextToken();
            scanner.getCurrentTokenSource();
            scanner.getCurrentTokenSource();
            ScannerTest.assertEquals((String)"Wrong token type", (int)45, (int)token);
            token = scanner.getNextToken();
            ScannerTest.assertEquals((String)"Wrong token type", (int)64, (int)token);
        }
        catch (InvalidInputException invalidInputException) {
            ScannerTest.assertTrue((boolean)false);
        }
    }
}

