/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.widgets;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jpt.common.ui.internal.widgets.ChooserPane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileChooserPane<T extends Model>
extends ChooserPane<T> {
    private ModifiablePropertyValueModel<String> textHolder;

    public FileChooserPane(Pane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    public FileChooserPane(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    @Override
    protected final Runnable buildBrowseAction() {
        return new Runnable(){

            public void run() {
                FileChooserPane.this.promptFile();
            }
        };
    }

    protected ViewerFilter buildFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return true;
            }
        };
    }

    @Override
    protected Control addMainControl(Composite container) {
        return this.addText(container, this.textHolder);
    }

    protected abstract ModifiablePropertyValueModel<String> buildTextHolder();

    protected ISelectionStatusValidator buildValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length != 1) {
                    return new Status(4, "org.eclipse.jpt.common.ui", "");
                }
                return new Status(0, "org.eclipse.jpt.common.ui", "");
            }
        };
    }

    protected abstract String getDialogTitle();

    protected abstract String getProjectPath();

    protected ModifiablePropertyValueModel<String> getTextHolder() {
        return this.textHolder;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.textHolder = this.buildTextHolder();
    }

    protected void promptFile() {
        String projectPath = this.getProjectPath();
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(this.getDialogTitle());
        dialog.setFilterPath(projectPath);
        String filePath = dialog.open();
        if (filePath != null) {
            this.textHolder.setValue((Object)filePath);
        }
    }
}

