/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility;

import java.io.Serializable;
import org.eclipse.jpt.common.utility.internal.StringTools;

public interface ExceptionHandler {
    public void handleException(Throwable var1);

    public static final class Null
    implements ExceptionHandler,
    Serializable {
        public static final ExceptionHandler INSTANCE = new Null();
        private static final long serialVersionUID = 1L;

        public static ExceptionHandler instance() {
            return INSTANCE;
        }

        private Null() {
        }

        public void handleException(Throwable t) {
        }

        public String toString() {
            return StringTools.buildSingletonToString(this);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    public static final class Runtime
    implements ExceptionHandler,
    Serializable {
        public static final ExceptionHandler INSTANCE = new Runtime();
        private static final long serialVersionUID = 1L;

        public static ExceptionHandler instance() {
            return INSTANCE;
        }

        private Runtime() {
        }

        public void handleException(Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }

        public String toString() {
            return StringTools.buildSingletonToString(this);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

