/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.command;

import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.command.CommandExecutor;
import org.eclipse.jpt.common.utility.command.StatefulCommandExecutor;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.SynchronizedBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStatefulCommandExecutor<E extends CommandExecutor>
implements StatefulCommandExecutor {
    protected final SynchronizedBoolean active = new SynchronizedBoolean(false);
    protected final E commandExecutor;

    protected AbstractStatefulCommandExecutor(E commandExecutor) {
        if (commandExecutor == null) {
            throw new NullPointerException();
        }
        this.commandExecutor = commandExecutor;
    }

    @Override
    public synchronized void start() {
        if (this.active.isTrue()) {
            throw new IllegalStateException("Not stopped.");
        }
        this.active.setTrue();
    }

    @Override
    public void execute(Command command) {
        if (this.active.isTrue()) {
            this.commandExecutor.execute(command);
        }
    }

    @Override
    public synchronized void stop() {
        if (this.active.isFalse()) {
            throw new IllegalStateException("Not started.");
        }
        this.active.setFalse();
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.commandExecutor);
    }
}

