/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import org.eclipse.jpt.common.utility.internal.Transformer;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyValueModelWrapper;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationPropertyValueModel<V1, V2>
extends PropertyValueModelWrapper<V1>
implements PropertyValueModel<V2> {
    protected volatile V2 value;
    protected final Transformer<V1, V2> transformer;

    public TransformationPropertyValueModel(PropertyValueModel<? extends V1> valueModel) {
        super(valueModel);
        this.transformer = this.buildTransformer();
    }

    public TransformationPropertyValueModel(PropertyValueModel<? extends V1> valueModel, Transformer<V1, V2> transformer) {
        super(valueModel);
        if (transformer == null) {
            throw new NullPointerException();
        }
        this.transformer = transformer;
    }

    protected Transformer<V1, V2> buildTransformer() {
        return new DefaultTransformer();
    }

    @Override
    public V2 getValue() {
        return this.value;
    }

    @Override
    protected void wrappedValueChanged(V1 oldValue, V1 newValue) {
        V2 old = this.value;
        this.value = this.transform(newValue);
        this.firePropertyChanged("value", old, this.value);
    }

    protected V2 transform(V1 v) {
        return this.transformer.transform(v);
    }

    protected V2 transform_(V1 v) {
        throw new RuntimeException("This method was not overridden.");
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.value);
    }

    @Override
    protected void engageModel() {
        super.engageModel();
        this.value = this.transform(this.valueModel.getValue());
    }

    @Override
    protected void disengageModel() {
        this.value = null;
        super.disengageModel();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DefaultTransformer
    implements Transformer<V1, V2> {
        protected DefaultTransformer() {
        }

        @Override
        public V2 transform(V1 v) {
            return v == null ? null : (Object)TransformationPropertyValueModel.this.transform_(v);
        }
    }
}

