/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.wizards.gen;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.jpa.eclipselink.core.JptJpaEclipseLinkCorePlugin;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.wizards.SelectEclipseLinkMappingFileDialog;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.wizards.gen.DynamicTableGenPanel;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.wizards.gen.JptJpaEclipseLinkUiEntityGenMessages;
import org.eclipse.jpt.jpa.ui.internal.JptUiMessages;
import org.eclipse.jpt.jpa.ui.internal.jface.XmlMappingFileViewerFilter;
import org.eclipse.jpt.jpa.ui.internal.wizards.entity.EntityWizardMsg;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.DefaultTableGenerationWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class DynamicDefaultTableGenerationWizardPage
extends DefaultTableGenerationWizardPage {
    private Label xmlMappingFileLabel;
    private Text xmlMappingFileText;
    private Button xmlMappingFileBrowseButton;

    public DynamicDefaultTableGenerationWizardPage(JpaProject jpaProject) {
        super(jpaProject);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.getHelpSystem().setHelp((Control)composite, "org.eclipse.jpt.jpa.ui.dialog_customizeDefaultEntityGeneration");
        this.createXmlMappingFileGroup(composite);
        this.createDomainJavaClassesPropertiesGroup(composite, 4);
        this.defaultTableGenPanel = new DynamicTableGenPanel(composite, 4, true, (WizardPage)this);
        this.setControl((Control)composite);
        this.setPageComplete(true);
    }

    protected void createDomainJavaClassesPropertiesGroup(Composite composite, int columns) {
        Group parent = new Group(composite, 0);
        parent.setText(JptJpaEclipseLinkUiEntityGenMessages.GenerateDynamicEntitiesWizard_defaultTablePage_domainJavaClass);
        parent.setLayout((Layout)new GridLayout(columns, false));
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = columns;
        layoutData.verticalAlignment = 4;
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = false;
        parent.setLayoutData((Object)layoutData);
        this.createPackageControls((Composite)parent, columns);
    }

    private void createXmlMappingFileGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        this.xmlMappingFileLabel = new Label(composite, 16384);
        this.xmlMappingFileLabel.setText(JptJpaEclipseLinkUiEntityGenMessages.GenerateDynamicEntitiesWizard_defaultTablePage_xmlMappingFile);
        this.xmlMappingFileLabel.setLayoutData((Object)new GridData(32));
        this.xmlMappingFileText = new Text(composite, 2052);
        this.xmlMappingFileText.setLayoutData((Object)new GridData(768));
        this.xmlMappingFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DynamicDefaultTableGenerationWizardPage.this.handleXmlMappingFileTextModified();
            }
        });
        this.xmlMappingFileBrowseButton = new Button(composite, 8);
        this.xmlMappingFileBrowseButton.setText(EntityWizardMsg.BROWSE_BUTTON_LABEL);
        GridData browseButtonData = new GridData(256);
        browseButtonData.horizontalSpan = 1;
        this.xmlMappingFileBrowseButton.setLayoutData((Object)browseButtonData);
        this.xmlMappingFileBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DynamicDefaultTableGenerationWizardPage.this.handleXmlMappingFileButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void handleXmlMappingFileTextModified() {
        this.getCustomizer().setXmlMappingFile(this.xmlMappingFileText.getText());
    }

    private void handleXmlMappingFileButtonPressed() {
        ViewerFilter filter = this.getDialogViewerFilter(this.jpaProject);
        WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        SelectEclipseLinkMappingFileDialog dialog = new SelectEclipseLinkMappingFileDialog(this.getShell(), this.jpaProject.getProject(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setTitle(JptUiMessages.SelectMappingFileDialog_title);
        dialog.setMessage(JptUiMessages.SelectMappingFileDialog_message);
        dialog.addFilter(filter);
        String ormFileName = this.xmlMappingFileText.getText();
        JpaXmlResource resource = this.jpaProject.getMappingFileXmlResource((IPath)new Path(ormFileName));
        IFile initialSelection = resource != null ? resource.getFile() : null;
        dialog.setInput(this.jpaProject.getProject());
        if (initialSelection != null) {
            dialog.setInitialSelection(initialSelection);
        }
        if (dialog.open() == 0) {
            String chosenName = dialog.getChosenName();
            this.xmlMappingFileText.setText(chosenName);
            this.getCustomizer().setXmlMappingFile(chosenName);
        }
    }

    protected ViewerFilter getDialogViewerFilter(JpaProject jpaProject) {
        return new XmlMappingFileViewerFilter(jpaProject, JptJpaEclipseLinkCorePlugin.ECLIPSELINK_ORM_XML_CONTENT_TYPE);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.xmlMappingFileText.setText(this.getCustomizer().getXmlMappingFile());
        }
    }

    protected JpaXmlResource getOrmXmlResource() {
        return this.jpaProject.getMappingFileXmlResource((IPath)new Path(this.xmlMappingFileText.getText()));
    }
}

