/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.commands;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.ui.internal.dialogs.AddPersistentAttributeToXmlAndMapDialog;
import org.eclipse.jpt.jpa.ui.selection.JpaSelectionManager;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddPersistentAttributeToXmlAndMapHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.execute_(event);
        return null;
    }

    private void execute_(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        ArrayList<OrmReadOnlyPersistentAttribute> newAttributes = new ArrayList<OrmReadOnlyPersistentAttribute>();
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        for (Object each : selection.toList()) {
            OrmReadOnlyPersistentAttribute attribute = (OrmReadOnlyPersistentAttribute)each;
            OrmReadOnlyPersistentAttribute newAttribute = this.addAndMap(attribute, window);
            if (newAttribute == null) continue;
            newAttributes.add(newAttribute);
        }
        if (newAttributes.size() == 1) {
            JpaSelectionManager selectionManager = (JpaSelectionManager)PlatformTools.getAdapter((Object)window, JpaSelectionManager.class);
            selectionManager.setSelection((JpaStructureNode)newAttributes.get(0));
        }
    }

    private OrmReadOnlyPersistentAttribute addAndMap(OrmReadOnlyPersistentAttribute attribute, IWorkbenchWindow window) {
        OrmPersistentType type = attribute.getOwningPersistentType();
        String attributeName = attribute.getName();
        AddPersistentAttributeToXmlAndMapDialog dialog = new AddPersistentAttributeToXmlAndMapDialog(window.getShell(), attribute);
        dialog.create();
        dialog.setBlockOnOpen(true);
        dialog.open();
        return type.getAttributeNamed(attributeName);
    }
}

