/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.impl.AbstractCreateFeature;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.propertypage.JPADiagramPropertyPage;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;

public class CreateMappedSuperclassFeature
extends AbstractCreateFeature {
    public CreateMappedSuperclassFeature(IFeatureProvider fp) {
        super(fp, JPAEditorMessages.CreateMappedSuperclassFeature_createMappedSuperclassFeatureName, JPAEditorMessages.CreateMappedSuperclassFeature_createMappedSuperclassFeatureDescription);
    }

    public boolean canCreate(ICreateContext context) {
        return context.getTargetContainer() instanceof Diagram;
    }

    public Object[] create(ICreateContext context) {
        EList shapes = this.getFeatureProvider().getDiagramTypeProvider().getDiagram().getChildren();
        IProject targetProject = null;
        JpaProject jpaProject = null;
        if (shapes == null || shapes.size() == 0) {
            jpaProject = this.getTargetJPAProject();
            targetProject = jpaProject.getProject();
        } else {
            Shape sh = (Shape)shapes.get(0);
            JavaPersistentType jpt = (JavaPersistentType)this.getFeatureProvider().getBusinessObjectForPictogramElement((PictogramElement)sh);
            if (jpt == null) {
                return new Object[0];
            }
            jpaProject = jpt.getJpaProject();
            targetProject = jpaProject.getProject();
        }
        String mappedSuperclassName = this.getFeatureProvider().getJPAEditorUtil().generateUniqueMappedSuperclassName(jpaProject, JPADiagramPropertyPage.getDefaultPackage(jpaProject.getProject()), this.getFeatureProvider());
        if (!JptJpaCorePlugin.getDiscoverAnnotatedClasses((IProject)jpaProject.getProject())) {
            JPAEditorUtil.createRegisterEntityInXMLJob(jpaProject, mappedSuperclassName);
        }
        try {
            this.getFeatureProvider().getJPAEditorUtil().createMappedSuperclassInProject(targetProject, mappedSuperclassName);
        }
        catch (Exception e1) {
            JPADiagramEditorPlugin.logError("Cannot create a mapped superclass in the project " + targetProject.getName(), e1);
        }
        PersistenceUnit pu = JpaArtifactFactory.instance().getPersistenceUnit(jpaProject);
        JavaPersistentType jpt = JpaArtifactFactory.instance().getJPT(mappedSuperclassName, pu);
        if (jpt != null) {
            this.addGraphicalRepresentation((IAreaContext)context, jpt);
            IWorkbenchPartSite ws = ((IEditorPart)this.getDiagramEditor()).getSite();
            ICompilationUnit cu = this.getFeatureProvider().getCompilationUnit(jpt);
            this.getFeatureProvider().getJPAEditorUtil().formatCode(cu, (IWorkbenchSite)ws);
            return new Object[]{jpt};
        }
        JPADiagramEditorPlugin.logError("The mapped superclass " + mappedSuperclassName + " could not be created", new Exception());
        return new Object[0];
    }

    public String getCreateImageId() {
        return "org.eclipse.jpt.jpadiagrameditor.ui.add_mapped_superclass";
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    private JpaProject getTargetJPAProject() {
        return this.getFeatureProvider().getMoinIntegrationUtil().getProjectByDiagram(this.getDiagram());
    }
}

