/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.relations;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.propertypage.JPADiagramPropertyPage;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IBidirectionalRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToOneRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;

public class ManyToOneBiDirRelation
extends ManyToOneRelation
implements IBidirectionalRelation {
    public ManyToOneBiDirRelation(IJPAEditorFeatureProvider fp, JavaPersistentType owner, JavaPersistentType inverse, String ownerAttributeName, String inverseAttributeName, boolean createAttribs, ICompilationUnit ownerCU, ICompilationUnit inverseCU) {
        super(owner, inverse);
        this.ownerAttributeName = ownerAttributeName;
        this.inverseAttributeName = inverseAttributeName;
        if (createAttribs) {
            this.createRelation(fp, ownerCU, inverseCU);
        }
    }

    @Override
    public JavaPersistentAttribute getOwnerAnnotatedAttribute() {
        return this.ownerAnnotatedAttribute;
    }

    @Override
    public void setOwnerAnnotatedAttribute(JavaPersistentAttribute ownerAnnotatedAttribute) {
        this.ownerAnnotatedAttribute = ownerAnnotatedAttribute;
    }

    @Override
    public JavaPersistentAttribute getInverseAnnotatedAttribute() {
        return this.inverseAnnotatedAttribute;
    }

    @Override
    public void setInverseAnnotatedAttribute(JavaPersistentAttribute inverseAnnotatedAttribute) {
        this.inverseAnnotatedAttribute = inverseAnnotatedAttribute;
    }

    private void createRelation(IJPAEditorFeatureProvider fp, ICompilationUnit ownerCU, ICompilationUnit inverseCU) {
        this.ownerAnnotatedAttribute = JPAEditorUtil.addAnnotatedAttribute(fp, this.owner, this.inverse, ownerCU, inverseCU, false, null);
        boolean isMap = JPADiagramPropertyPage.isMapType(this.owner.getJpaProject().getProject());
        String mapKeyType = this.getMapKeyType(isMap, this.owner);
        this.inverseAnnotatedAttribute = JPAEditorUtil.addAnnotatedAttribute(fp, this.inverse, this.owner, inverseCU, ownerCU, true, mapKeyType);
        JpaArtifactFactory.instance().addManyToOneBidirectionalRelation(fp, this.owner, this.ownerAnnotatedAttribute, this.inverse, this.inverseAnnotatedAttribute, isMap);
    }

    @Override
    public IRelation.RelDir getRelDir() {
        return IRelation.RelDir.BI;
    }

    private String getMapKeyType(boolean isMap, JavaPersistentType jpt) {
        return isMap ? JpaArtifactFactory.instance().getIdType(jpt) : null;
    }
}

