/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.parts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.SharedCursors;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.layout.CSSTextFigure;
import org.eclipse.jst.pagedesigner.css2.layout.ICSSFigure;
import org.eclipse.jst.pagedesigner.css2.provider.ICSSTextProvider;
import org.eclipse.jst.pagedesigner.css2.style.DefaultStyle;
import org.eclipse.jst.pagedesigner.editpolicies.LinkEditPolicy;
import org.eclipse.jst.pagedesigner.parts.SubNodeEditPart;
import org.eclipse.jst.pagedesigner.range.RangeUtil;
import org.eclipse.jst.pagedesigner.utils.HTMLUtil;
import org.eclipse.jst.pagedesigner.viewer.DesignRange;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TextEditPart
extends SubNodeEditPart
implements ICSSTextProvider {
    private String _cachedData;
    private Text _textNode;
    private Text _textNodeForFigure;

    public void setModel(Object model) {
        super.setModel(model);
        this._textNode = (Text)model;
        this._cachedData = this._textNode.getData();
        this._textNodeForFigure = this.getDestDocumentForDesign().createTextNode(this._cachedData);
    }

    protected IFigure createFigure() {
        return new CSSTextFigure(this);
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("link editpolicy", (EditPolicy)new LinkEditPolicy());
    }

    public Node getNodeForFigure() {
        return this._textNodeForFigure;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        this._cachedData = this._textNode.getData();
        this._textNodeForFigure.setData(this._cachedData);
        if (eventType == 1) {
            this.getFigure().revalidate();
        }
    }

    public ICSSStyle getCSSStyle() {
        ICSSStyle style;
        IFigure figure1 = this.getFigure();
        if (figure1 instanceof ICSSFigure && (style = ((ICSSFigure)figure1).getCSSStyle()) != null) {
            return style;
        }
        return DefaultStyle.getInstance();
    }

    public String getTextData() {
        ICSSStyle style = this.getCSSStyle();
        String data = this._cachedData;
        if (style.getStyleProperty("white-space") != "pre") {
            return HTMLUtil.compactWhitespaces(this._textNode, data);
        }
        return data;
    }

    public int[] getSelectedRange() {
        IHTMLGraphicalViewer viewer = (IHTMLGraphicalViewer)this.getViewer();
        if (viewer == null || !viewer.isInRangeMode()) {
            return null;
        }
        DesignRange range = viewer.getRangeSelection();
        if (range == null || !range.isValid()) {
            return null;
        }
        if (!RangeUtil.intersect(range, (EditPart)this)) {
            return null;
        }
        range = RangeUtil.normalize(range);
        EditPart startContainer = range.getStartPosition().getContainerPart();
        EditPart endContainer = range.getEndPosition().getContainerPart();
        int[] ret = new int[]{startContainer != this ? 0 : range.getStartPosition().getOffset(), endContainer != this ? this.getTextData().length() : range.getEndPosition().getOffset()};
        return ret;
    }

    public boolean isSelectable() {
        return true;
    }

    public Cursor getCursor(Point mouseLocation) {
        return SharedCursors.IBEAM;
    }
}

