/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import java.io.Serializable;
import java.math.BigDecimal;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.VersionComparator;

public class VersionComparatorTests
extends TestCase {
    public VersionComparatorTests(String name) {
        super(name);
    }

    public void testVersionIsEqual_integer() {
        VersionComparatorTests.assertTrue((VersionComparator.INTEGER_VERSION_COMPARATOR.compare("2.0.0", "2.0.0") == 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((VersionComparator.INTEGER_VERSION_COMPARATOR.compare("2.0.0", "2.0.0.0") == 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((VersionComparator.INTEGER_VERSION_COMPARATOR.compare("2.0.0.0.0.0.0000", "2.0") == 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((VersionComparator.INTEGER_VERSION_COMPARATOR.compare("2.0.-1", "2.0.-1") == 0 ? 1 : 0) != 0);
    }

    public void testVersionIsLess_integer() {
        VersionComparatorTests.assertTrue((VersionComparator.INTEGER_VERSION_COMPARATOR.compare("2.0.0", "2.0.1") < 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((VersionComparator.INTEGER_VERSION_COMPARATOR.compare("2.5.0", "2.14") < 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((VersionComparator.INTEGER_VERSION_COMPARATOR.compare("2.5.0", "2.5.0.0.1.0") < 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((VersionComparator.INTEGER_VERSION_COMPARATOR.compare("2.5.0.0.0.-1", "2.5") < 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((VersionComparator.INTEGER_VERSION_COMPARATOR.compare("2.0.-1", "2.0.0") < 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((VersionComparator.INTEGER_VERSION_COMPARATOR.compare("2.0.-1", "2") < 0 ? 1 : 0) != 0);
    }

    public void testVersionIsGreater_integer() {
        VersionComparatorTests.assertTrue((VersionComparator.INTEGER_VERSION_COMPARATOR.compare("2.0.2", "2.0.1") > 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((VersionComparator.INTEGER_VERSION_COMPARATOR.compare("2.0.2", "2.0.1") > 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((VersionComparator.INTEGER_VERSION_COMPARATOR.compare("2.5.0.0.1.0", "2.5.0") > 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((VersionComparator.INTEGER_VERSION_COMPARATOR.compare("2.5", "2.5.0.0.0.-1") > 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((VersionComparator.INTEGER_VERSION_COMPARATOR.compare("2.0.0", "2.0.-1") > 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((VersionComparator.INTEGER_VERSION_COMPARATOR.compare("2", "2.0.-1") > 0 ? 1 : 0) != 0);
    }

    public void testVersionIsEqual_integer_comma() {
        VersionComparator versionComparator = new VersionComparator(",", DecimalSegmentParser.instance());
        VersionComparatorTests.assertTrue((versionComparator.compare("2,0,0", "2,0,0") == 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare("2,0.0,0", "2,0,0") == 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare("2,0.0,0", "2,0,0.0") == 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare("2.0,0.0,0", "2,0,0.0") == 0 ? 1 : 0) != 0);
    }

    public void testVersionIsLess_integer_comma() {
        VersionComparator versionComparator = new VersionComparator(",", DecimalSegmentParser.instance());
        VersionComparatorTests.assertTrue((versionComparator.compare("2,0,0", "2,0,1") < 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare("2,0.0,0", "2,0,1") < 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare("2,0,0", "2,0,1.0") < 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare("2.0,0,0", "2,0,1") < 0 ? 1 : 0) != 0);
    }

    public void testVersionIsGreater_integer_comma() {
        VersionComparator versionComparator = new VersionComparator(",", DecimalSegmentParser.instance());
        VersionComparatorTests.assertTrue((versionComparator.compare("2,0,2", "2,0,1") > 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare("2,0,2.1", "2,0,1") > 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare("2,0,2", "2,0,1.9") > 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare("2.000,0,2", "2,0,1") > 0 ? 1 : 0) != 0);
    }

    public void testVersionIsEqual_subclass() {
        VersionComparator<Integer> versionComparator = new VersionComparator<Integer>(){

            protected Integer parseSegment(int index, String s) {
                return Integer.valueOf(s);
            }

            protected Integer getZero() {
                return 0;
            }
        };
        VersionComparatorTests.assertTrue((versionComparator.compare((Integer)((Object)"2.0.0"), (Integer)((Object)"2.0.0")) == 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare((Integer)((Object)"2.0.0"), (Integer)((Object)"2.0.0.0")) == 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare((Integer)((Object)"2.0.0.0"), (Integer)((Object)"2.0")) == 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare((Integer)((Object)"2.0.-1"), (Integer)((Object)"2.0.-1")) == 0 ? 1 : 0) != 0);
    }

    public void testVersionIsLess_subclass() {
        VersionComparator<Integer> versionComparator = new VersionComparator<Integer>(){

            protected Integer parseSegment(int index, String s) {
                return Integer.valueOf(s);
            }

            protected Integer getZero() {
                return 0;
            }
        };
        VersionComparatorTests.assertTrue((versionComparator.compare((Integer)((Object)"2.0.0"), (Integer)((Object)"2.0.1")) < 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare((Integer)((Object)"2.5.0"), (Integer)((Object)"2.14")) < 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare((Integer)((Object)"2.5.0"), (Integer)((Object)"2.5.0.0.1.0")) < 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare((Integer)((Object)"2.0.-1"), (Integer)((Object)"2.0.0")) < 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare((Integer)((Object)"2.0.-1"), (Integer)((Object)"2")) < 0 ? 1 : 0) != 0);
    }

    public void testVersionIsGreater_subclass() {
        VersionComparator<Integer> versionComparator = new VersionComparator<Integer>(){

            protected Integer parseSegment(int index, String s) {
                return Integer.valueOf(s);
            }

            protected Integer getZero() {
                return 0;
            }
        };
        VersionComparatorTests.assertTrue((versionComparator.compare((Integer)((Object)"2.0.2"), (Integer)((Object)"2.0.1")) > 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare((Integer)((Object)"2.0.2"), (Integer)((Object)"2.0.1")) > 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare((Integer)((Object)"2.5.0.0.1.0"), (Integer)((Object)"2.5.0")) > 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare((Integer)((Object)"2.0.0"), (Integer)((Object)"2.0.-1")) > 0 ? 1 : 0) != 0);
        VersionComparatorTests.assertTrue((versionComparator.compare((Integer)((Object)"2"), (Integer)((Object)"2.0.-1")) > 0 ? 1 : 0) != 0);
    }

    public void testBadString() {
        boolean exCaught = false;
        try {
            VersionComparatorTests.assertTrue((VersionComparator.INTEGER_VERSION_COMPARATOR.compare("2.0.0", "2.O.O") == 0 ? 1 : 0) != 0);
        }
        catch (NumberFormatException numberFormatException) {
            exCaught = true;
        }
        VersionComparatorTests.assertTrue((boolean)exCaught);
    }

    public void testBogusSubclass1() {
        VersionComparator<Integer> versionComparator = new VersionComparator<Integer>(){

            protected Integer getZero() {
                return 0;
            }
        };
        boolean exCaught = false;
        try {
            VersionComparatorTests.assertTrue((versionComparator.compare((Integer)((Object)"2.0.0"), (Integer)((Object)"2.0.0")) == 0 ? 1 : 0) != 0);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        VersionComparatorTests.assertTrue((boolean)exCaught);
    }

    public void testBogusSubclass2() {
        VersionComparator<Integer> versionComparator = new VersionComparator<Integer>(){

            protected Integer parseSegment(int index, String s) {
                return Integer.valueOf(s);
            }
        };
        boolean exCaught = false;
        try {
            VersionComparatorTests.assertTrue((versionComparator.compare((Integer)((Object)"2.0.0"), (Integer)((Object)"2.0.0.0.0")) == 0 ? 1 : 0) != 0);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        VersionComparatorTests.assertTrue((boolean)exCaught);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DecimalSegmentParser
    implements VersionComparator.SegmentParser<BigDecimal>,
    Serializable {
        public static final VersionComparator.SegmentParser<BigDecimal> INSTANCE = new DecimalSegmentParser();
        private static final BigDecimal ZERO = new BigDecimal(0);
        private static final long serialVersionUID = 1L;

        public static VersionComparator.SegmentParser<BigDecimal> instance() {
            return INSTANCE;
        }

        private DecimalSegmentParser() {
        }

        public BigDecimal parse(int segmentIndex, String segment) {
            return new BigDecimal(segment);
        }

        public BigDecimal getZero() {
            return ZERO;
        }

        public String toString() {
            return StringTools.buildSingletonToString((Object)this);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

