/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.EnumerationIterator;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.swing.TreeModelAdapter;
import org.eclipse.jpt.common.utility.internal.swing.Displayable;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.TreeNodeValueModel;
import org.eclipse.jpt.common.utility.tests.internal.model.value.swing.TreeModelAdapterTests;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeModelAdapterUITest {
    private JTree tree;
    private ModifiablePropertyValueModel<TreeNodeValueModel<Object>> rootNodeHolder;
    private boolean sorted;
    private TreeModel treeModel;
    private TreeSelectionModel treeSelectionModel;
    private TextField nameTextField;

    public static void main(String[] args) throws Exception {
        new TreeModelAdapterUITest().exec();
    }

    private TreeModelAdapterUITest() {
    }

    private void exec() throws Exception {
        this.rootNodeHolder = this.buildRootNodeHolder();
        this.sorted = this.rootNodeHolder.getValue() instanceof TreeModelAdapterTests.SortedTestNode;
        this.treeModel = this.buildTreeModel();
        this.treeSelectionModel = this.buildTreeSelectionModel();
        this.nameTextField = new TextField();
        this.openWindow();
    }

    private ModifiablePropertyValueModel<TreeNodeValueModel<Object>> buildRootNodeHolder() {
        return new SimplePropertyValueModel((Object)this.buildSortedRootNode());
    }

    private TreeModelAdapterTests.TestNode buildSortedRootNode() {
        return new TreeModelAdapterTests.SortedTestNode(this.buildRoot());
    }

    private TreeModelAdapterTests.TestNode buildUnsortedRootNode() {
        return new TreeModelAdapterTests.UnsortedTestNode(this.buildRoot());
    }

    private TreeModelAdapterTests.TestModel buildRoot() {
        TreeModelAdapterTests.TestModel root = new TreeModelAdapterTests.TestModel("root");
        TreeModelAdapterTests.TestModel node_1 = root.addChild("node 1");
        node_1.addChild("node 1.1");
        TreeModelAdapterTests.TestModel node_2 = root.addChild("node 2");
        node_2.addChild("node 2.1");
        TreeModelAdapterTests.TestModel node_2_2 = node_2.addChild("node 2.2");
        node_2_2.addChild("node 2.2.1");
        node_2_2.addChild("node 2.2.2");
        node_2.addChild("node 2.3");
        node_2.addChild("node 2.4");
        node_2.addChild("node 2.5");
        TreeModelAdapterTests.TestModel node_3 = root.addChild("node 3");
        TreeModelAdapterTests.TestModel node_3_1 = node_3.addChild("node 3.1");
        TreeModelAdapterTests.TestModel node_3_1_1 = node_3_1.addChild("node 3.1.1");
        node_3_1_1.addChild("node 3.1.1.1");
        root.addChild("node 4");
        return root;
    }

    private TreeModel buildTreeModel() {
        return new TreeModelAdapter(this.rootNodeHolder);
    }

    private TreeSelectionModel buildTreeSelectionModel() {
        DefaultTreeSelectionModel tsm = new DefaultTreeSelectionModel();
        tsm.addTreeSelectionListener(this.buildTreeSelectionListener());
        tsm.setSelectionMode(1);
        return tsm;
    }

    private TreeSelectionListener buildTreeSelectionListener() {
        return new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                TreeModelAdapterUITest.this.treeSelectionChanged(e);
            }
        };
    }

    void treeSelectionChanged(TreeSelectionEvent e) {
        TreeModelAdapterTests.TestModel selectedTestModel = this.selectedTestModel();
        if (selectedTestModel != null) {
            this.nameTextField.setText(selectedTestModel.getName());
        }
    }

    private void openWindow() {
        JFrame window = new JFrame(this.getClass().getName());
        window.setDefaultCloseOperation(0);
        window.addWindowListener(this.buildWindowListener());
        window.getContentPane().add(this.buildMainPanel(), "Center");
        window.setLocation(300, 300);
        window.setSize(400, 400);
        window.setVisible(true);
    }

    private WindowListener buildWindowListener() {
        return new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                e.getWindow().setVisible(false);
                System.exit(0);
            }
        };
    }

    private Component buildMainPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add(this.buildTreePane(), "Center");
        mainPanel.add(this.buildControlPanel(), "South");
        return mainPanel;
    }

    private Component buildTreePane() {
        return new JScrollPane(this.buildTree());
    }

    private JTree buildTree() {
        this.tree = new JTree(this.treeModel){

            public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                return ((Displayable)value).displayString();
            }
        };
        this.tree.setSelectionModel(this.treeSelectionModel);
        this.tree.setRootVisible(true);
        this.tree.setShowsRootHandles(true);
        this.tree.setRowHeight(20);
        this.tree.setDoubleBuffered(true);
        return this.tree;
    }

    private Component buildControlPanel() {
        JPanel controlPanel = new JPanel(new GridLayout(0, 1));
        controlPanel.add(this.buildAddRenameNodePanel());
        controlPanel.add(this.buildMiscPanel());
        return controlPanel;
    }

    private Component buildAddRenameNodePanel() {
        JPanel addRenameNodePanel = new JPanel(new BorderLayout());
        addRenameNodePanel.add((Component)this.buildAddButton(), "West");
        addRenameNodePanel.add((Component)this.nameTextField, "Center");
        addRenameNodePanel.add((Component)this.buildRenameButton(), "East");
        return addRenameNodePanel;
    }

    private Component buildMiscPanel() {
        JPanel miscPanel = new JPanel(new GridLayout(1, 0));
        miscPanel.add(this.buildClearChildrenButton());
        miscPanel.add(this.buildRemoveButton());
        miscPanel.add(this.buildResetButton());
        return miscPanel;
    }

    private String getName() {
        return this.nameTextField.getText();
    }

    private TreeModelAdapterTests.TestNode selectedNode() {
        if (this.treeSelectionModel.isSelectionEmpty()) {
            return null;
        }
        return (TreeModelAdapterTests.TestNode)this.treeSelectionModel.getSelectionPath().getLastPathComponent();
    }

    private TreeModelAdapterTests.TestModel selectedTestModel() {
        if (this.treeSelectionModel.isSelectionEmpty()) {
            return null;
        }
        return this.selectedNode().getValue();
    }

    private TreeModelAdapterTests.TestNode rootNode() {
        return (TreeModelAdapterTests.TestNode)this.treeModel.getRoot();
    }

    private TreeModelAdapterTests.TestModel root() {
        return this.rootNode().getValue();
    }

    private Collection<TreePath> expandedPaths() {
        Enumeration<TreePath> stream = this.tree.getExpandedDescendants(new TreePath(this.rootNode()));
        if (stream == null) {
            return Collections.emptyList();
        }
        return CollectionTools.list((Iterator)new EnumerationIterator(stream));
    }

    private void setSelectedNode(TreeModelAdapterTests.TestNode selectedNode) {
        this.treeSelectionModel.setSelectionPath(new TreePath(selectedNode.path()));
    }

    private void expandPaths(Collection<TreePath> paths) {
        for (TreePath path : paths) {
            this.tree.expandPath(path);
        }
    }

    private JButton buildAddButton() {
        return new JButton(this.buildAddAction());
    }

    private Action buildAddAction() {
        AbstractAction action = new AbstractAction("add"){

            public void actionPerformed(ActionEvent event) {
                TreeModelAdapterUITest.this.addNode();
            }
        };
        action.setEnabled(true);
        return action;
    }

    void addNode() {
        TreeModelAdapterTests.TestModel selectedTestModel = this.selectedTestModel();
        if (selectedTestModel != null) {
            String name = this.getName();
            Collection<TreePath> paths = this.expandedPaths();
            selectedTestModel.addChild(name);
            this.expandPaths(paths);
            this.setSelectedNode(this.selectedNode().childNamed(name));
        }
    }

    private JButton buildRemoveButton() {
        return new JButton(this.buildRemoveAction());
    }

    private Action buildRemoveAction() {
        AbstractAction action = new AbstractAction("remove"){

            public void actionPerformed(ActionEvent event) {
                TreeModelAdapterUITest.this.removeNode();
            }
        };
        action.setEnabled(true);
        return action;
    }

    void removeNode() {
        TreeModelAdapterTests.TestModel selectedTestModel = this.selectedTestModel();
        if (selectedTestModel != null && selectedTestModel != this.root()) {
            TreeModelAdapterTests.TestNode parentNode = (TreeModelAdapterTests.TestNode)this.selectedNode().parent();
            int childIndex = parentNode.indexOfChild((TreeNodeValueModel)this.selectedNode());
            selectedTestModel.getParent().removeChild(selectedTestModel);
            int childrenSize = parentNode.childrenSize();
            if (childIndex < childrenSize) {
                this.setSelectedNode((TreeModelAdapterTests.TestNode)parentNode.child(childIndex));
            } else if (childrenSize == 0) {
                this.setSelectedNode(parentNode);
            } else {
                this.setSelectedNode((TreeModelAdapterTests.TestNode)parentNode.child(childIndex - 1));
            }
        }
    }

    private JButton buildRenameButton() {
        return new JButton(this.buildRenameAction());
    }

    private Action buildRenameAction() {
        AbstractAction action = new AbstractAction("rename"){

            public void actionPerformed(ActionEvent event) {
                TreeModelAdapterUITest.this.renameNode();
            }
        };
        action.setEnabled(true);
        return action;
    }

    void renameNode() {
        TreeModelAdapterTests.TestModel selectedTestModel = this.selectedTestModel();
        if (selectedTestModel != null) {
            TreeModelAdapterTests.TestNode selectedNode = this.selectedNode();
            Collection<TreePath> paths = this.expandedPaths();
            selectedTestModel.setName(this.getName());
            this.expandPaths(paths);
            this.setSelectedNode(selectedNode);
        }
    }

    private JButton buildClearChildrenButton() {
        return new JButton(this.buildClearChildrenAction());
    }

    private Action buildClearChildrenAction() {
        AbstractAction action = new AbstractAction("clear children"){

            public void actionPerformed(ActionEvent event) {
                TreeModelAdapterUITest.this.clearChildren();
            }
        };
        action.setEnabled(true);
        return action;
    }

    void clearChildren() {
        TreeModelAdapterTests.TestModel selectedTestModel = this.selectedTestModel();
        if (selectedTestModel != null) {
            selectedTestModel.clearChildren();
        }
    }

    private JButton buildResetButton() {
        return new JButton(this.buildResetAction());
    }

    private Action buildResetAction() {
        AbstractAction action = new AbstractAction("reset"){

            public void actionPerformed(ActionEvent event) {
                TreeModelAdapterUITest.this.reset();
            }
        };
        action.setEnabled(true);
        return action;
    }

    void reset() {
        boolean bl = this.sorted = !this.sorted;
        if (this.sorted) {
            this.rootNodeHolder.setValue((Object)this.buildSortedRootNode());
        } else {
            this.rootNodeHolder.setValue((Object)this.buildUnsortedRootNode());
        }
        this.tree.expandPath(new TreePath(this.rootNode()));
    }
}

