/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.NamedQuery;
import org.eclipse.jpt.jpa.core.context.QueryHint;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.resource.java.NamedQueryAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.QueryHintAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class JavaQueryHintTests
extends ContextModelTestCase {
    private static final String QUERY_NAME = "QUERY_NAME";

    private ICompilationUnit createTestEntityWithNamedQuery() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.NamedQuery", "javax.persistence.QueryHint"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@NamedQuery(name=\"QUERY_NAME\", hints=@QueryHint())");
            }
        });
    }

    public JavaQueryHintTests(String name) {
        super(name);
    }

    public void testUpdateName() throws Exception {
        this.createTestEntityWithNamedQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        QueryHint queryHint = (QueryHint)((NamedQuery)entity.getQueryContainer().getNamedQueries().iterator().next()).getHints().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        NamedQueryAnnotation queryAnnotation = (NamedQueryAnnotation)resourceType.getAnnotation(0, "javax.persistence.NamedQuery");
        QueryHintAnnotation queryHintAnnotation = (QueryHintAnnotation)queryAnnotation.getHints().iterator().next();
        JavaQueryHintTests.assertNull((Object)queryHintAnnotation.getName());
        JavaQueryHintTests.assertNull((Object)queryHint.getName());
        queryHintAnnotation.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaQueryHintTests.assertEquals((String)"foo", (String)queryHintAnnotation.getName());
        JavaQueryHintTests.assertEquals((String)"foo", (String)queryHint.getName());
        queryHintAnnotation.setName(null);
        this.getJpaProject().synchronizeContextModel();
        JavaQueryHintTests.assertNull((Object)queryHint.getName());
    }

    public void testModifyName() throws Exception {
        this.createTestEntityWithNamedQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        QueryHint queryHint = (QueryHint)((NamedQuery)entity.getQueryContainer().getNamedQueries().iterator().next()).getHints().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        NamedQueryAnnotation queryAnnotation = (NamedQueryAnnotation)resourceType.getAnnotation(0, "javax.persistence.NamedQuery");
        QueryHintAnnotation queryHintAnnotation = (QueryHintAnnotation)queryAnnotation.getHints().iterator().next();
        JavaQueryHintTests.assertNull((Object)queryHintAnnotation.getName());
        JavaQueryHintTests.assertNull((Object)queryHint.getName());
        queryHint.setName("foo");
        JavaQueryHintTests.assertEquals((String)"foo", (String)queryHintAnnotation.getName());
        JavaQueryHintTests.assertEquals((String)"foo", (String)queryHint.getName());
        queryHint.setName(null);
        JavaQueryHintTests.assertNull((Object)queryHintAnnotation.getName());
        JavaQueryHintTests.assertNull((Object)queryHint.getName());
    }

    public void testUpdateValue() throws Exception {
        this.createTestEntityWithNamedQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        QueryHint queryHint = (QueryHint)((NamedQuery)entity.getQueryContainer().getNamedQueries().iterator().next()).getHints().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        NamedQueryAnnotation queryAnnotation = (NamedQueryAnnotation)resourceType.getAnnotation(0, "javax.persistence.NamedQuery");
        QueryHintAnnotation queryHintAnnotation = (QueryHintAnnotation)queryAnnotation.getHints().iterator().next();
        JavaQueryHintTests.assertNull((Object)queryHintAnnotation.getValue());
        JavaQueryHintTests.assertNull((Object)queryHint.getValue());
        queryHintAnnotation.setValue("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaQueryHintTests.assertEquals((String)"foo", (String)queryHintAnnotation.getValue());
        JavaQueryHintTests.assertEquals((String)"foo", (String)queryHint.getValue());
        queryHintAnnotation.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        JavaQueryHintTests.assertNull((Object)queryHint.getValue());
    }

    public void testModifyValue() throws Exception {
        this.createTestEntityWithNamedQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        QueryHint queryHint = (QueryHint)((NamedQuery)entity.getQueryContainer().getNamedQueries().iterator().next()).getHints().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        NamedQueryAnnotation queryAnnotation = (NamedQueryAnnotation)resourceType.getAnnotation(0, "javax.persistence.NamedQuery");
        QueryHintAnnotation queryHintAnnotation = (QueryHintAnnotation)queryAnnotation.getHints().iterator().next();
        JavaQueryHintTests.assertNull((Object)queryHintAnnotation.getValue());
        JavaQueryHintTests.assertNull((Object)queryHint.getValue());
        queryHint.setValue("foo");
        JavaQueryHintTests.assertEquals((String)"foo", (String)queryHintAnnotation.getValue());
        JavaQueryHintTests.assertEquals((String)"foo", (String)queryHint.getValue());
        queryHint.setValue(null);
        JavaQueryHintTests.assertNull((Object)queryHintAnnotation.getValue());
        JavaQueryHintTests.assertNull((Object)queryHint.getValue());
    }
}

