/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.TableGenerator;
import org.eclipse.jpt.jpa.core.context.UniqueConstraint;
import org.eclipse.jpt.jpa.core.context.java.JavaTableGenerator;
import org.eclipse.jpt.jpa.core.context.java.JavaUniqueConstraint;
import org.eclipse.jpt.jpa.core.context.orm.OrmEntity;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.resource.java.TableGeneratorAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class JavaTableGeneratorTests
extends ContextModelTestCase {
    private static final String TABLE_GENERATOR_NAME = "MY_TABLE_GENERATOR";

    private ICompilationUnit createTestEntityWithTableGenerator() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.TableGenerator", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
                sb.append("@TableGenerator(name=\"MY_TABLE_GENERATOR\")");
            }
        });
    }

    public JavaTableGeneratorTests(String name) {
        super(name);
    }

    public void testGetName() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertEquals((String)TABLE_GENERATOR_NAME, (String)idMapping.getGeneratorContainer().getTableGenerator().getName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.TableGenerator");
        tableGenerator.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaTableGeneratorTests.assertEquals((String)"foo", (String)idMapping.getGeneratorContainer().getTableGenerator().getName());
    }

    public void testSetName() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertEquals((String)TABLE_GENERATOR_NAME, (String)idMapping.getGeneratorContainer().getTableGenerator().getName());
        idMapping.getGeneratorContainer().getTableGenerator().setName("foo");
        JavaTableGeneratorTests.assertEquals((String)"foo", (String)idMapping.getGeneratorContainer().getTableGenerator().getName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertEquals((String)"foo", (String)tableGenerator.getName());
    }

    public void testGetCatalog() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getCatalog());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.TableGenerator");
        tableGenerator.setCatalog("myCatalog");
        this.getJpaProject().synchronizeContextModel();
        JavaTableGeneratorTests.assertEquals((String)"myCatalog", (String)idMapping.getGeneratorContainer().getTableGenerator().getCatalog());
        JavaTableGeneratorTests.assertEquals((String)"myCatalog", (String)idMapping.getGeneratorContainer().getTableGenerator().getSpecifiedCatalog());
    }

    public void testGetDefaultCatalog() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getDefaultCatalog());
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedCatalog("myCatalog");
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getDefaultCatalog());
        JavaTableGeneratorTests.assertEquals((String)"myCatalog", (String)idMapping.getGeneratorContainer().getTableGenerator().getSpecifiedCatalog());
    }

    public void testSetSpecifiedCatalog() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedCatalog("myCatalog");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        TableGeneratorAnnotation generatorAnnotation = (TableGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertEquals((String)"myCatalog", (String)generatorAnnotation.getCatalog());
    }

    public void testGetSchema() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getSchema());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.TableGenerator");
        tableGenerator.setSchema("mySchema");
        this.getJpaProject().synchronizeContextModel();
        JavaTableGeneratorTests.assertEquals((String)"mySchema", (String)idMapping.getGeneratorContainer().getTableGenerator().getSchema());
        JavaTableGeneratorTests.assertEquals((String)"mySchema", (String)idMapping.getGeneratorContainer().getTableGenerator().getSpecifiedSchema());
    }

    public void testGetDefaultSchema() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getDefaultSchema());
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedSchema("mySchema");
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getDefaultSchema());
        JavaTableGeneratorTests.assertEquals((String)"mySchema", (String)idMapping.getGeneratorContainer().getTableGenerator().getSpecifiedSchema());
    }

    public void testUpdateDefaultSchemaFromPersistenceUnitDefaults() throws Exception {
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName(JptJpaCorePlugin.DEFAULT_ORM_XML_RUNTIME_PATH.toString());
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.createTestEntityWithTableGenerator();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        IdMapping idMapping = (IdMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getDefaultSchema());
        this.getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSpecifiedSchema("FOO");
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)idMapping.getGeneratorContainer().getTableGenerator().getDefaultSchema());
        this.getEntityMappings().setSpecifiedSchema("BAR");
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)idMapping.getGeneratorContainer().getTableGenerator().getDefaultSchema());
        ormEntity.getTable().setSpecifiedSchema("XML_SCHEMA");
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)idMapping.getGeneratorContainer().getTableGenerator().getDefaultSchema());
        this.getEntityMappings().removePersistentType(0);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getGeneratorContainer().getTableGenerator().getDefaultSchema());
    }

    public void testSetSpecifiedSchema() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedSchema("mySchema");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        TableGeneratorAnnotation generatorAnnotation = (TableGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertEquals((String)"mySchema", (String)generatorAnnotation.getSchema());
    }

    public void testGetPkColumnName() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getPkColumnName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.TableGenerator");
        tableGenerator.setPkColumnName("myPkColumnName");
        this.getJpaProject().synchronizeContextModel();
        JavaTableGeneratorTests.assertEquals((String)"myPkColumnName", (String)idMapping.getGeneratorContainer().getTableGenerator().getPkColumnName());
        JavaTableGeneratorTests.assertEquals((String)"myPkColumnName", (String)idMapping.getGeneratorContainer().getTableGenerator().getSpecifiedPkColumnName());
    }

    public void testGetDefaultPkColumnName() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getDefaultPkColumnName());
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedPkColumnName("myPkColumnName");
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getDefaultPkColumnName());
        JavaTableGeneratorTests.assertEquals((String)"myPkColumnName", (String)idMapping.getGeneratorContainer().getTableGenerator().getSpecifiedPkColumnName());
    }

    public void testSetSpecifiedPkColumnName() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedPkColumnName("myPkColumnName");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        TableGeneratorAnnotation generatorAnnotation = (TableGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertEquals((String)"myPkColumnName", (String)generatorAnnotation.getPkColumnName());
    }

    public void testGetValueColumnName() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getValueColumnName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.TableGenerator");
        tableGenerator.setValueColumnName("myValueColumnName");
        this.getJpaProject().synchronizeContextModel();
        JavaTableGeneratorTests.assertEquals((String)"myValueColumnName", (String)idMapping.getGeneratorContainer().getTableGenerator().getValueColumnName());
        JavaTableGeneratorTests.assertEquals((String)"myValueColumnName", (String)idMapping.getGeneratorContainer().getTableGenerator().getSpecifiedValueColumnName());
    }

    public void testGetDefaultValueColumnName() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getDefaultValueColumnName());
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedValueColumnName("myValueColumnName");
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getDefaultValueColumnName());
        JavaTableGeneratorTests.assertEquals((String)"myValueColumnName", (String)idMapping.getGeneratorContainer().getTableGenerator().getSpecifiedValueColumnName());
    }

    public void testSetSpecifiedValueColumnName() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedValueColumnName("myValueColumnName");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        TableGeneratorAnnotation generatorAnnotation = (TableGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertEquals((String)"myValueColumnName", (String)generatorAnnotation.getValueColumnName());
    }

    public void testGetPkColumnValue() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getPkColumnValue());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.TableGenerator");
        tableGenerator.setPkColumnValue("myPkColumnValue");
        this.getJpaProject().synchronizeContextModel();
        JavaTableGeneratorTests.assertEquals((String)"myPkColumnValue", (String)idMapping.getGeneratorContainer().getTableGenerator().getPkColumnValue());
        JavaTableGeneratorTests.assertEquals((String)"myPkColumnValue", (String)idMapping.getGeneratorContainer().getTableGenerator().getSpecifiedPkColumnValue());
    }

    public void testGetDefaultPkColumnValue() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getDefaultPkColumnValue());
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedPkColumnValue("myPkColumnValue");
        JavaTableGeneratorTests.assertNull((Object)idMapping.getGeneratorContainer().getTableGenerator().getDefaultPkColumnValue());
        JavaTableGeneratorTests.assertEquals((String)"myPkColumnValue", (String)idMapping.getGeneratorContainer().getTableGenerator().getSpecifiedPkColumnValue());
    }

    public void testSetSpecifiedPkColumnValue() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedPkColumnValue("myPkColumnValue");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        TableGeneratorAnnotation generatorAnnotation = (TableGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertEquals((String)"myPkColumnValue", (String)generatorAnnotation.getPkColumnValue());
    }

    public void testGetInitialValue() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertEquals((int)0, (int)idMapping.getGeneratorContainer().getTableGenerator().getInitialValue());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.TableGenerator");
        tableGenerator.setInitialValue(Integer.valueOf(82));
        this.getJpaProject().synchronizeContextModel();
        JavaTableGeneratorTests.assertEquals((int)82, (int)idMapping.getGeneratorContainer().getTableGenerator().getInitialValue());
        JavaTableGeneratorTests.assertEquals((Object)82, (Object)idMapping.getGeneratorContainer().getTableGenerator().getSpecifiedInitialValue());
    }

    public void testGetDefaultInitialValue() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertEquals((int)0, (int)idMapping.getGeneratorContainer().getTableGenerator().getDefaultInitialValue());
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedInitialValue(Integer.valueOf(82));
        JavaTableGeneratorTests.assertEquals((int)0, (int)idMapping.getGeneratorContainer().getTableGenerator().getDefaultInitialValue());
        JavaTableGeneratorTests.assertEquals((Object)82, (Object)idMapping.getGeneratorContainer().getTableGenerator().getSpecifiedInitialValue());
    }

    public void testSetSpecifiedInitialValue() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedInitialValue(Integer.valueOf(20));
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        TableGeneratorAnnotation generatorAnnotation = (TableGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertEquals((Object)20, (Object)generatorAnnotation.getInitialValue());
    }

    public void testGetAllocationSize() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertEquals((int)50, (int)idMapping.getGeneratorContainer().getTableGenerator().getAllocationSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        TableGeneratorAnnotation tableGenerator = (TableGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.TableGenerator");
        tableGenerator.setAllocationSize(Integer.valueOf(20));
        this.getJpaProject().synchronizeContextModel();
        JavaTableGeneratorTests.assertEquals((int)20, (int)idMapping.getGeneratorContainer().getTableGenerator().getAllocationSize());
        JavaTableGeneratorTests.assertEquals((Object)20, (Object)idMapping.getGeneratorContainer().getTableGenerator().getSpecifiedAllocationSize());
    }

    public void testGetDefaultAllocationSize() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaTableGeneratorTests.assertEquals((int)50, (int)idMapping.getGeneratorContainer().getTableGenerator().getDefaultAllocationSize());
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedAllocationSize(Integer.valueOf(20));
        JavaTableGeneratorTests.assertEquals((int)50, (int)idMapping.getGeneratorContainer().getTableGenerator().getDefaultAllocationSize());
        JavaTableGeneratorTests.assertEquals((Object)20, (Object)idMapping.getGeneratorContainer().getTableGenerator().getSpecifiedAllocationSize());
    }

    public void testSetSpecifiedAllocationSize() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getGeneratorContainer().getTableGenerator().setSpecifiedAllocationSize(Integer.valueOf(25));
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        TableGeneratorAnnotation generatorAnnotation = (TableGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertEquals((Object)25, (Object)generatorAnnotation.getAllocationSize());
    }

    public void testUniqueConstraints() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaTableGenerator tableGenerator = (JavaTableGenerator)((IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getGeneratorContainer().getTableGenerator();
        Iterator uniqueConstraints = tableGenerator.getUniqueConstraints().iterator();
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        TableGeneratorAnnotation tableGeneratorAnnotation = (TableGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.TableGenerator");
        tableGeneratorAnnotation.addUniqueConstraint(0).addColumnName(0, "foo");
        tableGeneratorAnnotation.addUniqueConstraint(0).addColumnName(0, "bar");
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = tableGenerator.getUniqueConstraints().iterator();
        JavaTableGeneratorTests.assertTrue((boolean)uniqueConstraints.hasNext());
        JavaTableGeneratorTests.assertEquals((String)"bar", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaTableGeneratorTests.assertEquals((String)"foo", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testUniqueConstraintsSize() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        TableGenerator tableGenerator = ((IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getGeneratorContainer().getTableGenerator();
        JavaTableGeneratorTests.assertEquals((int)0, (int)tableGenerator.getUniqueConstraintsSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        TableGeneratorAnnotation tableGeneratorAnnotation = (TableGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.TableGenerator");
        tableGeneratorAnnotation.addUniqueConstraint(0).addColumnName(0, "foo");
        tableGeneratorAnnotation.addUniqueConstraint(1).addColumnName(0, "bar");
        this.getJpaProject().synchronizeContextModel();
        JavaTableGeneratorTests.assertEquals((int)2, (int)tableGenerator.getUniqueConstraintsSize());
    }

    public void testAddUniqueConstraint() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        TableGenerator tableGenerator = ((IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getGeneratorContainer().getTableGenerator();
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "FOO");
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "BAR");
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        TableGeneratorAnnotation tableGeneratorAnnotation = (TableGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.TableGenerator");
        ListIterator uniqueConstraints = tableGeneratorAnnotation.getUniqueConstraints().iterator();
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNameAt(0));
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNameAt(0));
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNameAt(0));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testAddUniqueConstraint2() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        TableGenerator tableGenerator = ((IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getGeneratorContainer().getTableGenerator();
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "FOO");
        tableGenerator.addUniqueConstraint(1).addColumnName(0, "BAR");
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        TableGeneratorAnnotation tableGeneratorAnnotation = (TableGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.TableGenerator");
        ListIterator uniqueConstraints = tableGeneratorAnnotation.getUniqueConstraints().iterator();
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNameAt(0));
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNameAt(0));
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNameAt(0));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testRemoveUniqueConstraint() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        TableGenerator tableGenerator = ((IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getGeneratorContainer().getTableGenerator();
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "FOO");
        tableGenerator.addUniqueConstraint(1).addColumnName(0, "BAR");
        tableGenerator.addUniqueConstraint(2).addColumnName(0, "BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        TableGeneratorAnnotation tableGeneratorAnnotation = (TableGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertEquals((int)3, (int)tableGeneratorAnnotation.getUniqueConstraintsSize());
        tableGenerator.removeUniqueConstraint(1);
        ListIterator uniqueConstraintAnnotations = tableGeneratorAnnotation.getUniqueConstraints().iterator();
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        Iterator uniqueConstraints = tableGenerator.getUniqueConstraints().iterator();
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGenerator.removeUniqueConstraint(1);
        uniqueConstraintAnnotations = tableGeneratorAnnotation.getUniqueConstraints().iterator();
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        uniqueConstraints = tableGenerator.getUniqueConstraints().iterator();
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGenerator.removeUniqueConstraint(0);
        uniqueConstraintAnnotations = tableGeneratorAnnotation.getUniqueConstraints().iterator();
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        uniqueConstraints = tableGenerator.getUniqueConstraints().iterator();
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testMoveUniqueConstraint() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        TableGenerator tableGenerator = ((IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getGeneratorContainer().getTableGenerator();
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "FOO");
        tableGenerator.addUniqueConstraint(1).addColumnName(0, "BAR");
        tableGenerator.addUniqueConstraint(2).addColumnName(0, "BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        TableGeneratorAnnotation tableGeneratorAnnotation = (TableGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.TableGenerator");
        JavaTableGeneratorTests.assertEquals((int)3, (int)tableGeneratorAnnotation.getUniqueConstraintsSize());
        tableGenerator.moveUniqueConstraint(2, 0);
        Iterator uniqueConstraints = tableGenerator.getUniqueConstraints().iterator();
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        ListIterator uniqueConstraintAnnotations = tableGeneratorAnnotation.getUniqueConstraints().iterator();
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        tableGenerator.moveUniqueConstraint(0, 1);
        uniqueConstraints = tableGenerator.getUniqueConstraints().iterator();
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        uniqueConstraintAnnotations = tableGeneratorAnnotation.getUniqueConstraints().iterator();
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
    }

    public void testUpdateUniqueConstraints() throws Exception {
        this.createTestEntityWithTableGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        TableGenerator tableGenerator = ((IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getGeneratorContainer().getTableGenerator();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        TableGeneratorAnnotation tableGeneratorAnnotation = (TableGeneratorAnnotation)resourceField.getAnnotation("javax.persistence.TableGenerator");
        tableGeneratorAnnotation.addUniqueConstraint(0).addColumnName("FOO");
        tableGeneratorAnnotation.addUniqueConstraint(1).addColumnName("BAR");
        tableGeneratorAnnotation.addUniqueConstraint(2).addColumnName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        Iterator uniqueConstraints = tableGenerator.getUniqueConstraints().iterator();
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGeneratorAnnotation.moveUniqueConstraint(2, 0);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = tableGenerator.getUniqueConstraints().iterator();
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGeneratorAnnotation.moveUniqueConstraint(0, 1);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = tableGenerator.getUniqueConstraints().iterator();
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGeneratorAnnotation.removeUniqueConstraint(1);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = tableGenerator.getUniqueConstraints().iterator();
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGeneratorAnnotation.removeUniqueConstraint(1);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = tableGenerator.getUniqueConstraints().iterator();
        JavaTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGeneratorAnnotation.removeUniqueConstraint(0);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = tableGenerator.getUniqueConstraints().iterator();
        JavaTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }
}

