/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.BaseTemporalConverter;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.TemporalType;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.TemporalAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class JavaVersionMappingTests
extends ContextModelTestCase {
    private ICompilationUnit createTestEntityWithVersionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Version"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Version").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithTemporal() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Version", "javax.persistence.Temporal", "javax.persistence.TemporalType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Version").append(CR);
                sb.append("@Temporal(TemporalType.TIMESTAMP)").append(CR);
            }
        });
    }

    public JavaVersionMappingTests(String name) {
        super(name);
    }

    public void testMorphToBasicMapping() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)versionMapping.getConverter()).setTemporalType(TemporalType.TIME);
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setMappingKey("basic");
        JavaVersionMappingTests.assertEquals((String)"FOO", (String)((BasicMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        JavaVersionMappingTests.assertEquals((Object)TemporalType.TIME, (Object)((BaseTemporalConverter)((BasicMapping)persistentAttribute.getMapping()).getConverter()).getTemporalType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaVersionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        JavaVersionMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Basic"));
        JavaVersionMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        JavaVersionMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
    }

    public void testMorphToDefault() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)versionMapping.getConverter()).setTemporalType(TemporalType.TIME);
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaVersionMappingTests.assertEquals((String)"FOO", (String)((BasicMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        JavaVersionMappingTests.assertEquals((Object)TemporalType.TIME, (Object)((BaseTemporalConverter)((BasicMapping)persistentAttribute.getMapping()).getConverter()).getTemporalType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaVersionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        JavaVersionMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        JavaVersionMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
    }

    public void testMorphToIdMapping() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)versionMapping.getConverter()).setTemporalType(TemporalType.TIME);
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setMappingKey("id");
        JavaVersionMappingTests.assertEquals((String)"FOO", (String)((IdMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        JavaVersionMappingTests.assertEquals((Object)TemporalType.TIME, (Object)((BaseTemporalConverter)((IdMapping)persistentAttribute.getMapping()).getConverter()).getTemporalType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaVersionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        JavaVersionMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        JavaVersionMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        JavaVersionMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
    }

    public void testMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)versionMapping.getConverter()).setTemporalType(TemporalType.TIME);
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setMappingKey("embedded");
        JavaVersionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaVersionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        JavaVersionMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        JavaVersionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        JavaVersionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
    }

    public void testMorphToTransientMapping() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)versionMapping.getConverter()).setTemporalType(TemporalType.TIME);
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setMappingKey("transient");
        JavaVersionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaVersionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        JavaVersionMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Transient"));
        JavaVersionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        JavaVersionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
    }

    public void testMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)versionMapping.getConverter()).setTemporalType(TemporalType.TIME);
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setMappingKey("embeddedId");
        JavaVersionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaVersionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        JavaVersionMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.EmbeddedId"));
        JavaVersionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        JavaVersionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
    }

    public void testMorphToOneToOneMapping() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)versionMapping.getConverter()).setTemporalType(TemporalType.TIME);
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setMappingKey("oneToOne");
        JavaVersionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToOneMapping));
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaVersionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        JavaVersionMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        JavaVersionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        JavaVersionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
    }

    public void testMorphToOneToManyMapping() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)versionMapping.getConverter()).setTemporalType(TemporalType.TIME);
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setMappingKey("oneToMany");
        JavaVersionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaVersionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        JavaVersionMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToMany"));
        JavaVersionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        JavaVersionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
    }

    public void testMorphToManyToOneMapping() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)versionMapping.getConverter()).setTemporalType(TemporalType.TIME);
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setMappingKey("manyToOne");
        JavaVersionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaVersionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        JavaVersionMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ManyToOne"));
        JavaVersionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        JavaVersionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
    }

    public void testMorphToManyToManyMapping() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)versionMapping.getConverter()).setTemporalType(TemporalType.TIME);
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setMappingKey("manyToMany");
        JavaVersionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToManyMapping));
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaVersionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        JavaVersionMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ManyToMany"));
        JavaVersionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        JavaVersionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
    }

    public void testGetTemporal() throws Exception {
        this.createTestEntityWithTemporal();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaVersionMappingTests.assertEquals((Object)TemporalType.TIMESTAMP, (Object)((BaseTemporalConverter)versionMapping.getConverter()).getTemporalType());
    }

    public void testSetTemporal() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaVersionMappingTests.assertNull((Object)versionMapping.getConverter().getType());
        versionMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)versionMapping.getConverter()).setTemporalType(TemporalType.TIME);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        TemporalAnnotation temporal = (TemporalAnnotation)resourceField.getAnnotation("javax.persistence.Temporal");
        JavaVersionMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.TemporalType.TIME, (Object)temporal.getValue());
        versionMapping.setConverter(null);
        JavaVersionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
    }

    public void testGetTemporalUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaVersionMappingTests.assertNull((Object)versionMapping.getConverter().getType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        TemporalAnnotation temporal = (TemporalAnnotation)resourceField.addAnnotation("javax.persistence.Temporal");
        temporal.setValue(org.eclipse.jpt.jpa.core.resource.java.TemporalType.DATE);
        this.getJpaProject().synchronizeContextModel();
        JavaVersionMappingTests.assertEquals((Object)TemporalType.DATE, (Object)((BaseTemporalConverter)versionMapping.getConverter()).getTemporalType());
        resourceField.removeAnnotation("javax.persistence.Temporal");
        this.getJpaProject().synchronizeContextModel();
        JavaVersionMappingTests.assertNull((Object)versionMapping.getConverter().getType());
        JavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        JavaVersionMappingTests.assertSame((Object)versionMapping, (Object)persistentAttribute.getMapping());
    }

    public void testGetColumn() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaVersionMappingTests.assertNull((Object)versionMapping.getColumn().getSpecifiedName());
        JavaVersionMappingTests.assertEquals((String)"id", (String)versionMapping.getColumn().getName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ColumnAnnotation column = (ColumnAnnotation)resourceField.addAnnotation("javax.persistence.Column");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaVersionMappingTests.assertEquals((String)"foo", (String)versionMapping.getColumn().getSpecifiedName());
        JavaVersionMappingTests.assertEquals((String)"foo", (String)versionMapping.getColumn().getName());
        JavaVersionMappingTests.assertEquals((String)"id", (String)versionMapping.getColumn().getDefaultName());
    }
}

