/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.orm;

import java.util.ListIterator;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.SequenceGenerator;
import org.eclipse.jpt.jpa.core.context.TableGenerator;
import org.eclipse.jpt.jpa.core.context.orm.OrmNamedNativeQuery;
import org.eclipse.jpt.jpa.core.context.orm.OrmNamedQuery;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmSequenceGenerator;
import org.eclipse.jpt.jpa.core.context.orm.OrmTableGenerator;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEmbeddable;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlMappedSuperclass;
import org.eclipse.jpt.jpa.core.resource.orm.XmlNamedNativeQuery;
import org.eclipse.jpt.jpa.core.resource.orm.XmlNamedQuery;
import org.eclipse.jpt.jpa.core.resource.orm.XmlPersistenceUnitDefaults;
import org.eclipse.jpt.jpa.core.resource.orm.XmlSequenceGenerator;
import org.eclipse.jpt.jpa.core.resource.orm.XmlTableGenerator;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class EntityMappingsTests
extends ContextModelTestCase {
    public EntityMappingsTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName(JptJpaCorePlugin.DEFAULT_ORM_XML_RUNTIME_PATH.toString());
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    public void testGetVersion() throws Exception {
        EntityMappingsTests.assertEquals((String)"1.0", (String)this.getEntityMappings().getVersion());
    }

    public void testUpdateDescription() throws Exception {
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getDescription());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getDescription());
        this.getXmlEntityMappings().setDescription("newDescription");
        EntityMappingsTests.assertEquals((String)"newDescription", (String)this.getEntityMappings().getDescription());
        EntityMappingsTests.assertEquals((String)"newDescription", (String)this.getXmlEntityMappings().getDescription());
        this.getXmlEntityMappings().setDescription(null);
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getDescription());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getDescription());
    }

    public void testModifyDescription() throws Exception {
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getDescription());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getDescription());
        this.getEntityMappings().setDescription("newDescription");
        EntityMappingsTests.assertEquals((String)"newDescription", (String)this.getEntityMappings().getDescription());
        EntityMappingsTests.assertEquals((String)"newDescription", (String)this.getXmlEntityMappings().getDescription());
        this.getEntityMappings().setDescription(null);
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getDescription());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getDescription());
    }

    public void testUpdatePackage() throws Exception {
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getPackage());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getPackage());
        this.getXmlEntityMappings().setPackage("foo.model");
        EntityMappingsTests.assertEquals((String)"foo.model", (String)this.getEntityMappings().getPackage());
        EntityMappingsTests.assertEquals((String)"foo.model", (String)this.getXmlEntityMappings().getPackage());
        this.getXmlEntityMappings().setPackage(null);
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getPackage());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getPackage());
    }

    public void testModifyPackage() throws Exception {
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getPackage());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getPackage());
        this.getEntityMappings().setPackage("foo.model");
        EntityMappingsTests.assertEquals((String)"foo.model", (String)this.getEntityMappings().getPackage());
        EntityMappingsTests.assertEquals((String)"foo.model", (String)this.getXmlEntityMappings().getPackage());
        this.getEntityMappings().setPackage(null);
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getPackage());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getPackage());
    }

    public void testUpdateSpecifiedSchema() throws Exception {
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedSchema());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getSchema());
        this.getXmlEntityMappings().setSchema("MY_SCHEMA");
        EntityMappingsTests.assertEquals((String)"MY_SCHEMA", (String)this.getEntityMappings().getSpecifiedSchema());
        EntityMappingsTests.assertEquals((String)"MY_SCHEMA", (String)this.getXmlEntityMappings().getSchema());
        this.getXmlEntityMappings().setSchema(null);
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedSchema());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getSchema());
    }

    public void testModifySpecifiedSchema() throws Exception {
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedSchema());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getSchema());
        this.getEntityMappings().setSpecifiedSchema("MY_SCHEMA");
        EntityMappingsTests.assertEquals((String)"MY_SCHEMA", (String)this.getEntityMappings().getSpecifiedSchema());
        EntityMappingsTests.assertEquals((String)"MY_SCHEMA", (String)this.getXmlEntityMappings().getSchema());
        this.getEntityMappings().setSpecifiedSchema(null);
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedSchema());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getSchema());
    }

    public void testUpdateSpecifiedCatalog() throws Exception {
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedCatalog());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getCatalog());
        this.getXmlEntityMappings().setCatalog("MY_CATALOG");
        EntityMappingsTests.assertEquals((String)"MY_CATALOG", (String)this.getEntityMappings().getSpecifiedCatalog());
        EntityMappingsTests.assertEquals((String)"MY_CATALOG", (String)this.getXmlEntityMappings().getCatalog());
        this.getXmlEntityMappings().setCatalog(null);
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedCatalog());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getCatalog());
    }

    public void testUpdateDefaultSchema() throws Exception {
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getDefaultSchema());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedSchema());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getSchema());
        this.getXmlEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        XmlPersistenceUnitDefaults persistenceUnitDefaults = OrmFactory.eINSTANCE.createXmlPersistenceUnitDefaults();
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setPersistenceUnitDefaults(persistenceUnitDefaults);
        persistenceUnitDefaults.setSchema("MY_SCHEMA");
        EntityMappingsTests.assertEquals((String)"MY_SCHEMA", (String)this.getEntityMappings().getDefaultSchema());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedSchema());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getSchema());
        EntityMappingsTests.assertEquals((String)"MY_SCHEMA", (String)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getSchema());
        persistenceUnitDefaults.setSchema(null);
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getDefaultSchema());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedSchema());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getSchema());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getSchema());
    }

    public void testUpdateSchema() throws Exception {
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getDefaultSchema());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSchema());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedSchema());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getSchema());
        this.getXmlEntityMappings().setSchema("MY_SCHEMA");
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getDefaultSchema());
        EntityMappingsTests.assertEquals((String)"MY_SCHEMA", (String)this.getEntityMappings().getSchema());
        EntityMappingsTests.assertEquals((String)"MY_SCHEMA", (String)this.getEntityMappings().getSpecifiedSchema());
        EntityMappingsTests.assertEquals((String)"MY_SCHEMA", (String)this.getXmlEntityMappings().getSchema());
        this.getXmlEntityMappings().setSchema(null);
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getDefaultSchema());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSchema());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedSchema());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getSchema());
        this.getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSpecifiedSchema("DEFAULT_SCHEMA");
        EntityMappingsTests.assertEquals((String)"DEFAULT_SCHEMA", (String)this.getEntityMappings().getDefaultSchema());
        EntityMappingsTests.assertEquals((String)"DEFAULT_SCHEMA", (String)this.getEntityMappings().getSchema());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedSchema());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getSchema());
        this.getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSpecifiedSchema(null);
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getDefaultSchema());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSchema());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedSchema());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getSchema());
    }

    public void testModifySpecifiedCatalog() throws Exception {
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedCatalog());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getCatalog());
        this.getEntityMappings().setSpecifiedCatalog("MY_CATALOG");
        EntityMappingsTests.assertEquals((String)"MY_CATALOG", (String)this.getEntityMappings().getSpecifiedCatalog());
        EntityMappingsTests.assertEquals((String)"MY_CATALOG", (String)this.getXmlEntityMappings().getCatalog());
        this.getEntityMappings().setSpecifiedCatalog(null);
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedCatalog());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getCatalog());
    }

    public void testUpdateDefaultCatalog() throws Exception {
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getDefaultCatalog());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedCatalog());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getCatalog());
        this.getXmlEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        XmlPersistenceUnitDefaults persistenceUnitDefaults = OrmFactory.eINSTANCE.createXmlPersistenceUnitDefaults();
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setPersistenceUnitDefaults(persistenceUnitDefaults);
        persistenceUnitDefaults.setCatalog("MY_CATALOG");
        EntityMappingsTests.assertEquals((String)"MY_CATALOG", (String)this.getEntityMappings().getDefaultCatalog());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedCatalog());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getCatalog());
        EntityMappingsTests.assertEquals((String)"MY_CATALOG", (String)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getCatalog());
        persistenceUnitDefaults.setCatalog(null);
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getDefaultCatalog());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedCatalog());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getCatalog());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getCatalog());
    }

    public void testUpdateCatalog() throws Exception {
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getDefaultCatalog());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getCatalog());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedCatalog());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getCatalog());
        this.getXmlEntityMappings().setCatalog("MY_CATALOG");
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getDefaultCatalog());
        EntityMappingsTests.assertEquals((String)"MY_CATALOG", (String)this.getEntityMappings().getCatalog());
        EntityMappingsTests.assertEquals((String)"MY_CATALOG", (String)this.getEntityMappings().getSpecifiedCatalog());
        EntityMappingsTests.assertEquals((String)"MY_CATALOG", (String)this.getXmlEntityMappings().getCatalog());
        this.getXmlEntityMappings().setCatalog(null);
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getDefaultCatalog());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getCatalog());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedCatalog());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getCatalog());
        this.getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSpecifiedCatalog("DEFAULT_CATALOG");
        EntityMappingsTests.assertEquals((String)"DEFAULT_CATALOG", (String)this.getEntityMappings().getDefaultCatalog());
        EntityMappingsTests.assertEquals((String)"DEFAULT_CATALOG", (String)this.getEntityMappings().getCatalog());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedCatalog());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getCatalog());
        this.getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSpecifiedCatalog(null);
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getDefaultCatalog());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getCatalog());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedCatalog());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getCatalog());
    }

    public void testUpdateSpecifiedAccess() throws Exception {
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedAccess());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getAccess());
        this.getXmlEntityMappings().setAccess("PROPERTY");
        EntityMappingsTests.assertEquals((Object)AccessType.PROPERTY, (Object)this.getEntityMappings().getSpecifiedAccess());
        EntityMappingsTests.assertEquals((String)"PROPERTY", (String)this.getXmlEntityMappings().getAccess());
        this.getXmlEntityMappings().setAccess(null);
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedAccess());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getAccess());
    }

    public void testModifySpecifiedAccess() throws Exception {
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedAccess());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getAccess());
        this.getEntityMappings().setSpecifiedAccess(AccessType.PROPERTY);
        EntityMappingsTests.assertEquals((Object)AccessType.PROPERTY, (Object)this.getEntityMappings().getSpecifiedAccess());
        EntityMappingsTests.assertEquals((String)"PROPERTY", (String)this.getXmlEntityMappings().getAccess());
        this.getEntityMappings().setSpecifiedAccess(null);
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedAccess());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getAccess());
    }

    public void testUpdateDefaultAccess() throws Exception {
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getDefaultAccess());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedAccess());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getAccess());
        this.getXmlEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        XmlPersistenceUnitDefaults persistenceUnitDefaults = OrmFactory.eINSTANCE.createXmlPersistenceUnitDefaults();
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setPersistenceUnitDefaults(persistenceUnitDefaults);
        persistenceUnitDefaults.setAccess("PROPERTY");
        EntityMappingsTests.assertEquals((Object)AccessType.PROPERTY, (Object)this.getEntityMappings().getDefaultAccess());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedAccess());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getAccess());
        persistenceUnitDefaults.setAccess("FIELD");
        EntityMappingsTests.assertEquals((Object)AccessType.FIELD, (Object)this.getEntityMappings().getDefaultAccess());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedAccess());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getAccess());
        persistenceUnitDefaults.setAccess(null);
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getDefaultAccess());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedAccess());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getAccess());
    }

    public void testUpdateAccess() throws Exception {
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getAccess());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getDefaultAccess());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedAccess());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getAccess());
        this.getXmlEntityMappings().setAccess("FIELD");
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getDefaultAccess());
        EntityMappingsTests.assertEquals((Object)AccessType.FIELD, (Object)this.getEntityMappings().getAccess());
        EntityMappingsTests.assertEquals((Object)AccessType.FIELD, (Object)this.getEntityMappings().getSpecifiedAccess());
        EntityMappingsTests.assertEquals((String)"FIELD", (String)this.getXmlEntityMappings().getAccess());
        this.getXmlEntityMappings().setAccess(null);
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getAccess());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getDefaultAccess());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedAccess());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getAccess());
        this.getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSpecifiedAccess(AccessType.FIELD);
        EntityMappingsTests.assertEquals((Object)AccessType.FIELD, (Object)this.getEntityMappings().getDefaultAccess());
        EntityMappingsTests.assertEquals((Object)AccessType.FIELD, (Object)this.getEntityMappings().getAccess());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedAccess());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getAccess());
        this.getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSpecifiedAccess(null);
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getDefaultAccess());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getAccess());
        EntityMappingsTests.assertNull((Object)this.getEntityMappings().getSpecifiedAccess());
        EntityMappingsTests.assertNull((Object)this.getXmlEntityMappings().getAccess());
    }

    public void testUpdateOrmPersistentTypes() throws Exception {
        EntityMappingsTests.assertFalse((boolean)this.getEntityMappings().getPersistentTypes().iterator().hasNext());
        EntityMappingsTests.assertTrue((boolean)this.getXmlEntityMappings().getMappedSuperclasses().isEmpty());
        EntityMappingsTests.assertTrue((boolean)this.getXmlEntityMappings().getEntities().isEmpty());
        EntityMappingsTests.assertTrue((boolean)this.getXmlEntityMappings().getEmbeddables().isEmpty());
        XmlEmbeddable embeddable = OrmFactory.eINSTANCE.createXmlEmbeddable();
        this.getXmlEntityMappings().getEmbeddables().add((Object)embeddable);
        embeddable.setClassName("model.Foo");
        EntityMappingsTests.assertTrue((boolean)this.getEntityMappings().getPersistentTypes().iterator().hasNext());
        EntityMappingsTests.assertEquals((String)"model.Foo", (String)((OrmPersistentType)this.getEntityMappings().getPersistentTypes().iterator().next()).getMapping().getClass_());
        EntityMappingsTests.assertTrue((boolean)this.getXmlEntityMappings().getMappedSuperclasses().isEmpty());
        EntityMappingsTests.assertTrue((boolean)this.getXmlEntityMappings().getEntities().isEmpty());
        EntityMappingsTests.assertFalse((boolean)this.getXmlEntityMappings().getEmbeddables().isEmpty());
        EntityMappingsTests.assertEquals((String)"model.Foo", (String)((XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0)).getClassName());
        XmlEntity entity = OrmFactory.eINSTANCE.createXmlEntity();
        this.getXmlEntityMappings().getEntities().add((Object)entity);
        entity.setClassName("model.Foo2");
        EntityMappingsTests.assertTrue((boolean)this.getEntityMappings().getPersistentTypes().iterator().hasNext());
        EntityMappingsTests.assertEquals((String)"model.Foo2", (String)((OrmPersistentType)this.getEntityMappings().getPersistentTypes().iterator().next()).getMapping().getClass_());
        EntityMappingsTests.assertTrue((boolean)this.getXmlEntityMappings().getMappedSuperclasses().isEmpty());
        EntityMappingsTests.assertFalse((boolean)this.getXmlEntityMappings().getEntities().isEmpty());
        EntityMappingsTests.assertFalse((boolean)this.getXmlEntityMappings().getEmbeddables().isEmpty());
        EntityMappingsTests.assertEquals((String)"model.Foo2", (String)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getClassName());
        XmlMappedSuperclass mappedSuperclass = OrmFactory.eINSTANCE.createXmlMappedSuperclass();
        this.getXmlEntityMappings().getMappedSuperclasses().add((Object)mappedSuperclass);
        mappedSuperclass.setClassName("model.Foo3");
        EntityMappingsTests.assertTrue((boolean)this.getEntityMappings().getPersistentTypes().iterator().hasNext());
        EntityMappingsTests.assertEquals((String)"model.Foo3", (String)((OrmPersistentType)this.getEntityMappings().getPersistentTypes().iterator().next()).getMapping().getClass_());
        EntityMappingsTests.assertFalse((boolean)this.getXmlEntityMappings().getMappedSuperclasses().isEmpty());
        EntityMappingsTests.assertFalse((boolean)this.getXmlEntityMappings().getEntities().isEmpty());
        EntityMappingsTests.assertFalse((boolean)this.getXmlEntityMappings().getEmbeddables().isEmpty());
        EntityMappingsTests.assertEquals((String)"model.Foo3", (String)((XmlMappedSuperclass)this.getXmlEntityMappings().getMappedSuperclasses().get(0)).getClassName());
    }

    public void testAddOrmPersistentType() throws Exception {
        EntityMappingsTests.assertFalse((boolean)this.getEntityMappings().getPersistentTypes().iterator().hasNext());
        EntityMappingsTests.assertTrue((boolean)this.getXmlEntityMappings().getMappedSuperclasses().isEmpty());
        EntityMappingsTests.assertTrue((boolean)this.getXmlEntityMappings().getEntities().isEmpty());
        EntityMappingsTests.assertTrue((boolean)this.getXmlEntityMappings().getEmbeddables().isEmpty());
        this.getEntityMappings().addPersistentType("embeddable", "model.Foo");
        EntityMappingsTests.assertTrue((boolean)this.getEntityMappings().getPersistentTypes().iterator().hasNext());
        EntityMappingsTests.assertEquals((String)"model.Foo", (String)((OrmPersistentType)this.getEntityMappings().getPersistentTypes().iterator().next()).getMapping().getClass_());
        EntityMappingsTests.assertEquals((String)"embeddable", (String)((OrmPersistentType)this.getEntityMappings().getPersistentTypes().iterator().next()).getMapping().getKey());
        EntityMappingsTests.assertTrue((boolean)this.getXmlEntityMappings().getMappedSuperclasses().isEmpty());
        EntityMappingsTests.assertTrue((boolean)this.getXmlEntityMappings().getEntities().isEmpty());
        EntityMappingsTests.assertFalse((boolean)this.getXmlEntityMappings().getEmbeddables().isEmpty());
        EntityMappingsTests.assertEquals((String)"model.Foo", (String)((XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0)).getClassName());
        this.getEntityMappings().addPersistentType("entity", "model.Foo2");
        EntityMappingsTests.assertTrue((boolean)this.getEntityMappings().getPersistentTypes().iterator().hasNext());
        EntityMappingsTests.assertEquals((String)"model.Foo2", (String)((OrmPersistentType)this.getEntityMappings().getPersistentTypes().iterator().next()).getMapping().getClass_());
        EntityMappingsTests.assertEquals((String)"entity", (String)((OrmPersistentType)this.getEntityMappings().getPersistentTypes().iterator().next()).getMapping().getKey());
        EntityMappingsTests.assertTrue((boolean)this.getXmlEntityMappings().getMappedSuperclasses().isEmpty());
        EntityMappingsTests.assertFalse((boolean)this.getXmlEntityMappings().getEntities().isEmpty());
        EntityMappingsTests.assertFalse((boolean)this.getXmlEntityMappings().getEmbeddables().isEmpty());
        EntityMappingsTests.assertEquals((String)"model.Foo2", (String)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getClassName());
        this.getEntityMappings().addPersistentType("mappedSuperclass", "model.Foo3");
        EntityMappingsTests.assertTrue((boolean)this.getEntityMappings().getPersistentTypes().iterator().hasNext());
        EntityMappingsTests.assertEquals((String)"model.Foo3", (String)((OrmPersistentType)this.getEntityMappings().getPersistentTypes().iterator().next()).getMapping().getClass_());
        EntityMappingsTests.assertEquals((String)"mappedSuperclass", (String)((OrmPersistentType)this.getEntityMappings().getPersistentTypes().iterator().next()).getMapping().getKey());
        EntityMappingsTests.assertFalse((boolean)this.getXmlEntityMappings().getMappedSuperclasses().isEmpty());
        EntityMappingsTests.assertFalse((boolean)this.getXmlEntityMappings().getEntities().isEmpty());
        EntityMappingsTests.assertFalse((boolean)this.getXmlEntityMappings().getEmbeddables().isEmpty());
        EntityMappingsTests.assertEquals((String)"model.Foo3", (String)((XmlMappedSuperclass)this.getXmlEntityMappings().getMappedSuperclasses().get(0)).getClassName());
    }

    public void testRemoveOrmPersistentType() throws Exception {
        EntityMappingsTests.assertFalse((boolean)this.getEntityMappings().getPersistentTypes().iterator().hasNext());
        EntityMappingsTests.assertTrue((boolean)this.getXmlEntityMappings().getMappedSuperclasses().isEmpty());
        EntityMappingsTests.assertTrue((boolean)this.getXmlEntityMappings().getEntities().isEmpty());
        EntityMappingsTests.assertTrue((boolean)this.getXmlEntityMappings().getEmbeddables().isEmpty());
        this.getEntityMappings().addPersistentType("embeddable", "model.Foo");
        this.getEntityMappings().addPersistentType("entity", "model.Foo2");
        this.getEntityMappings().addPersistentType("mappedSuperclass", "model.Foo3");
        this.getEntityMappings().removePersistentType(1);
        EntityMappingsTests.assertFalse((boolean)this.getXmlEntityMappings().getMappedSuperclasses().isEmpty());
        EntityMappingsTests.assertTrue((boolean)this.getXmlEntityMappings().getEntities().isEmpty());
        EntityMappingsTests.assertFalse((boolean)this.getXmlEntityMappings().getEmbeddables().isEmpty());
        this.getEntityMappings().removePersistentType(1);
        EntityMappingsTests.assertFalse((boolean)this.getXmlEntityMappings().getMappedSuperclasses().isEmpty());
        EntityMappingsTests.assertTrue((boolean)this.getXmlEntityMappings().getEntities().isEmpty());
        EntityMappingsTests.assertTrue((boolean)this.getXmlEntityMappings().getEmbeddables().isEmpty());
        this.getEntityMappings().removePersistentType(0);
        EntityMappingsTests.assertTrue((boolean)this.getXmlEntityMappings().getMappedSuperclasses().isEmpty());
        EntityMappingsTests.assertTrue((boolean)this.getXmlEntityMappings().getEntities().isEmpty());
        EntityMappingsTests.assertTrue((boolean)this.getXmlEntityMappings().getEmbeddables().isEmpty());
    }

    public void testUpdateTableGenerators() throws Exception {
        EntityMappingsTests.assertEquals((int)0, (int)this.getEntityMappings().getTableGeneratorsSize());
        EntityMappingsTests.assertEquals((int)0, (int)this.getXmlEntityMappings().getTableGenerators().size());
        EntityMappingsTests.assertEquals((int)0, (int)this.getEntityMappings().getPersistenceUnit().getGeneratorsSize());
        XmlTableGenerator tableGeneratorResource = OrmFactory.eINSTANCE.createXmlTableGenerator();
        this.getXmlEntityMappings().getTableGenerators().add((Object)tableGeneratorResource);
        tableGeneratorResource.setName("FOO");
        TableGenerator tableGenerator = (TableGenerator)this.getEntityMappings().getTableGenerators().iterator().next();
        EntityMappingsTests.assertEquals((String)"FOO", (String)tableGenerator.getName());
        EntityMappingsTests.assertEquals((int)1, (int)this.getEntityMappings().getPersistenceUnit().getGeneratorsSize());
        XmlTableGenerator tableGeneratorResource2 = OrmFactory.eINSTANCE.createXmlTableGenerator();
        this.getXmlEntityMappings().getTableGenerators().add(0, (Object)tableGeneratorResource2);
        tableGeneratorResource2.setName("BAR");
        ListIterator tableGenerators = this.getEntityMappings().getTableGenerators().iterator();
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmTableGenerator)tableGenerators.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmTableGenerator)tableGenerators.next()).getName());
        EntityMappingsTests.assertFalse((boolean)tableGenerators.hasNext());
        EntityMappingsTests.assertEquals((int)2, (int)this.getEntityMappings().getPersistenceUnit().getGeneratorsSize());
        XmlTableGenerator tableGeneratorResource3 = OrmFactory.eINSTANCE.createXmlTableGenerator();
        this.getXmlEntityMappings().getTableGenerators().add(1, (Object)tableGeneratorResource3);
        tableGeneratorResource3.setName("BAZ");
        tableGenerators = this.getEntityMappings().getTableGenerators().iterator();
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmTableGenerator)tableGenerators.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmTableGenerator)tableGenerators.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmTableGenerator)tableGenerators.next()).getName());
        EntityMappingsTests.assertFalse((boolean)tableGenerators.hasNext());
        EntityMappingsTests.assertEquals((int)3, (int)this.getEntityMappings().getPersistenceUnit().getGeneratorsSize());
        this.getXmlEntityMappings().getTableGenerators().move(2, 0);
        tableGenerators = this.getEntityMappings().getTableGenerators().iterator();
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmTableGenerator)tableGenerators.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmTableGenerator)tableGenerators.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmTableGenerator)tableGenerators.next()).getName());
        EntityMappingsTests.assertFalse((boolean)tableGenerators.hasNext());
        EntityMappingsTests.assertEquals((int)3, (int)this.getEntityMappings().getPersistenceUnit().getGeneratorsSize());
        this.getXmlEntityMappings().getTableGenerators().remove(0);
        tableGenerators = this.getEntityMappings().getTableGenerators().iterator();
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmTableGenerator)tableGenerators.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmTableGenerator)tableGenerators.next()).getName());
        EntityMappingsTests.assertFalse((boolean)tableGenerators.hasNext());
        EntityMappingsTests.assertEquals((int)2, (int)this.getEntityMappings().getPersistenceUnit().getGeneratorsSize());
        this.getXmlEntityMappings().getTableGenerators().remove(1);
        tableGenerators = this.getEntityMappings().getTableGenerators().iterator();
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmTableGenerator)tableGenerators.next()).getName());
        EntityMappingsTests.assertFalse((boolean)tableGenerators.hasNext());
        EntityMappingsTests.assertEquals((int)1, (int)this.getEntityMappings().getPersistenceUnit().getGeneratorsSize());
        this.getXmlEntityMappings().getTableGenerators().clear();
        tableGenerators = this.getEntityMappings().getTableGenerators().iterator();
        EntityMappingsTests.assertFalse((boolean)tableGenerators.hasNext());
        EntityMappingsTests.assertEquals((int)0, (int)this.getEntityMappings().getPersistenceUnit().getGeneratorsSize());
    }

    public void testAddTableGenerator() throws Exception {
        EntityMappingsTests.assertEquals((int)0, (int)this.getEntityMappings().getTableGeneratorsSize());
        EntityMappingsTests.assertEquals((int)0, (int)this.getXmlEntityMappings().getTableGenerators().size());
        this.getEntityMappings().addTableGenerator(0).setName("FOO");
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0)).getName());
        this.getEntityMappings().addTableGenerator(0).setName("BAR");
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(1)).getName());
        EntityMappingsTests.assertEquals((int)2, (int)this.getXmlEntityMappings().getTableGenerators().size());
        ListIterator tableGenerators = this.getEntityMappings().getTableGenerators().iterator();
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmTableGenerator)tableGenerators.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmTableGenerator)tableGenerators.next()).getName());
        EntityMappingsTests.assertFalse((boolean)tableGenerators.hasNext());
    }

    public void testRemoveTableGenerator() throws Exception {
        EntityMappingsTests.assertEquals((int)0, (int)this.getEntityMappings().getTableGeneratorsSize());
        EntityMappingsTests.assertEquals((int)0, (int)this.getXmlEntityMappings().getTableGenerators().size());
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        tableGenerator.setName("FOO");
        OrmTableGenerator tableGenerator2 = this.getEntityMappings().addTableGenerator(1);
        tableGenerator2.setName("BAR");
        OrmTableGenerator tableGenerator3 = this.getEntityMappings().addTableGenerator(2);
        tableGenerator3.setName("BAZ");
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(1)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(2)).getName());
        EntityMappingsTests.assertEquals((int)3, (int)this.getXmlEntityMappings().getTableGenerators().size());
        this.getEntityMappings().removeTableGenerator(0);
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(1)).getName());
        ListIterator tableGenerators = this.getEntityMappings().getTableGenerators().iterator();
        OrmTableGenerator xmlTableGenerator = (OrmTableGenerator)tableGenerators.next();
        EntityMappingsTests.assertEquals((String)"BAR", (String)xmlTableGenerator.getName());
        EntityMappingsTests.assertEquals((Object)tableGenerator2, (Object)xmlTableGenerator);
        xmlTableGenerator = (OrmTableGenerator)tableGenerators.next();
        EntityMappingsTests.assertEquals((String)"BAZ", (String)xmlTableGenerator.getName());
        EntityMappingsTests.assertEquals((Object)tableGenerator3, (Object)xmlTableGenerator);
        EntityMappingsTests.assertFalse((boolean)tableGenerators.hasNext());
        this.getEntityMappings().removeTableGenerator(1);
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0)).getName());
        tableGenerators = this.getEntityMappings().getTableGenerators().iterator();
        xmlTableGenerator = (OrmTableGenerator)tableGenerators.next();
        EntityMappingsTests.assertEquals((String)"BAR", (String)xmlTableGenerator.getName());
        EntityMappingsTests.assertEquals((Object)tableGenerator2, (Object)xmlTableGenerator);
        EntityMappingsTests.assertFalse((boolean)tableGenerators.hasNext());
        this.getEntityMappings().removeTableGenerator(0);
        EntityMappingsTests.assertEquals((int)0, (int)this.getXmlEntityMappings().getTableGenerators().size());
        tableGenerators = this.getEntityMappings().getTableGenerators().iterator();
        EntityMappingsTests.assertFalse((boolean)tableGenerators.hasNext());
    }

    public void testMoveTableGenerator() throws Exception {
        EntityMappingsTests.assertEquals((int)0, (int)this.getEntityMappings().getTableGeneratorsSize());
        EntityMappingsTests.assertEquals((int)0, (int)this.getXmlEntityMappings().getTableGenerators().size());
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        tableGenerator.setName("FOO");
        OrmTableGenerator tableGenerator2 = this.getEntityMappings().addTableGenerator(1);
        tableGenerator2.setName("BAR");
        OrmTableGenerator tableGenerator3 = this.getEntityMappings().addTableGenerator(2);
        tableGenerator3.setName("BAZ");
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(1)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(2)).getName());
        EntityMappingsTests.assertEquals((int)3, (int)this.getXmlEntityMappings().getTableGenerators().size());
        this.getEntityMappings().moveTableGenerator(2, 0);
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(1)).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(2)).getName());
        EntityMappingsTests.assertEquals((int)3, (int)this.getXmlEntityMappings().getTableGenerators().size());
        this.getEntityMappings().moveTableGenerator(0, 2);
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(1)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(2)).getName());
        EntityMappingsTests.assertEquals((int)3, (int)this.getXmlEntityMappings().getTableGenerators().size());
    }

    public void testTableGeneratorsSize() throws Exception {
        EntityMappingsTests.assertEquals((int)0, (int)this.getEntityMappings().getTableGeneratorsSize());
        EntityMappingsTests.assertEquals((int)0, (int)this.getXmlEntityMappings().getTableGenerators().size());
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        tableGenerator.setName("FOO");
        OrmTableGenerator tableGenerator2 = this.getEntityMappings().addTableGenerator(1);
        tableGenerator2.setName("BAR");
        OrmTableGenerator tableGenerator3 = this.getEntityMappings().addTableGenerator(2);
        tableGenerator3.setName("BAZ");
        EntityMappingsTests.assertEquals((int)3, (int)this.getEntityMappings().getTableGeneratorsSize());
        this.getXmlEntityMappings().getTableGenerators().remove(0);
        EntityMappingsTests.assertEquals((int)2, (int)this.getEntityMappings().getTableGeneratorsSize());
    }

    public void testUpdateSequenceGenerators() throws Exception {
        EntityMappingsTests.assertEquals((int)0, (int)this.getEntityMappings().getSequenceGeneratorsSize());
        EntityMappingsTests.assertEquals((int)0, (int)this.getXmlEntityMappings().getSequenceGenerators().size());
        EntityMappingsTests.assertEquals((int)0, (int)this.getEntityMappings().getPersistenceUnit().getGeneratorsSize());
        XmlSequenceGenerator sequenceGeneratorResource = OrmFactory.eINSTANCE.createXmlSequenceGenerator();
        this.getXmlEntityMappings().getSequenceGenerators().add((Object)sequenceGeneratorResource);
        sequenceGeneratorResource.setName("FOO");
        SequenceGenerator sequenceGenerator = (SequenceGenerator)this.getEntityMappings().getSequenceGenerators().iterator().next();
        EntityMappingsTests.assertEquals((String)"FOO", (String)sequenceGenerator.getName());
        EntityMappingsTests.assertEquals((int)1, (int)this.getEntityMappings().getPersistenceUnit().getGeneratorsSize());
        XmlSequenceGenerator sequenceGeneratorResource2 = OrmFactory.eINSTANCE.createXmlSequenceGenerator();
        this.getXmlEntityMappings().getSequenceGenerators().add(0, (Object)sequenceGeneratorResource2);
        sequenceGeneratorResource2.setName("BAR");
        ListIterator sequenceGenerators = this.getEntityMappings().getSequenceGenerators().iterator();
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmSequenceGenerator)sequenceGenerators.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmSequenceGenerator)sequenceGenerators.next()).getName());
        EntityMappingsTests.assertFalse((boolean)sequenceGenerators.hasNext());
        EntityMappingsTests.assertEquals((int)2, (int)this.getEntityMappings().getPersistenceUnit().getGeneratorsSize());
        XmlSequenceGenerator sequenceGeneratorResource3 = OrmFactory.eINSTANCE.createXmlSequenceGenerator();
        this.getXmlEntityMappings().getSequenceGenerators().add(1, (Object)sequenceGeneratorResource3);
        sequenceGeneratorResource3.setName("BAZ");
        sequenceGenerators = this.getEntityMappings().getSequenceGenerators().iterator();
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmSequenceGenerator)sequenceGenerators.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmSequenceGenerator)sequenceGenerators.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmSequenceGenerator)sequenceGenerators.next()).getName());
        EntityMappingsTests.assertFalse((boolean)sequenceGenerators.hasNext());
        EntityMappingsTests.assertEquals((int)3, (int)this.getEntityMappings().getPersistenceUnit().getGeneratorsSize());
        this.getXmlEntityMappings().getSequenceGenerators().move(2, 0);
        sequenceGenerators = this.getEntityMappings().getSequenceGenerators().iterator();
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmSequenceGenerator)sequenceGenerators.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmSequenceGenerator)sequenceGenerators.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmSequenceGenerator)sequenceGenerators.next()).getName());
        EntityMappingsTests.assertFalse((boolean)sequenceGenerators.hasNext());
        this.getXmlEntityMappings().getSequenceGenerators().remove(0);
        sequenceGenerators = this.getEntityMappings().getSequenceGenerators().iterator();
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmSequenceGenerator)sequenceGenerators.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmSequenceGenerator)sequenceGenerators.next()).getName());
        EntityMappingsTests.assertFalse((boolean)sequenceGenerators.hasNext());
        EntityMappingsTests.assertEquals((int)2, (int)this.getEntityMappings().getPersistenceUnit().getGeneratorsSize());
        this.getXmlEntityMappings().getSequenceGenerators().remove(1);
        sequenceGenerators = this.getEntityMappings().getSequenceGenerators().iterator();
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmSequenceGenerator)sequenceGenerators.next()).getName());
        EntityMappingsTests.assertFalse((boolean)sequenceGenerators.hasNext());
        EntityMappingsTests.assertEquals((int)1, (int)this.getEntityMappings().getPersistenceUnit().getGeneratorsSize());
        this.getXmlEntityMappings().getSequenceGenerators().clear();
        sequenceGenerators = this.getEntityMappings().getSequenceGenerators().iterator();
        EntityMappingsTests.assertFalse((boolean)sequenceGenerators.hasNext());
        EntityMappingsTests.assertEquals((int)0, (int)this.getEntityMappings().getPersistenceUnit().getGeneratorsSize());
    }

    public void testAddSequenceGenerator() throws Exception {
        EntityMappingsTests.assertEquals((int)0, (int)this.getEntityMappings().getSequenceGeneratorsSize());
        EntityMappingsTests.assertEquals((int)0, (int)this.getXmlEntityMappings().getSequenceGenerators().size());
        this.getEntityMappings().addSequenceGenerator(0).setName("FOO");
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlSequenceGenerator)this.getXmlEntityMappings().getSequenceGenerators().get(0)).getName());
        this.getEntityMappings().addSequenceGenerator(0).setName("BAR");
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlSequenceGenerator)this.getXmlEntityMappings().getSequenceGenerators().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlSequenceGenerator)this.getXmlEntityMappings().getSequenceGenerators().get(1)).getName());
        EntityMappingsTests.assertEquals((int)2, (int)this.getXmlEntityMappings().getSequenceGenerators().size());
        ListIterator sequenceGenerators = this.getEntityMappings().getSequenceGenerators().iterator();
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmSequenceGenerator)sequenceGenerators.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmSequenceGenerator)sequenceGenerators.next()).getName());
        EntityMappingsTests.assertFalse((boolean)sequenceGenerators.hasNext());
    }

    public void testRemoveSequenceGenerator() throws Exception {
        EntityMappingsTests.assertEquals((int)0, (int)this.getEntityMappings().getSequenceGeneratorsSize());
        EntityMappingsTests.assertEquals((int)0, (int)this.getXmlEntityMappings().getSequenceGenerators().size());
        OrmSequenceGenerator sequenceGenerator = this.getEntityMappings().addSequenceGenerator(0);
        sequenceGenerator.setName("FOO");
        OrmSequenceGenerator sequenceGenerator2 = this.getEntityMappings().addSequenceGenerator(1);
        sequenceGenerator2.setName("BAR");
        OrmSequenceGenerator sequenceGenerator3 = this.getEntityMappings().addSequenceGenerator(2);
        sequenceGenerator3.setName("BAZ");
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlSequenceGenerator)this.getXmlEntityMappings().getSequenceGenerators().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlSequenceGenerator)this.getXmlEntityMappings().getSequenceGenerators().get(1)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlSequenceGenerator)this.getXmlEntityMappings().getSequenceGenerators().get(2)).getName());
        EntityMappingsTests.assertEquals((int)3, (int)this.getXmlEntityMappings().getSequenceGenerators().size());
        this.getEntityMappings().removeSequenceGenerator(0);
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlSequenceGenerator)this.getXmlEntityMappings().getSequenceGenerators().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlSequenceGenerator)this.getXmlEntityMappings().getSequenceGenerators().get(1)).getName());
        ListIterator sequenceGenerators = this.getEntityMappings().getSequenceGenerators().iterator();
        SequenceGenerator xmlSequenceGenerator = (SequenceGenerator)sequenceGenerators.next();
        EntityMappingsTests.assertEquals((String)"BAR", (String)xmlSequenceGenerator.getName());
        EntityMappingsTests.assertEquals((Object)sequenceGenerator2, (Object)xmlSequenceGenerator);
        xmlSequenceGenerator = (SequenceGenerator)sequenceGenerators.next();
        EntityMappingsTests.assertEquals((String)"BAZ", (String)xmlSequenceGenerator.getName());
        EntityMappingsTests.assertEquals((Object)sequenceGenerator3, (Object)xmlSequenceGenerator);
        EntityMappingsTests.assertFalse((boolean)sequenceGenerators.hasNext());
        this.getEntityMappings().removeSequenceGenerator(1);
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlSequenceGenerator)this.getXmlEntityMappings().getSequenceGenerators().get(0)).getName());
        sequenceGenerators = this.getEntityMappings().getSequenceGenerators().iterator();
        xmlSequenceGenerator = (SequenceGenerator)sequenceGenerators.next();
        EntityMappingsTests.assertEquals((String)"BAR", (String)xmlSequenceGenerator.getName());
        EntityMappingsTests.assertEquals((Object)sequenceGenerator2, (Object)xmlSequenceGenerator);
        EntityMappingsTests.assertFalse((boolean)sequenceGenerators.hasNext());
        this.getEntityMappings().removeSequenceGenerator(0);
        EntityMappingsTests.assertEquals((int)0, (int)this.getXmlEntityMappings().getSequenceGenerators().size());
        sequenceGenerators = this.getEntityMappings().getSequenceGenerators().iterator();
        EntityMappingsTests.assertFalse((boolean)sequenceGenerators.hasNext());
    }

    public void testMoveSequenceGenerator() throws Exception {
        EntityMappingsTests.assertEquals((int)0, (int)this.getEntityMappings().getSequenceGeneratorsSize());
        EntityMappingsTests.assertEquals((int)0, (int)this.getXmlEntityMappings().getSequenceGenerators().size());
        OrmSequenceGenerator sequenceGenerator = this.getEntityMappings().addSequenceGenerator(0);
        sequenceGenerator.setName("FOO");
        OrmSequenceGenerator sequenceGenerator2 = this.getEntityMappings().addSequenceGenerator(1);
        sequenceGenerator2.setName("BAR");
        OrmSequenceGenerator sequenceGenerator3 = this.getEntityMappings().addSequenceGenerator(2);
        sequenceGenerator3.setName("BAZ");
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlSequenceGenerator)this.getXmlEntityMappings().getSequenceGenerators().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlSequenceGenerator)this.getXmlEntityMappings().getSequenceGenerators().get(1)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlSequenceGenerator)this.getXmlEntityMappings().getSequenceGenerators().get(2)).getName());
        EntityMappingsTests.assertEquals((int)3, (int)this.getXmlEntityMappings().getSequenceGenerators().size());
        this.getEntityMappings().moveSequenceGenerator(2, 0);
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlSequenceGenerator)this.getXmlEntityMappings().getSequenceGenerators().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlSequenceGenerator)this.getXmlEntityMappings().getSequenceGenerators().get(1)).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlSequenceGenerator)this.getXmlEntityMappings().getSequenceGenerators().get(2)).getName());
        EntityMappingsTests.assertEquals((int)3, (int)this.getXmlEntityMappings().getSequenceGenerators().size());
        this.getEntityMappings().moveSequenceGenerator(0, 2);
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlSequenceGenerator)this.getXmlEntityMappings().getSequenceGenerators().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlSequenceGenerator)this.getXmlEntityMappings().getSequenceGenerators().get(1)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlSequenceGenerator)this.getXmlEntityMappings().getSequenceGenerators().get(2)).getName());
        EntityMappingsTests.assertEquals((int)3, (int)this.getXmlEntityMappings().getSequenceGenerators().size());
    }

    public void testSequenceGeneratorsSize() throws Exception {
        EntityMappingsTests.assertEquals((int)0, (int)this.getEntityMappings().getSequenceGeneratorsSize());
        EntityMappingsTests.assertEquals((int)0, (int)this.getXmlEntityMappings().getSequenceGenerators().size());
        OrmSequenceGenerator sequenceGenerator = this.getEntityMappings().addSequenceGenerator(0);
        sequenceGenerator.setName("FOO");
        OrmSequenceGenerator sequenceGenerator2 = this.getEntityMappings().addSequenceGenerator(1);
        sequenceGenerator2.setName("BAR");
        OrmSequenceGenerator sequenceGenerator3 = this.getEntityMappings().addSequenceGenerator(2);
        sequenceGenerator3.setName("BAZ");
        EntityMappingsTests.assertEquals((int)3, (int)this.getEntityMappings().getSequenceGeneratorsSize());
        this.getXmlEntityMappings().getSequenceGenerators().remove(0);
        EntityMappingsTests.assertEquals((int)2, (int)this.getEntityMappings().getSequenceGeneratorsSize());
    }

    public void testAddNamedQuery() throws Exception {
        OrmNamedQuery namedQuery = this.getEntityMappings().getQueryContainer().addNamedQuery(0);
        namedQuery.setName("FOO");
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlNamedQuery)this.getXmlEntityMappings().getNamedQueries().get(0)).getName());
        OrmNamedQuery namedQuery2 = this.getEntityMappings().getQueryContainer().addNamedQuery(0);
        namedQuery2.setName("BAR");
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlNamedQuery)this.getXmlEntityMappings().getNamedQueries().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlNamedQuery)this.getXmlEntityMappings().getNamedQueries().get(1)).getName());
        OrmNamedQuery namedQuery3 = this.getEntityMappings().getQueryContainer().addNamedQuery(1);
        namedQuery3.setName("BAZ");
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlNamedQuery)this.getXmlEntityMappings().getNamedQueries().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlNamedQuery)this.getXmlEntityMappings().getNamedQueries().get(1)).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlNamedQuery)this.getXmlEntityMappings().getNamedQueries().get(2)).getName());
        ListIterator namedQueries = this.getEntityMappings().getQueryContainer().getNamedQueries().iterator();
        EntityMappingsTests.assertEquals((Object)namedQuery2, namedQueries.next());
        EntityMappingsTests.assertEquals((Object)namedQuery3, namedQueries.next());
        EntityMappingsTests.assertEquals((Object)namedQuery, namedQueries.next());
        namedQueries = this.getEntityMappings().getQueryContainer().getNamedQueries().iterator();
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmNamedQuery)namedQueries.next()).getName());
    }

    public void testRemoveNamedQuery() throws Exception {
        this.getEntityMappings().getQueryContainer().addNamedQuery(0).setName("FOO");
        this.getEntityMappings().getQueryContainer().addNamedQuery(1).setName("BAR");
        this.getEntityMappings().getQueryContainer().addNamedQuery(2).setName("BAZ");
        EntityMappingsTests.assertEquals((int)3, (int)this.getXmlEntityMappings().getNamedQueries().size());
        this.getEntityMappings().getQueryContainer().removeNamedQuery(0);
        EntityMappingsTests.assertEquals((int)2, (int)this.getXmlEntityMappings().getNamedQueries().size());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlNamedQuery)this.getXmlEntityMappings().getNamedQueries().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlNamedQuery)this.getXmlEntityMappings().getNamedQueries().get(1)).getName());
        this.getEntityMappings().getQueryContainer().removeNamedQuery(0);
        EntityMappingsTests.assertEquals((int)1, (int)this.getXmlEntityMappings().getNamedQueries().size());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlNamedQuery)this.getXmlEntityMappings().getNamedQueries().get(0)).getName());
        this.getEntityMappings().getQueryContainer().removeNamedQuery(0);
        EntityMappingsTests.assertEquals((int)0, (int)this.getXmlEntityMappings().getNamedQueries().size());
    }

    public void testMoveNamedQuery() throws Exception {
        this.getEntityMappings().getQueryContainer().addNamedQuery(0).setName("FOO");
        this.getEntityMappings().getQueryContainer().addNamedQuery(1).setName("BAR");
        this.getEntityMappings().getQueryContainer().addNamedQuery(2).setName("BAZ");
        EntityMappingsTests.assertEquals((int)3, (int)this.getXmlEntityMappings().getNamedQueries().size());
        this.getEntityMappings().getQueryContainer().moveNamedQuery(2, 0);
        ListIterator namedQueries = this.getEntityMappings().getQueryContainer().getNamedQueries().iterator();
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlNamedQuery)this.getXmlEntityMappings().getNamedQueries().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlNamedQuery)this.getXmlEntityMappings().getNamedQueries().get(1)).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlNamedQuery)this.getXmlEntityMappings().getNamedQueries().get(2)).getName());
        this.getEntityMappings().getQueryContainer().moveNamedQuery(0, 1);
        namedQueries = this.getEntityMappings().getQueryContainer().getNamedQueries().iterator();
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlNamedQuery)this.getXmlEntityMappings().getNamedQueries().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlNamedQuery)this.getXmlEntityMappings().getNamedQueries().get(1)).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlNamedQuery)this.getXmlEntityMappings().getNamedQueries().get(2)).getName());
    }

    public void testUpdateNamedQueries() throws Exception {
        EntityMappingsTests.assertEquals((int)0, (int)this.getEntityMappings().getPersistenceUnit().getQueriesSize());
        this.getXmlEntityMappings().getNamedQueries().add((Object)OrmFactory.eINSTANCE.createXmlNamedQuery());
        this.getXmlEntityMappings().getNamedQueries().add((Object)OrmFactory.eINSTANCE.createXmlNamedQuery());
        this.getXmlEntityMappings().getNamedQueries().add((Object)OrmFactory.eINSTANCE.createXmlNamedQuery());
        ((XmlNamedQuery)this.getXmlEntityMappings().getNamedQueries().get(0)).setName("FOO");
        ((XmlNamedQuery)this.getXmlEntityMappings().getNamedQueries().get(1)).setName("BAR");
        ((XmlNamedQuery)this.getXmlEntityMappings().getNamedQueries().get(2)).setName("BAZ");
        ListIterator namedQueries = this.getEntityMappings().getQueryContainer().getNamedQueries().iterator();
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertFalse((boolean)namedQueries.hasNext());
        EntityMappingsTests.assertEquals((int)3, (int)this.getEntityMappings().getPersistenceUnit().getQueriesSize());
        this.getXmlEntityMappings().getNamedQueries().move(2, 0);
        namedQueries = this.getEntityMappings().getQueryContainer().getNamedQueries().iterator();
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertFalse((boolean)namedQueries.hasNext());
        this.getXmlEntityMappings().getNamedQueries().move(0, 1);
        namedQueries = this.getEntityMappings().getQueryContainer().getNamedQueries().iterator();
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertFalse((boolean)namedQueries.hasNext());
        this.getXmlEntityMappings().getNamedQueries().remove(1);
        namedQueries = this.getEntityMappings().getQueryContainer().getNamedQueries().iterator();
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertFalse((boolean)namedQueries.hasNext());
        EntityMappingsTests.assertEquals((int)2, (int)this.getEntityMappings().getPersistenceUnit().getQueriesSize());
        this.getXmlEntityMappings().getNamedQueries().remove(1);
        namedQueries = this.getEntityMappings().getQueryContainer().getNamedQueries().iterator();
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertFalse((boolean)namedQueries.hasNext());
        EntityMappingsTests.assertEquals((int)1, (int)this.getEntityMappings().getPersistenceUnit().getQueriesSize());
        this.getXmlEntityMappings().getNamedQueries().remove(0);
        EntityMappingsTests.assertFalse((boolean)this.getEntityMappings().getQueryContainer().getNamedQueries().iterator().hasNext());
        EntityMappingsTests.assertEquals((int)0, (int)this.getEntityMappings().getPersistenceUnit().getQueriesSize());
    }

    public void testAddNamedNativeQuery() throws Exception {
        OrmNamedNativeQuery namedNativeQuery = this.getEntityMappings().getQueryContainer().addNamedNativeQuery(0);
        namedNativeQuery.setName("FOO");
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlNamedNativeQuery)this.getXmlEntityMappings().getNamedNativeQueries().get(0)).getName());
        OrmNamedNativeQuery namedNativeQuery2 = this.getEntityMappings().getQueryContainer().addNamedNativeQuery(0);
        namedNativeQuery2.setName("BAR");
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlNamedNativeQuery)this.getXmlEntityMappings().getNamedNativeQueries().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlNamedNativeQuery)this.getXmlEntityMappings().getNamedNativeQueries().get(1)).getName());
        OrmNamedNativeQuery namedNativeQuery3 = this.getEntityMappings().getQueryContainer().addNamedNativeQuery(1);
        namedNativeQuery3.setName("BAZ");
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlNamedNativeQuery)this.getXmlEntityMappings().getNamedNativeQueries().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlNamedNativeQuery)this.getXmlEntityMappings().getNamedNativeQueries().get(1)).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlNamedNativeQuery)this.getXmlEntityMappings().getNamedNativeQueries().get(2)).getName());
        ListIterator namedNativeQueries = this.getEntityMappings().getQueryContainer().getNamedNativeQueries().iterator();
        EntityMappingsTests.assertEquals((Object)namedNativeQuery2, namedNativeQueries.next());
        EntityMappingsTests.assertEquals((Object)namedNativeQuery3, namedNativeQueries.next());
        EntityMappingsTests.assertEquals((Object)namedNativeQuery, namedNativeQueries.next());
        namedNativeQueries = this.getEntityMappings().getQueryContainer().getNamedNativeQueries().iterator();
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
    }

    public void testRemoveNamedNativeQuery() throws Exception {
        this.getEntityMappings().getQueryContainer().addNamedNativeQuery(0).setName("FOO");
        this.getEntityMappings().getQueryContainer().addNamedNativeQuery(1).setName("BAR");
        this.getEntityMappings().getQueryContainer().addNamedNativeQuery(2).setName("BAZ");
        EntityMappingsTests.assertEquals((int)3, (int)this.getXmlEntityMappings().getNamedNativeQueries().size());
        this.getEntityMappings().getQueryContainer().removeNamedNativeQuery(0);
        EntityMappingsTests.assertEquals((int)2, (int)this.getXmlEntityMappings().getNamedNativeQueries().size());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlNamedNativeQuery)this.getXmlEntityMappings().getNamedNativeQueries().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlNamedNativeQuery)this.getXmlEntityMappings().getNamedNativeQueries().get(1)).getName());
        this.getEntityMappings().getQueryContainer().removeNamedNativeQuery(0);
        EntityMappingsTests.assertEquals((int)1, (int)this.getXmlEntityMappings().getNamedNativeQueries().size());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlNamedNativeQuery)this.getXmlEntityMappings().getNamedNativeQueries().get(0)).getName());
        this.getEntityMappings().getQueryContainer().removeNamedNativeQuery(0);
        EntityMappingsTests.assertEquals((int)0, (int)this.getXmlEntityMappings().getNamedNativeQueries().size());
    }

    public void testMoveNamedNativeQuery() throws Exception {
        this.getEntityMappings().getQueryContainer().addNamedNativeQuery(0).setName("FOO");
        this.getEntityMappings().getQueryContainer().addNamedNativeQuery(1).setName("BAR");
        this.getEntityMappings().getQueryContainer().addNamedNativeQuery(2).setName("BAZ");
        EntityMappingsTests.assertEquals((int)3, (int)this.getXmlEntityMappings().getNamedNativeQueries().size());
        this.getEntityMappings().getQueryContainer().moveNamedNativeQuery(2, 0);
        ListIterator namedNativeQueries = this.getEntityMappings().getQueryContainer().getNamedNativeQueries().iterator();
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlNamedNativeQuery)this.getXmlEntityMappings().getNamedNativeQueries().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlNamedNativeQuery)this.getXmlEntityMappings().getNamedNativeQueries().get(1)).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlNamedNativeQuery)this.getXmlEntityMappings().getNamedNativeQueries().get(2)).getName());
        this.getEntityMappings().getQueryContainer().moveNamedNativeQuery(0, 1);
        namedNativeQueries = this.getEntityMappings().getQueryContainer().getNamedNativeQueries().iterator();
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlNamedNativeQuery)this.getXmlEntityMappings().getNamedNativeQueries().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlNamedNativeQuery)this.getXmlEntityMappings().getNamedNativeQueries().get(1)).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlNamedNativeQuery)this.getXmlEntityMappings().getNamedNativeQueries().get(2)).getName());
    }

    public void testUpdateNamedNativeQueries() throws Exception {
        EntityMappingsTests.assertEquals((int)0, (int)this.getEntityMappings().getPersistenceUnit().getQueriesSize());
        this.getXmlEntityMappings().getNamedNativeQueries().add((Object)OrmFactory.eINSTANCE.createXmlNamedNativeQuery());
        this.getXmlEntityMappings().getNamedNativeQueries().add((Object)OrmFactory.eINSTANCE.createXmlNamedNativeQuery());
        this.getXmlEntityMappings().getNamedNativeQueries().add((Object)OrmFactory.eINSTANCE.createXmlNamedNativeQuery());
        ((XmlNamedNativeQuery)this.getXmlEntityMappings().getNamedNativeQueries().get(0)).setName("FOO");
        ((XmlNamedNativeQuery)this.getXmlEntityMappings().getNamedNativeQueries().get(1)).setName("BAR");
        ((XmlNamedNativeQuery)this.getXmlEntityMappings().getNamedNativeQueries().get(2)).setName("BAZ");
        ListIterator namedNativeQueries = this.getEntityMappings().getQueryContainer().getNamedNativeQueries().iterator();
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertFalse((boolean)namedNativeQueries.hasNext());
        EntityMappingsTests.assertEquals((int)3, (int)this.getEntityMappings().getPersistenceUnit().getQueriesSize());
        this.getXmlEntityMappings().getNamedNativeQueries().move(2, 0);
        namedNativeQueries = this.getEntityMappings().getQueryContainer().getNamedNativeQueries().iterator();
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertFalse((boolean)namedNativeQueries.hasNext());
        this.getXmlEntityMappings().getNamedNativeQueries().move(0, 1);
        namedNativeQueries = this.getEntityMappings().getQueryContainer().getNamedNativeQueries().iterator();
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertFalse((boolean)namedNativeQueries.hasNext());
        this.getXmlEntityMappings().getNamedNativeQueries().remove(1);
        namedNativeQueries = this.getEntityMappings().getQueryContainer().getNamedNativeQueries().iterator();
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertFalse((boolean)namedNativeQueries.hasNext());
        EntityMappingsTests.assertEquals((int)2, (int)this.getEntityMappings().getPersistenceUnit().getQueriesSize());
        this.getXmlEntityMappings().getNamedNativeQueries().remove(1);
        namedNativeQueries = this.getEntityMappings().getQueryContainer().getNamedNativeQueries().iterator();
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertFalse((boolean)namedNativeQueries.hasNext());
        EntityMappingsTests.assertEquals((int)1, (int)this.getEntityMappings().getPersistenceUnit().getQueriesSize());
        this.getXmlEntityMappings().getNamedNativeQueries().remove(0);
        EntityMappingsTests.assertFalse((boolean)this.getEntityMappings().getQueryContainer().getNamedNativeQueries().iterator().hasNext());
        EntityMappingsTests.assertEquals((int)0, (int)this.getEntityMappings().getPersistenceUnit().getQueriesSize());
    }
}

