/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.BaseEnumeratedConverter;
import org.eclipse.jpt.jpa.core.context.BaseTemporalConverter;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.EnumType;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.TemporalType;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.jpa2.context.ElementCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericJavaBasicMapping2_0Tests
extends Generic2_0ContextModelTestCase {
    private ICompilationUnit createTestEntityWithBasicMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
            }
        });
    }

    public GenericJavaBasicMapping2_0Tests(String name) {
        super(name);
    }

    public void testBasicMorphToDefaultBasic() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaBasicMapping2_0Tests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setConverter(BaseEnumeratedConverter.class);
        ((BaseEnumeratedConverter)basicMapping.getConverter()).setSpecifiedEnumType(EnumType.STRING);
        resourceField.addAnnotation("javax.persistence.Lob");
        resourceField.addAnnotation("javax.persistence.Temporal");
        resourceField.addAnnotation("javax.persistence.Access");
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        GenericJavaBasicMapping2_0Tests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        GenericJavaBasicMapping2_0Tests.assertEquals((String)"FOO", (String)((BasicMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        GenericJavaBasicMapping2_0Tests.assertEquals((Object)EnumType.STRING, (Object)((BaseEnumeratedConverter)((BasicMapping)persistentAttribute.getMapping()).getConverter()).getEnumType());
        GenericJavaBasicMapping2_0Tests.assertNull((Object)((BasicMapping)persistentAttribute.getMapping()).getSpecifiedFetch());
        GenericJavaBasicMapping2_0Tests.assertNull((Object)((BasicMapping)persistentAttribute.getMapping()).getSpecifiedOptional());
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Basic"));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Lob"));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Enumerated"));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testBasicMorphToId() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaBasicMapping2_0Tests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)basicMapping.getConverter()).setTemporalType(TemporalType.TIME);
        resourceField.addAnnotation("javax.persistence.Lob");
        resourceField.addAnnotation("javax.persistence.Enumerated");
        resourceField.addAnnotation("javax.persistence.Access");
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        GenericJavaBasicMapping2_0Tests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setMappingKey("id");
        GenericJavaBasicMapping2_0Tests.assertEquals((String)"FOO", (String)((IdMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        GenericJavaBasicMapping2_0Tests.assertEquals((Object)TemporalType.TIME, (Object)((BaseTemporalConverter)((IdMapping)persistentAttribute.getMapping()).getConverter()).getTemporalType());
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Basic"));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Lob"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Enumerated"));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testBasicMorphToVersion() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaBasicMapping2_0Tests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)basicMapping.getConverter()).setTemporalType(TemporalType.TIME);
        resourceField.addAnnotation("javax.persistence.Lob");
        resourceField.addAnnotation("javax.persistence.Enumerated");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaBasicMapping2_0Tests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setMappingKey("version");
        GenericJavaBasicMapping2_0Tests.assertEquals((String)"FOO", (String)((VersionMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        GenericJavaBasicMapping2_0Tests.assertEquals((Object)TemporalType.TIME, (Object)((BaseTemporalConverter)((VersionMapping)persistentAttribute.getMapping()).getConverter()).getTemporalType());
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Basic"));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Lob"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Enumerated"));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testBasicMorphToEmbedded() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaBasicMapping2_0Tests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        resourceField.addAnnotation("javax.persistence.Temporal");
        resourceField.addAnnotation("javax.persistence.Lob");
        resourceField.addAnnotation("javax.persistence.Enumerated");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaBasicMapping2_0Tests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setMappingKey("embedded");
        GenericJavaBasicMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Basic"));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Lob"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Enumerated"));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testBasicMorphToEmbeddedId() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaBasicMapping2_0Tests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        resourceField.addAnnotation("javax.persistence.Temporal");
        resourceField.addAnnotation("javax.persistence.Lob");
        resourceField.addAnnotation("javax.persistence.Enumerated");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaBasicMapping2_0Tests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setMappingKey("embeddedId");
        GenericJavaBasicMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Basic"));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.EmbeddedId"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Lob"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Enumerated"));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testBasicMorphToTransient() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaBasicMapping2_0Tests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        resourceField.addAnnotation("javax.persistence.Temporal");
        resourceField.addAnnotation("javax.persistence.Lob");
        resourceField.addAnnotation("javax.persistence.Enumerated");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaBasicMapping2_0Tests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setMappingKey("transient");
        GenericJavaBasicMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Basic"));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Transient"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Lob"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Enumerated"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testBasicMorphToOneToOne() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaBasicMapping2_0Tests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        resourceField.addAnnotation("javax.persistence.Temporal");
        resourceField.addAnnotation("javax.persistence.Lob");
        resourceField.addAnnotation("javax.persistence.Enumerated");
        resourceField.addAnnotation("javax.persistence.Access");
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        GenericJavaBasicMapping2_0Tests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setMappingKey("oneToOne");
        GenericJavaBasicMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToOneMapping));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Basic"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Lob"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToOneToMany() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaBasicMapping2_0Tests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        resourceField.addAnnotation("javax.persistence.Temporal");
        resourceField.addAnnotation("javax.persistence.Lob");
        resourceField.addAnnotation("javax.persistence.Enumerated");
        resourceField.addAnnotation("javax.persistence.Access");
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        GenericJavaBasicMapping2_0Tests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setMappingKey("oneToMany");
        GenericJavaBasicMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToMany"));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Basic"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Lob"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToManyToOne() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaBasicMapping2_0Tests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        resourceField.addAnnotation("javax.persistence.Temporal");
        resourceField.addAnnotation("javax.persistence.Lob");
        resourceField.addAnnotation("javax.persistence.Enumerated");
        resourceField.addAnnotation("javax.persistence.Access");
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        GenericJavaBasicMapping2_0Tests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setMappingKey("manyToOne");
        GenericJavaBasicMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ManyToOne"));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Basic"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Lob"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToManyToMany() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaBasicMapping2_0Tests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        resourceField.addAnnotation("javax.persistence.Temporal");
        resourceField.addAnnotation("javax.persistence.Lob");
        resourceField.addAnnotation("javax.persistence.Enumerated");
        resourceField.addAnnotation("javax.persistence.Access");
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        GenericJavaBasicMapping2_0Tests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setMappingKey("manyToMany");
        GenericJavaBasicMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToManyMapping));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ManyToMany"));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Basic"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Lob"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToElementCollection() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaBasicMapping2_0Tests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        resourceField.addAnnotation("javax.persistence.Temporal");
        resourceField.addAnnotation("javax.persistence.Lob");
        resourceField.addAnnotation("javax.persistence.Enumerated");
        resourceField.addAnnotation("javax.persistence.Access");
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        GenericJavaBasicMapping2_0Tests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setMappingKey("elementCollection");
        GenericJavaBasicMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ElementCollectionMapping2_0));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ElementCollection"));
        GenericJavaBasicMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Basic"));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Lob"));
        GenericJavaBasicMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Enumerated"));
    }
}

