/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmIdMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmOneToOneMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.java.GenericJavaNullAttributeMapping;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericOrmPersistentAttribute2_0Tests
extends Generic2_0ContextModelTestCase {
    public GenericOrmPersistentAttribute2_0Tests(String name) {
        super(name);
    }

    private ICompilationUnit createTestTypeNullAttributeMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityIdMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Column"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
                sb.append("@Column(name=\"FOO\")");
            }
        });
    }

    private ICompilationUnit createTestEntityIdMappingPropertyAccess() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Column"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
                sb.append("@Column(name=\"FOO\")");
            }
        });
    }

    private ICompilationUnit createTestEntityOneToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne");
                sb.append("    private Address address;");
            }
        });
    }

    private ICompilationUnit createTestEntityAnnotatedFieldPropertySpecified() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "javax.persistence.Id", "javax.persistence.Access", "javax.persistence.AccessType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append("@Access(AccessType.PROPERTY)");
            }

            public void appendNameFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic");
                sb.append("@Access(AccessType.FIELD)");
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    public void testMakeSpecified() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)2, (int)ormPersistentType.getDefaultAttributesSize());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        ormPersistentAttribute.addToXml();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)1, (int)ormPersistentType.getDefaultAttributesSize());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        ormPersistentAttribute.addToXml();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)0, (int)ormPersistentType.getDefaultAttributesSize());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)2, (int)ormPersistentType.getSpecifiedAttributesSize());
        ListIterator specifiedAttributes = ormPersistentType.getSpecifiedAttributes().iterator();
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"name", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
    }

    public void testMakeSpecifiedWithAccess() throws Exception {
        this.createTestEntityAnnotatedFieldPropertySpecified();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)2, (int)ormPersistentType.getDefaultAttributesSize());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)CollectionTools.get((Iterable)ormPersistentType.getDefaultAttributes(), (int)1);
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertEquals(null, (Object)ormPersistentAttribute.getJavaPersistentAttribute().getSpecifiedAccess());
        ormPersistentAttribute.addToXml();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)1, (int)ormPersistentType.getDefaultAttributesSize());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertEquals(null, (Object)specifiedOrmPersistentAttribute.getSpecifiedAccess());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)specifiedOrmPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"name", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        ormPersistentAttribute.addToXml();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)0, (int)ormPersistentType.getDefaultAttributesSize());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)2, (int)ormPersistentType.getSpecifiedAttributesSize());
        ListIterator specifiedAttributes = ormPersistentType.getSpecifiedAttributes().iterator();
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)specifiedOrmPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertEquals(null, (Object)specifiedOrmPersistentAttribute.getSpecifiedAccess());
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"name", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)specifiedOrmPersistentAttribute.getSpecifiedAccess());
    }

    public void testMakeSpecifiedMappingKey() throws Exception {
        this.createTestTypeNullAttributeMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)3, (int)ormPersistentType.getDefaultAttributesSize());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"address", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof GenericJavaNullAttributeMapping));
        ormPersistentAttribute.addToXml("oneToOne");
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)2, (int)ormPersistentType.getDefaultAttributesSize());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"address", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)(specifiedOrmPersistentAttribute.getMapping() instanceof OrmOneToOneMapping));
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        ormPersistentAttribute.addToXml("id");
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)1, (int)ormPersistentType.getDefaultAttributesSize());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)2, (int)ormPersistentType.getSpecifiedAttributesSize());
        ListIterator specifiedAttributes = ormPersistentType.getSpecifiedAttributes().iterator();
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)(specifiedOrmPersistentAttribute.getMapping() instanceof OrmIdMapping));
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"address", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
    }

    public void testMakeVirtual() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)2, (int)ormPersistentType.getDefaultAttributesSize());
        ((OrmReadOnlyPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next()).addToXml();
        ((OrmReadOnlyPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next()).addToXml();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)0, (int)ormPersistentType.getDefaultAttributesSize());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)2, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        specifiedOrmPersistentAttribute.removeFromXml();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)1, (int)ormPersistentType.getDefaultAttributesSize());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        specifiedOrmPersistentAttribute.removeFromXml();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)2, (int)ormPersistentType.getDefaultAttributesSize());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)0, (int)ormPersistentType.getSpecifiedAttributesSize());
        ListIterator virtualAttributes = ormPersistentType.getDefaultAttributes().iterator();
        OrmReadOnlyPersistentAttribute virtualAttribute = (OrmReadOnlyPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)virtualAttribute.getName());
        virtualAttribute = (OrmReadOnlyPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"name", (String)virtualAttribute.getName());
    }

    public void testMakeVirtualNoUnderlyingJavaAttribute() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)2, (int)ormPersistentType.getDefaultAttributesSize());
        ((OrmReadOnlyPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next()).addToXml();
        ((OrmReadOnlyPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next()).addToXml();
        ((OrmPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next()).getMapping().setName("noJavaAttribute");
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)1, (int)ormPersistentType.getDefaultAttributesSize());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)2, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        specifiedOrmPersistentAttribute.removeFromXml();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)1, (int)ormPersistentType.getDefaultAttributesSize());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)((OrmReadOnlyPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next()).getName());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"name", (String)((OrmPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next()).getName());
    }

    public void testVirtualMappingTypeWhenMetadataComplete() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getMappingKey());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"FOO", (String)((IdMapping)ormPersistentAttribute.getMapping()).getColumn().getName());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMappingKey());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)((BasicMapping)ormPersistentAttribute.getMapping()).getColumn().getName());
    }

    public void testVirtualMappingTypeWhenMetadataComplete2() throws Exception {
        this.createTestEntityOneToOneMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"address", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMappingKey());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"address", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)ormPersistentAttribute.getMappingKey());
    }

    public void testGetJavaPersistentAttribute() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        JavaPersistentAttribute javaPersistentAttribute = javaPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        JavaResourceAttribute javaResourceAttribute = ormPersistentAttribute.getJavaPersistentAttribute().getResourceAttribute();
        GenericOrmPersistentAttribute2_0Tests.assertTrue((javaResourceAttribute.getKind() == JavaResourceAnnotatedElement.Kind.FIELD ? 1 : 0) != 0);
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)javaResourceAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertEquals(javaPersistentType.getJavaResourceType().getFields().iterator().next(), (Object)javaResourceAttribute);
        ormPersistentAttribute.addToXml();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        ((OrmPersistentAttribute)ormPersistentAttribute).removeFromXml();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        ormPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        ListIterator attributes = ormPersistentType.getAttributes().iterator();
        OrmReadOnlyPersistentAttribute idFieldAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        OrmReadOnlyPersistentAttribute idPropertyAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)ormPersistentAttribute, (Object)idFieldAttribute);
        GenericOrmPersistentAttribute2_0Tests.assertNotSame((Object)ormPersistentAttribute, (Object)idPropertyAttribute);
        ormPersistentAttribute = idPropertyAttribute;
        GenericOrmPersistentAttribute2_0Tests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getJavaPersistentAttribute().getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)idFieldAttribute.getJavaPersistentAttribute().getAccess());
        javaResourceAttribute = ormPersistentAttribute.getJavaPersistentAttribute().getResourceAttribute();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)javaResourceAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertEquals(javaPersistentType.getJavaResourceType().getMethods().iterator().next(), (Object)javaResourceAttribute);
        ormPersistentType.setSpecifiedAccess(null);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        OrmPersistentAttribute ormPersistentAttribute2 = ormPersistentAttribute.addToXml();
        ormPersistentAttribute2.getMapping().setName("id2");
        GenericOrmPersistentAttribute2_0Tests.assertEquals(null, (Object)ormPersistentAttribute2.getJavaPersistentAttribute());
        ormPersistentAttribute2.getMapping().setName(null);
        GenericOrmPersistentAttribute2_0Tests.assertEquals(null, (Object)ormPersistentAttribute2.getJavaPersistentAttribute());
        ormPersistentAttribute2.getMapping().setName("id");
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute2.getJavaPersistentAttribute());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute2.getJavaPersistentAttribute());
    }

    public void testGetJavaPersistentAttributeMixedAccess() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        ListIterator attributes = ormPersistentType.getAttributes().iterator();
        OrmReadOnlyPersistentAttribute ormFieldAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        OrmReadOnlyPersistentAttribute ormPropertyAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        JavaPersistentAttribute javaPersistentAttribute = javaPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormFieldAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPropertyAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getOwningPersistentType().getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)ormFieldAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)ormPropertyAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPropertyAttribute.getJavaPersistentAttribute());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)ormFieldAttribute.getMappingKey());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"basic", (String)ormPropertyAttribute.getMappingKey());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)javaPersistentAttribute.getMappingKey());
        ormPropertyAttribute.addToXml();
        ormPropertyAttribute = ormPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)ormPropertyAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPropertyAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPropertyAttribute.getJavaPersistentAttribute());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((ormPropertyAttribute.getJavaPersistentAttribute().getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.METHOD ? 1 : 0) != 0);
        GenericOrmPersistentAttribute2_0Tests.assertTrue((javaPersistentAttribute.getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.FIELD ? 1 : 0) != 0);
        ((OrmPersistentAttribute)ormPropertyAttribute).setSpecifiedAccess(AccessType.FIELD);
        ormPropertyAttribute = ormPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)ormPropertyAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPropertyAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)javaPersistentAttribute, (Object)ormPropertyAttribute.getJavaPersistentAttribute());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((ormPropertyAttribute.getJavaPersistentAttribute().getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.FIELD ? 1 : 0) != 0);
        GenericOrmPersistentAttribute2_0Tests.assertTrue((javaPersistentAttribute.getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.FIELD ? 1 : 0) != 0);
    }

    public void testGetAccess() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        JavaPersistentAttribute javaPersistentAttribute = javaPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((ormPersistentAttribute.getJavaPersistentAttribute().getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.FIELD ? 1 : 0) != 0);
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((javaPersistentAttribute.getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.FIELD ? 1 : 0) != 0);
        ormPersistentAttribute.addToXml();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((ormPersistentAttribute.getJavaPersistentAttribute().getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.FIELD ? 1 : 0) != 0);
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((javaPersistentAttribute.getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.FIELD ? 1 : 0) != 0);
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getJavaPersistentAttribute().getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((javaPersistentAttribute.getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.FIELD ? 1 : 0) != 0);
    }

    public void testGetAccessPropertyInJava() throws Exception {
        this.createTestEntityIdMappingPropertyAccess();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        JavaPersistentAttribute javaPersistentAttribute = javaPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((ormPersistentAttribute.getJavaPersistentAttribute().getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.METHOD ? 1 : 0) != 0);
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((javaPersistentAttribute.getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.METHOD ? 1 : 0) != 0);
        ormPersistentAttribute.addToXml();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((ormPersistentAttribute.getJavaPersistentAttribute().getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.METHOD ? 1 : 0) != 0);
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((javaPersistentAttribute.getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.METHOD ? 1 : 0) != 0);
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getJavaPersistentAttribute().getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((javaPersistentAttribute.getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.METHOD ? 1 : 0) != 0);
    }

    public void testGetAccessPropertyInJava2() throws Exception {
        this.createTestEntityAnnotatedFieldPropertySpecified();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        JavaPersistentAttribute javaPersistentAttribute = javaPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((ormPersistentAttribute.getJavaPersistentAttribute().getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.METHOD ? 1 : 0) != 0);
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((javaPersistentAttribute.getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.METHOD ? 1 : 0) != 0);
        OrmReadOnlyPersistentAttribute nameOrmPersistentAttribute = ormPersistentType.getAttributeNamed("name");
        JavaPersistentAttribute nameJavaPersistentAttribute = javaPersistentType.getAttributeNamed("name");
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)nameOrmPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)nameOrmPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((nameOrmPersistentAttribute.getJavaPersistentAttribute().getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.FIELD ? 1 : 0) != 0);
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)nameJavaPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((nameJavaPersistentAttribute.getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.FIELD ? 1 : 0) != 0);
        ormPersistentAttribute.addToXml();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((ormPersistentAttribute.getJavaPersistentAttribute().getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.METHOD ? 1 : 0) != 0);
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((javaPersistentAttribute.getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.METHOD ? 1 : 0) != 0);
        nameOrmPersistentAttribute.addToXml();
        nameOrmPersistentAttribute = ormPersistentType.getAttributeNamed("name");
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)nameOrmPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)nameOrmPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)nameOrmPersistentAttribute.getJavaPersistentAttribute().getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((nameOrmPersistentAttribute.getJavaPersistentAttribute().getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.FIELD ? 1 : 0) != 0);
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)nameJavaPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((nameJavaPersistentAttribute.getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.FIELD ? 1 : 0) != 0);
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)nameJavaPersistentAttribute, (Object)nameOrmPersistentAttribute.getJavaPersistentAttribute());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getJavaPersistentAttribute().getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((javaPersistentAttribute.getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.METHOD ? 1 : 0) != 0);
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)nameOrmPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)nameOrmPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertNotSame((Object)javaPersistentAttribute, (Object)nameOrmPersistentAttribute.getJavaPersistentAttribute());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)nameOrmPersistentAttribute.getJavaPersistentAttribute().getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)nameJavaPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((nameJavaPersistentAttribute.getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.FIELD ? 1 : 0) != 0);
    }
}

