/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericOrmPersistentType2_0Tests
extends Generic2_0ContextModelTestCase {
    public GenericOrmPersistentType2_0Tests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntityIdMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Column"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
                sb.append("@Column(name=\"FOO\")");
            }
        });
    }

    private ICompilationUnit createTestEntityAnnotatedFieldPropertySpecified() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "javax.persistence.Id", "javax.persistence.Access", "javax.persistence.AccessType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append("@Access(AccessType.PROPERTY)");
            }

            public void appendNameFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic");
                sb.append("@Access(AccessType.FIELD)");
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestEntityFieldSpecifiedPropertyAnnotated() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "javax.persistence.Id", "javax.persistence.Access", "javax.persistence.AccessType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append("@Access(AccessType.FIELD)");
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
                sb.append("@Access(AccessType.PROPERTY)");
            }
        });
    }

    private ICompilationUnit createTestEntityPropertySpecified() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Access", "javax.persistence.AccessType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append("@Access(AccessType.PROPERTY)");
            }
        });
    }

    public void testGetAccessWithJavaAnnotations() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getAccess());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
        GenericOrmPersistentType2_0Tests.assertEquals(null, (Object)javaPersistentType.getSpecifiedAccess());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        ormPersistentAttribute.addToXml();
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getAccess());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
        GenericOrmPersistentType2_0Tests.assertEquals(null, (Object)javaPersistentType.getSpecifiedAccess());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getAccess());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
    }

    public void testGetAccessWithJavaAnnotationsProperty() throws Exception {
        this.createTestEntityAnnotatedFieldPropertySpecified();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentType.getAccess());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getAccess());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getSpecifiedAccess());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        ormPersistentAttribute.addToXml();
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentType.getAccess());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getAccess());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getSpecifiedAccess());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getAccess());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getAccess());
    }

    public void testVirtualAttributes() throws Exception {
        this.createTestEntityAnnotatedFieldPropertySpecified();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ListIterator virtualAttributes = ormPersistentType.getDefaultAttributes().iterator();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentType2_0Tests.assertEquals((String)"name", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentType2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentType2_0Tests.assertFalse((boolean)virtualAttributes.hasNext());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        virtualAttributes = ormPersistentType.getDefaultAttributes().iterator();
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentType2_0Tests.assertEquals((String)"name", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentType2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentType2_0Tests.assertFalse((boolean)virtualAttributes.hasNext());
    }

    public void testVirtualAttributes2() throws Exception {
        this.createTestEntityPropertySpecified();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ListIterator virtualAttributes = ormPersistentType.getDefaultAttributes().iterator();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentType2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentType2_0Tests.assertFalse((boolean)virtualAttributes.hasNext());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        virtualAttributes = ormPersistentType.getDefaultAttributes().iterator();
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentType2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentType2_0Tests.assertEquals((String)"name", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentType2_0Tests.assertFalse((boolean)virtualAttributes.hasNext());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.FALSE);
        virtualAttributes = ormPersistentType.getDefaultAttributes().iterator();
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentType2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentType2_0Tests.assertFalse((boolean)virtualAttributes.hasNext());
    }

    public void testVirtualAttributes3() throws Exception {
        this.createTestEntityFieldSpecifiedPropertyAnnotated();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ListIterator virtualAttributes = ormPersistentType.getDefaultAttributes().iterator();
        OrmReadOnlyPersistentAttribute virtualAttribute = (OrmReadOnlyPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentType2_0Tests.assertEquals((String)"id", (String)virtualAttribute.getName());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)virtualAttribute.getAccess());
        virtualAttribute = (OrmReadOnlyPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentType2_0Tests.assertEquals((String)"name", (String)virtualAttribute.getName());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)virtualAttribute.getAccess());
        virtualAttribute = (OrmReadOnlyPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentType2_0Tests.assertEquals((String)"id", (String)virtualAttribute.getName());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)virtualAttribute.getAccess());
        GenericOrmPersistentType2_0Tests.assertFalse((boolean)virtualAttributes.hasNext());
        virtualAttribute.addToXml();
        virtualAttributes = ormPersistentType.getDefaultAttributes().iterator();
        virtualAttribute = (OrmReadOnlyPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentType2_0Tests.assertEquals((String)"name", (String)virtualAttribute.getName());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)virtualAttribute.getAccess());
        virtualAttribute = (OrmReadOnlyPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentType2_0Tests.assertEquals((String)"id", (String)virtualAttribute.getName());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)virtualAttribute.getAccess());
        GenericOrmPersistentType2_0Tests.assertFalse((boolean)virtualAttributes.hasNext());
        OrmPersistentAttribute specifiedAttribute = (OrmPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        GenericOrmPersistentType2_0Tests.assertEquals((String)"id", (String)specifiedAttribute.getName());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)specifiedAttribute.getSpecifiedAccess());
        virtualAttributes = ormPersistentType.getDefaultAttributes().iterator();
        virtualAttributes.next();
        ((OrmReadOnlyPersistentAttribute)virtualAttributes.next()).addToXml();
        virtualAttributes = ormPersistentType.getDefaultAttributes().iterator();
        virtualAttribute = (OrmReadOnlyPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentType2_0Tests.assertEquals((String)"name", (String)virtualAttribute.getName());
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)virtualAttribute.getAccess());
        GenericOrmPersistentType2_0Tests.assertFalse((boolean)virtualAttributes.hasNext());
    }

    public void testGetDefaultAccess() throws Exception {
        this.createTestEntityPropertySpecified();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentType.getDefaultAccess());
        javaPersistentType.setSpecifiedAccess(AccessType.FIELD);
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getDefaultAccess());
        javaPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentType.getDefaultAccess());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        GenericOrmPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getDefaultAccess());
    }
}

