/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.Access2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.java.AccessType;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java.JavaResourceModel2_0TestCase;

public class Access2_0AnnotationTests
extends JavaResourceModel2_0TestCase {
    public Access2_0AnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestAccessOnType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Access", "javax.persistence.AccessType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Access(AccessType.PROPERTY)");
            }
        });
    }

    private ICompilationUnit createTestAccessOnField() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Access", "javax.persistence.AccessType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Access(AccessType.FIELD)");
            }
        });
    }

    private ICompilationUnit createTestAccessOnProperty() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Access", "javax.persistence.AccessType"});
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Access(AccessType.PROPERTY)");
            }
        });
    }

    public void testGetAccessOnType() throws Exception {
        ICompilationUnit cu = this.createTestAccessOnType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        Access2_0Annotation access = (Access2_0Annotation)resourceType.getAnnotation("javax.persistence.Access");
        Access2_0AnnotationTests.assertNotNull((Object)access);
        Access2_0AnnotationTests.assertEquals((Object)AccessType.PROPERTY, (Object)access.getValue());
    }

    public void testSetAccessOnType() throws Exception {
        ICompilationUnit cu = this.createTestType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        Access2_0Annotation access = (Access2_0Annotation)resourceType.getAnnotation("javax.persistence.Access");
        Access2_0AnnotationTests.assertNull((Object)access);
        resourceType.addAnnotation("javax.persistence.Access");
        this.assertSourceContains("@Access", cu);
        access = (Access2_0Annotation)resourceType.getAnnotation("javax.persistence.Access");
        Access2_0AnnotationTests.assertNotNull((Object)access);
        access.setValue(AccessType.FIELD);
        Access2_0AnnotationTests.assertEquals((Object)AccessType.FIELD, (Object)access.getValue());
        this.assertSourceContains("@Access(FIELD)", cu);
        access.setValue(AccessType.PROPERTY);
        Access2_0AnnotationTests.assertEquals((Object)AccessType.PROPERTY, (Object)access.getValue());
        this.assertSourceContains("@Access(PROPERTY)", cu);
        access.setValue(null);
        this.assertSourceDoesNotContain("@Access(", cu);
    }

    public void testGetAccessOnField() throws Exception {
        ICompilationUnit cu = this.createTestAccessOnField();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        Access2_0Annotation access = (Access2_0Annotation)resourceField.getAnnotation("javax.persistence.Access");
        Access2_0AnnotationTests.assertNotNull((Object)access);
        Access2_0AnnotationTests.assertEquals((Object)AccessType.FIELD, (Object)access.getValue());
    }

    public void testSetAccessOnField() throws Exception {
        ICompilationUnit cu = this.createTestType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        Access2_0Annotation access = (Access2_0Annotation)resourceField.getAnnotation("javax.persistence.Access");
        Access2_0AnnotationTests.assertNull((Object)access);
        resourceField.addAnnotation("javax.persistence.Access");
        this.assertSourceContains("@Access", cu);
        access = (Access2_0Annotation)resourceField.getAnnotation("javax.persistence.Access");
        Access2_0AnnotationTests.assertNotNull((Object)access);
        access.setValue(AccessType.FIELD);
        Access2_0AnnotationTests.assertEquals((Object)AccessType.FIELD, (Object)access.getValue());
        this.assertSourceContains("@Access(FIELD)", cu);
        access.setValue(AccessType.PROPERTY);
        Access2_0AnnotationTests.assertEquals((Object)AccessType.PROPERTY, (Object)access.getValue());
        this.assertSourceContains("@Access(PROPERTY)", cu);
        access.setValue(null);
        this.assertSourceDoesNotContain("@Access(", cu);
    }

    public void testGetAccessOnProperty() throws Exception {
        ICompilationUnit cu = this.createTestAccessOnProperty();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceMethod resourceMethod = (JavaResourceMethod)CollectionTools.get((Iterable)resourceType.getMethods(), (int)0);
        Access2_0Annotation access = (Access2_0Annotation)resourceMethod.getAnnotation("javax.persistence.Access");
        Access2_0AnnotationTests.assertNotNull((Object)access);
        Access2_0AnnotationTests.assertEquals((Object)AccessType.PROPERTY, (Object)access.getValue());
    }

    public void testSetAccessOnProperty() throws Exception {
        ICompilationUnit cu = this.createTestType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceMethod resourceMethod = (JavaResourceMethod)CollectionTools.get((Iterable)resourceType.getMethods(), (int)0);
        Access2_0Annotation access = (Access2_0Annotation)resourceMethod.getAnnotation("javax.persistence.Access");
        Access2_0AnnotationTests.assertNull((Object)access);
        resourceMethod.addAnnotation("javax.persistence.Access");
        this.assertSourceContains("@Access", cu);
        access = (Access2_0Annotation)resourceMethod.getAnnotation("javax.persistence.Access");
        Access2_0AnnotationTests.assertNotNull((Object)access);
        access.setValue(AccessType.FIELD);
        Access2_0AnnotationTests.assertEquals((Object)AccessType.FIELD, (Object)access.getValue());
        this.assertSourceContains("@Access(FIELD)", cu);
        access.setValue(AccessType.PROPERTY);
        Access2_0AnnotationTests.assertEquals((Object)AccessType.PROPERTY, (Object)access.getValue());
        this.assertSourceContains("@Access(PROPERTY)", cu);
        access.setValue(null);
        this.assertSourceDoesNotContain("@Access(", cu);
    }
}

