/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMember;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.AssociationOverride2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JoinTableAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java.JavaResourceModel2_0TestCase;

public class AssociationOverride2_0Tests
extends JavaResourceModel2_0TestCase {
    private static final String ASSOCIATION_OVERRIDE_NAME = "MY_ASSOCIATION_OVERRIDE";
    private static final String JOIN_TABLE_NAME = "MY_JOIN_TABLE";
    private static final String CATALOG_NAME = "MY_CATALOG";
    private static final String SCHEMA_NAME = "MY_SCHEMA";

    public AssociationOverride2_0Tests(String name) {
        super(name);
    }

    private ICompilationUnit createTestAssociationOverrideOnField() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.AssociationOverride"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\")");
            }
        });
    }

    private ICompilationUnit createTestAssociationOverrideOnType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.AssociationOverride"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\")");
            }
        });
    }

    private ICompilationUnit createTestAssociationOverrideWithJoinColumns() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.AssociationOverride", "javax.persistence.JoinColumn"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"BAR\"), @JoinColumn})");
            }
        });
    }

    private ICompilationUnit createTestAssociationOverrideWithJoinTable() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.AssociationOverride", "javax.persistence.JoinTable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(name = \"MY_JOIN_TABLE\"))");
            }
        });
    }

    private ICompilationUnit createTestAssociationOverrideJoinTableWithCatalog() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.AssociationOverride", "javax.persistence.JoinTable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(catalog = \"MY_CATALOG\"))");
            }
        });
    }

    private ICompilationUnit createTestAssociationOverrideJoinTableWithSchema() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.AssociationOverride", "javax.persistence.JoinTable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(schema = \"MY_SCHEMA\"))");
            }
        });
    }

    private ICompilationUnit createTestAssociationOverrideJoinTableWithUniqueConstraints() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.AssociationOverride", "javax.persistence.JoinTable", "javax.persistence.UniqueConstraint"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(uniqueConstraints = {@UniqueConstraint(columnNames = {\"BAR\"}), @UniqueConstraint(columnNames = {\"FOO\"}), @UniqueConstraint(columnNames = {\"BAZ\"})}))");
            }
        });
    }

    private ICompilationUnit createTestAssociationOverrideJoinTableWithJoinColumns() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.AssociationOverride", "javax.persistence.JoinTable", "javax.persistence.JoinColumn"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(joinColumns = {@JoinColumn(name = \"BAR\"), @JoinColumn}))");
            }
        });
    }

    private ICompilationUnit createTestAssociationOverrideJoinTableWithInverseJoinColumns() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.AssociationOverride", "javax.persistence.JoinTable", "javax.persistence.JoinColumn"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(inverseJoinColumns = {@JoinColumn(name = \"BAR\"), @JoinColumn}))");
            }
        });
    }

    private AssociationOverride2_0Annotation associationOverrideAt(int index, JavaResourceMember resourceMember) {
        return (AssociationOverride2_0Annotation)resourceMember.getAnnotation(index, "javax.persistence.AssociationOverride");
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnField();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceField);
        AssociationOverride2_0Tests.assertNotNull((Object)associationOverride);
        AssociationOverride2_0Tests.assertEquals((String)ASSOCIATION_OVERRIDE_NAME, (String)associationOverride.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnField();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceField);
        AssociationOverride2_0Tests.assertNotNull((Object)associationOverride);
        AssociationOverride2_0Tests.assertEquals((String)ASSOCIATION_OVERRIDE_NAME, (String)associationOverride.getName());
        associationOverride.setName("Foo");
        AssociationOverride2_0Tests.assertEquals((String)"Foo", (String)associationOverride.getName());
        this.assertSourceContains("@AssociationOverride(name = \"Foo\")", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnField();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceField);
        AssociationOverride2_0Tests.assertEquals((String)ASSOCIATION_OVERRIDE_NAME, (String)associationOverride.getName());
        associationOverride.setName(null);
        AssociationOverride2_0Tests.assertNull((Object)associationOverride.getName());
        this.assertSourceDoesNotContain("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\")", cu);
        this.assertSourceContains("@AssociationOverride", cu);
    }

    public void testJoinColumns() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnField();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceField);
        AssociationOverride2_0Tests.assertEquals((int)0, (int)associationOverride.getJoinColumnsSize());
    }

    public void testJoinColumns2() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnField();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceField);
        associationOverride.addJoinColumn(0);
        associationOverride.addJoinColumn(1);
        AssociationOverride2_0Tests.assertEquals((int)2, (int)associationOverride.getJoinColumnsSize());
    }

    public void testJoinColumns3() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceField);
        AssociationOverride2_0Tests.assertEquals((int)2, (int)associationOverride.getJoinColumnsSize());
    }

    public void testAddJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnField();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceField);
        associationOverride.addJoinColumn(0).setName("FOO");
        associationOverride.addJoinColumn(1);
        associationOverride.addJoinColumn(0).setName("BAR");
        AssociationOverride2_0Tests.assertEquals((String)"BAR", (String)associationOverride.joinColumnAt(0).getName());
        AssociationOverride2_0Tests.assertEquals((String)"FOO", (String)associationOverride.joinColumnAt(1).getName());
        AssociationOverride2_0Tests.assertNull((Object)associationOverride.joinColumnAt(2).getName());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"BAR\"),@JoinColumn(name = \"FOO\"), @JoinColumn})", cu);
    }

    public void testRemoveJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceField);
        associationOverride.addJoinColumn(0).setName("FOO");
        ListIterator joinColumns = associationOverride.getJoinColumns().iterator();
        AssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverride2_0Tests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverride2_0Tests.assertNull((Object)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverride2_0Tests.assertEquals((boolean)false, (boolean)joinColumns.hasNext());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\"), @JoinColumn})", cu);
        associationOverride.removeJoinColumn(1);
        joinColumns = associationOverride.getJoinColumns().iterator();
        AssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverride2_0Tests.assertNull((Object)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverride2_0Tests.assertEquals((boolean)false, (boolean)joinColumns.hasNext());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn})", cu);
        associationOverride.removeJoinColumn(0);
        joinColumns = associationOverride.getJoinColumns().iterator();
        AssociationOverride2_0Tests.assertNull((Object)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverride2_0Tests.assertEquals((boolean)false, (boolean)joinColumns.hasNext());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = @JoinColumn)", cu);
        associationOverride.setName(null);
        associationOverride.removeJoinColumn(0);
        this.assertSourceDoesNotContain("@AssociationOverride(", cu);
    }

    public void testMoveJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceField);
        JoinColumnAnnotation joinColumn = associationOverride.joinColumnAt(0);
        joinColumn.setReferencedColumnName("REF_NAME");
        joinColumn.setUnique(Boolean.FALSE);
        joinColumn.setNullable(Boolean.FALSE);
        joinColumn.setInsertable(Boolean.FALSE);
        joinColumn.setUpdatable(Boolean.FALSE);
        joinColumn.setColumnDefinition("COLUMN_DEF");
        joinColumn.setTable("TABLE");
        associationOverride.addJoinColumn(0).setName("FOO");
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"), @JoinColumn})", cu);
        associationOverride.moveJoinColumn(2, 0);
        AssociationOverride2_0Tests.assertEquals((String)"BAR", (String)associationOverride.joinColumnAt(0).getName());
        AssociationOverride2_0Tests.assertNull((Object)associationOverride.joinColumnAt(1).getName());
        AssociationOverride2_0Tests.assertEquals((String)"FOO", (String)associationOverride.joinColumnAt(2).getName());
        AssociationOverride2_0Tests.assertEquals((int)3, (int)associationOverride.getJoinColumnsSize());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"), @JoinColumn, @JoinColumn(name = \"FOO\")})", cu);
    }

    public void testMoveJoinColumn2() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceField);
        JoinColumnAnnotation joinColumn = associationOverride.joinColumnAt(0);
        joinColumn.setReferencedColumnName("REF_NAME");
        joinColumn.setUnique(Boolean.FALSE);
        joinColumn.setNullable(Boolean.FALSE);
        joinColumn.setInsertable(Boolean.FALSE);
        joinColumn.setUpdatable(Boolean.FALSE);
        joinColumn.setColumnDefinition("COLUMN_DEF");
        joinColumn.setTable("TABLE");
        associationOverride.addJoinColumn(0).setName("FOO");
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"), @JoinColumn})", cu);
        associationOverride.moveJoinColumn(0, 2);
        AssociationOverride2_0Tests.assertNull((Object)associationOverride.joinColumnAt(0).getName());
        AssociationOverride2_0Tests.assertEquals((String)"FOO", (String)associationOverride.joinColumnAt(1).getName());
        AssociationOverride2_0Tests.assertEquals((String)"BAR", (String)associationOverride.joinColumnAt(2).getName());
        AssociationOverride2_0Tests.assertEquals((int)3, (int)associationOverride.getJoinColumnsSize());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn, @JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\")})", cu);
    }

    public void testSetJoinColumnName() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceField);
        AssociationOverride2_0Tests.assertEquals((int)2, (int)associationOverride.getJoinColumnsSize());
        JoinColumnAnnotation joinColumn = associationOverride.joinColumnAt(0);
        AssociationOverride2_0Tests.assertEquals((String)"BAR", (String)joinColumn.getName());
        joinColumn.setName("foo");
        AssociationOverride2_0Tests.assertEquals((String)"foo", (String)joinColumn.getName());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"foo\"), @JoinColumn})", cu);
    }

    public void testGetNullJoinTable() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation joinTable = associationOverride.getJoinTable();
        AssociationOverride2_0Tests.assertNotNull((Object)associationOverride);
        AssociationOverride2_0Tests.assertNull((Object)joinTable);
    }

    public void testJoinTableGetName() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation joinTable = associationOverride.getJoinTable();
        AssociationOverride2_0Tests.assertEquals((String)JOIN_TABLE_NAME, (String)joinTable.getName());
    }

    public void testJoinTableSetName() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation joinTable = associationOverride.getJoinTable();
        AssociationOverride2_0Tests.assertEquals((String)JOIN_TABLE_NAME, (String)joinTable.getName());
        joinTable.setName("Foo");
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(name = \"Foo\"))", cu);
        joinTable.setName(null);
        AssociationOverride2_0Tests.assertNull((Object)associationOverride.getJoinTable().getName());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable)", cu);
    }

    public void testAddJoinTable() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation joinTable = associationOverride.getJoinTable();
        AssociationOverride2_0Tests.assertNull((Object)joinTable);
        associationOverride.addJoinTable();
        joinTable = associationOverride.getJoinTable();
        AssociationOverride2_0Tests.assertNotNull((Object)joinTable);
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable)", cu);
    }

    public void testRemoveJoinTable() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation joinTable = associationOverride.getJoinTable();
        AssociationOverride2_0Tests.assertNull((Object)joinTable);
    }

    public void testJoinTableGetCatalog() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithCatalog();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation table = associationOverride.getJoinTable();
        AssociationOverride2_0Tests.assertNotNull((Object)table);
        AssociationOverride2_0Tests.assertEquals((String)CATALOG_NAME, (String)table.getCatalog());
    }

    public void testJoinTableSetCatalog() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation table = associationOverride.getJoinTable();
        AssociationOverride2_0Tests.assertNotNull((Object)table);
        AssociationOverride2_0Tests.assertNull((Object)table.getCatalog());
        table.setCatalog("Foo");
        AssociationOverride2_0Tests.assertEquals((String)"Foo", (String)table.getCatalog());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(name = \"MY_JOIN_TABLE\", catalog = \"Foo\"))", cu);
    }

    public void testJoinTableSetCatalogNull() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithCatalog();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation table = associationOverride.getJoinTable();
        AssociationOverride2_0Tests.assertEquals((String)CATALOG_NAME, (String)table.getCatalog());
        table.setCatalog(null);
        AssociationOverride2_0Tests.assertNull((Object)table.getCatalog());
        this.assertSourceDoesNotContain("@JoinTable(", cu);
    }

    public void testJoinTableGetSchema() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithSchema();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation table = associationOverride.getJoinTable();
        AssociationOverride2_0Tests.assertNotNull((Object)table);
        AssociationOverride2_0Tests.assertEquals((String)SCHEMA_NAME, (String)table.getSchema());
    }

    public void testJoinTableSetSchema() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation table = associationOverride.getJoinTable();
        AssociationOverride2_0Tests.assertNotNull((Object)table);
        AssociationOverride2_0Tests.assertNull((Object)table.getSchema());
        table.setSchema("Foo");
        AssociationOverride2_0Tests.assertEquals((String)"Foo", (String)table.getSchema());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(name = \"MY_JOIN_TABLE\", schema = \"Foo\"))", cu);
    }

    public void testJoinTableSetSchemaNull() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithSchema();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation table = associationOverride.getJoinTable();
        AssociationOverride2_0Tests.assertEquals((String)SCHEMA_NAME, (String)table.getSchema());
        table.setSchema(null);
        AssociationOverride2_0Tests.assertNull((Object)table.getSchema());
        this.assertSourceDoesNotContain("@JoinTable(", cu);
    }

    public void testJoinTableUniqueConstraints() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation table = associationOverride.getJoinTable();
        AssociationOverride2_0Tests.assertEquals((int)0, (int)table.getUniqueConstraintsSize());
    }

    public void testJoinTableUniqueConstraints2() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation table = associationOverride.getJoinTable();
        table.addUniqueConstraint(0);
        table.addUniqueConstraint(1);
        AssociationOverride2_0Tests.assertEquals((int)2, (int)table.getUniqueConstraintsSize());
    }

    public void testJoinTableUniqueConstraints3() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithUniqueConstraints();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation table = associationOverride.getJoinTable();
        AssociationOverride2_0Tests.assertEquals((int)3, (int)table.getUniqueConstraintsSize());
    }

    public void testJoinTableAddUniqueConstraint() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation table = associationOverride.getJoinTable();
        table.addUniqueConstraint(0).addColumnName("FOO");
        table.addUniqueConstraint(1);
        table.addUniqueConstraint(0).addColumnName("BAR");
        AssociationOverride2_0Tests.assertEquals((String)"BAR", (String)table.uniqueConstraintAt(0).columnNameAt(0));
        AssociationOverride2_0Tests.assertEquals((String)"FOO", (String)table.uniqueConstraintAt(1).columnNameAt(0));
        AssociationOverride2_0Tests.assertEquals((int)0, (int)table.uniqueConstraintAt(2).getColumnNamesSize());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(name = \"MY_JOIN_TABLE\", uniqueConstraints = {@UniqueConstraint(columnNames = \"BAR\"),@UniqueConstraint(columnNames = \"FOO\"), @UniqueConstraint}))", cu);
    }

    public void testJoinTableRemoveUniqueConstraint() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithUniqueConstraints();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation table = associationOverride.getJoinTable();
        AssociationOverride2_0Tests.assertEquals((String)"BAR", (String)table.uniqueConstraintAt(0).columnNameAt(0));
        AssociationOverride2_0Tests.assertEquals((String)"FOO", (String)table.uniqueConstraintAt(1).columnNameAt(0));
        AssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)table.uniqueConstraintAt(2).columnNameAt(0));
        AssociationOverride2_0Tests.assertEquals((int)3, (int)table.getUniqueConstraintsSize());
        table.removeUniqueConstraint(1);
        AssociationOverride2_0Tests.assertEquals((String)"BAR", (String)table.uniqueConstraintAt(0).columnNameAt(0));
        AssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)table.uniqueConstraintAt(1).columnNameAt(0));
        AssociationOverride2_0Tests.assertEquals((int)2, (int)table.getUniqueConstraintsSize());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(uniqueConstraints = {@UniqueConstraint(columnNames = {\"BAR\"}), @UniqueConstraint(columnNames = {\"BAZ\"})}))", cu);
        table.removeUniqueConstraint(0);
        AssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)table.uniqueConstraintAt(0).columnNameAt(0));
        AssociationOverride2_0Tests.assertEquals((int)1, (int)table.getUniqueConstraintsSize());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(uniqueConstraints = @UniqueConstraint(columnNames = {\"BAZ\"})))", cu);
        table.removeUniqueConstraint(0);
        AssociationOverride2_0Tests.assertEquals((int)0, (int)table.getUniqueConstraintsSize());
        this.assertSourceDoesNotContain("@JoinTable(", cu);
    }

    public void testJoinTableMoveUniqueConstraint() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithUniqueConstraints();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation table = associationOverride.getJoinTable();
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(uniqueConstraints = {@UniqueConstraint(columnNames = {\"BAR\"}), @UniqueConstraint(columnNames = {\"FOO\"}), @UniqueConstraint(columnNames = {\"BAZ\"})}))", cu);
        table.moveUniqueConstraint(2, 0);
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(uniqueConstraints = {@UniqueConstraint(columnNames = {\"FOO\"}), @UniqueConstraint(columnNames = {\"BAZ\"}), @UniqueConstraint(columnNames = {\"BAR\"})}))", cu);
    }

    public void testJoinTableMoveUniqueConstraint2() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithUniqueConstraints();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation table = associationOverride.getJoinTable();
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(uniqueConstraints = {@UniqueConstraint(columnNames = {\"BAR\"}), @UniqueConstraint(columnNames = {\"FOO\"}), @UniqueConstraint(columnNames = {\"BAZ\"})}))", cu);
        table.moveUniqueConstraint(0, 2);
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(uniqueConstraints = {@UniqueConstraint(columnNames = {\"BAZ\"}), @UniqueConstraint(columnNames = {\"BAR\"}), @UniqueConstraint(columnNames = {\"FOO\"})}))", cu);
    }

    public void testJoinTableJoinColumns() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation table = associationOverride.getJoinTable();
        AssociationOverride2_0Tests.assertEquals((int)0, (int)table.getJoinColumnsSize());
    }

    public void testJoinTableJoinColumns2() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation table = associationOverride.getJoinTable();
        table.addJoinColumn(0);
        table.addJoinColumn(1);
        AssociationOverride2_0Tests.assertEquals((int)2, (int)table.getJoinColumnsSize());
    }

    public void testJoinTableJoinColumns3() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation table = associationOverride.getJoinTable();
        AssociationOverride2_0Tests.assertEquals((int)2, (int)table.getJoinColumnsSize());
    }

    public void testJoinTableAddJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation table = associationOverride.getJoinTable();
        table.addJoinColumn(0).setName("FOO");
        table.addJoinColumn(1);
        table.addJoinColumn(0).setName("BAR");
        AssociationOverride2_0Tests.assertEquals((String)"BAR", (String)table.joinColumnAt(0).getName());
        AssociationOverride2_0Tests.assertEquals((String)"FOO", (String)table.joinColumnAt(1).getName());
        AssociationOverride2_0Tests.assertNull((Object)table.joinColumnAt(2).getName());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(name = \"MY_JOIN_TABLE\", joinColumns = {@JoinColumn(name = \"BAR\"),@JoinColumn(name = \"FOO\"), @JoinColumn}))", cu);
    }

    public void testJoinTableRemoveJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation table = associationOverride.getJoinTable();
        table.addJoinColumn(0).setName("FOO");
        AssociationOverride2_0Tests.assertEquals((String)"FOO", (String)table.joinColumnAt(0).getName());
        AssociationOverride2_0Tests.assertEquals((String)"BAR", (String)table.joinColumnAt(1).getName());
        AssociationOverride2_0Tests.assertNull((Object)table.joinColumnAt(2).getName());
        AssociationOverride2_0Tests.assertEquals((int)3, (int)table.getJoinColumnsSize());
        table.removeJoinColumn(1);
        AssociationOverride2_0Tests.assertEquals((String)"FOO", (String)table.joinColumnAt(0).getName());
        AssociationOverride2_0Tests.assertNull((Object)table.joinColumnAt(1).getName());
        AssociationOverride2_0Tests.assertEquals((int)2, (int)table.getJoinColumnsSize());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn}))", cu);
        table.removeJoinColumn(0);
        AssociationOverride2_0Tests.assertNull((Object)table.joinColumnAt(0).getName());
        AssociationOverride2_0Tests.assertEquals((int)1, (int)table.getJoinColumnsSize());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(joinColumns = @JoinColumn))", cu);
        table.removeJoinColumn(0);
        AssociationOverride2_0Tests.assertEquals((int)0, (int)table.getJoinColumnsSize());
        this.assertSourceDoesNotContain("@JoinTable(", cu);
    }

    public void testJoinTableMoveJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation table = associationOverride.getJoinTable();
        JoinColumnAnnotation joinColumn = table.joinColumnAt(0);
        joinColumn.setReferencedColumnName("REF_NAME");
        joinColumn.setUnique(Boolean.FALSE);
        joinColumn.setNullable(Boolean.FALSE);
        joinColumn.setInsertable(Boolean.FALSE);
        joinColumn.setUpdatable(Boolean.FALSE);
        joinColumn.setColumnDefinition("COLUMN_DEF");
        joinColumn.setTable("TABLE");
        table.addJoinColumn(0).setName("FOO");
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"), @JoinColumn}))", cu);
        table.moveJoinColumn(2, 0);
        AssociationOverride2_0Tests.assertEquals((String)"BAR", (String)table.joinColumnAt(0).getName());
        AssociationOverride2_0Tests.assertNull((Object)table.joinColumnAt(1).getName());
        AssociationOverride2_0Tests.assertEquals((String)"FOO", (String)table.joinColumnAt(2).getName());
        AssociationOverride2_0Tests.assertEquals((int)3, (int)table.getJoinColumnsSize());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(joinColumns = {@JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"), @JoinColumn, @JoinColumn(name = \"FOO\")}))", cu);
    }

    public void testJoinTableMoveJoinColumn2() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation table = associationOverride.getJoinTable();
        JoinColumnAnnotation joinColumn = table.joinColumnAt(0);
        joinColumn.setReferencedColumnName("REF_NAME");
        joinColumn.setUnique(Boolean.FALSE);
        joinColumn.setNullable(Boolean.FALSE);
        joinColumn.setInsertable(Boolean.FALSE);
        joinColumn.setUpdatable(Boolean.FALSE);
        joinColumn.setColumnDefinition("COLUMN_DEF");
        joinColumn.setTable("TABLE");
        table.addJoinColumn(0).setName("FOO");
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"), @JoinColumn}))", cu);
        table.moveJoinColumn(0, 2);
        AssociationOverride2_0Tests.assertNull((Object)table.joinColumnAt(0).getName());
        AssociationOverride2_0Tests.assertEquals((String)"FOO", (String)table.joinColumnAt(1).getName());
        AssociationOverride2_0Tests.assertEquals((String)"BAR", (String)table.joinColumnAt(2).getName());
        AssociationOverride2_0Tests.assertEquals((int)3, (int)table.getJoinColumnsSize());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(joinColumns = {@JoinColumn, @JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\")}))", cu);
    }

    public void testJoinTableSetJoinColumnName() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation table = associationOverride.getJoinTable();
        AssociationOverride2_0Tests.assertEquals((int)2, (int)table.getJoinColumnsSize());
        JoinColumnAnnotation joinColumn = table.joinColumnAt(0);
        AssociationOverride2_0Tests.assertEquals((String)"BAR", (String)joinColumn.getName());
        joinColumn.setName("foo");
        AssociationOverride2_0Tests.assertEquals((String)"foo", (String)joinColumn.getName());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(joinColumns = {@JoinColumn(name = \"foo\"), @JoinColumn}))", cu);
    }

    public void testJoinTableInverseJoinColumns() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation table = associationOverride.getJoinTable();
        AssociationOverride2_0Tests.assertEquals((int)0, (int)table.getInverseJoinColumnsSize());
    }

    public void testInverseJoinColumns2() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation table = associationOverride.getJoinTable();
        table.addInverseJoinColumn(0);
        table.addInverseJoinColumn(1);
        AssociationOverride2_0Tests.assertEquals((int)2, (int)table.getInverseJoinColumnsSize());
    }

    public void testJoinTableInverseJoinColumns3() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithInverseJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation table = associationOverride.getJoinTable();
        AssociationOverride2_0Tests.assertEquals((int)2, (int)table.getInverseJoinColumnsSize());
    }

    public void testAddInverseJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation table = associationOverride.getJoinTable();
        table.addInverseJoinColumn(0).setName("FOO");
        table.addInverseJoinColumn(1);
        table.addInverseJoinColumn(0).setName("BAR");
        AssociationOverride2_0Tests.assertEquals((String)"BAR", (String)table.inverseJoinColumnAt(0).getName());
        AssociationOverride2_0Tests.assertEquals((String)"FOO", (String)table.inverseJoinColumnAt(1).getName());
        AssociationOverride2_0Tests.assertNull((Object)table.inverseJoinColumnAt(2).getName());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(name = \"MY_JOIN_TABLE\", inverseJoinColumns = {@JoinColumn(name = \"BAR\"),@JoinColumn(name = \"FOO\"), @JoinColumn}))", cu);
    }

    public void testJoinTableRemoveInverseJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithInverseJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation table = associationOverride.getJoinTable();
        table.addInverseJoinColumn(2).setName("FOO");
        ListIterator inverseJoinColumns = table.getInverseJoinColumns().iterator();
        AssociationOverride2_0Tests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        AssociationOverride2_0Tests.assertNull((Object)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        AssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        AssociationOverride2_0Tests.assertFalse((boolean)inverseJoinColumns.hasNext());
        table.removeInverseJoinColumn(1);
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(inverseJoinColumns = {@JoinColumn(name = \"BAR\"), @JoinColumn(name = \"FOO\")}))", cu);
        inverseJoinColumns = table.getInverseJoinColumns().iterator();
        AssociationOverride2_0Tests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        AssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        AssociationOverride2_0Tests.assertFalse((boolean)inverseJoinColumns.hasNext());
        table.removeInverseJoinColumn(0);
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(inverseJoinColumns = @JoinColumn(name = \"FOO\")))", cu);
        inverseJoinColumns = table.getInverseJoinColumns().iterator();
        AssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        AssociationOverride2_0Tests.assertFalse((boolean)inverseJoinColumns.hasNext());
        table.removeInverseJoinColumn(0);
        this.assertSourceDoesNotContain("@JoinTable(", cu);
    }

    public void testJoinTableMoveInverseJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithInverseJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation table = associationOverride.getJoinTable();
        table.addInverseJoinColumn(0).setName("FOO");
        ListIterator inverseJoinColumns = table.getInverseJoinColumns().iterator();
        AssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        AssociationOverride2_0Tests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        AssociationOverride2_0Tests.assertNull((Object)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        table.moveInverseJoinColumn(2, 0);
        inverseJoinColumns = table.getInverseJoinColumns().iterator();
        AssociationOverride2_0Tests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        AssociationOverride2_0Tests.assertNull((Object)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        AssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(inverseJoinColumns = {@JoinColumn(name = \"BAR\"), @JoinColumn, @JoinColumn(name = \"FOO\")}))", cu);
    }

    public void testJoinTableMoveInverseJoinColumn2() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithInverseJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation table = associationOverride.getJoinTable();
        table.addInverseJoinColumn(1).setName("FOO");
        ListIterator inverseJoinColumns = table.getInverseJoinColumns().iterator();
        AssociationOverride2_0Tests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        AssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        AssociationOverride2_0Tests.assertNull((Object)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        table.moveInverseJoinColumn(0, 2);
        inverseJoinColumns = table.getInverseJoinColumns().iterator();
        AssociationOverride2_0Tests.assertNull((Object)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        AssociationOverride2_0Tests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        AssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(inverseJoinColumns = {@JoinColumn, @JoinColumn(name = \"BAR\"), @JoinColumn(name = \"FOO\")}))", cu);
    }

    public void testJoinTableSetInverseJoinColumnName() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithInverseJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        AssociationOverride2_0Annotation associationOverride = this.associationOverrideAt(0, (JavaResourceMember)resourceType);
        JoinTableAnnotation table = associationOverride.getJoinTable();
        AssociationOverride2_0Tests.assertEquals((int)2, (int)table.getInverseJoinColumnsSize());
        JoinColumnAnnotation joinColumn = table.inverseJoinColumnAt(0);
        AssociationOverride2_0Tests.assertEquals((String)"BAR", (String)joinColumn.getName());
        joinColumn.setName("foo");
        AssociationOverride2_0Tests.assertEquals((String)"foo", (String)joinColumn.getName());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(inverseJoinColumns = {@JoinColumn(name = \"foo\"), @JoinColumn}))", cu);
    }
}

