/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMember;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyJoinColumn2_0Annotation;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java.JavaResourceModel2_0TestCase;

public class MapKeyJoinColumn2_0AnnotationTests
extends JavaResourceModel2_0TestCase {
    private static final String COLUMN_NAME = "MY_COLUMN";
    private static final String COLUMN_TABLE = "MY_TABLE";
    private static final String COLUMN_COLUMN_DEFINITION = "COLUMN_DEFINITION";
    private static final String COLUMN_REFERENCED_COLUMN_NAME = "MY_REF_COLUMN_NAME";

    public MapKeyJoinColumn2_0AnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestJoinColumn() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MapKeyJoinColumn"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKeyJoinColumn");
            }
        });
    }

    private ICompilationUnit createTestJoinColumnWithName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MapKeyJoinColumn"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKeyJoinColumn(name = \"MY_COLUMN\")");
            }
        });
    }

    private ICompilationUnit createTestJoinColumnWithTable() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MapKeyJoinColumn"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKeyJoinColumn(table = \"MY_TABLE\")");
            }
        });
    }

    private ICompilationUnit createTestJoinColumnWithReferencedColumnName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MapKeyJoinColumn"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKeyJoinColumn(referencedColumnName = \"MY_REF_COLUMN_NAME\")");
            }
        });
    }

    private ICompilationUnit createTestJoinColumnWithColumnDefinition() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MapKeyJoinColumn"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKeyJoinColumn(columnDefinition = \"COLUMN_DEFINITION\")");
            }
        });
    }

    private ICompilationUnit createTestJoinColumnWithBooleanElement(final String booleanElement) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MapKeyJoinColumn"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKeyJoinColumn(" + booleanElement + " = true)");
            }
        });
    }

    private MapKeyJoinColumn2_0Annotation mapKeyJoinColumnAt(int index, JavaResourceMember resourceMember) {
        return (MapKeyJoinColumn2_0Annotation)resourceMember.getAnnotation(index, "javax.persistence.MapKeyJoinColumn");
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumn2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyJoinColumn2_0AnnotationTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumn2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyJoinColumn2_0AnnotationTests.assertNull((Object)column.getName());
        MapKeyJoinColumn2_0AnnotationTests.assertNull((Object)column.getNullable());
        MapKeyJoinColumn2_0AnnotationTests.assertNull((Object)column.getInsertable());
        MapKeyJoinColumn2_0AnnotationTests.assertNull((Object)column.getUnique());
        MapKeyJoinColumn2_0AnnotationTests.assertNull((Object)column.getUpdatable());
        MapKeyJoinColumn2_0AnnotationTests.assertNull((Object)column.getTable());
        MapKeyJoinColumn2_0AnnotationTests.assertNull((Object)column.getReferencedColumnName());
        MapKeyJoinColumn2_0AnnotationTests.assertNull((Object)column.getColumnDefinition());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumn2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyJoinColumn2_0AnnotationTests.assertNull((Object)column.getName());
        column.setName("Foo");
        MapKeyJoinColumn2_0AnnotationTests.assertEquals((String)"Foo", (String)column.getName());
        this.assertSourceContains("@MapKeyJoinColumn(name = \"Foo\")", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumn2_0AnnotationTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
        column.setName(null);
        MapKeyJoinColumn2_0AnnotationTests.assertNull((Object)column.getName());
        this.assertSourceDoesNotContain("@MapKeyJoinColumn(", cu);
    }

    public void testGetTable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumn2_0AnnotationTests.assertEquals((String)COLUMN_TABLE, (String)column.getTable());
    }

    public void testSetTable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumn2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyJoinColumn2_0AnnotationTests.assertNull((Object)column.getTable());
        column.setTable("Foo");
        MapKeyJoinColumn2_0AnnotationTests.assertEquals((String)"Foo", (String)column.getTable());
        this.assertSourceContains("@MapKeyJoinColumn(table = \"Foo\")", cu);
        column.setTable(null);
        this.assertSourceDoesNotContain("@MapKeyJoinColumn(", cu);
    }

    public void testGetReferencedColumnName() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithReferencedColumnName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumn2_0AnnotationTests.assertEquals((String)COLUMN_REFERENCED_COLUMN_NAME, (String)column.getReferencedColumnName());
    }

    public void testSetReferencedColumnName() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumn2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyJoinColumn2_0AnnotationTests.assertNull((Object)column.getReferencedColumnName());
        column.setReferencedColumnName("Foo");
        MapKeyJoinColumn2_0AnnotationTests.assertEquals((String)"Foo", (String)column.getReferencedColumnName());
        this.assertSourceContains("@MapKeyJoinColumn(referencedColumnName = \"Foo\")", cu);
        column.setReferencedColumnName(null);
        this.assertSourceDoesNotContain("@MapKeyJoinColumn(", cu);
    }

    public void testGetColumnDefinition() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithColumnDefinition();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumn2_0AnnotationTests.assertEquals((String)COLUMN_COLUMN_DEFINITION, (String)column.getColumnDefinition());
    }

    public void testSetColumnDefinition() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumn2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyJoinColumn2_0AnnotationTests.assertNull((Object)column.getColumnDefinition());
        column.setColumnDefinition("Foo");
        MapKeyJoinColumn2_0AnnotationTests.assertEquals((String)"Foo", (String)column.getColumnDefinition());
        this.assertSourceContains("@MapKeyJoinColumn(columnDefinition = \"Foo\")", cu);
        column.setColumnDefinition(null);
        this.assertSourceDoesNotContain("@MapKeyJoinColumn(", cu);
    }

    public void testGetUnique() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithBooleanElement("unique");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumn2_0AnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)column.getUnique());
    }

    public void testSetUnique() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumn2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyJoinColumn2_0AnnotationTests.assertNull((Object)column.getUnique());
        column.setUnique(Boolean.FALSE);
        MapKeyJoinColumn2_0AnnotationTests.assertEquals((Object)Boolean.FALSE, (Object)column.getUnique());
        this.assertSourceContains("@MapKeyJoinColumn(unique = false)", cu);
        column.setUnique(null);
        this.assertSourceDoesNotContain("@MapKeyJoinColumn(", cu);
    }

    public void testGetNullable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithBooleanElement("nullable");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumn2_0AnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)column.getNullable());
    }

    public void testSetNullable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumn2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyJoinColumn2_0AnnotationTests.assertNull((Object)column.getNullable());
        column.setNullable(Boolean.FALSE);
        MapKeyJoinColumn2_0AnnotationTests.assertEquals((Object)Boolean.FALSE, (Object)column.getNullable());
        this.assertSourceContains("@MapKeyJoinColumn(nullable = false)", cu);
        column.setNullable(null);
        this.assertSourceDoesNotContain("@MapKeyJoinColumn(", cu);
    }

    public void testGetInsertable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithBooleanElement("insertable");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumn2_0AnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)column.getInsertable());
    }

    public void testSetInsertable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumn2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyJoinColumn2_0AnnotationTests.assertNull((Object)column.getInsertable());
        column.setInsertable(Boolean.FALSE);
        MapKeyJoinColumn2_0AnnotationTests.assertEquals((Object)Boolean.FALSE, (Object)column.getInsertable());
        this.assertSourceContains("@MapKeyJoinColumn(insertable = false)", cu);
        column.setInsertable(null);
        this.assertSourceDoesNotContain("@MapKeyJoinColumn(", cu);
    }

    public void testGetUpdatable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithBooleanElement("updatable");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumn2_0AnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)column.getUpdatable());
    }

    public void testSetUpdatable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumn2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyJoinColumn2_0AnnotationTests.assertNull((Object)column.getUpdatable());
        column.setUpdatable(Boolean.FALSE);
        MapKeyJoinColumn2_0AnnotationTests.assertEquals((Object)Boolean.FALSE, (Object)column.getUpdatable());
        this.assertSourceContains("@MapKeyJoinColumn(updatable = false)", cu);
        column.setUpdatable(null);
        this.assertSourceDoesNotContain("@MapKeyJoinColumn(", cu);
    }
}

