/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMember;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyJoinColumn2_0Annotation;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java.JavaResourceModel2_0TestCase;

public class MapKeyJoinColumns2_0AnnotationTests
extends JavaResourceModel2_0TestCase {
    private static final String COLUMN_NAME = "MY_COLUMN";
    private static final String COLUMN_TABLE = "MY_TABLE";
    private static final String COLUMN_COLUMN_DEFINITION = "COLUMN_DEFINITION";
    private static final String COLUMN_REFERENCED_COLUMN_NAME = "MY_REF_COLUMN_NAME";

    public MapKeyJoinColumns2_0AnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestJoinColumns() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MapKeyJoinColumn", "javax.persistence.MapKeyJoinColumns"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKeyJoinColumns(@MapKeyJoinColumn)");
            }
        });
    }

    private ICompilationUnit createTestJoinColumnWithName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MapKeyJoinColumn", "javax.persistence.MapKeyJoinColumns"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKeyJoinColumns(@MapKeyJoinColumn(name = \"MY_COLUMN\"))");
            }
        });
    }

    private ICompilationUnit createTestJoinColumnWithTable() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MapKeyJoinColumn", "javax.persistence.MapKeyJoinColumns"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKeyJoinColumns(@MapKeyJoinColumn(table = \"MY_TABLE\"))");
            }
        });
    }

    private ICompilationUnit createTestJoinColumnWithReferencedColumnName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MapKeyJoinColumn", "javax.persistence.MapKeyJoinColumns"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKeyJoinColumns(@MapKeyJoinColumn(referencedColumnName = \"MY_REF_COLUMN_NAME\"))");
            }
        });
    }

    private ICompilationUnit createTestJoinColumnWithColumnDefinition() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MapKeyJoinColumn", "javax.persistence.MapKeyJoinColumns"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKeyJoinColumns(@MapKeyJoinColumn(columnDefinition = \"COLUMN_DEFINITION\"))");
            }
        });
    }

    private ICompilationUnit createTestJoinColumnWithBooleanElement(final String booleanElement) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MapKeyJoinColumn", "javax.persistence.MapKeyJoinColumns"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKeyJoinColumns(@MapKeyJoinColumn(" + booleanElement + " = true))");
            }
        });
    }

    private ICompilationUnit createTestJoinColumn() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MapKeyJoinColumn", "javax.persistence.MapKeyJoinColumns"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKeyJoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\")");
            }
        });
    }

    private MapKeyJoinColumn2_0Annotation mapKeyJoinColumnAt(int index, JavaResourceMember resourceMember) {
        return (MapKeyJoinColumn2_0Annotation)resourceMember.getAnnotation(index, "javax.persistence.MapKeyJoinColumn");
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumns2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyJoinColumns2_0AnnotationTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumns2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyJoinColumns2_0AnnotationTests.assertNull((Object)column.getName());
        MapKeyJoinColumns2_0AnnotationTests.assertNull((Object)column.getNullable());
        MapKeyJoinColumns2_0AnnotationTests.assertNull((Object)column.getInsertable());
        MapKeyJoinColumns2_0AnnotationTests.assertNull((Object)column.getUnique());
        MapKeyJoinColumns2_0AnnotationTests.assertNull((Object)column.getUpdatable());
        MapKeyJoinColumns2_0AnnotationTests.assertNull((Object)column.getTable());
        MapKeyJoinColumns2_0AnnotationTests.assertNull((Object)column.getColumnDefinition());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumns2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyJoinColumns2_0AnnotationTests.assertNull((Object)column.getName());
        column.setName("Foo");
        MapKeyJoinColumns2_0AnnotationTests.assertEquals((String)"Foo", (String)column.getName());
        this.assertSourceContains("@MapKeyJoinColumns(@MapKeyJoinColumn(name = \"Foo\"))", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumns2_0AnnotationTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
        column.setName(null);
        MapKeyJoinColumns2_0AnnotationTests.assertNull((Object)column.getName());
        this.assertSourceDoesNotContain("@MapKeyJoinColumn(", cu);
    }

    public void testGetTable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumns2_0AnnotationTests.assertEquals((String)COLUMN_TABLE, (String)column.getTable());
    }

    public void testSetTable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumns2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyJoinColumns2_0AnnotationTests.assertNull((Object)column.getTable());
        column.setTable("Foo");
        MapKeyJoinColumns2_0AnnotationTests.assertEquals((String)"Foo", (String)column.getTable());
        this.assertSourceContains("@MapKeyJoinColumns(@MapKeyJoinColumn(table = \"Foo\"))", cu);
        column.setTable(null);
        this.assertSourceDoesNotContain("@MapKeyJoinColumn(", cu);
    }

    public void testGetReferencedColumnName() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithReferencedColumnName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumns2_0AnnotationTests.assertEquals((String)COLUMN_REFERENCED_COLUMN_NAME, (String)column.getReferencedColumnName());
    }

    public void testSetReferencedColumnName() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumns2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyJoinColumns2_0AnnotationTests.assertNull((Object)column.getReferencedColumnName());
        column.setReferencedColumnName("Foo");
        MapKeyJoinColumns2_0AnnotationTests.assertEquals((String)"Foo", (String)column.getReferencedColumnName());
        this.assertSourceContains("@MapKeyJoinColumns(@MapKeyJoinColumn(referencedColumnName = \"Foo\"))", cu);
        column.setReferencedColumnName(null);
        this.assertSourceDoesNotContain("@MapKeyJoinColumn(", cu);
    }

    public void testGetColumnDefinition() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithColumnDefinition();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumns2_0AnnotationTests.assertEquals((String)COLUMN_COLUMN_DEFINITION, (String)column.getColumnDefinition());
    }

    public void testSetColumnDefinition() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumns2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyJoinColumns2_0AnnotationTests.assertNull((Object)column.getColumnDefinition());
        column.setColumnDefinition("Foo");
        MapKeyJoinColumns2_0AnnotationTests.assertEquals((String)"Foo", (String)column.getColumnDefinition());
        this.assertSourceContains("@MapKeyJoinColumns(@MapKeyJoinColumn(columnDefinition = \"Foo\"))", cu);
        column.setColumnDefinition(null);
        this.assertSourceDoesNotContain("@MapKeyJoinColumn(", cu);
    }

    public void testGetUnique() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithBooleanElement("unique");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumns2_0AnnotationTests.assertTrue((boolean)column.getUnique());
    }

    public void testSetUnique() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumns2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyJoinColumns2_0AnnotationTests.assertNull((Object)column.getUnique());
        column.setUnique(Boolean.FALSE);
        MapKeyJoinColumns2_0AnnotationTests.assertFalse((boolean)column.getUnique());
        this.assertSourceContains("@MapKeyJoinColumns(@MapKeyJoinColumn(unique = false))", cu);
        column.setUnique(null);
        this.assertSourceDoesNotContain("@MapKeyJoinColumn(", cu);
    }

    public void testGetNullable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithBooleanElement("nullable");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumns2_0AnnotationTests.assertTrue((boolean)column.getNullable());
    }

    public void testSetNullable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumns2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyJoinColumns2_0AnnotationTests.assertNull((Object)column.getNullable());
        column.setNullable(Boolean.FALSE);
        MapKeyJoinColumns2_0AnnotationTests.assertFalse((boolean)column.getNullable());
        this.assertSourceContains("@MapKeyJoinColumns(@MapKeyJoinColumn(nullable = false))", cu);
        column.setNullable(null);
        this.assertSourceDoesNotContain("@MapKeyJoinColumn(", cu);
    }

    public void testGetInsertable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithBooleanElement("insertable");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumns2_0AnnotationTests.assertTrue((boolean)column.getInsertable());
    }

    public void testSetInsertable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumns2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyJoinColumns2_0AnnotationTests.assertNull((Object)column.getInsertable());
        column.setInsertable(Boolean.FALSE);
        MapKeyJoinColumns2_0AnnotationTests.assertFalse((boolean)column.getInsertable());
        this.assertSourceContains("@MapKeyJoinColumns(@MapKeyJoinColumn(insertable = false))", cu);
        column.setInsertable(null);
        this.assertSourceDoesNotContain("@MapKeyJoinColumn(", cu);
    }

    public void testGetUpdatable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithBooleanElement("updatable");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumns2_0AnnotationTests.assertTrue((boolean)column.getUpdatable());
    }

    public void testSetUpdatable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyJoinColumn2_0Annotation column = this.mapKeyJoinColumnAt(0, (JavaResourceMember)resourceField);
        MapKeyJoinColumns2_0AnnotationTests.assertNotNull((Object)column);
        MapKeyJoinColumns2_0AnnotationTests.assertNull((Object)column.getUpdatable());
        column.setUpdatable(Boolean.FALSE);
        MapKeyJoinColumns2_0AnnotationTests.assertFalse((boolean)column.getUpdatable());
        this.assertSourceContains("@MapKeyJoinColumns(@MapKeyJoinColumn(updatable = false))", cu);
        column.setUpdatable(null);
        this.assertSourceDoesNotContain("@MapKeyJoinColumn(", cu);
    }

    public void testAddJoinColumnCopyExisting() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        String expected1 = "@MapKeyJoinColumns({";
        String expected2 = "@MapKeyJoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"),";
        String expected3 = "@MapKeyJoinColumn(name = \"FOO\") })";
        MapKeyJoinColumn2_0Annotation joinColumn = (MapKeyJoinColumn2_0Annotation)resourceField.addAnnotation(1, "javax.persistence.MapKeyJoinColumn");
        joinColumn.setName("FOO");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        MapKeyJoinColumns2_0AnnotationTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyJoinColumn"));
        MapKeyJoinColumns2_0AnnotationTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyJoinColumns"));
        MapKeyJoinColumns2_0AnnotationTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.MapKeyJoinColumn"));
        MapKeyJoinColumns2_0AnnotationTests.assertEquals((int)2, (int)resourceField.getAnnotationsSize("javax.persistence.MapKeyJoinColumn"));
    }

    public void testAddJoinColumnToBeginningOfList() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        String expected1 = "@MapKeyJoinColumns({";
        String expected2 = "@MapKeyJoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"),";
        String expected3 = "@MapKeyJoinColumn(name = \"FOO\") })";
        MapKeyJoinColumn2_0Annotation joinColumn = (MapKeyJoinColumn2_0Annotation)resourceField.addAnnotation(1, "javax.persistence.MapKeyJoinColumn");
        joinColumn.setName("FOO");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        expected2 = "@MapKeyJoinColumn(name = \"BAZ\"),";
        expected3 = "@MapKeyJoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"), @MapKeyJoinColumn(name = \"FOO\") })";
        joinColumn = (MapKeyJoinColumn2_0Annotation)resourceField.addAnnotation(0, "javax.persistence.MapKeyJoinColumn");
        joinColumn.setName("BAZ");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        ListIterator joinColumns = resourceField.getAnnotations("javax.persistence.MapKeyJoinColumn").iterator();
        MapKeyJoinColumns2_0AnnotationTests.assertEquals((String)"BAZ", (String)((MapKeyJoinColumn2_0Annotation)joinColumns.next()).getName());
        MapKeyJoinColumns2_0AnnotationTests.assertEquals((String)"BAR", (String)((MapKeyJoinColumn2_0Annotation)joinColumns.next()).getName());
        MapKeyJoinColumns2_0AnnotationTests.assertEquals((String)"FOO", (String)((MapKeyJoinColumn2_0Annotation)joinColumns.next()).getName());
        MapKeyJoinColumns2_0AnnotationTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyJoinColumn"));
        MapKeyJoinColumns2_0AnnotationTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyJoinColumns"));
        MapKeyJoinColumns2_0AnnotationTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.MapKeyJoinColumn"));
        MapKeyJoinColumns2_0AnnotationTests.assertEquals((int)3, (int)resourceField.getAnnotationsSize("javax.persistence.MapKeyJoinColumn"));
    }

    public void testRemoveJoinColumnCopyExisting() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        String expected1 = "@MapKeyJoinColumns({";
        String expected2 = "@MapKeyJoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"),";
        String expected3 = "@MapKeyJoinColumn(name = \"FOO\") })";
        MapKeyJoinColumn2_0Annotation joinColumn = (MapKeyJoinColumn2_0Annotation)resourceField.addAnnotation(1, "javax.persistence.MapKeyJoinColumn");
        joinColumn.setName("FOO");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        expected2 = "@MapKeyJoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\")";
        resourceField.removeAnnotation(1, "javax.persistence.MapKeyJoinColumn");
        this.assertSourceContains(expected2, cu);
        this.assertSourceDoesNotContain("@MapKeyJoinColumns", cu);
    }
}

