/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.OneToOne2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.java.FetchType;
import org.eclipse.jpt.jpa.core.resource.java.OneToOneAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java.JavaResourceModel2_0TestCase;

public class OneToOne2_0AnnotationTests
extends JavaResourceModel2_0TestCase {
    public OneToOne2_0AnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestOneToOne() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.OneToOne"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne");
            }
        });
    }

    private ICompilationUnit createTestOneToOneWithFetch() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.OneToOne", "javax.persistence.FetchType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne(fetch = FetchType.EAGER)");
            }
        });
    }

    private ICompilationUnit createTestOneToOneWithTargetEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.OneToOne"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne(targetEntity = AnnotationTestType.class)");
            }
        });
    }

    private ICompilationUnit createTestOneToOneWithOptional() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.OneToOne"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne(optional = true)");
            }
        });
    }

    private ICompilationUnit createTestOneToOneWithMappedBy() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.OneToOne"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne(mappedBy = \"foo\")");
            }
        });
    }

    private ICompilationUnit createTestOneToOneWithCascade() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.OneToOne", "javax.persistence.CascadeType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne(cascade = CascadeType.ALL)");
            }
        });
    }

    private ICompilationUnit createTestOneToOneWithMultipleCascade() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.OneToOne", "javax.persistence.CascadeType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne(cascade = {CascadeType.MERGE, CascadeType.REMOVE})");
            }
        });
    }

    private ICompilationUnit createTestOneToOneWithDuplicateCascade() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.OneToOne", "javax.persistence.CascadeType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne(cascade = {CascadeType.MERGE, CascadeType.MERGE})");
            }
        });
    }

    public void testOneToOne() throws Exception {
        ICompilationUnit cu = this.createTestOneToOne();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        OneToOne2_0AnnotationTests.assertNotNull((Object)oneToOne);
    }

    public void testGetFetch() throws Exception {
        ICompilationUnit cu = this.createTestOneToOneWithFetch();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        OneToOne2_0AnnotationTests.assertEquals((Object)FetchType.EAGER, (Object)oneToOne.getFetch());
    }

    public void testSetFetch() throws Exception {
        ICompilationUnit cu = this.createTestOneToOneWithFetch();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        OneToOne2_0AnnotationTests.assertEquals((Object)FetchType.EAGER, (Object)oneToOne.getFetch());
        oneToOne.setFetch(FetchType.LAZY);
        OneToOne2_0AnnotationTests.assertEquals((Object)FetchType.LAZY, (Object)oneToOne.getFetch());
        this.assertSourceContains("@OneToOne(fetch = LAZY)", cu);
    }

    public void testSetFetchNull() throws Exception {
        ICompilationUnit cu = this.createTestOneToOneWithFetch();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        OneToOne2_0AnnotationTests.assertEquals((Object)FetchType.EAGER, (Object)oneToOne.getFetch());
        oneToOne.setFetch(null);
        OneToOne2_0AnnotationTests.assertNull((Object)oneToOne.getFetch());
        this.assertSourceContains("@OneToOne", cu);
        this.assertSourceDoesNotContain("fetch", cu);
    }

    public void testGetTargetEntity() throws Exception {
        ICompilationUnit cu = this.createTestOneToOneWithTargetEntity();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        OneToOne2_0AnnotationTests.assertEquals((String)"AnnotationTestType", (String)oneToOne.getTargetEntity());
    }

    public void testSetTargetEntity() throws Exception {
        ICompilationUnit cu = this.createTestOneToOneWithTargetEntity();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        OneToOne2_0AnnotationTests.assertEquals((String)"AnnotationTestType", (String)oneToOne.getTargetEntity());
        oneToOne.setTargetEntity("Foo");
        this.assertSourceContains("@OneToOne(targetEntity = Foo.class)", cu);
    }

    public void testSetTargetEntityNull() throws Exception {
        ICompilationUnit cu = this.createTestOneToOneWithTargetEntity();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        OneToOne2_0AnnotationTests.assertEquals((String)"AnnotationTestType", (String)oneToOne.getTargetEntity());
        oneToOne.setTargetEntity(null);
        this.assertSourceContains("@OneToOne", cu);
        this.assertSourceDoesNotContain("targetEntity", cu);
    }

    public void testGetFullyQualifiedTargetEntity() throws Exception {
        ICompilationUnit cu = this.createTestOneToOneWithTargetEntity();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        OneToOne2_0AnnotationTests.assertEquals((String)"test.AnnotationTestType", (String)oneToOne.getFullyQualifiedTargetEntityClassName());
        oneToOne.setTargetEntity("Foo");
        this.assertSourceContains("@OneToOne(targetEntity = Foo.class)", cu);
        OneToOne2_0AnnotationTests.assertEquals((String)"Foo", (String)oneToOne.getTargetEntity());
        OneToOne2_0AnnotationTests.assertEquals((String)"Foo", (String)oneToOne.getFullyQualifiedTargetEntityClassName());
    }

    public void testGetOptional() throws Exception {
        ICompilationUnit cu = this.createTestOneToOneWithOptional();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        OneToOne2_0AnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)oneToOne.getOptional());
    }

    public void testSetOptional() throws Exception {
        ICompilationUnit cu = this.createTestOneToOneWithOptional();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        OneToOne2_0AnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)oneToOne.getOptional());
        oneToOne.setOptional(Boolean.FALSE);
        OneToOne2_0AnnotationTests.assertEquals((Object)Boolean.FALSE, (Object)oneToOne.getOptional());
        this.assertSourceContains("@OneToOne(optional = false)", cu);
    }

    public void testSetOptionalNull() throws Exception {
        ICompilationUnit cu = this.createTestOneToOneWithOptional();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        OneToOne2_0AnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)oneToOne.getOptional());
        oneToOne.setOptional(null);
        OneToOne2_0AnnotationTests.assertNull((Object)oneToOne.getOptional());
        this.assertSourceContains("@OneToOne", cu);
        this.assertSourceDoesNotContain("optional", cu);
    }

    public void testGetMappedBy() throws Exception {
        ICompilationUnit cu = this.createTestOneToOneWithMappedBy();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        OneToOne2_0AnnotationTests.assertEquals((String)"foo", (String)oneToOne.getMappedBy());
    }

    public void testGetMappedByNull() throws Exception {
        ICompilationUnit cu = this.createTestOneToOne();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        OneToOne2_0AnnotationTests.assertEquals(null, (String)oneToOne.getMappedBy());
    }

    public void testSetMappedBy() throws Exception {
        ICompilationUnit cu = this.createTestOneToOne();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        OneToOne2_0AnnotationTests.assertNull((Object)oneToOne.getMappedBy());
        oneToOne.setMappedBy("bar");
        OneToOne2_0AnnotationTests.assertEquals((String)"bar", (String)oneToOne.getMappedBy());
        this.assertSourceContains("@OneToOne(mappedBy = \"bar\")", cu);
    }

    public void testSetMappedByNull() throws Exception {
        ICompilationUnit cu = this.createTestOneToOneWithMappedBy();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        OneToOne2_0AnnotationTests.assertEquals((String)"foo", (String)oneToOne.getMappedBy());
        oneToOne.setMappedBy(null);
        OneToOne2_0AnnotationTests.assertNull((Object)oneToOne.getMappedBy());
        this.assertSourceContains("@OneToOne", cu);
        this.assertSourceDoesNotContain("mappedBy", cu);
    }

    public void testSetCascadeAll() throws Exception {
        ICompilationUnit cu = this.createTestOneToOne();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        OneToOne2_0AnnotationTests.assertFalse((boolean)oneToOne.isCascadeAll());
        oneToOne.setCascadeAll(true);
        this.assertSourceContains("@OneToOne(cascade = ALL)", cu);
        OneToOne2_0AnnotationTests.assertTrue((boolean)oneToOne.isCascadeAll());
    }

    public void testSetCascadeMerge() throws Exception {
        ICompilationUnit cu = this.createTestOneToOne();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        OneToOne2_0AnnotationTests.assertFalse((boolean)oneToOne.isCascadeMerge());
        oneToOne.setCascadeMerge(true);
        this.assertSourceContains("@OneToOne(cascade = MERGE)", cu);
        OneToOne2_0AnnotationTests.assertTrue((boolean)oneToOne.isCascadeMerge());
    }

    public void testSetCascadePersist() throws Exception {
        ICompilationUnit cu = this.createTestOneToOne();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        OneToOne2_0AnnotationTests.assertFalse((boolean)oneToOne.isCascadePersist());
        oneToOne.setCascadePersist(true);
        this.assertSourceContains("@OneToOne(cascade = PERSIST)", cu);
        OneToOne2_0AnnotationTests.assertTrue((boolean)oneToOne.isCascadePersist());
    }

    public void testSetCascadeRemove() throws Exception {
        ICompilationUnit cu = this.createTestOneToOne();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        OneToOne2_0AnnotationTests.assertFalse((boolean)oneToOne.isCascadeRemove());
        oneToOne.setCascadeRemove(true);
        this.assertSourceContains("@OneToOne(cascade = REMOVE)", cu);
        OneToOne2_0AnnotationTests.assertTrue((boolean)oneToOne.isCascadeRemove());
    }

    public void testSetCascadeRefresh() throws Exception {
        ICompilationUnit cu = this.createTestOneToOne();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        OneToOne2_0AnnotationTests.assertFalse((boolean)oneToOne.isCascadeRefresh());
        oneToOne.setCascadeRefresh(true);
        this.assertSourceContains("@OneToOne(cascade = REFRESH)", cu);
        OneToOne2_0AnnotationTests.assertTrue((boolean)oneToOne.isCascadeRefresh());
    }

    public void testSetCascadeDetach() throws Exception {
        ICompilationUnit cu = this.createTestOneToOne();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToOne2_0Annotation oneToOne = (OneToOne2_0Annotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        OneToOne2_0AnnotationTests.assertFalse((boolean)oneToOne.isCascadeDetach());
        oneToOne.setCascadeDetach(true);
        this.assertSourceContains("@OneToOne(cascade = DETACH)", cu);
        OneToOne2_0AnnotationTests.assertTrue((boolean)oneToOne.isCascadeDetach());
    }

    public void testCascadeMoreThanOnce() throws Exception {
        ICompilationUnit cu = this.createTestOneToOneWithCascade();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        OneToOne2_0AnnotationTests.assertTrue((boolean)oneToOne.isCascadeAll());
        oneToOne.setCascadeAll(true);
        OneToOne2_0AnnotationTests.assertTrue((boolean)oneToOne.isCascadeAll());
        this.assertSourceContains("@OneToOne(cascade = CascadeType.ALL)", cu);
        oneToOne.setCascadeAll(false);
        OneToOne2_0AnnotationTests.assertFalse((boolean)oneToOne.isCascadeAll());
        this.assertSourceDoesNotContain("cascade", cu);
        oneToOne.setCascadeAll(false);
        OneToOne2_0AnnotationTests.assertFalse((boolean)oneToOne.isCascadeAll());
        this.assertSourceDoesNotContain("cascade", cu);
    }

    public void testDuplicateCascade() throws Exception {
        ICompilationUnit cu = this.createTestOneToOneWithDuplicateCascade();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        OneToOne2_0AnnotationTests.assertTrue((boolean)oneToOne.isCascadeMerge());
        oneToOne.setCascadeMerge(false);
        OneToOne2_0AnnotationTests.assertTrue((boolean)oneToOne.isCascadeMerge());
        oneToOne.setCascadeMerge(false);
        OneToOne2_0AnnotationTests.assertFalse((boolean)oneToOne.isCascadeMerge());
        this.assertSourceDoesNotContain("cascade", cu);
    }

    public void testMultipleCascade() throws Exception {
        ICompilationUnit cu = this.createTestOneToOneWithMultipleCascade();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        OneToOne2_0AnnotationTests.assertTrue((boolean)oneToOne.isCascadeMerge());
        OneToOne2_0AnnotationTests.assertTrue((boolean)oneToOne.isCascadeRemove());
        oneToOne.setCascadeMerge(false);
        this.assertSourceContains("@OneToOne(cascade = REMOVE)", cu);
        oneToOne.setCascadeRemove(false);
        this.assertSourceDoesNotContain("cascade", cu);
    }
}

