/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.metadata;

import junit.framework.Assert;
import org.eclipse.jpt.jpa.core.prefs.JpaEntityGenPreferencesManager;
import org.eclipse.jpt.jpa.core.prefs.JpaJpqlPreferencesManager;
import org.eclipse.jpt.jpa.core.tests.internal.metadata.JpaMetadataTests;

public class JpaJpqlMetadataTests
extends JpaMetadataTests {
    public static final String CASE_PREF_KEY = "jpqlIdentifier.CASE";
    public static final String MATCH_FIRST_CHARACTER_CASE_PREF_KEY = "jpqlIdentifier.MATCH_FIRST_CHARACTER_CASE";
    public static final String CASE_TEST_VALUE = "uppercase";
    public static final boolean MATCH_FIRST_CHARACTER_CASE_TEST_VALUE = false;

    public JpaJpqlMetadataTests(String name) {
        super(name);
    }

    public void testIdentifiersCaseWorkspaceMetadata() throws Exception {
        JpaJpqlPreferencesManager.setIdentifiersCaseWorkspacePreference((String)CASE_TEST_VALUE);
        JpaJpqlPreferencesManager.getLegacyWorkspacePreferences().flush();
        String value = this.getWorkspacePrefs().get(CASE_PREF_KEY);
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)CASE_TEST_VALUE.equals(value));
        JpaEntityGenPreferencesManager.removeLegacyWorkspacePreference((String)CASE_PREF_KEY);
    }

    public void testMatchFirstCharacterCaseWorkspaceMetadata() throws Exception {
        JpaJpqlPreferencesManager.setMatchFirstCharacterCaseWorkspacePreference((boolean)false);
        JpaJpqlPreferencesManager.getLegacyWorkspacePreferences().flush();
        String stringValue = this.getWorkspacePrefs().get(MATCH_FIRST_CHARACTER_CASE_PREF_KEY);
        Assert.assertNotNull((Object)stringValue);
        boolean value = Boolean.valueOf(stringValue);
        Assert.assertTrue((!value ? 1 : 0) != 0);
        JpaEntityGenPreferencesManager.removeLegacyWorkspacePreference((String)MATCH_FIRST_CHARACTER_CASE_PREF_KEY);
    }
}

