/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.metadata;

import junit.framework.Assert;
import org.eclipse.jpt.jpa.core.prefs.JpaValidationPreferencesManager;
import org.eclipse.jpt.jpa.core.tests.internal.metadata.JpaMetadataTests;

public class JpaValidationMetadataTests
extends JpaMetadataTests {
    public static final String WORKSPACE_OVERRIDEN_PREF_KEY = "workspace_preferences_overriden";
    public static final String PERSISTENCE_NO_PERSISTENCE_UNIT_PREF_KEY = "problem.PERSISTENCE_NO_PERSISTENCE_UNIT";
    public static final boolean WORKSPACE_OVERRIDEN_TEST_VALUE = true;
    public static final String PERSISTENCE_NO_PERSISTENCE_UNIT_TEST_VALUE = "info";
    protected JpaValidationPreferencesManager projectPrefsManager;

    public JpaValidationMetadataTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.projectPrefsManager = new JpaValidationPreferencesManager(this.getJavaProject().getProject());
        Assert.assertNotNull((Object)this.projectPrefsManager);
    }

    public void testWorkspaceLevelProblemMetadata() throws Exception {
        JpaValidationPreferencesManager.setWorkspaceLevelProblemPreference((String)"PERSISTENCE_NO_PERSISTENCE_UNIT", (String)PERSISTENCE_NO_PERSISTENCE_UNIT_TEST_VALUE);
        JpaValidationPreferencesManager.getLegacyWorkspacePreferences().flush();
        String value = this.getWorkspacePrefs().get(PERSISTENCE_NO_PERSISTENCE_UNIT_PREF_KEY);
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)PERSISTENCE_NO_PERSISTENCE_UNIT_TEST_VALUE.equals(value));
        JpaValidationPreferencesManager.removeLegacyWorkspacePreference((String)PERSISTENCE_NO_PERSISTENCE_UNIT_PREF_KEY);
    }

    public void testProjectHasSpecificOptionsMetadata() throws Exception {
        this.projectPrefsManager.setProjectHasSpecificOptions(true);
        this.projectPrefsManager.getLegacyProjectPreferences().flush();
        String stringValue = this.getProjectPrefs().get(WORKSPACE_OVERRIDEN_PREF_KEY);
        Assert.assertNotNull((Object)stringValue);
        boolean value = Boolean.valueOf(stringValue);
        Assert.assertTrue((boolean)value);
    }

    public void testProjectLevelProblemMetadata() throws Exception {
        this.projectPrefsManager.setProjectLevelProblemPreference("PERSISTENCE_NO_PERSISTENCE_UNIT", PERSISTENCE_NO_PERSISTENCE_UNIT_TEST_VALUE);
        this.projectPrefsManager.getLegacyProjectPreferences().flush();
        String value = this.getProjectPrefs().get(PERSISTENCE_NO_PERSISTENCE_UNIT_PREF_KEY);
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)PERSISTENCE_NO_PERSISTENCE_UNIT_TEST_VALUE.equals(value));
    }
}

