/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.model;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jpt.common.core.tests.internal.projects.TestFacetedProject;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.projects.TestPlatformProject;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.ReflectionTools;
import org.eclipse.jpt.jpa.core.JpaFacet;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaProjectManager;
import org.eclipse.jpt.jpa.core.internal.facet.JpaFacetInstallDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaProjectManagerTests
extends TestCase {
    public static final String CR = System.getProperty("line.separator");
    private TestFacetedProject testProjectHarness;

    public JpaProjectManagerTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (this.debug()) {
            this.printName();
        }
        this.testProjectHarness = this.buildTestProjectHarness();
    }

    private boolean debug() {
        Boolean debug = (Boolean)ReflectionTools.executeStaticMethod(this.getGenericJpaProjectManagerClass(), (String)"debug");
        return debug;
    }

    private Class<?> getGenericJpaProjectManagerClass() {
        return this.getJpaProjectManager().getClass();
    }

    protected JpaProjectManager getJpaProjectManager() {
        return (JpaProjectManager)ResourcesPlugin.getWorkspace().getAdapter(JpaProjectManager.class);
    }

    private void printName() {
        String name = this.getName();
        System.out.println();
        System.out.println();
        this.printNameBorder(name);
        System.out.println(name);
        this.printNameBorder(name);
    }

    private void printNameBorder(String name) {
        int i = name.length();
        while (i-- > 0) {
            System.out.print('=');
        }
        System.out.println();
    }

    protected void tearDown() throws Exception {
        this.testProjectHarness.getProject().delete(true, true, null);
        this.testProjectHarness = null;
        super.tearDown();
    }

    private JpaProject getJpaProject() {
        return this.getJpaProject(this.getProject());
    }

    private JpaProject getJpaProject(IProject project) {
        try {
            return this.getJpaProject_(project);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    private JpaProject getJpaProject_(IProject project) throws InterruptedException {
        return this.getJpaProjectReference(project).getValue();
    }

    private JpaProject.Reference getJpaProjectReference(IProject project) {
        return (JpaProject.Reference)project.getAdapter(JpaProject.Reference.class);
    }

    private IProject getProject() {
        return this.testProjectHarness.getProject();
    }

    private TestFacetedProject buildTestProjectHarness() throws Exception {
        TestJavaProject tjp = TestJavaProject.buildJavaProject((String)((Object)((Object)this)).getClass().getSimpleName(), (boolean)true);
        tjp.createCompilationUnit("test.pkg", "TestEntity.java", "@Entity public class TestEntity {}");
        tjp.createCompilationUnit("test.pkg", "TestEntity2.java", "@Entity public class TestEntity2 {}");
        return tjp;
    }

    private IFile getFile(TestPlatformProject p, String path) {
        return p.getProject().getFile((IPath)new Path(path));
    }

    public void testJpaProjectManager() {
        JpaProjectManagerTests.assertNotNull((Object)this.getJpaProjectManager());
    }

    private IDataModel buildJpaConfigDataModel() {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new JpaFacetInstallDataModelProvider());
        dataModel.setProperty("JpaFacetInstallDataModelProperties.CREATE_ORM_XML", (Object)Boolean.TRUE);
        return dataModel;
    }

    public void testProjectCloseReopen() throws Exception {
        this.testProjectHarness.installFacet("jpt.jpa", "1.0", (Object)this.buildJpaConfigDataModel());
        JpaProject jpaProject = this.getJpaProject();
        JpaProjectManagerTests.assertNotNull((Object)jpaProject);
        this.testProjectHarness.getProject().close(null);
        JpaProjectManagerTests.assertFalse((String)"Project is not closed", (boolean)this.testProjectHarness.getProject().isOpen());
        jpaProject = this.getJpaProject();
        JpaProjectManagerTests.assertNull((String)"JpaProject is not null", (Object)jpaProject);
        this.testProjectHarness.getProject().open(null);
        JpaProjectManagerTests.assertTrue((boolean)this.testProjectHarness.getProject().isOpen());
        jpaProject = this.getJpaProject();
        JpaProjectManagerTests.assertNotNull((String)"JpaProject is null", (Object)jpaProject);
        JpaProjectManagerTests.assertEquals((int)4, (int)jpaProject.getJpaFilesSize());
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProjectHarness, "src/test/pkg/TestEntity.java")));
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProjectHarness, "src/test/pkg/TestEntity2.java")));
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProjectHarness, "src/META-INF/persistence.xml")));
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProjectHarness, "src/META-INF/orm.xml")));
    }

    public void testProjectDeleteReimport() throws Exception {
        this.testProjectHarness.installFacet("jpt.jpa", "1.0", (Object)this.buildJpaConfigDataModel());
        JpaProject jpaProject = this.getJpaProject();
        JpaProjectManagerTests.assertNotNull((Object)jpaProject);
        JpaProjectManagerTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getJpaProjectManager().waitToGetJpaProjects()));
        this.testProjectHarness.getProject().delete(false, true, null);
        jpaProject = this.getJpaProject();
        JpaProjectManagerTests.assertNull((Object)jpaProject);
        JpaProjectManagerTests.assertEquals((int)0, (int)CollectionTools.size((Iterable)this.getJpaProjectManager().waitToGetJpaProjects()));
        JpaProjectManagerTests.assertEquals((int)0, (int)ResourcesPlugin.getWorkspace().getRoot().getProjects().length);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.testProjectHarness.getProject().getName());
        project.create(null);
        JpaProjectManagerTests.assertEquals((int)1, (int)ResourcesPlugin.getWorkspace().getRoot().getProjects().length);
        project.open(null);
        JpaProjectManagerTests.assertTrue((boolean)project.isOpen());
        JpaProjectManagerTests.assertTrue((boolean)JpaFacet.isInstalled((IProject)project));
        jpaProject = this.getJpaProject(project);
        JpaProjectManagerTests.assertNotNull((Object)jpaProject);
        JpaProjectManagerTests.assertEquals((int)4, (int)jpaProject.getJpaFilesSize());
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProjectHarness, "src/test/pkg/TestEntity.java")));
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProjectHarness, "src/test/pkg/TestEntity2.java")));
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProjectHarness, "src/META-INF/persistence.xml")));
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProjectHarness, "src/META-INF/orm.xml")));
    }

    public void testFacetInstallUninstall() throws Exception {
        JpaProjectManagerTests.assertNull((Object)this.getJpaProject());
        this.testProjectHarness.installFacet("jpt.jpa", "1.0", (Object)this.buildJpaConfigDataModel());
        JpaProjectManagerTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getJpaProjectManager().waitToGetJpaProjects()));
        JpaProject jpaProject = this.getJpaProject();
        JpaProjectManagerTests.assertNotNull((Object)jpaProject);
        JpaProjectManagerTests.assertEquals((int)4, (int)jpaProject.getJpaFilesSize());
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProjectHarness, "src/test/pkg/TestEntity.java")));
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProjectHarness, "src/test/pkg/TestEntity2.java")));
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProjectHarness, "src/META-INF/persistence.xml")));
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProjectHarness, "src/META-INF/orm.xml")));
        this.testProjectHarness.uninstallFacet("jpt.jpa", "1.0");
        JpaProjectManagerTests.assertEquals((int)0, (int)CollectionTools.size((Iterable)this.getJpaProjectManager().waitToGetJpaProjects()));
        jpaProject = this.getJpaProject();
        JpaProjectManagerTests.assertNull((Object)jpaProject);
    }

    public void testEditFacetSettingsFileAddThenRemoveJpaFacet() throws Exception {
        JpaProjectManagerTests.assertNull((Object)this.getJpaProject());
        IFile facetSettingsFile = this.getFile((TestPlatformProject)this.testProjectHarness, ".settings/org.eclipse.wst.common.project.facet.core.xml");
        BufferedInputStream inStream = new BufferedInputStream(facetSettingsFile.getContents());
        int fileSize = ((InputStream)inStream).available();
        byte[] buf = new byte[fileSize];
        ((InputStream)inStream).read(buf);
        ((InputStream)inStream).close();
        String oldDocument = new String(buf);
        String oldString = "<installed facet=\"java\" version=\"1.5\"/>";
        String newString = String.valueOf(oldString) + CR + "  " + "<installed facet=\"jpt.jpa\" version=\"1.0\"/>";
        String newDocument = oldDocument.replaceAll(oldString, newString);
        facetSettingsFile.setContents((InputStream)new ByteArrayInputStream(newDocument.getBytes()), false, false, null);
        JpaProjectManagerTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getJpaProjectManager().waitToGetJpaProjects()));
        JpaProject jpaProject = this.getJpaProject();
        JpaProjectManagerTests.assertNotNull((Object)jpaProject);
        JpaProjectManagerTests.assertEquals((int)2, (int)jpaProject.getJpaFilesSize());
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProjectHarness, "src/test/pkg/TestEntity.java")));
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProjectHarness, "src/test/pkg/TestEntity2.java")));
        facetSettingsFile.setContents((InputStream)new ByteArrayInputStream(oldDocument.getBytes()), false, false, null);
        JpaProjectManagerTests.assertEquals((int)0, (int)CollectionTools.size((Iterable)this.getJpaProjectManager().waitToGetJpaProjects()));
        jpaProject = this.getJpaProject();
        JpaProjectManagerTests.assertNull((Object)jpaProject);
    }

    public void testEditFacetSettingsFileRemoveThenAddJpaFacet() throws Exception {
        this.testProjectHarness.installFacet("jpt.jpa", "1.0", (Object)this.buildJpaConfigDataModel());
        JpaProject jpaProject = this.getJpaProject();
        JpaProjectManagerTests.assertNotNull((Object)jpaProject);
        IFile facetSettingsFile = this.getFile((TestPlatformProject)this.testProjectHarness, ".settings/org.eclipse.wst.common.project.facet.core.xml");
        BufferedInputStream inStream = new BufferedInputStream(facetSettingsFile.getContents());
        int fileSize = ((InputStream)inStream).available();
        byte[] buf = new byte[fileSize];
        ((InputStream)inStream).read(buf);
        ((InputStream)inStream).close();
        String oldDocument = new String(buf);
        String oldString = "<installed facet=\"java\" version=\"1.5\"/>" + CR + "  " + "<installed facet=\"jpt.jpa\" version=\"1.0\"/>";
        String newString = "<installed facet=\"java\" version=\"1.5\"/>";
        String newDocument = oldDocument.replaceAll(oldString, newString);
        facetSettingsFile.setContents((InputStream)new ByteArrayInputStream(newDocument.getBytes()), false, false, null);
        JpaProjectManagerTests.assertEquals((int)0, (int)CollectionTools.size((Iterable)this.getJpaProjectManager().waitToGetJpaProjects()));
        jpaProject = this.getJpaProject();
        JpaProjectManagerTests.assertNull((Object)jpaProject);
        facetSettingsFile.setContents((InputStream)new ByteArrayInputStream(oldDocument.getBytes()), false, false, null);
        JpaProjectManagerTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getJpaProjectManager().waitToGetJpaProjects()));
        jpaProject = this.getJpaProject();
        JpaProjectManagerTests.assertNotNull((Object)jpaProject);
        JpaProjectManagerTests.assertEquals((int)4, (int)jpaProject.getJpaFilesSize());
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProjectHarness, "src/test/pkg/TestEntity.java")));
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProjectHarness, "src/test/pkg/TestEntity2.java")));
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProjectHarness, "src/META-INF/persistence.xml")));
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProjectHarness, "src/META-INF/orm.xml")));
    }
}

