/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.projects;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.jpa.core.JpaFacet;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class TestJpaProject
extends TestJavaProject {
    public static final String JPA_JAR_NAME_SYSTEM_PROPERTY = "org.eclipse.jpt.jpa.jar";
    public static final String ECLIPSELINK_JAR_NAME_SYSTEM_PROPERTY = "org.eclipse.jpt.eclipselink.jar";

    public static TestJpaProject buildJpaProject(String baseProjectName, boolean autoBuild, IDataModel jpaConfig) throws CoreException {
        return new TestJpaProject(baseProjectName, autoBuild, jpaConfig);
    }

    public static TestJpaProject buildJpaProject(String baseProjectName, boolean autoBuild) throws CoreException {
        return TestJpaProject.buildJpaProject(baseProjectName, autoBuild, null);
    }

    public TestJpaProject(String projectName) throws CoreException {
        this(projectName, false);
    }

    public TestJpaProject(String projectName, boolean autoBuild) throws CoreException {
        this(projectName, autoBuild, null);
    }

    public TestJpaProject(String projectName, boolean autoBuild, IDataModel jpaConfig) throws CoreException {
        super(projectName, autoBuild);
        String jpaFacetVersion = JpaFacet.VERSION_1_0.getVersionString();
        if (jpaConfig != null) {
            jpaFacetVersion = jpaConfig.getStringProperty("IFacetDataModelProperties.FACET_VERSION_STR");
        }
        this.installFacet("jst.utility", "1.0");
        this.installFacet("jpt.jpa", jpaFacetVersion, jpaConfig);
        this.addJar(TestJpaProject.jpaJarName());
        if (TestJpaProject.eclipseLinkJarName() != null) {
            this.addJar(TestJpaProject.eclipseLinkJarName());
        }
        this.getJpaProject().setDiscoversAnnotatedClasses(true);
    }

    public static String jpaJarName() {
        return TestJpaProject.getSystemProperty(JPA_JAR_NAME_SYSTEM_PROPERTY);
    }

    public static String eclipseLinkJarName() {
        return TestJpaProject.getSystemProperty(ECLIPSELINK_JAR_NAME_SYSTEM_PROPERTY);
    }

    private static String getSystemProperty(String propertyName) {
        return System.getProperty(propertyName);
    }

    public JpaProject getJpaProject() {
        try {
            return this.getJpaProject_();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    private JpaProject getJpaProject_() throws InterruptedException {
        return this.getJpaProjectReference().getValue();
    }

    private JpaProject.Reference getJpaProjectReference() {
        return (JpaProject.Reference)this.getProject().getAdapter(JpaProject.Reference.class);
    }
}

