/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMember;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.resource.java.AssociationOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class AssociationOverridesTests
extends JpaJavaResourceModelTestCase {
    private static final String ASSOCIATION_OVERRIDE_NAME = "MY_ASSOCIATION_OVERRIDE";

    public AssociationOverridesTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestAssociationOverrideOnField() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\"))");
            }
        });
    }

    private ICompilationUnit createTestAssociationOverrideWithJoinColumns() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides", "javax.persistence.JoinColumn"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"BAR\"), @JoinColumn}))");
            }
        });
    }

    private ICompilationUnit createTestAssociationOverride() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.AssociationOverride", "javax.persistence.JoinColumn"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append(CR);
                sb.append("@AssociationOverride(name = \"FOO\", joinColumns = @JoinColumn(name = \"FOO\", columnDefinition = \"BAR\", referencedColumnName = \"BAZ\"))");
            }
        });
    }

    private AssociationOverrideAnnotation getAssociationOverrideAnnotationAt(JavaResourceMember resourceMember, int index) {
        return (AssociationOverrideAnnotation)resourceMember.getAnnotation(index, "javax.persistence.AssociationOverride");
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnField();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        AssociationOverrideAnnotation associationOverride = this.getAssociationOverrideAnnotationAt((JavaResourceMember)resourceField, 0);
        AssociationOverridesTests.assertNotNull((Object)associationOverride);
        AssociationOverridesTests.assertEquals((String)ASSOCIATION_OVERRIDE_NAME, (String)associationOverride.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnField();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        AssociationOverrideAnnotation associationOverride = this.getAssociationOverrideAnnotationAt((JavaResourceMember)resourceField, 0);
        AssociationOverridesTests.assertNotNull((Object)associationOverride);
        AssociationOverridesTests.assertEquals((String)ASSOCIATION_OVERRIDE_NAME, (String)associationOverride.getName());
        associationOverride.setName("Foo");
        AssociationOverridesTests.assertEquals((String)"Foo", (String)associationOverride.getName());
        this.assertSourceContains("@AssociationOverrides(@AssociationOverride(name = \"Foo\"))", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnField();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        AssociationOverrideAnnotation associationOverride = this.getAssociationOverrideAnnotationAt((JavaResourceMember)resourceField, 0);
        AssociationOverridesTests.assertEquals((String)ASSOCIATION_OVERRIDE_NAME, (String)associationOverride.getName());
        associationOverride.setName(null);
        AssociationOverridesTests.assertNull((Object)associationOverride.getName());
        this.assertSourceDoesNotContain("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\")", cu);
        this.assertSourceContains("@AssociationOverride", cu);
        this.assertSourceContains("@AssociationOverrides", cu);
    }

    public void testAddAssociationOverrideCopyExisting() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverride();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        String expected1 = "@AssociationOverrides({";
        String expected2 = "@AssociationOverride(name = \"FOO\", joinColumns = @JoinColumn(name = \"FOO\", columnDefinition = \"BAR\", referencedColumnName = \"BAZ\")),";
        String expected3 = "@AssociationOverride(name = \"BAR\") })";
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)resourceType.addAnnotation(1, "javax.persistence.AssociationOverride");
        associationOverride.setName("BAR");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        AssociationOverridesTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.AssociationOverride"));
        AssociationOverridesTests.assertNotNull((Object)resourceType.getAnnotation("javax.persistence.AssociationOverrides"));
        AssociationOverridesTests.assertNotNull((Object)resourceType.getAnnotation(0, "javax.persistence.AssociationOverride"));
        AssociationOverridesTests.assertEquals((int)2, (int)resourceType.getAnnotationsSize("javax.persistence.AssociationOverride"));
    }

    public void testAddAssociationOverrideToBeginningOfList() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverride();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        String expected1 = "@AssociationOverrides({";
        String expected2 = "@AssociationOverride(name = \"FOO\", joinColumns = @JoinColumn(name = \"FOO\", columnDefinition = \"BAR\", referencedColumnName = \"BAZ\")),";
        String expected3 = "@AssociationOverride(name = \"BAR\") })";
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)resourceType.addAnnotation(1, "javax.persistence.AssociationOverride");
        associationOverride.setName("BAR");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        expected2 = "@AssociationOverride(name = \"BAZ\"),";
        expected3 = "@AssociationOverride(name = \"FOO\", joinColumns = @JoinColumn(name = \"FOO\", columnDefinition = \"BAR\", referencedColumnName = \"BAZ\")), @AssociationOverride(name = \"BAR\") })";
        associationOverride = (AssociationOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AssociationOverride");
        associationOverride.setName("BAZ");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        ListIterator associationOverrides = resourceType.getAnnotations("javax.persistence.AssociationOverride").iterator();
        AssociationOverridesTests.assertEquals((String)"BAZ", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        AssociationOverridesTests.assertEquals((String)"FOO", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        AssociationOverridesTests.assertEquals((String)"BAR", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        AssociationOverridesTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.AssociationOverride"));
        AssociationOverridesTests.assertNotNull((Object)resourceType.getAnnotation("javax.persistence.AssociationOverrides"));
        AssociationOverridesTests.assertNotNull((Object)resourceType.getAnnotation(0, "javax.persistence.AssociationOverride"));
        AssociationOverridesTests.assertEquals((int)3, (int)resourceType.getAnnotationsSize("javax.persistence.AssociationOverride"));
    }

    public void testRemoveAssociationOverrideCopyExisting() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverride();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        String expected1 = "@AssociationOverrides({";
        String expected2 = "@AssociationOverride(name = \"FOO\", joinColumns = @JoinColumn(name = \"FOO\", columnDefinition = \"BAR\", referencedColumnName = \"BAZ\")),";
        String expected3 = "@AssociationOverride(name = \"BAR\") })";
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)resourceType.addAnnotation(1, "javax.persistence.AssociationOverride");
        associationOverride.setName("BAR");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        expected2 = "@AssociationOverride(name = \"FOO\", joinColumns = @JoinColumn(name = \"FOO\", columnDefinition = \"BAR\", referencedColumnName = \"BAZ\"))";
        resourceType.removeAnnotation(1, "javax.persistence.AssociationOverride");
        this.assertSourceContains(expected2, cu);
        this.assertSourceDoesNotContain("@AssociationOverrides", cu);
    }

    public void testJoinColumns() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnField();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        AssociationOverrideAnnotation associationOverride = this.getAssociationOverrideAnnotationAt((JavaResourceMember)resourceField, 0);
        AssociationOverridesTests.assertEquals((int)0, (int)associationOverride.getJoinColumnsSize());
    }

    public void testJoinColumns2() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnField();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        AssociationOverrideAnnotation associationOverride = this.getAssociationOverrideAnnotationAt((JavaResourceMember)resourceField, 0);
        associationOverride.addJoinColumn(0);
        associationOverride.addJoinColumn(1);
        AssociationOverridesTests.assertEquals((int)2, (int)associationOverride.getJoinColumnsSize());
    }

    public void testJoinColumns3() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        AssociationOverrideAnnotation associationOverride = this.getAssociationOverrideAnnotationAt((JavaResourceMember)resourceField, 0);
        AssociationOverridesTests.assertEquals((int)2, (int)associationOverride.getJoinColumnsSize());
    }

    public void testAddJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnField();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        AssociationOverrideAnnotation associationOverride = this.getAssociationOverrideAnnotationAt((JavaResourceMember)resourceField, 0);
        associationOverride.addJoinColumn(0).setName("FOO");
        associationOverride.addJoinColumn(1);
        associationOverride.addJoinColumn(0).setName("BAR");
        ListIterator joinColumns = associationOverride.getJoinColumns().iterator();
        AssociationOverridesTests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverridesTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverridesTests.assertNull((Object)((JoinColumnAnnotation)joinColumns.next()).getName());
        this.assertSourceContains("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"BAR\"),@JoinColumn(name = \"FOO\"), @JoinColumn}))", cu);
    }

    public void testRemoveJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        AssociationOverrideAnnotation associationOverride = this.getAssociationOverrideAnnotationAt((JavaResourceMember)resourceField, 0);
        associationOverride.addJoinColumn(0).setName("FOO");
        ListIterator joinColumns = associationOverride.getJoinColumns().iterator();
        AssociationOverridesTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverridesTests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverridesTests.assertNull((Object)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverridesTests.assertEquals((boolean)false, (boolean)joinColumns.hasNext());
        this.assertSourceContains("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\"), @JoinColumn}))", cu);
        associationOverride.removeJoinColumn(1);
        joinColumns = associationOverride.getJoinColumns().iterator();
        AssociationOverridesTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverridesTests.assertNull((Object)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverridesTests.assertEquals((boolean)false, (boolean)joinColumns.hasNext());
        this.assertSourceContains("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn}))", cu);
        associationOverride.removeJoinColumn(0);
        joinColumns = associationOverride.getJoinColumns().iterator();
        AssociationOverridesTests.assertNull((Object)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverridesTests.assertEquals((boolean)false, (boolean)joinColumns.hasNext());
        this.assertSourceContains("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = @JoinColumn))", cu);
        associationOverride.setName(null);
        associationOverride.removeJoinColumn(0);
        this.assertSourceDoesNotContain("@JoinColumn", cu);
    }

    public void testMoveJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        AssociationOverrideAnnotation associationOverride = this.getAssociationOverrideAnnotationAt((JavaResourceMember)resourceField, 0);
        JoinColumnAnnotation joinColumn = associationOverride.joinColumnAt(0);
        joinColumn.setReferencedColumnName("REF_NAME");
        joinColumn.setUnique(Boolean.FALSE);
        joinColumn.setNullable(Boolean.FALSE);
        joinColumn.setInsertable(Boolean.FALSE);
        joinColumn.setUpdatable(Boolean.FALSE);
        joinColumn.setColumnDefinition("COLUMN_DEF");
        joinColumn.setTable("TABLE");
        associationOverride.addJoinColumn(0).setName("FOO");
        this.assertSourceContains("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"), @JoinColumn}))", cu);
        associationOverride.moveJoinColumn(2, 0);
        AssociationOverridesTests.assertEquals((String)"BAR", (String)associationOverride.joinColumnAt(0).getName());
        AssociationOverridesTests.assertNull((Object)associationOverride.joinColumnAt(1).getName());
        AssociationOverridesTests.assertEquals((String)"FOO", (String)associationOverride.joinColumnAt(2).getName());
        AssociationOverridesTests.assertEquals((int)3, (int)associationOverride.getJoinColumnsSize());
        this.assertSourceContains("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"), @JoinColumn, @JoinColumn(name = \"FOO\")}))", cu);
    }

    public void testMoveJoinColumn2() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        AssociationOverrideAnnotation associationOverride = this.getAssociationOverrideAnnotationAt((JavaResourceMember)resourceField, 0);
        JoinColumnAnnotation joinColumn = associationOverride.joinColumnAt(0);
        joinColumn.setReferencedColumnName("REF_NAME");
        joinColumn.setUnique(Boolean.FALSE);
        joinColumn.setNullable(Boolean.FALSE);
        joinColumn.setInsertable(Boolean.FALSE);
        joinColumn.setUpdatable(Boolean.FALSE);
        joinColumn.setColumnDefinition("COLUMN_DEF");
        joinColumn.setTable("TABLE");
        associationOverride.addJoinColumn(0).setName("FOO");
        this.assertSourceContains("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"), @JoinColumn}))", cu);
        associationOverride.moveJoinColumn(0, 2);
        AssociationOverridesTests.assertNull((Object)associationOverride.joinColumnAt(0).getName());
        AssociationOverridesTests.assertEquals((String)"FOO", (String)associationOverride.joinColumnAt(1).getName());
        AssociationOverridesTests.assertEquals((String)"BAR", (String)associationOverride.joinColumnAt(2).getName());
        AssociationOverridesTests.assertEquals((int)3, (int)associationOverride.getJoinColumnsSize());
        this.assertSourceContains("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn, @JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\")}))", cu);
    }

    public void testSetJoinColumnName() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        AssociationOverrideAnnotation associationOverride = this.getAssociationOverrideAnnotationAt((JavaResourceMember)resourceField, 0);
        AssociationOverridesTests.assertEquals((int)2, (int)associationOverride.getJoinColumnsSize());
        JoinColumnAnnotation joinColumn = associationOverride.joinColumnAt(0);
        AssociationOverridesTests.assertEquals((String)"BAR", (String)joinColumn.getName());
        joinColumn.setName("foo");
        AssociationOverridesTests.assertEquals((String)"foo", (String)joinColumn.getName());
        this.assertSourceContains("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"foo\"), @JoinColumn}))", cu);
    }
}

