/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.resource.java.BasicAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.FetchType;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class BasicTests
extends JpaJavaResourceModelTestCase {
    public BasicTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestBasic() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Basic"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic");
            }
        });
    }

    private ICompilationUnit createTestBasicWithOptional() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Basic"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic(optional = true)");
            }
        });
    }

    private ICompilationUnit createTestBasicWithFetch() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Basic", "javax.persistence.FetchType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic(fetch = FetchType.EAGER)");
            }
        });
    }

    public void testBasic() throws Exception {
        ICompilationUnit cu = this.createTestBasic();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        BasicAnnotation basic = (BasicAnnotation)resourceField.getAnnotation("javax.persistence.Basic");
        BasicTests.assertNotNull((Object)basic);
    }

    public void testGetOptional() throws Exception {
        ICompilationUnit cu = this.createTestBasicWithOptional();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        BasicAnnotation basic = (BasicAnnotation)resourceField.getAnnotation("javax.persistence.Basic");
        BasicTests.assertEquals((Object)Boolean.TRUE, (Object)basic.getOptional());
    }

    public void testSetOptional() throws Exception {
        ICompilationUnit cu = this.createTestBasicWithOptional();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        BasicAnnotation basic = (BasicAnnotation)resourceField.getAnnotation("javax.persistence.Basic");
        BasicTests.assertEquals((Object)Boolean.TRUE, (Object)basic.getOptional());
        basic.setOptional(Boolean.FALSE);
        BasicTests.assertEquals((Object)Boolean.FALSE, (Object)basic.getOptional());
        this.assertSourceContains("@Basic(optional = false)", cu);
    }

    public void testSetOptionalNull() throws Exception {
        ICompilationUnit cu = this.createTestBasicWithOptional();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        BasicAnnotation basic = (BasicAnnotation)resourceField.getAnnotation("javax.persistence.Basic");
        BasicTests.assertEquals((Object)Boolean.TRUE, (Object)basic.getOptional());
        basic.setOptional(null);
        BasicTests.assertNull((Object)basic.getOptional());
        this.assertSourceContains("@Basic", cu);
        this.assertSourceDoesNotContain("optional", cu);
    }

    public void testGetFetch() throws Exception {
        ICompilationUnit cu = this.createTestBasicWithFetch();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        BasicAnnotation basic = (BasicAnnotation)resourceField.getAnnotation("javax.persistence.Basic");
        BasicTests.assertEquals((Object)FetchType.EAGER, (Object)basic.getFetch());
    }

    public void testSetFetch() throws Exception {
        ICompilationUnit cu = this.createTestBasicWithFetch();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        BasicAnnotation basic = (BasicAnnotation)resourceField.getAnnotation("javax.persistence.Basic");
        BasicTests.assertEquals((Object)FetchType.EAGER, (Object)basic.getFetch());
        basic.setFetch(FetchType.LAZY);
        BasicTests.assertEquals((Object)FetchType.LAZY, (Object)basic.getFetch());
        this.assertSourceContains("@Basic(fetch = LAZY)", cu);
    }

    public void testSetFetchNull() throws Exception {
        ICompilationUnit cu = this.createTestBasicWithFetch();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        BasicAnnotation basic = (BasicAnnotation)resourceField.getAnnotation("javax.persistence.Basic");
        BasicTests.assertEquals((Object)FetchType.EAGER, (Object)basic.getFetch());
        basic.setFetch(null);
        BasicTests.assertNull((Object)basic.getFetch());
        this.assertSourceContains("@Basic", cu);
        this.assertSourceDoesNotContain("fetch", cu);
    }
}

