/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceEmbeddableAnnotation;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceEntityAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.EmbeddableAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.EntityAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.MappedSuperclassAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.SecondaryTableAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.TableAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class JavaResourceTypeTests
extends JpaJavaResourceModelTestCase {
    public JavaResourceTypeTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestInvalidAnnotations() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Foo"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Foo");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Foo");
            }
        });
    }

    private ICompilationUnit createTestEntityWithMemberEmbeddable() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Embeddable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendMemberTypeTo(StringBuilder sb) {
                sb.append("     @Embeddable");
                sb.append(CR);
                sb.append("     public static class Foo { }").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityDuplicates() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity(name = \"FirstEntity\")").append(CR);
                sb.append("@Entity(name = \"SecondEntity\")");
            }
        });
    }

    private ICompilationUnit createTestEntityWithEmbeddable() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Embeddable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append(CR);
                sb.append("@Embeddable");
            }
        });
    }

    private ICompilationUnit createTestEntityWithTable() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Table"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append(CR);
                sb.append("@Table(name = \"FOO\", schema = \"BAR\")");
            }
        });
    }

    private ICompilationUnit createTestEntityMultipleTables() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Table"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append(CR);
                sb.append("@Table(name = \"FOO\")");
                sb.append(CR);
                sb.append("@Table(name = \"BAR\")");
            }
        });
    }

    private ICompilationUnit createTestEntityWithSecondaryTable() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.SecondaryTable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append(CR);
                sb.append("@SecondaryTable(name = \"FOO\")");
            }
        });
    }

    private ICompilationUnit createTestEntityWithEmptySecondaryTables() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.SecondaryTables"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append(CR);
                sb.append("@SecondaryTables()");
            }
        });
    }

    private ICompilationUnit createTestEntityWithSecondaryTables() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append(CR);
                sb.append("@SecondaryTables(@SecondaryTable(name = \"FOO\"))");
            }
        });
    }

    private ICompilationUnit createTestEntityWith2SecondaryTables() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append(CR);
                sb.append("@SecondaryTables({@SecondaryTable(name = \"FOO\"), @SecondaryTable(name = \"BAR\")})");
            }
        });
    }

    private ICompilationUnit createTestEntityWithMemberTypes() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendMemberTypeTo(StringBuilder sb) {
                sb.append("     static class FooStatic {}").append(CR);
                sb.append(CR);
                sb.append("     class FooNotStatic {}").append(CR);
                sb.append(CR);
                sb.append("     @interface MyAnnotation {}").append(CR);
                sb.append(CR);
                sb.append("     enum MyEnum {}").append(CR);
            }
        });
    }

    public void testJavaTypeAnnotations() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceTypeTests.assertEquals((int)2, (int)resourceType.getAnnotationsSize());
    }

    public void testJavaTypeAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceTypeTests.assertNotNull((Object)resourceType.getAnnotation("javax.persistence.Table"));
    }

    public void testJavaTypeAnnotationNull() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceTypeTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.Table"));
    }

    public void testDuplicateAnnotations() throws Exception {
        ICompilationUnit cu = this.createTestEntityMultipleTables();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        TableAnnotation tableResource = (TableAnnotation)resourceType.getAnnotation("javax.persistence.Table");
        JavaResourceTypeTests.assertEquals((String)"FOO", (String)tableResource.getName());
    }

    public void testRemoveTable() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        resourceType.removeAnnotation("javax.persistence.Table");
        this.assertSourceDoesNotContain("@Table", cu);
    }

    public void testRemoveTableName() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        TableAnnotation tableAnnotation = (TableAnnotation)resourceType.getAnnotation("javax.persistence.Table");
        tableAnnotation.setSchema(null);
        this.assertSourceContains("@Table(name = \"FOO\")", cu);
        tableAnnotation.setName(null);
        this.assertSourceDoesNotContain("(name", cu);
    }

    public void testMultipleTypeMappings() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithEmbeddable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceTypeTests.assertEquals((int)2, (int)resourceType.getAnnotationsSize());
        JavaResourceTypeTests.assertNotNull((Object)resourceType.getAnnotation("javax.persistence.Embeddable"));
        JavaResourceTypeTests.assertNotNull((Object)resourceType.getAnnotation("javax.persistence.Entity"));
        Annotation javaTypeMappingAnnotation = resourceType.getAnnotation("javax.persistence.Embeddable");
        JavaResourceTypeTests.assertTrue((boolean)(javaTypeMappingAnnotation instanceof EmbeddableAnnotation));
        this.assertSourceContains("@Entity", cu);
        this.assertSourceContains("@Embeddable", cu);
        resourceType.setPrimaryAnnotation("javax.persistence.MappedSuperclass", EmptyIterable.instance());
        JavaResourceTypeTests.assertEquals((int)1, (int)resourceType.getAnnotationsSize());
        javaTypeMappingAnnotation = resourceType.getAnnotation("javax.persistence.MappedSuperclass");
        JavaResourceTypeTests.assertTrue((boolean)(javaTypeMappingAnnotation instanceof MappedSuperclassAnnotation));
        this.assertSourceDoesNotContain("@Entity", cu);
        this.assertSourceContains("@MappedSuperclass", cu);
        this.assertSourceDoesNotContain("@Embeddable", cu);
    }

    public void testSetJavaTypeMappingAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceTypeTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize());
        resourceType.setPrimaryAnnotation("javax.persistence.Entity", EmptyIterable.instance());
        JavaResourceTypeTests.assertTrue((boolean)(resourceType.getAnnotation("javax.persistence.Entity") instanceof EntityAnnotation));
        this.assertSourceContains("@Entity", cu);
    }

    public void testAddJavaTypeAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        this.assertSourceDoesNotContain("@Table", cu);
        resourceType.addAnnotation("javax.persistence.Table");
        this.assertSourceContains("@Table", cu);
    }

    public void testRemoveJavaTypeAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        this.assertSourceContains("@Table", cu);
        resourceType.removeAnnotation("javax.persistence.Table");
        this.assertSourceDoesNotContain("@Table", cu);
    }

    public void testChangeTypeMappingInSource() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        this.testType(cu).edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                SourceEntityAnnotation.DECLARATION_ANNOTATION_ADAPTER.removeAnnotation(declaration);
            }
        });
        cu.createImport("javax.persistence.Embeddable", null, (IProgressMonitor)new NullProgressMonitor());
        this.testType(cu).edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                SourceEmbeddableAnnotation.DECLARATION_ANNOTATION_ADAPTER.newMarkerAnnotation(declaration);
            }
        });
        JavaResourceTypeTests.assertNotNull((Object)resourceType.getAnnotation("javax.persistence.Table"));
        JavaResourceTypeTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.Entity"));
        JavaResourceTypeTests.assertNotNull((Object)resourceType.getAnnotation("javax.persistence.Embeddable"));
        this.assertSourceContains("@Table", cu);
    }

    public void testJavaTypeAnnotationsNestable() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithSecondaryTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceTypeTests.assertEquals((int)1, (int)resourceType.getAnnotationsSize("javax.persistence.SecondaryTable"));
        SecondaryTableAnnotation secondaryTableResource = (SecondaryTableAnnotation)resourceType.getAnnotations("javax.persistence.SecondaryTable").iterator().next();
        JavaResourceTypeTests.assertEquals((String)"FOO", (String)secondaryTableResource.getName());
    }

    public void testJavaTypeAnnotationsNoNestable() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceTypeTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.SecondaryTable"));
    }

    public void testJavaTypeAnnotationsContainerNoNestable() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithEmptySecondaryTables();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceTypeTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize("javax.persistence.SecondaryTable"));
    }

    public void testAddJavaTypeAnnotationNestableContainer() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation secondaryTableResource = (SecondaryTableAnnotation)resourceType.addAnnotation(0, "javax.persistence.SecondaryTable");
        secondaryTableResource.setName("FOO");
        this.assertSourceContains("@SecondaryTable(name = \"FOO\")", cu);
    }

    public void testAddJavaTypeAnnotationNestableContainer2() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithSecondaryTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation secondaryTableResource = (SecondaryTableAnnotation)resourceType.addAnnotation(1, "javax.persistence.SecondaryTable");
        secondaryTableResource.setName("BAR");
        this.assertSourceContains("@SecondaryTables({ @SecondaryTable(name = \"FOO\"), @SecondaryTable(name = \"BAR\") })", cu);
        JavaResourceTypeTests.assertNotNull((Object)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable"));
        JavaResourceTypeTests.assertEquals((int)2, (int)resourceType.getAnnotationsSize("javax.persistence.SecondaryTable"));
    }

    public void testAddJavaTypeAnnotationNestableContainer3() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithSecondaryTables();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation secondaryTableResource = (SecondaryTableAnnotation)resourceType.addAnnotation(1, "javax.persistence.SecondaryTable");
        secondaryTableResource.setName("BAR");
        this.assertSourceContains("@SecondaryTables({@SecondaryTable(name = \"FOO\"),@SecondaryTable(name = \"BAR\")})", cu);
        JavaResourceTypeTests.assertNotNull((Object)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable"));
        JavaResourceTypeTests.assertEquals((int)2, (int)resourceType.getAnnotationsSize("javax.persistence.SecondaryTable"));
    }

    public void testAddJavaTypeAnnotationNestableContainer5() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithSecondaryTables();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation secondaryTableResource = (SecondaryTableAnnotation)resourceType.addAnnotation(0, "javax.persistence.SecondaryTable");
        secondaryTableResource.setName("BAR");
        this.assertSourceContains("@SecondaryTables({@SecondaryTable(name = \"BAR\"),@SecondaryTable(name = \"FOO\")})", cu);
        JavaResourceTypeTests.assertNotNull((Object)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable"));
        JavaResourceTypeTests.assertEquals((int)2, (int)resourceType.getAnnotationsSize("javax.persistence.SecondaryTable"));
    }

    public void testAddJavaTypeAnnotationNestableContainer6() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithSecondaryTables();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation secondaryTableResource = (SecondaryTableAnnotation)resourceType.addAnnotation(0, "javax.persistence.SecondaryTable");
        secondaryTableResource.setName("BAR");
        this.assertSourceContains("@SecondaryTables({@SecondaryTable(name = \"BAR\"),@SecondaryTable(name = \"FOO\")})", cu);
        JavaResourceTypeTests.assertNotNull((Object)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable"));
        JavaResourceTypeTests.assertEquals((int)2, (int)resourceType.getAnnotationsSize("javax.persistence.SecondaryTable"));
        secondaryTableResource = (SecondaryTableAnnotation)resourceType.addAnnotation(0, "javax.persistence.SecondaryTable");
        secondaryTableResource.setName("BAZ");
        this.assertSourceContains("@SecondaryTables({@SecondaryTable(name = \"BAZ\"),@SecondaryTable(name = \"BAR\"), @SecondaryTable(name = \"FOO\")})", cu);
        JavaResourceTypeTests.assertEquals((int)3, (int)resourceType.getAnnotationsSize("javax.persistence.SecondaryTable"));
    }

    public void testRemoveJavaTypeAnnotationNestableContainer() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithSecondaryTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        resourceType.removeAnnotation(0, "javax.persistence.SecondaryTable");
        this.assertSourceDoesNotContain("@SecondaryTable", cu);
    }

    public void testRemoveJavaTypeAnnotationNestableContainer2() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithSecondaryTables();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        resourceType.removeAnnotation(0, "javax.persistence.SecondaryTable");
        this.assertSourceDoesNotContain("@SecondaryTable(name = \"FOO\")", cu);
        this.assertSourceContains("@SecondaryTables", cu);
    }

    public void testRemoveJavaTypeAnnotationIndex() throws Exception {
        ICompilationUnit cu = this.createTestEntityWith2SecondaryTables();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        resourceType.removeAnnotation(0, "javax.persistence.SecondaryTable");
        this.assertSourceDoesNotContain("@SecondaryTable(name = \"FOO\"", cu);
        this.assertSourceContains("@SecondaryTable(name = \"BAR\"", cu);
        this.assertSourceDoesNotContain("@SecondaryTables", cu);
    }

    public void testRemoveJavaTypeAnnotationIndex2() throws Exception {
        ICompilationUnit cu = this.createTestEntityWith2SecondaryTables();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation newAnnotation = (SecondaryTableAnnotation)resourceType.addAnnotation(2, "javax.persistence.SecondaryTable");
        newAnnotation.setName("BAZ");
        this.assertSourceContains("@SecondaryTables({@SecondaryTable(name = \"FOO\"), @SecondaryTable(name = \"BAR\"), @SecondaryTable(name = \"BAZ", cu);
        resourceType.removeAnnotation(1, "javax.persistence.SecondaryTable");
        this.assertSourceContains("@SecondaryTables({@SecondaryTable(name = \"FOO\"), @SecondaryTable(name = \"BAZ\")})", cu);
    }

    public void testMoveJavaTypeAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestEntityWith2SecondaryTables();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation newAnnotation = (SecondaryTableAnnotation)resourceType.addAnnotation(2, "javax.persistence.SecondaryTable");
        newAnnotation.setName("BAZ");
        this.assertSourceContains("@SecondaryTables({@SecondaryTable(name = \"FOO\"), @SecondaryTable(name = \"BAR\"), @SecondaryTable(name = \"BAZ\")})", cu);
        resourceType.moveAnnotation(0, 2, "javax.persistence.SecondaryTable");
        this.assertSourceContains("@SecondaryTables({@SecondaryTable(name = \"BAZ\"), @SecondaryTable(name = \"FOO\"), @SecondaryTable(name = \"BAR\")})", cu);
    }

    public void testMoveJavaTypeAnnotation2() throws Exception {
        ICompilationUnit cu = this.createTestEntityWith2SecondaryTables();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation newAnnotation = (SecondaryTableAnnotation)resourceType.addAnnotation(2, "javax.persistence.SecondaryTable");
        newAnnotation.setName("BAZ");
        this.assertSourceContains("@SecondaryTables({@SecondaryTable(name = \"FOO\"), @SecondaryTable(name = \"BAR\"), @SecondaryTable(name = \"BAZ\")})", cu);
        resourceType.moveAnnotation(2, 0, "javax.persistence.SecondaryTable");
        this.assertSourceContains("@SecondaryTables({@SecondaryTable(name = \"BAR\"), @SecondaryTable(name = \"BAZ\"), @SecondaryTable(name = \"FOO\")})", cu);
    }

    public void testNestedTypes() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithMemberTypes();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceTypeTests.assertEquals((String)"only not classes and interfaces should be returned by #getTypes()", (int)2, (int)CollectionTools.size((Iterable)resourceType.getTypes()));
        JavaResourceTypeTests.assertEquals((String)"only enums should be returned by #getEnums()", (int)1, (int)CollectionTools.size((Iterable)resourceType.getEnums()));
    }

    public void testDuplicateEntityAnnotations() throws Exception {
        ICompilationUnit cu = this.createTestEntityDuplicates();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        EntityAnnotation javaTypeMappingAnnotation = (EntityAnnotation)resourceType.getAnnotation("javax.persistence.Entity");
        JavaResourceTypeTests.assertEquals((String)"FirstEntity", (String)javaTypeMappingAnnotation.getName());
        JavaResourceTypeTests.assertEquals((int)1, (int)resourceType.getAnnotationsSize());
        javaTypeMappingAnnotation = (EntityAnnotation)resourceType.getAnnotation("javax.persistence.Entity");
        JavaResourceTypeTests.assertEquals((String)"FirstEntity", (String)javaTypeMappingAnnotation.getName());
    }

    public void testAttributes() throws Exception {
    }

    public void testFields() throws Exception {
    }

    public void testProperties() throws Exception {
    }

    public void testGetSuperclassQualifiedName() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceTypeTests.assertEquals((String)"java.lang.Object", (String)resourceType.getSuperclassQualifiedName());
    }

    public void testIsAnnotated() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceTypeTests.assertTrue((boolean)resourceType.isAnnotated());
        resourceType.removeAnnotation("javax.persistence.Entity");
        JavaResourceTypeTests.assertFalse((boolean)resourceType.isAnnotated());
        resourceType.addAnnotation("javax.persistence.Table");
        JavaResourceTypeTests.assertTrue((boolean)resourceType.isAnnotated());
    }

    public void testAnnotatedMemberType() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithMemberEmbeddable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceTypeTests.assertNotNull((Object)resourceType.getAnnotation("javax.persistence.Entity"));
        JavaResourceTypeTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.Embeddable"));
        JavaResourceType nestedType = (JavaResourceType)resourceType.getTypes().iterator().next();
        JavaResourceTypeTests.assertNull((Object)nestedType.getAnnotation("javax.persistence.Entity"));
        JavaResourceTypeTests.assertNotNull((Object)nestedType.getAnnotation("javax.persistence.Embeddable"));
    }

    public void testInvalidAnnotations() throws Exception {
        ICompilationUnit cu = this.createTestInvalidAnnotations();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceTypeTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize());
        JavaResourceTypeTests.assertEquals((int)0, (int)resourceType.getAnnotationsSize());
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaResourceTypeTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize());
        JavaResourceTypeTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize());
    }
}

