/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JoinTableAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class JoinTableTests
extends JpaJavaResourceModelTestCase {
    private static final String TABLE_NAME = "MY_TABLE";
    private static final String SCHEMA_NAME = "MY_SCHEMA";
    private static final String CATALOG_NAME = "MY_CATALOG";

    public JoinTableTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestJoinTable() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.JoinTable"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinTable");
            }
        });
    }

    private ICompilationUnit createTestJoinTableWithName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.JoinTable"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinTable(name = \"MY_TABLE\")");
            }
        });
    }

    private ICompilationUnit createTestJoinTableWithSchema() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.JoinTable"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinTable(schema = \"MY_SCHEMA\")");
            }
        });
    }

    private ICompilationUnit createTestJoinTableWithCatalog() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.JoinTable"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinTable(catalog = \"MY_CATALOG\")");
            }
        });
    }

    private ICompilationUnit createTestJoinTableWithUniqueConstraints() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.JoinTable", "javax.persistence.UniqueConstraint"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinTable(uniqueConstraints = {@UniqueConstraint(columnNames = {\"BAR\"}), @UniqueConstraint(columnNames = {\"FOO\"}), @UniqueConstraint(columnNames = {\"BAZ\"})})");
            }
        });
    }

    private ICompilationUnit createTestJoinTableWithJoinColumns() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.JoinTable", "javax.persistence.JoinColumn"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinTable(joinColumns = {@JoinColumn(name = \"BAR\"), @JoinColumn})");
            }
        });
    }

    private ICompilationUnit createTestJoinTableWithInverseJoinColumns() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.JoinTable", "javax.persistence.JoinColumn"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinTable(inverseJoinColumns = {@JoinColumn(name = \"BAR\"), @JoinColumn})");
            }
        });
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestJoinTableWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JoinTableTests.assertNotNull((Object)table);
        JoinTableTests.assertEquals((String)TABLE_NAME, (String)table.getName());
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestJoinTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JoinTableTests.assertNotNull((Object)table);
        JoinTableTests.assertNull((Object)table.getName());
        JoinTableTests.assertNull((Object)table.getCatalog());
        JoinTableTests.assertNull((Object)table.getSchema());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestJoinTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JoinTableTests.assertNotNull((Object)table);
        JoinTableTests.assertNull((Object)table.getName());
        table.setName("Foo");
        JoinTableTests.assertEquals((String)"Foo", (String)table.getName());
        this.assertSourceContains("@JoinTable(name = \"Foo\")", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestJoinTableWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JoinTableTests.assertEquals((String)TABLE_NAME, (String)table.getName());
        table.setName(null);
        JoinTableTests.assertNull((Object)table.getName());
        this.assertSourceDoesNotContain("@JoinTable(", cu);
    }

    public void testGetCatalog() throws Exception {
        ICompilationUnit cu = this.createTestJoinTableWithCatalog();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JoinTableTests.assertNotNull((Object)table);
        JoinTableTests.assertEquals((String)CATALOG_NAME, (String)table.getCatalog());
    }

    public void testSetCatalog() throws Exception {
        ICompilationUnit cu = this.createTestJoinTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JoinTableTests.assertNotNull((Object)table);
        JoinTableTests.assertNull((Object)table.getCatalog());
        table.setCatalog("Foo");
        JoinTableTests.assertEquals((String)"Foo", (String)table.getCatalog());
        this.assertSourceContains("@JoinTable(catalog = \"Foo\")", cu);
    }

    public void testSetCatalogNull() throws Exception {
        ICompilationUnit cu = this.createTestJoinTableWithCatalog();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JoinTableTests.assertEquals((String)CATALOG_NAME, (String)table.getCatalog());
        table.setCatalog(null);
        JoinTableTests.assertNull((Object)table.getCatalog());
        this.assertSourceDoesNotContain("@JoinTable(", cu);
    }

    public void testGetSchema() throws Exception {
        ICompilationUnit cu = this.createTestJoinTableWithSchema();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JoinTableTests.assertNotNull((Object)table);
        JoinTableTests.assertEquals((String)SCHEMA_NAME, (String)table.getSchema());
    }

    public void testSetSchema() throws Exception {
        ICompilationUnit cu = this.createTestJoinTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JoinTableTests.assertNotNull((Object)table);
        JoinTableTests.assertNull((Object)table.getSchema());
        table.setSchema("Foo");
        JoinTableTests.assertEquals((String)"Foo", (String)table.getSchema());
        this.assertSourceContains("@JoinTable(schema = \"Foo\")", cu);
    }

    public void testSetSchemaNull() throws Exception {
        ICompilationUnit cu = this.createTestJoinTableWithSchema();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JoinTableTests.assertEquals((String)SCHEMA_NAME, (String)table.getSchema());
        table.setSchema(null);
        JoinTableTests.assertNull((Object)table.getSchema());
        this.assertSourceDoesNotContain("@JoinTable(", cu);
    }

    public void testUniqueConstraints() throws Exception {
        ICompilationUnit cu = this.createTestJoinTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JoinTableTests.assertEquals((int)0, (int)table.getUniqueConstraintsSize());
    }

    public void testUniqueConstraints2() throws Exception {
        ICompilationUnit cu = this.createTestJoinTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        table.addUniqueConstraint(0);
        table.addUniqueConstraint(1);
        JoinTableTests.assertEquals((int)2, (int)table.getUniqueConstraintsSize());
    }

    public void testUniqueConstraints3() throws Exception {
        ICompilationUnit cu = this.createTestJoinTableWithUniqueConstraints();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JoinTableTests.assertEquals((int)3, (int)table.getUniqueConstraintsSize());
    }

    public void testAddUniqueConstraint() throws Exception {
        ICompilationUnit cu = this.createTestJoinTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        table.addUniqueConstraint(0).addColumnName("FOO");
        table.addUniqueConstraint(1);
        table.addUniqueConstraint(0).addColumnName("BAR");
        JoinTableTests.assertEquals((String)"BAR", (String)table.uniqueConstraintAt(0).columnNameAt(0));
        JoinTableTests.assertEquals((String)"FOO", (String)table.uniqueConstraintAt(1).columnNameAt(0));
        JoinTableTests.assertEquals((int)0, (int)table.uniqueConstraintAt(2).getColumnNamesSize());
        this.assertSourceContains("@JoinTable(uniqueConstraints = {@UniqueConstraint(columnNames = \"BAR\"),@UniqueConstraint(columnNames = \"FOO\"), @UniqueConstraint})", cu);
    }

    public void testRemoveUniqueConstraint() throws Exception {
        ICompilationUnit cu = this.createTestJoinTableWithUniqueConstraints();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JoinTableTests.assertEquals((String)"BAR", (String)table.uniqueConstraintAt(0).columnNameAt(0));
        JoinTableTests.assertEquals((String)"FOO", (String)table.uniqueConstraintAt(1).columnNameAt(0));
        JoinTableTests.assertEquals((String)"BAZ", (String)table.uniqueConstraintAt(2).columnNameAt(0));
        JoinTableTests.assertEquals((int)3, (int)table.getUniqueConstraintsSize());
        table.removeUniqueConstraint(1);
        JoinTableTests.assertEquals((String)"BAR", (String)table.uniqueConstraintAt(0).columnNameAt(0));
        JoinTableTests.assertEquals((String)"BAZ", (String)table.uniqueConstraintAt(1).columnNameAt(0));
        JoinTableTests.assertEquals((int)2, (int)table.getUniqueConstraintsSize());
        this.assertSourceContains("@JoinTable(uniqueConstraints = {@UniqueConstraint(columnNames = {\"BAR\"}), @UniqueConstraint(columnNames = {\"BAZ\"})})", cu);
        table.removeUniqueConstraint(0);
        JoinTableTests.assertEquals((String)"BAZ", (String)table.uniqueConstraintAt(0).columnNameAt(0));
        JoinTableTests.assertEquals((int)1, (int)table.getUniqueConstraintsSize());
        this.assertSourceContains("@JoinTable(uniqueConstraints = @UniqueConstraint(columnNames = {\"BAZ\"}))", cu);
        table.removeUniqueConstraint(0);
        JoinTableTests.assertEquals((int)0, (int)table.getUniqueConstraintsSize());
        this.assertSourceDoesNotContain("@JoinTable(", cu);
    }

    public void testMoveUniqueConstraint() throws Exception {
        ICompilationUnit cu = this.createTestJoinTableWithUniqueConstraints();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        this.assertSourceContains("@JoinTable(uniqueConstraints = {@UniqueConstraint(columnNames = {\"BAR\"}), @UniqueConstraint(columnNames = {\"FOO\"}), @UniqueConstraint(columnNames = {\"BAZ\"})})", cu);
        table.moveUniqueConstraint(2, 0);
        this.assertSourceContains("@JoinTable(uniqueConstraints = {@UniqueConstraint(columnNames = {\"FOO\"}), @UniqueConstraint(columnNames = {\"BAZ\"}), @UniqueConstraint(columnNames = {\"BAR\"})})", cu);
    }

    public void testMoveUniqueConstraint2() throws Exception {
        ICompilationUnit cu = this.createTestJoinTableWithUniqueConstraints();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        this.assertSourceContains("@JoinTable(uniqueConstraints = {@UniqueConstraint(columnNames = {\"BAR\"}), @UniqueConstraint(columnNames = {\"FOO\"}), @UniqueConstraint(columnNames = {\"BAZ\"})})", cu);
        table.moveUniqueConstraint(0, 2);
        this.assertSourceContains("@JoinTable(uniqueConstraints = {@UniqueConstraint(columnNames = {\"BAZ\"}), @UniqueConstraint(columnNames = {\"BAR\"}), @UniqueConstraint(columnNames = {\"FOO\"})})", cu);
    }

    public void testJoinColumns() throws Exception {
        ICompilationUnit cu = this.createTestJoinTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JoinTableTests.assertEquals((int)0, (int)table.getJoinColumnsSize());
    }

    public void testJoinColumns2() throws Exception {
        ICompilationUnit cu = this.createTestJoinTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        table.addJoinColumn(0);
        table.addJoinColumn(1);
        JoinTableTests.assertEquals((int)2, (int)table.getJoinColumnsSize());
    }

    public void testJoinColumns3() throws Exception {
        ICompilationUnit cu = this.createTestJoinTableWithJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JoinTableTests.assertEquals((int)2, (int)table.getJoinColumnsSize());
    }

    public void testAddJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestJoinTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        table.addJoinColumn(0).setName("FOO");
        table.addJoinColumn(1);
        table.addJoinColumn(0).setName("BAR");
        JoinTableTests.assertEquals((String)"BAR", (String)table.joinColumnAt(0).getName());
        JoinTableTests.assertEquals((String)"FOO", (String)table.joinColumnAt(1).getName());
        JoinTableTests.assertNull((Object)table.joinColumnAt(2).getName());
        this.assertSourceContains("@JoinTable(joinColumns = {@JoinColumn(name = \"BAR\"),@JoinColumn(name = \"FOO\"), @JoinColumn})", cu);
    }

    public void testRemoveJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestJoinTableWithJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        table.addJoinColumn(0).setName("FOO");
        JoinTableTests.assertEquals((String)"FOO", (String)table.joinColumnAt(0).getName());
        JoinTableTests.assertEquals((String)"BAR", (String)table.joinColumnAt(1).getName());
        JoinTableTests.assertNull((Object)table.joinColumnAt(2).getName());
        JoinTableTests.assertEquals((int)3, (int)table.getJoinColumnsSize());
        table.removeJoinColumn(1);
        JoinTableTests.assertEquals((String)"FOO", (String)table.joinColumnAt(0).getName());
        JoinTableTests.assertNull((Object)table.joinColumnAt(1).getName());
        JoinTableTests.assertEquals((int)2, (int)table.getJoinColumnsSize());
        this.assertSourceContains("@JoinTable(joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn})", cu);
        table.removeJoinColumn(0);
        JoinTableTests.assertNull((Object)table.joinColumnAt(0).getName());
        JoinTableTests.assertEquals((int)1, (int)table.getJoinColumnsSize());
        this.assertSourceContains("@JoinTable(joinColumns = @JoinColumn)", cu);
        table.removeJoinColumn(0);
        JoinTableTests.assertEquals((int)0, (int)table.getJoinColumnsSize());
        this.assertSourceDoesNotContain("@JoinTable(", cu);
    }

    public void testMoveJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestJoinTableWithJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JoinColumnAnnotation joinColumn = table.joinColumnAt(0);
        joinColumn.setReferencedColumnName("REF_NAME");
        joinColumn.setUnique(Boolean.FALSE);
        joinColumn.setNullable(Boolean.FALSE);
        joinColumn.setInsertable(Boolean.FALSE);
        joinColumn.setUpdatable(Boolean.FALSE);
        joinColumn.setColumnDefinition("COLUMN_DEF");
        joinColumn.setTable("TABLE");
        table.addJoinColumn(0).setName("FOO");
        this.assertSourceContains("@JoinTable(joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"), @JoinColumn})", cu);
        table.moveJoinColumn(2, 0);
        JoinTableTests.assertEquals((String)"BAR", (String)table.joinColumnAt(0).getName());
        JoinTableTests.assertNull((Object)table.joinColumnAt(1).getName());
        JoinTableTests.assertEquals((String)"FOO", (String)table.joinColumnAt(2).getName());
        JoinTableTests.assertEquals((int)3, (int)table.getJoinColumnsSize());
        this.assertSourceContains("@JoinTable(joinColumns = {@JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"), @JoinColumn, @JoinColumn(name = \"FOO\")})", cu);
    }

    public void testMoveJoinColumn2() throws Exception {
        ICompilationUnit cu = this.createTestJoinTableWithJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JoinColumnAnnotation joinColumn = table.joinColumnAt(0);
        joinColumn.setReferencedColumnName("REF_NAME");
        joinColumn.setUnique(Boolean.FALSE);
        joinColumn.setNullable(Boolean.FALSE);
        joinColumn.setInsertable(Boolean.FALSE);
        joinColumn.setUpdatable(Boolean.FALSE);
        joinColumn.setColumnDefinition("COLUMN_DEF");
        joinColumn.setTable("TABLE");
        table.addJoinColumn(0).setName("FOO");
        this.assertSourceContains("@JoinTable(joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"), @JoinColumn})", cu);
        table.moveJoinColumn(0, 2);
        JoinTableTests.assertNull((Object)table.joinColumnAt(0).getName());
        JoinTableTests.assertEquals((String)"FOO", (String)table.joinColumnAt(1).getName());
        JoinTableTests.assertEquals((String)"BAR", (String)table.joinColumnAt(2).getName());
        JoinTableTests.assertEquals((int)3, (int)table.getJoinColumnsSize());
        this.assertSourceContains("@JoinTable(joinColumns = {@JoinColumn, @JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\")})", cu);
    }

    public void testSetJoinColumnName() throws Exception {
        ICompilationUnit cu = this.createTestJoinTableWithJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JoinTableTests.assertEquals((int)2, (int)table.getJoinColumnsSize());
        JoinColumnAnnotation joinColumn = table.joinColumnAt(0);
        JoinTableTests.assertEquals((String)"BAR", (String)joinColumn.getName());
        joinColumn.setName("foo");
        JoinTableTests.assertEquals((String)"foo", (String)joinColumn.getName());
        this.assertSourceContains("@JoinTable(joinColumns = {@JoinColumn(name = \"foo\"), @JoinColumn})", cu);
    }

    public void testInverseJoinColumns() throws Exception {
        ICompilationUnit cu = this.createTestJoinTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JoinTableTests.assertEquals((int)0, (int)table.getInverseJoinColumnsSize());
    }

    public void testInverseJoinColumns2() throws Exception {
        ICompilationUnit cu = this.createTestJoinTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        table.addInverseJoinColumn(0);
        table.addInverseJoinColumn(1);
        JoinTableTests.assertEquals((int)2, (int)table.getInverseJoinColumnsSize());
    }

    public void testInverseJoinColumns3() throws Exception {
        ICompilationUnit cu = this.createTestJoinTableWithInverseJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JoinTableTests.assertEquals((int)2, (int)table.getInverseJoinColumnsSize());
    }

    public void testAddInverseJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestJoinTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        table.addInverseJoinColumn(0).setName("FOO");
        table.addInverseJoinColumn(1);
        table.addInverseJoinColumn(0).setName("BAR");
        JoinTableTests.assertEquals((String)"BAR", (String)table.inverseJoinColumnAt(0).getName());
        JoinTableTests.assertEquals((String)"FOO", (String)table.inverseJoinColumnAt(1).getName());
        JoinTableTests.assertNull((Object)table.inverseJoinColumnAt(2).getName());
        this.assertSourceContains("@JoinTable(inverseJoinColumns = {@JoinColumn(name = \"BAR\"),@JoinColumn(name = \"FOO\"), @JoinColumn})", cu);
    }

    public void testRemoveInverseJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestJoinTableWithInverseJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        table.addInverseJoinColumn(2).setName("FOO");
        ListIterator inverseJoinColumns = table.getInverseJoinColumns().iterator();
        JoinTableTests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        JoinTableTests.assertNull((Object)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        JoinTableTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        JoinTableTests.assertFalse((boolean)inverseJoinColumns.hasNext());
        table.removeInverseJoinColumn(1);
        this.assertSourceContains("@JoinTable(inverseJoinColumns = {@JoinColumn(name = \"BAR\"), @JoinColumn(name = \"FOO\")})", cu);
        inverseJoinColumns = table.getInverseJoinColumns().iterator();
        JoinTableTests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        JoinTableTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        JoinTableTests.assertFalse((boolean)inverseJoinColumns.hasNext());
        table.removeInverseJoinColumn(0);
        this.assertSourceContains("@JoinTable(inverseJoinColumns = @JoinColumn(name = \"FOO\"))", cu);
        inverseJoinColumns = table.getInverseJoinColumns().iterator();
        JoinTableTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        JoinTableTests.assertFalse((boolean)inverseJoinColumns.hasNext());
        table.removeInverseJoinColumn(0);
        this.assertSourceDoesNotContain("@JoinTable(", cu);
    }

    public void testMoveInverseJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestJoinTableWithInverseJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        table.addInverseJoinColumn(0).setName("FOO");
        ListIterator inverseJoinColumns = table.getInverseJoinColumns().iterator();
        JoinTableTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        JoinTableTests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        JoinTableTests.assertNull((Object)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        table.moveInverseJoinColumn(2, 0);
        inverseJoinColumns = table.getInverseJoinColumns().iterator();
        JoinTableTests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        JoinTableTests.assertNull((Object)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        JoinTableTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        this.assertSourceContains("@JoinTable(inverseJoinColumns = {@JoinColumn(name = \"BAR\"), @JoinColumn, @JoinColumn(name = \"FOO\")})", cu);
    }

    public void testMoveInverseJoinColumn2() throws Exception {
        ICompilationUnit cu = this.createTestJoinTableWithInverseJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        table.addInverseJoinColumn(1).setName("FOO");
        ListIterator inverseJoinColumns = table.getInverseJoinColumns().iterator();
        JoinTableTests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        JoinTableTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        JoinTableTests.assertNull((Object)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        table.moveInverseJoinColumn(0, 2);
        inverseJoinColumns = table.getInverseJoinColumns().iterator();
        JoinTableTests.assertNull((Object)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        JoinTableTests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        JoinTableTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        this.assertSourceContains("@JoinTable(inverseJoinColumns = {@JoinColumn, @JoinColumn(name = \"BAR\"), @JoinColumn(name = \"FOO\")})", cu);
    }

    public void testSetInverseJoinColumnName() throws Exception {
        ICompilationUnit cu = this.createTestJoinTableWithInverseJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinTableAnnotation table = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JoinTableTests.assertEquals((int)2, (int)table.getInverseJoinColumnsSize());
        JoinColumnAnnotation joinColumn = table.inverseJoinColumnAt(0);
        JoinTableTests.assertEquals((String)"BAR", (String)joinColumn.getName());
        joinColumn.setName("foo");
        JoinTableTests.assertEquals((String)"foo", (String)joinColumn.getName());
        this.assertSourceContains("@JoinTable(inverseJoinColumns = {@JoinColumn(name = \"foo\"), @JoinColumn})", cu);
    }
}

