/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.resource.java.OrderByAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class OrderByTests
extends JpaJavaResourceModelTestCase {
    public OrderByTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestOrderBy() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.OrderBy"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OrderBy");
            }
        });
    }

    private ICompilationUnit createTestOrderByWithValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.OrderBy"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OrderBy(value = \"key\")");
            }
        });
    }

    public void testOrderBy() throws Exception {
        ICompilationUnit cu = this.createTestOrderBy();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        OrderByAnnotation orderBy = (OrderByAnnotation)resourceField.getAnnotation("javax.persistence.OrderBy");
        OrderByTests.assertNotNull((Object)orderBy);
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestOrderByWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        OrderByAnnotation orderBy = (OrderByAnnotation)resourceField.getAnnotation("javax.persistence.OrderBy");
        OrderByTests.assertEquals((String)"key", (String)orderBy.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestOrderBy();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        OrderByAnnotation orderBy = (OrderByAnnotation)resourceField.getAnnotation("javax.persistence.OrderBy");
        orderBy.setValue("foo");
        this.assertSourceContains("@OrderBy(\"foo\")", cu);
        orderBy.setValue(null);
        this.assertSourceContains("@OrderBy", cu);
    }
}

