/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.SecondaryTableAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class SecondaryTablesTests
extends JpaJavaResourceModelTestCase {
    private static final String TABLE_NAME = "MY_TABLE";
    private static final String SCHEMA_NAME = "MY_SCHEMA";
    private static final String CATALOG_NAME = "MY_CATALOG";

    public SecondaryTablesTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestSecondaryTables() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@SecondaryTables(@SecondaryTable)");
            }
        });
    }

    private ICompilationUnit createTestSecondaryTableWithName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@SecondaryTables(@SecondaryTable(name = \"MY_TABLE\"))");
            }
        });
    }

    private ICompilationUnit createTestSecondaryTableWithSchema() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@SecondaryTables(@SecondaryTable(schema = \"MY_SCHEMA\"))");
            }
        });
    }

    private ICompilationUnit createTestSecondaryTableWithCatalog() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@SecondaryTables(@SecondaryTable(catalog = \"MY_CATALOG\"))");
            }
        });
    }

    private ICompilationUnit createTestSecondaryTableWithUniqueConstraints() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables", "javax.persistence.UniqueConstraint"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@SecondaryTables(@SecondaryTable(uniqueConstraints = {@UniqueConstraint(columnNames = {\"BAR\"}), @UniqueConstraint}))");
            }
        });
    }

    private ICompilationUnit createTestSecondaryTable() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.SecondaryTable", "javax.persistence.UniqueConstraint"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append(CR);
                sb.append("@SecondaryTable(name = \"FOO\", catalog = \"BAR\", schema = \"BAZ\", uniqueConstraints = @UniqueConstraint(columnNames = {\"BAR\"}))");
            }
        });
    }

    private ICompilationUnit createTestSecondaryTablesWithPkJoinColumns() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.SecondaryTables", "javax.persistence.SecondaryTable", "javax.persistence.PrimaryKeyJoinColumn"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@SecondaryTables(@SecondaryTable(pkJoinColumns = {@PrimaryKeyJoinColumn(name = \"BAR\"), @PrimaryKeyJoinColumn(name = \"FOO\"), @PrimaryKeyJoinColumn(name = \"BAZ\")}))");
            }
        });
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTableWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        Annotation secondaryTables = resourceType.getAnnotation("javax.persistence.SecondaryTables");
        SecondaryTablesTests.assertNotNull((Object)secondaryTables);
        SecondaryTableAnnotation secondaryTable = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTablesTests.assertEquals((String)TABLE_NAME, (String)secondaryTable.getName());
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTables();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation secondaryTable = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTablesTests.assertNull((Object)secondaryTable.getName());
        SecondaryTablesTests.assertNull((Object)secondaryTable.getCatalog());
        SecondaryTablesTests.assertNull((Object)secondaryTable.getSchema());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTables();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation secondaryTable = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTablesTests.assertNull((Object)secondaryTable.getName());
        secondaryTable.setName("Foo");
        SecondaryTablesTests.assertEquals((String)"Foo", (String)secondaryTable.getName());
        this.assertSourceContains("@SecondaryTables(@SecondaryTable(name = \"Foo\"))", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTableWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation secondaryTable = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTablesTests.assertEquals((String)TABLE_NAME, (String)secondaryTable.getName());
        secondaryTable.setName(null);
        SecondaryTablesTests.assertNull((Object)secondaryTable.getName());
        this.assertSourceDoesNotContain("@SecondaryTable(", cu);
    }

    public void testGetCatalog() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTableWithCatalog();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation secondaryTable = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTablesTests.assertEquals((String)CATALOG_NAME, (String)secondaryTable.getCatalog());
    }

    public void testSetCatalog() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTables();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation secondaryTable = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTablesTests.assertNull((Object)secondaryTable.getCatalog());
        secondaryTable.setCatalog("Foo");
        SecondaryTablesTests.assertEquals((String)"Foo", (String)secondaryTable.getCatalog());
        this.assertSourceContains("@SecondaryTables(@SecondaryTable(catalog = \"Foo\"))", cu);
    }

    public void testSetCatalogNull() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTableWithCatalog();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation secondaryTable = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTablesTests.assertEquals((String)CATALOG_NAME, (String)secondaryTable.getCatalog());
        secondaryTable.setCatalog(null);
        SecondaryTablesTests.assertNull((Object)secondaryTable.getCatalog());
        this.assertSourceDoesNotContain("@SecondaryTable(", cu);
    }

    public void testGetSchema() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTableWithSchema();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation secondaryTable = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTablesTests.assertNotNull((Object)secondaryTable);
        SecondaryTablesTests.assertEquals((String)SCHEMA_NAME, (String)secondaryTable.getSchema());
    }

    public void testSetSchema() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTables();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation secondaryTable = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTablesTests.assertNull((Object)secondaryTable.getSchema());
        secondaryTable.setSchema("Foo");
        SecondaryTablesTests.assertEquals((String)"Foo", (String)secondaryTable.getSchema());
        this.assertSourceContains("@SecondaryTables(@SecondaryTable(schema = \"Foo\"))", cu);
    }

    public void testSetSchemaNull() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTableWithSchema();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation secondaryTable = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTablesTests.assertEquals((String)SCHEMA_NAME, (String)secondaryTable.getSchema());
        secondaryTable.setSchema(null);
        SecondaryTablesTests.assertNull((Object)secondaryTable.getSchema());
        this.assertSourceDoesNotContain("@SecondaryTable(", cu);
    }

    public void testUniqueConstraints() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTables();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation secondaryTable = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTablesTests.assertEquals((int)0, (int)secondaryTable.getUniqueConstraintsSize());
    }

    public void testUniqueConstraints2() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTables();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation secondaryTable = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        secondaryTable.addUniqueConstraint(0);
        secondaryTable.addUniqueConstraint(1);
        SecondaryTablesTests.assertEquals((int)2, (int)secondaryTable.getUniqueConstraintsSize());
    }

    public void testUniqueConstraints3() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTableWithUniqueConstraints();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation secondaryTable = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTablesTests.assertEquals((int)2, (int)secondaryTable.getUniqueConstraintsSize());
    }

    public void testAddUniqueConstraint() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTables();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation secondaryTable = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        secondaryTable.addUniqueConstraint(0).addColumnName("FOO");
        secondaryTable.addUniqueConstraint(1);
        secondaryTable.addUniqueConstraint(0).addColumnName("BAR");
        SecondaryTablesTests.assertEquals((String)"BAR", (String)secondaryTable.uniqueConstraintAt(0).columnNameAt(0));
        SecondaryTablesTests.assertEquals((String)"FOO", (String)secondaryTable.uniqueConstraintAt(1).columnNameAt(0));
        SecondaryTablesTests.assertEquals((int)0, (int)secondaryTable.uniqueConstraintAt(2).getColumnNamesSize());
        this.assertSourceContains("@SecondaryTables(@SecondaryTable(uniqueConstraints = {@UniqueConstraint(columnNames = \"BAR\"),@UniqueConstraint(columnNames = \"FOO\"), @UniqueConstraint}))", cu);
    }

    public void testRemoveUniqueConstraint() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTableWithUniqueConstraints();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation secondaryTable = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        secondaryTable.addUniqueConstraint(0).addColumnName("FOO");
        secondaryTable.removeUniqueConstraint(2);
        this.assertSourceContains("@SecondaryTables(@SecondaryTable(uniqueConstraints = {@UniqueConstraint(columnNames = \"FOO\"), @UniqueConstraint(columnNames = {\"BAR\"})})", cu);
        secondaryTable.removeUniqueConstraint(0);
        this.assertSourceContains("@SecondaryTables(@SecondaryTable(uniqueConstraints = @UniqueConstraint(columnNames = {\"BAR\"}))", cu);
        secondaryTable.removeUniqueConstraint(0);
        this.assertSourceDoesNotContain("@SecondaryTable(", cu);
    }

    public void testMoveUniqueConstraint() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTableWithUniqueConstraints();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation secondaryTable = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        secondaryTable.addUniqueConstraint(0).addColumnName("FOO");
        SecondaryTablesTests.assertEquals((String)"FOO", (String)secondaryTable.uniqueConstraintAt(0).columnNameAt(0));
        SecondaryTablesTests.assertEquals((String)"BAR", (String)secondaryTable.uniqueConstraintAt(1).columnNameAt(0));
        SecondaryTablesTests.assertEquals((int)0, (int)secondaryTable.uniqueConstraintAt(2).getColumnNamesSize());
        secondaryTable.moveUniqueConstraint(2, 0);
        SecondaryTablesTests.assertEquals((String)"BAR", (String)secondaryTable.uniqueConstraintAt(0).columnNameAt(0));
        SecondaryTablesTests.assertEquals((int)0, (int)secondaryTable.uniqueConstraintAt(1).getColumnNamesSize());
        SecondaryTablesTests.assertEquals((String)"FOO", (String)secondaryTable.uniqueConstraintAt(2).columnNameAt(0));
        this.assertSourceContains("@SecondaryTables(@SecondaryTable(uniqueConstraints = {@UniqueConstraint(columnNames = {\"BAR\"}), @UniqueConstraint, @UniqueConstraint(columnNames = \"FOO\")}))", cu);
    }

    public void testMoveUniqueConstraint2() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTableWithUniqueConstraints();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation secondaryTable = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        secondaryTable.addUniqueConstraint(0).addColumnName("FOO");
        SecondaryTablesTests.assertEquals((String)"FOO", (String)secondaryTable.uniqueConstraintAt(0).columnNameAt(0));
        SecondaryTablesTests.assertEquals((String)"BAR", (String)secondaryTable.uniqueConstraintAt(1).columnNameAt(0));
        SecondaryTablesTests.assertEquals((int)0, (int)secondaryTable.uniqueConstraintAt(2).getColumnNamesSize());
        secondaryTable.moveUniqueConstraint(0, 2);
        SecondaryTablesTests.assertEquals((int)0, (int)secondaryTable.uniqueConstraintAt(0).getColumnNamesSize());
        SecondaryTablesTests.assertEquals((String)"FOO", (String)secondaryTable.uniqueConstraintAt(1).columnNameAt(0));
        SecondaryTablesTests.assertEquals((String)"BAR", (String)secondaryTable.uniqueConstraintAt(2).columnNameAt(0));
        this.assertSourceContains("@SecondaryTables(@SecondaryTable(uniqueConstraints = {@UniqueConstraint, @UniqueConstraint(columnNames = \"FOO\"), @UniqueConstraint(columnNames = {\"BAR\"})}))", cu);
    }

    public void testAddSecondaryTableCopyExisting() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        String expected1 = "@SecondaryTables({";
        String expected2 = "@SecondaryTable(name = \"FOO\", catalog = \"BAR\", schema = \"BAZ\", uniqueConstraints = @UniqueConstraint(columnNames = { \"BAR\" })),";
        String expected3 = "@SecondaryTable(name = \"BAR\") })";
        SecondaryTableAnnotation secondaryTable = (SecondaryTableAnnotation)resourceType.addAnnotation(1, "javax.persistence.SecondaryTable");
        secondaryTable.setName("BAR");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        SecondaryTablesTests.assertNotNull((Object)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable"));
        SecondaryTablesTests.assertEquals((int)2, (int)resourceType.getAnnotationsSize("javax.persistence.SecondaryTable"));
    }

    public void testAddSecondaryTable() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        String expected1 = "@SecondaryTables({";
        String expected2 = "@SecondaryTable(name = \"FOO\", catalog = \"BAR\", schema = \"BAZ\", uniqueConstraints = @UniqueConstraint(columnNames = { \"BAR\" })),";
        String expected3 = "@SecondaryTable(name = \"BAR\") })";
        SecondaryTableAnnotation secondaryTable = (SecondaryTableAnnotation)resourceType.addAnnotation(1, "javax.persistence.SecondaryTable");
        secondaryTable.setName("BAR");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        expected2 = "@SecondaryTable(name = \"BAZ\"),";
        expected3 = "@SecondaryTable(name = \"FOO\", catalog = \"BAR\", schema = \"BAZ\", uniqueConstraints = @UniqueConstraint(columnNames = { \"BAR\" })), @SecondaryTable(name = \"BAR\") })";
        secondaryTable = (SecondaryTableAnnotation)resourceType.addAnnotation(0, "javax.persistence.SecondaryTable");
        secondaryTable.setName("BAZ");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        ListIterator secondaryTables = resourceType.getAnnotations("javax.persistence.SecondaryTable").iterator();
        SecondaryTablesTests.assertEquals((String)"BAZ", (String)((SecondaryTableAnnotation)secondaryTables.next()).getName());
        SecondaryTablesTests.assertEquals((String)"FOO", (String)((SecondaryTableAnnotation)secondaryTables.next()).getName());
        SecondaryTablesTests.assertEquals((String)"BAR", (String)((SecondaryTableAnnotation)secondaryTables.next()).getName());
        SecondaryTablesTests.assertNotNull((Object)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable"));
        SecondaryTablesTests.assertEquals((int)3, (int)resourceType.getAnnotationsSize("javax.persistence.SecondaryTable"));
    }

    public void testRemoveSecondaryTableCopyExisting() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        String expected1 = "@SecondaryTables({";
        String expected2 = "@SecondaryTable(name = \"FOO\", catalog = \"BAR\", schema = \"BAZ\", uniqueConstraints = @UniqueConstraint(columnNames = { \"BAR\" })),";
        String expected3 = "@SecondaryTable(name = \"BAR\") })";
        SecondaryTableAnnotation secondaryTable = (SecondaryTableAnnotation)resourceType.addAnnotation(1, "javax.persistence.SecondaryTable");
        secondaryTable.setName("BAR");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        expected1 = "@SecondaryTable(name = \"FOO\", catalog = \"BAR\", schema = \"BAZ\", uniqueConstraints = @UniqueConstraint(columnNames = { \"BAR\" }))";
        resourceType.removeAnnotation(1, "javax.persistence.SecondaryTable");
        this.assertSourceContains(expected1, cu);
        this.assertSourceDoesNotContain("@SecondaryTables", cu);
    }

    public void testPkJoinColumns() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTables();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTablesTests.assertEquals((int)0, (int)table.getPkJoinColumnsSize());
    }

    public void testPkJoinColumns2() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTables();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        table.addPkJoinColumn(0);
        table.addPkJoinColumn(1);
        SecondaryTablesTests.assertEquals((int)2, (int)table.getPkJoinColumnsSize());
    }

    public void testPkJoinColumns3() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTablesWithPkJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTablesTests.assertEquals((int)3, (int)table.getPkJoinColumnsSize());
    }

    public void testAddPkJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTables();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        table.addPkJoinColumn(0).setName("FOO");
        table.addPkJoinColumn(1);
        table.addPkJoinColumn(0).setName("BAR");
        this.assertSourceContains("@SecondaryTables(@SecondaryTable(pkJoinColumns = {@PrimaryKeyJoinColumn(name = \"BAR\"),@PrimaryKeyJoinColumn(name = \"FOO\"), @PrimaryKeyJoinColumn}))", cu);
    }

    public void testRemovePkJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTablesWithPkJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        table.removePkJoinColumn(1);
        this.assertSourceContains("@SecondaryTables(@SecondaryTable(pkJoinColumns = {@PrimaryKeyJoinColumn(name = \"BAR\"), @PrimaryKeyJoinColumn(name = \"BAZ\")}))", cu);
        table.removePkJoinColumn(0);
        this.assertSourceContains("@SecondaryTables(@SecondaryTable(pkJoinColumns = @PrimaryKeyJoinColumn(name = \"BAZ\")))", cu);
        table.removePkJoinColumn(0);
        this.assertSourceDoesNotContain("@SecondaryTable(", cu);
    }

    public void testMovePkJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTablesWithPkJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        PrimaryKeyJoinColumnAnnotation joinColumn = table.pkJoinColumnAt(0);
        joinColumn.setReferencedColumnName("REF_NAME");
        joinColumn.setColumnDefinition("COLUMN_DEF");
        table.movePkJoinColumn(2, 0);
        this.assertSourceContains("@SecondaryTables(@SecondaryTable(pkJoinColumns = {@PrimaryKeyJoinColumn(name = \"FOO\"), @PrimaryKeyJoinColumn(name = \"BAZ\"), @PrimaryKeyJoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", columnDefinition = \"COLUMN_DEF\")}))", cu);
    }

    public void testMovePkJoinColumn2() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTablesWithPkJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        PrimaryKeyJoinColumnAnnotation joinColumn = table.pkJoinColumnAt(0);
        joinColumn.setReferencedColumnName("REF_NAME");
        joinColumn.setColumnDefinition("COLUMN_DEF");
        table.movePkJoinColumn(0, 2);
        this.assertSourceContains("@SecondaryTables(@SecondaryTable(pkJoinColumns = {@PrimaryKeyJoinColumn(name = \"BAZ\"), @PrimaryKeyJoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", columnDefinition = \"COLUMN_DEF\"), @PrimaryKeyJoinColumn(name = \"FOO\")}))", cu);
    }

    public void testSetPkJoinColumnName() throws Exception {
        ICompilationUnit cu = this.createTestSecondaryTablesWithPkJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        SecondaryTablesTests.assertEquals((int)3, (int)table.getPkJoinColumnsSize());
        PrimaryKeyJoinColumnAnnotation joinColumn = table.pkJoinColumnAt(0);
        SecondaryTablesTests.assertEquals((String)"BAR", (String)joinColumn.getName());
        joinColumn.setName("foo");
        SecondaryTablesTests.assertEquals((String)"foo", (String)joinColumn.getName());
        this.assertSourceContains("@SecondaryTables(@SecondaryTable(pkJoinColumns = {@PrimaryKeyJoinColumn(name = \"foo\"), @PrimaryKeyJoinColumn(name = \"FOO\"), @PrimaryKeyJoinColumn(name = \"BAZ\")}))", cu);
    }
}

